/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.pa;

import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.ModelMessages;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.pa.CmdProgressMonitor;
import com.arm.streamline.pa.DummyProgressObserver;
import com.arm.streamline.pa.StreamlineAnalysisErrorHandler;
import com.arm.streamline.pa.StreamlineApiError;
import com.arm.streamline.pa.StreamlineGaData;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.io.ProgressTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamlineApi
implements AutoCloseable {
    ICapture streamlineCapture;
    @NonNull Analysis streamlineAnalysis;
    File captureSource;
    StateFile stateFile;
    StreamlineGaData gaData;

    public StreamlineApi(@NonNull File captureSource, boolean progress) throws IOException, InterruptedException {
        this(captureSource, (IProgressMonitor)new CmdProgressMonitor(progress));
    }

    private static List<ChartAndSeriesConfig> getDefaultCharts(Analysis analysis) {
        HashMap chartMap = new HashMap();
        return analysis.getAllBinData().getAllProviders().stream().map(b -> {
            CounterRecord counter = b.getCounterRecord();
            @NonNull String name = counter.getName() == null ? ModelMessages.UNNAMED : counter.getName();
            String expression = b.getExpressionFormat();
            ChartConfig cconf = new ChartConfig();
            cconf.setTitle(b.getTitleFormat());
            SeriesConfig sconf = new SeriesConfig();
            sconf.setName(name);
            sconf.setExpression(expression);
            sconf.setUnits(counter.getUnits());
            return new ChartSeriesRecord(cconf, sconf, counter.getOrder());
        }).sorted().map(seriesRecord -> {
            String title = seriesRecord.chartConfig.getTitle();
            ChartAndSeriesConfig ret = (ChartAndSeriesConfig)chartMap.get(title);
            if (ret == null) {
                ret = new ChartAndSeriesConfig(seriesRecord.chartConfig);
                chartMap.put(title, ret);
            }
            ret.addSeries(seriesRecord.seriesConfig);
            return ret;
        }).collect(Collectors.toList());
    }

    private static List<ChartAndSeriesConfig> getAdditionalCharts(Analysis analysis) {
        HashSet titleSet = new HashSet();
        ArrayList<ChartAndSeriesConfig> toAdd = new ArrayList<ChartAndSeriesConfig>();
        for (String name : TemplatePath.STOCK_NAMES) {
            try {
                Logger.getGlobal().fine(name);
                TemplatePath path = TemplatePath.resolveTemplatePath(name);
                TemplateFile template = new TemplateFile(path, analysis.getSourceToClusterIdMap());
                List<ChartAndSeriesConfig> counters = TemplateUtils.getChartAndSeriesConfigsToBeApplied(template, false, analysis);
                toAdd.addAll(counters.stream().filter(c -> titleSet.add(c.getChart().getTitle())).collect(Collectors.toList()));
            }
            catch (FileNotFoundException e) {
                Logger.getGlobal().severe("Unable to find template file " + name);
            }
            catch (IOException e) {
                Logger.getGlobal().severe("Unable to read template file " + name);
            }
        }
        Logger.getGlobal().fine("Additional counters added: " + toAdd.size());
        return toAdd;
    }

    public StreamlineApi(@NonNull File captureSource, @NonNull IProgressMonitor progressMonitor) throws IOException, InterruptedException {
        this.captureSource = captureSource;
        this.streamlineCapture = ICapture.createCapture(captureSource);
        if (!this.streamlineCapture.hasReport(true)) {
            this.createStreamlineCaptureReport();
        }
        this.stateFile = StateFile.load(new File(captureSource, "report"), new ProgressTracker());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CancellationPredicate cancellationPredicate = new CancellationPredicate();){
                System.out.println("Importing capture...");
                try {
                    this.streamlineAnalysis = new Analysis(captureSource, progressMonitor, cancellationPredicate, false);
                }
                catch (InvocationTargetException e) {
                    System.out.println("This capture was previously analysed using a different version, so it must be reanalysed...");
                    this.createStreamlineCaptureReport();
                    System.out.println("Importing capture...");
                    this.streamlineAnalysis = new Analysis(captureSource, progressMonitor, cancellationPredicate, false);
                }
                ZoomLevel zoomLevel = new ZoomLevel(1000);
                this.streamlineAnalysis.getScales().setZoomLevel(zoomLevel);
                while (this.streamlineAnalysis.isBusy()) {
                    Thread.sleep(10L);
                }
                ArrayList<IChartDataProvider> currCharts = new ArrayList<IChartDataProvider>(this.streamlineAnalysis.getChartList());
                HashSet<String> currChartNames = new HashSet<String>();
                for (IChartDataProvider iChartDataProvider : currCharts) {
                    currChartNames.add(iChartDataProvider.getTitle());
                }
                for (ChartAndSeriesConfig chartAndSeriesConfig : StreamlineApi.getDefaultCharts(this.streamlineAnalysis)) {
                    if (currChartNames.contains(chartAndSeriesConfig.getChart().getTitle())) continue;
                    this.streamlineAnalysis.addNewChart(chartAndSeriesConfig);
                }
                for (ChartAndSeriesConfig chartAndSeriesConfig : StreamlineApi.getAdditionalCharts(this.streamlineAnalysis)) {
                    if (currChartNames.contains(chartAndSeriesConfig.getChart().getTitle())) continue;
                    this.streamlineAnalysis.addNewChart(chartAndSeriesConfig);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InvocationTargetException e) {
            throw new StreamlineApiError("Failed to process capture " + String.valueOf(captureSource));
        }
        ICAMDataProvider model = StreamlineApi.pickCamModel(this.streamlineAnalysis.getCAMDataProviders());
        ProcessData camProcess = StreamlineApi.processDataForModel(this.streamlineAnalysis, model);
        this.gaData = new StreamlineGaData(model, camProcess);
    }

    private static ProcessData processDataForModel(@NonNull Analysis streamlineAnalysis, @Nullable ICAMDataProvider model) {
        if (model == null) {
            return null;
        }
        long processUtid = model.getOriginUtid();
        return StreamlineApi.getProcessDataByUtid(streamlineAnalysis, processUtid);
    }

    private static @Nullable ProcessData getProcessDataByUtid(@NonNull Analysis analysis, long utid) {
        if (utid == 0L) {
            return null;
        }
        IUniqueIds uids = analysis.getUniqueIdMap();
        Optional threadOpt = uids.findThread((int)utid);
        assert (threadOpt.isPresent());
        UniqueProcess process = ((UniqueThread)threadOpt.get()).getProcess();
        int procUpid = process.getUID();
        List<ProcessData> processes = analysis.getProcessDataProvider().getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY);
        List filtered = processes.stream().filter(proc -> proc.getUID() == procUpid).collect(Collectors.toList());
        if (filtered.size() != 1) {
            throw new StreamlineApiError("Expected to find exactly one process by utid " + utid + ", but found instead found " + filtered.size());
        }
        return (ProcessData)filtered.get(0);
    }

    public static @Nullable ICAMDataProvider pickCamModel(@NonNull List<@NonNull ICAMDataProvider> camDataProviders) {
        for (ICAMDataProvider p : camDataProviders) {
            if (!p.getName().contains("Graphics Analyzer") && !p.getName().contains("Mali Graphics Debugger") && !p.getName().contains("Performance Advisor")) continue;
            return p;
        }
        return null;
    }

    private void createStreamlineCaptureReport() {
        System.out.println("Creating report database in capture directory...");
        IAnalysisInputSettings settings = this.streamlineCapture.getAnalysisSettings();
        DummyProgressObserver progressObserver = new DummyProgressObserver();
        StreamlineAnalysisErrorHandler errorHandler = new StreamlineAnalysisErrorHandler();
        this.streamlineCapture.analyze(settings, new SessionProcessor(), this.streamlineCapture, progressObserver, errorHandler, false);
        if (errorHandler.wasErrorReported()) {
            System.err.println(errorHandler.getMessage());
            throw new StreamlineApiError("Failed to process capture " + this.captureSource.getName());
        }
    }

    public ICapture getStreamlineCapture() {
        return this.streamlineCapture;
    }

    public Analysis getStreamlineAnalysis() {
        return this.streamlineAnalysis;
    }

    public void setBinSizeOneMilSecAndWait() {
        Analysis streamlineAnalysis = this.getStreamlineAnalysis();
        streamlineAnalysis.getScales().setZoomLevel(Scales.ONE_MILLISECOND_ZOOM_LEVEL);
        try {
            while (streamlineAnalysis.isBusy()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new StreamlineApiError("Interrupted");
        }
    }

    public void setBinSizeHundredMilSecAndWait() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (Analysis streamlineAnalysis = this.getStreamlineAnalysis();){
                streamlineAnalysis.getScales().setZoomLevel(Scales.HUNDRED_MILLISECONDS_ZOOM_LEVEL);
                while (streamlineAnalysis.isBusy()) {
                    Thread.sleep(10L);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            throw new StreamlineApiError("Interrupted");
        }
        catch (Exception e) {
            throw new StreamlineApiError(e.getMessage(), e);
        }
    }

    public StreamlineGaData getStreamlineGaData() {
        return this.gaData;
    }

    @Override
    public void close() throws Exception {
        this.streamlineAnalysis.close();
    }

    private static class ChartSeriesRecord
    implements Comparable<ChartSeriesRecord> {
        public @NonNull ChartConfig chartConfig;
        public @NonNull SeriesConfig seriesConfig;
        public int order;

        public ChartSeriesRecord(@NonNull ChartConfig chartConfig, @NonNull SeriesConfig seriesConfig, int order) {
            this.chartConfig = chartConfig;
            this.seriesConfig = seriesConfig;
            this.order = order;
        }

        @Override
        public int compareTo(ChartSeriesRecord o) {
            return this.order - o.order;
        }
    }
}

