/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.templates;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesXMLParser;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TemplateFile
implements Cloneable,
Comparable<TemplateFile> {
    public static final String TAG = "template";
    private static final int CURRENT_VERSION = 2;
    private static final int MINIMUM_VERSION = 2;
    private static final String ATTR_VERSION = "version";
    public static final String ATTR_EXPAND_CLUSTER = "expand_clusters";
    private @Nullable ITemplatePath mPath;
    private @NonNull List<@NonNull ChartAndSeriesConfig> mCharts = new ArrayList<ChartAndSeriesConfig>();

    public TemplateFile() {
    }

    public TemplateFile(@NonNull File file, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) throws IOException {
        this(new TemplatePath(file), sourceToClusterIds);
    }

    public TemplateFile(@NonNull ITemplatePath path, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) throws IOException {
        this.mPath = path;
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLParser in = XMLParser.create((InputStream)this.mPath.openInputStream());){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (TAG.equals(tag)) {
                    String marker = in.getMarker();
                    int version = in.getIntegerAttribute(ATTR_VERSION, 0);
                    if (version > 2) {
                        throw InvalidVersionException.createTemplateVersionTooNewException();
                    }
                    if (version < 2) {
                        throw InvalidVersionException.createTemplateVersionTooOldException();
                    }
                    boolean expandCluster = in.isAttributeSet(ATTR_EXPAND_CLUSTER, false);
                    while ((tag = in.nextTag(marker)) != null) {
                        if ("chart".equals(tag)) {
                            @NonNull List<@NonNull ChartAndSeriesConfig> load = ChartAndSeriesXMLParser.load(in, expandCluster, sourceToClusterIds);
                            this.mCharts.addAll(load.stream().filter(c -> c.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION).collect(Collectors.toList()));
                            continue;
                        }
                        in.skip();
                    }
                    break;
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public final void addChart(@NonNull ChartAndSeriesConfig chart) {
        this.mCharts.add(chart);
    }

    public final void addAllCharts(@NonNull Collection<@NonNull ChartAndSeriesConfig> charts) {
        this.mCharts.addAll(charts);
    }

    public final boolean canSave() {
        return this.mPath != null && !this.mPath.isStock();
    }

    public final TemplateFile clone() {
        try {
            TemplateFile clone = (TemplateFile)super.clone();
            clone.mCharts.clear();
            for (ChartAndSeriesConfig chart : this.mCharts) {
                clone.mCharts.add(chart.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            CommonPlugin.error((Throwable)exception);
            return null;
        }
    }

    @Override
    public final int compareTo(TemplateFile other) {
        @Nullable ITemplatePath path = this.mPath;
        @Nullable ITemplatePath otherPath = other.mPath;
        if (path == null) {
            return otherPath == null ? 0 : -1;
        }
        if (otherPath == null) {
            return 1;
        }
        return path.compareTo(otherPath);
    }

    public final @NonNull List<@NonNull ChartAndSeriesConfig> getCharts() {
        return this.mCharts;
    }

    public final @NonNull String getName() {
        return this.mPath != null ? this.mPath.getName() : "";
    }

    public final @Nullable ITemplatePath getPath() {
        return this.mPath;
    }

    public final @Nullable File getPathAsFile() {
        return this.canSave() ? ((ITemplatePath)NullChecking.neverNull((Object)this.mPath)).toFile() : null;
    }

    public final boolean matches(TemplateFile other) {
        int count = this.mCharts.size();
        if (count == other.mCharts.size()) {
            int i = 0;
            while (i < count) {
                if (!this.mCharts.get(i).matches(other.mCharts.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final void save() throws IOException {
        if (this.canSave()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (XMLGenerator xml = new XMLGenerator((OutputStream)new BufferedOutputStream(((ITemplatePath)NullChecking.neverNull((Object)this.mPath)).openOutputStream()));){
                xml.startDocument();
                xml.startTag(TAG);
                xml.addAttribute(ATTR_VERSION, 2);
                ChartAndSeriesXMLParser.save(xml, this.mCharts);
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public final void setPath(@NonNull ITemplatePath path) {
        this.mPath = path;
    }

    public void clear() {
        this.mCharts.clear();
    }
}

