/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class SessionImage {
    public static final String TAG_IMAGE = "image";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_PATH = "path";
    private static final boolean DEFAULT_ENABLED = true;
    private boolean mEnabled = true;
    private @NonNull String mImageName;

    public SessionImage(@NonNull File file, boolean loadSymbols) {
        this.mImageName = file.getName();
        this.mEnabled = loadSymbols;
    }

    public SessionImage(SessionImage other) {
        this.mEnabled = other.mEnabled;
        this.mImageName = other.mImageName;
    }

    public SessionImage(@NonNull String imageName, boolean loadSymbols) {
        this.mImageName = imageName;
        this.mEnabled = loadSymbols;
    }

    public SessionImage(XMLParser in) throws IOException {
        this.load(in);
    }

    public String getImageName() {
        return this.mImageName;
    }

    public boolean loadSymbols() {
        return this.mEnabled;
    }

    public void save(XMLGenerator xml) throws IOException {
        xml.startEmptyTag(TAG_IMAGE);
        xml.addAttribute(ATTR_PATH, this.mImageName);
        xml.addAttributeNot(ATTR_ENABLED, this.mEnabled, true);
    }

    public void setImageName(@NonNull String imageName) {
        this.mImageName = imageName;
    }

    public void setLoadSymbols(boolean symbols) {
        this.mEnabled = symbols;
    }

    private void load(XMLParser in) throws IOException {
        String path = in.getAttribute(ATTR_PATH);
        if (path != null && !path.equals("")) {
            this.mImageName = new File(path).getName();
        }
        this.mEnabled = in.isAttributeSet(ATTR_ENABLED, true);
        in.skip();
    }
}

