/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class PathWithEnabledFlag {
    private static final String ATTR_PATH = "path";
    private static final String ATTR_USE = "use";
    private final @NonNull String path;
    private final boolean use;

    public PathWithEnabledFlag(@NonNull File path, boolean use) {
        this.path = path.getPath();
        this.use = use;
    }

    public PathWithEnabledFlag(@NonNull XMLParser in) throws IOException {
        String path = in.getAttribute(ATTR_PATH);
        boolean use = in.isAttributeSet(ATTR_USE);
        in.skip();
        if (path == null || path.trim().isEmpty()) {
            throw new IOException("Invalid " + in.getCurrentTag() + " element");
        }
        this.path = path;
        this.use = use;
    }

    public @NonNull File getFile() {
        return new File(this.path);
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public boolean isUsed() {
        return this.use;
    }

    public @NonNull File resolvePath(@NonNull File apcDirectory) {
        int dotApcPos;
        File apcFile;
        File file = new File(this.path);
        if (!file.isAbsolute() && (apcFile = new File(apcDirectory, this.path)).isFile()) {
            return apcFile;
        }
        if (!file.exists() && (dotApcPos = this.path.indexOf(".apc/")) >= 0) {
            String apcRel = this.path.substring(dotApcPos + 5);
            File apcFile2 = new File(apcDirectory, apcRel);
            if (apcFile2.isFile()) {
                return apcFile2;
            }
            @NonNull File jittedFile = new File(apcDirectory, "jitdumps");
            @NonNull File filePath = new File(jittedFile, file.getName());
            if (filePath.isFile()) {
                return filePath;
            }
        }
        return file;
    }

    public void save(@NonNull XMLGenerator xml, @NonNull String tag) throws IOException {
        xml.startEmptyTag(tag);
        xml.addAttribute(ATTR_PATH, this.path);
        xml.addAttributeBool(ATTR_USE, this.use);
    }
}

