/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.process.IProcessCounter;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public final class TimelineSeriesProcessCounter
implements IProcessCounter {
    private final @NonNull String title;
    private final @NonNull ISeriesDataProvider series;
    private final boolean percent;

    public TimelineSeriesProcessCounter(@NonNull IChartDataProvider chart, @NonNull ISeriesDataProvider series) {
        String chartName = ((String)NullChecking.neverNullOr((Object)chart.getTitle(), (Object)"")).strip();
        String seriesName = ((String)NullChecking.neverNullOr((Object)series.getName(), (Object)"")).strip();
        this.title = chartName.contentEquals(seriesName) ? seriesName : String.format("%s: %s", chartName, seriesName);
        this.series = series;
        this.percent = chart.isPercentage();
    }

    @Override
    public long getData(int start, int end, int uid, boolean isKernel) {
        TIntHashSet filteredThreadUids = new TIntHashSet(1, 1.0f);
        filteredThreadUids.add(uid);
        double result = this.series.getAggregateValueOfRangeFromDensestLevel(start, end, (TIntSet)filteredThreadUids);
        if (!this.percent) {
            return (long)result;
        }
        return Math.max(0L, Math.min(10000L, (long)(10000.0 * result)));
    }

    @Override
    public @NonNull String getDescription() {
        return (String)NullChecking.neverNullOr((Object)this.series.getDescription(), (Object)"");
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public boolean isPercentage() {
        return this.percent;
    }

    @Override
    public boolean isDefaultSortItem() {
        return false;
    }

    @Override
    public @Nullable Integer getChartRGB() {
        RGB rgb = this.series.getConfig().getColor();
        return (rgb.red & 0xFF) << 16 | (rgb.green & 0xFF) << 8 | rgb.blue & 0xFF;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference getColourPreference() {
        return IColumnDescriptor.ColourPreference.user_defined;
    }
}

