/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.RGBString;
import com.arm.streamline.model.annotation.AnnotationTimesliceData;
import com.arm.streamline.model.process.HeatmapDataCompute;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.MapData;
import com.arm.streamline.model.process.ThreadAnnotation;
import com.arm.streamline.model.process.TimelineMap;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.Messages;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineRow
implements ITimelineRowProvider {
    private final @Nullable TimelineMap mTimelineMap;
    private final @NonNull TimelineRowType mRowType;
    private final @Nullable TimelineRow mParent;
    private final @NonNull List<@NonNull ITimelineRowProvider> mChildren = new ArrayList<ITimelineRowProvider>();
    private @Nullable Pattern mPattern;
    private final @Nullable IUniqueID mThreadLike;
    private final @NonNull String mName;
    private final int mGroup;
    private final int mChannel;
    private int mThreadHierarchyUID;
    private @Nullable List<ThreadAnnotation> mAnnotations;
    private int mAnnotatePrevStart;
    private int mAnnotatePrevStop;
    private @Nullable ZoomLevel mAnnotatePrevZoomLevel;
    private boolean mPassesFilter = true;
    private boolean mOpen = true;
    private final boolean mIsIdle;
    private final boolean mIsKernel;
    private final @NonNull IUniqueIds mThreadProcInfo;
    private final int mCoreNo;
    private final long vmUID;
    private final boolean hasThreadChildren;

    private static @NonNull String deriveDisplayName(@NonNull IUniqueID threadLike, @NonNull IUniqueIds threadInfo, boolean isProcess) {
        @NonNull String rawName = (String)NullChecking.neverNullOr((Object)threadLike.getName(), (Object)Messages.NonUniqueId_UNRESOLVED);
        if (threadInfo.isIdleUID(threadLike.getUID())) {
            return rawName;
        }
        if (isProcess && threadInfo.isKernelUID(threadLike.getUID())) {
            return rawName;
        }
        Optional optVmNonUniquePidOrTid = threadInfo.getId(threadLike.getUID());
        if (optVmNonUniquePidOrTid.isPresent()) {
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractPerVmId.PerVmNonUniquePidOrTid pidOrTid = (AbstractPerVmId.PerVmNonUniquePidOrTid)optVmNonUniquePidOrTid.get();
            return String.format("%s #%s", rawName, Integer.toUnsignedString(pidOrTid.id));
        }
        return rawName;
    }

    public TimelineRow(@NonNull TimelineMap pd, @NonNull Comparator<IUniqueID> comparator, @NonNull IUniqueID threadLike, @NonNull TimelineRowType type, @NonNull IUniqueIds uniqueIdMap) {
        this(pd, comparator, threadLike, type, null, uniqueIdMap);
    }

    private TimelineRow(@NonNull TimelineMap pd, @NonNull Comparator<IUniqueID> comparator, @NonNull IUniqueID threadLike, @NonNull TimelineRowType type, @Nullable TimelineRow parent, @NonNull IUniqueIds uniqueIdMap) {
        this.mThreadProcInfo = uniqueIdMap;
        this.mRowType = type;
        this.mParent = parent;
        this.mTimelineMap = parent == null ? pd : null;
        this.mThreadLike = threadLike;
        this.mGroup = 0;
        this.mChannel = 0;
        this.mCoreNo = 0;
        this.vmUID = threadLike.getVmUID();
        boolean hasThreadChildren = false;
        switch (type) {
            case VMUID: 
            case CPU: {
                throw new IllegalArgumentException("VM unsupported");
            }
            case PROCESS: {
                boolean skipThreadsRow;
                this.mName = TimelineRow.deriveDisplayName(threadLike, uniqueIdMap, true);
                Optional optProcess = this.mThreadProcInfo.findProcess(threadLike.getUID());
                UniqueProcess process = (UniqueProcess)optProcess.get();
                this.mIsIdle = this.mThreadProcInfo.isIdleUID(threadLike.getUID());
                this.mIsKernel = this.mThreadProcInfo.isKernelUID(threadLike.getUID());
                List<@NonNull T> threads = this.mThreadProcInfo.getThreadsOf(process).collect(Collectors.toList());
                Collections.sort(threads, comparator);
                boolean bl = skipThreadsRow = threads.size() < 2;
                if (skipThreadsRow) {
                    this.addGroups((IUniqueID)threads.get(0));
                    break;
                }
                for (UniqueThread thread : threads) {
                    TimelineRow t = new TimelineRow(pd, comparator, (IUniqueID)thread, TimelineRowType.THREAD, this, this.mThreadProcInfo);
                    this.mChildren.add(t);
                }
                hasThreadChildren = true;
                break;
            }
            case THREAD: {
                this.mName = TimelineRow.deriveDisplayName(threadLike, uniqueIdMap, false);
                this.mIsIdle = this.mThreadProcInfo.isIdleUID(threadLike.getUID());
                this.mIsKernel = this.mThreadProcInfo.isKernelUID(threadLike.getUID());
                this.addGroups(threadLike);
                break;
            }
            default: {
                throw new AssertionError((Object)type);
            }
        }
        this.hasThreadChildren = hasThreadChildren;
    }

    private TimelineRow(@NonNull TimelineRow parent, @NonNull IUniqueID threadLike, int group, int channel, @NonNull IUniqueIds uniqueIdMap) {
        this.mThreadProcInfo = uniqueIdMap;
        this.mRowType = TimelineRowType.ANNOTATION;
        this.mParent = parent;
        this.mThreadLike = threadLike;
        this.mGroup = group;
        this.mChannel = channel;
        this.mTimelineMap = null;
        this.mName = parent.getAnalysis().getAnnotationDataStructure().getChannelName(threadLike.getUID(), this.mChannel);
        this.mIsIdle = false;
        this.mIsKernel = false;
        this.mCoreNo = 0;
        this.vmUID = threadLike.getVmUID();
        this.hasThreadChildren = false;
    }

    private TimelineRow(@NonNull TimelineRow parent, @NonNull IUniqueID threadLike, int group, @NonNull IUniqueIds uniqueIdMap) {
        this.mThreadProcInfo = uniqueIdMap;
        this.mRowType = TimelineRowType.GROUP;
        this.mParent = parent;
        this.mThreadLike = threadLike;
        this.mGroup = group;
        this.mName = parent.getAnalysis().getAnnotationDataStructure().getGroupName(threadLike.getUID(), this.mGroup);
        this.mChannel = 0;
        this.mTimelineMap = null;
        this.mIsIdle = false;
        this.mIsKernel = false;
        this.mCoreNo = 0;
        this.vmUID = threadLike.getVmUID();
        this.hasThreadChildren = false;
        this.addChannels(threadLike, group);
    }

    public TimelineRow(@NonNull TimelineMap parent, @NonNull IUniqueIds uniqueIdMap, long vmUID, int coreNo, @NonNull String coreLabel, int uid) {
        this.mThreadProcInfo = uniqueIdMap;
        this.mRowType = TimelineRowType.CPU;
        this.mParent = null;
        this.mThreadLike = null;
        this.mGroup = 0;
        this.mChannel = 0;
        this.mTimelineMap = parent;
        this.mName = coreLabel;
        this.mIsIdle = false;
        this.mIsKernel = false;
        this.mCoreNo = coreNo;
        this.mThreadHierarchyUID = uid;
        this.vmUID = vmUID;
        this.hasThreadChildren = false;
    }

    @Override
    public @NonNull List<ThreadAnnotation> getAnnotationData(int start, int stop) {
        @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
        @Nullable List<ThreadAnnotation> prevAnnotations = this.mAnnotations;
        if (prevAnnotations != null && start == this.mAnnotatePrevStart && stop == this.mAnnotatePrevStop && zoomLevel.equals((Object)this.mAnnotatePrevZoomLevel)) {
            return prevAnnotations;
        }
        ArrayList<ThreadAnnotation> list = switch (this.getRowType()) {
            case TimelineRowType.GROUP -> this.getGroupData(start, stop);
            case TimelineRowType.ANNOTATION -> this.getAnnotatedData(start, stop);
            case TimelineRowType.PROCESS, TimelineRowType.THREAD, TimelineRowType.VMUID, TimelineRowType.CPU -> new ArrayList();
            default -> throw new AssertionError((Object)this.getRowType());
        };
        this.mAnnotations = list;
        this.mAnnotatePrevZoomLevel = zoomLevel;
        this.mAnnotatePrevStart = start;
        this.mAnnotatePrevStop = stop;
        return list;
    }

    @Override
    public @Nullable List<String> getAnnotationList(int slot) {
        switch (this.mRowType) {
            case ANNOTATION: {
                return this.getAnnotationSummary(slot);
            }
            case GROUP: {
                return this.getGroupSummary(slot);
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: 
            case CPU: {
                return new ArrayList<String>();
            }
        }
        throw new AssertionError((Object)this.mRowType);
    }

    public @NonNull String getBaseName() {
        IUniqueID mThreadLike = (IUniqueID)NullChecking.neverNull((Object)this.mThreadLike);
        @Nullable String name = mThreadLike.getName();
        if (name == null) {
            return "";
        }
        int index = name.lastIndexOf(" #");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getChildren() {
        Pattern pattern = this.getTimelineMap().getFilterPattern();
        if (this.mPattern != pattern) {
            for (ITimelineRowProvider row : this.mChildren) {
                row.setPassesFilter(this.mPassesFilter || pattern == null || pattern.matcher(row.getName()).find());
            }
            this.mPattern = pattern;
        }
        return this.mChildren;
    }

    @Override
    public @NonNull HeatmapDataCompute.PerCoreData getCpuMapData(int first, int last) {
        assert (this.getRowType() == TimelineRowType.CPU);
        assert (this.getTimelineMap().getMode() == TimelineMapMode.HEAT_MAP);
        TimelineMap tlm = this.getTimelineMap();
        HeatmapDataCompute hdc = tlm.getHeatmapDataCompute();
        HeatmapDataCompute.HeatmapData data = hdc.computeHeatmapData(first, last);
        return data.getCPU(this.mCoreNo);
    }

    @Override
    public int[] getMapData(int start, int stop, boolean averagePerCore) {
        MapData mapObject = this.getMapObject(start, stop, averagePerCore);
        if (mapObject != null) {
            if (this.getTimelineMap().getMode() == TimelineMapMode.HEAT_MAP) {
                return mapObject.getProcessData();
            }
            if (this.getTimelineMap().getMode() == TimelineMapMode.CORE_MAP) {
                return mapObject.getCpuData();
            }
            if (this.getTimelineMap().getMode() == TimelineMapMode.CLUSTER_MAP) {
                return mapObject.getClusterData();
            }
            CommonPlugin.error((String)"Invalid TimelineMapMode", (Throwable)new Throwable());
        }
        return new int[0];
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public TimelineRow getParent() {
        return this.mParent;
    }

    @Override
    public TimelineRowType getRowType() {
        return this.mRowType;
    }

    public @NonNull TimelineMap getTimelineMap() {
        @Nullable TimelineRow parent = this.mParent;
        if (parent == null) {
            return (TimelineMap)NullChecking.neverNull((Object)this.mTimelineMap);
        }
        return parent.getTimelineMap();
    }

    @Override
    public int getUID() {
        switch (this.mRowType) {
            case GROUP: 
            case ANNOTATION: 
            case CPU: {
                return this.mThreadHierarchyUID;
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: {
                IUniqueID mThreadLike = (IUniqueID)NullChecking.neverNull((Object)this.mThreadLike);
                return mThreadLike.getUID();
            }
        }
        throw new AssertionError((Object)this.mRowType);
    }

    @Override
    public long getVmEndTimeNs() {
        return this.getAnalysis().getVmEndTimeNs(this.vmUID);
    }

    @Override
    public long getVmStartTimeNs() {
        return this.getAnalysis().getVmStartTimeNs(this.vmUID);
    }

    @Override
    public boolean isIdle() {
        return this.mIsIdle;
    }

    @Override
    public boolean isKernel() {
        return this.mIsKernel;
    }

    @Override
    public boolean isOpen() {
        return this.mOpen;
    }

    @Override
    public boolean passesFilter() {
        return this.mPassesFilter;
    }

    @Override
    public void setOpenness(boolean open) {
        this.mOpen = open;
    }

    @Override
    public void setPassesFilter(boolean passes) {
        this.mPassesFilter = passes;
    }

    public void setThreadHierarchyUniqueID(int id) {
        this.mThreadHierarchyUID = id;
    }

    private void addChannels(IUniqueID thread, int group) {
        int[] channels;
        int threadUid = thread.getUID();
        int[] nArray = channels = this.getAnalysis().getAnnotationDataStructure().getChannels(threadUid);
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            int channel = nArray[n2];
            if (this.getAnalysis().getAnnotationDataStructure().containsChannel(threadUid, channel, group)) {
                TimelineRow t = new TimelineRow(this, thread, group, channel, this.mThreadProcInfo);
                this.mChildren.add(t);
            }
            ++n2;
        }
    }

    private void addGroups(@NonNull IUniqueID thread) {
        int[] groups = this.getAnalysis().getAnnotationDataStructure().getGroups(thread.getUID());
        if (groups.length == 1) {
            this.addChannels(thread, groups[0]);
        } else {
            int[] nArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                int group = nArray[n2];
                TimelineRow t = new TimelineRow(this, thread, group, this.mThreadProcInfo);
                this.mChildren.add(t);
                ++n2;
            }
        }
    }

    private Analysis getAnalysis() {
        return this.getTimelineMap().getAnalysis();
    }

    private @NonNull List<ThreadAnnotation> getAnnotatedData(int start, int stop) {
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        ArrayList<ThreadAnnotation> data = new ArrayList<ThreadAnnotation>();
        int id = 1;
        if (stop < start) {
            return data;
        }
        int remainder = stop - dataEndIndex;
        stop = Math.min(stop, dataEndIndex);
        ArrayList<HashMap<IUniqueID, AnnotationTimesliceData>> dataBlocks = this.getTimelineMap().getAnnotations().getDataBlocks(start, stop - start + 1);
        for (Map map : dataBlocks) {
            if (map != null) {
                AnnotationTimesliceData current = (AnnotationTimesliceData)map.get(this.mThreadLike);
                if (current != null && current.hasChannel(this.mChannel)) {
                    if (current.isStartFrame(this.mChannel)) {
                        ++id;
                    }
                    ThreadAnnotation ta = new ThreadAnnotation(current.getRGB(this.mChannel), current.toString(this.mChannel, ", "), id, current.isStartFrame(this.mChannel), current.isEndFrame(this.mChannel));
                    data.add(ta);
                    continue;
                }
                data.add(null);
                continue;
            }
            data.add(null);
        }
        while (remainder-- > 0) {
            data.add(null);
        }
        return data;
    }

    private List<String> getAnnotationSummary(int slot) {
        AnnotationTimesliceData data;
        if (this.mRowType != TimelineRowType.ANNOTATION) {
            return null;
        }
        ArrayList<String> summaries = new ArrayList<String>();
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        if (slot > dataEndIndex || slot < 0) {
            return summaries;
        }
        HashMap<IUniqueID, AnnotationTimesliceData> hashData = this.getTimelineMap().getAnnotations().getData(slot);
        if (hashData != null && (data = (AnnotationTimesliceData)hashData.get(this.mThreadLike)) != null && data.hasChannel(this.mChannel)) {
            ArrayList<RGBString> labels = data.getLabels(this.mChannel);
            for (RGBString label : labels) {
                summaries.add(label.getString());
            }
        }
        return summaries;
    }

    private @NonNull List<ThreadAnnotation> getGroupData(int start, int stop) {
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        int end = stop - start;
        int id = 1;
        ArrayList<ThreadAnnotation> groupData = new ArrayList<ThreadAnnotation>();
        int index = 0;
        while (index <= end) {
            if (start + index > dataEndIndex) {
                groupData.add(null);
            } else {
                for (ITimelineRowProvider row : this.getChildren()) {
                    ThreadAnnotation threadAnnotation = row.getAnnotationData(start, stop).get(index);
                    if (threadAnnotation == null) continue;
                    if (groupData.size() == index) {
                        groupData.add(threadAnnotation.duplicate(id));
                        continue;
                    }
                    ((ThreadAnnotation)groupData.get(index)).update(threadAnnotation);
                }
                if (groupData.size() == index) {
                    groupData.add(null);
                }
                if (groupData.get(index) != null && ((ThreadAnnotation)groupData.get(index)).isStartFrame()) {
                    ((ThreadAnnotation)groupData.get(index)).setId(++id);
                }
            }
            ++index;
        }
        return groupData;
    }

    private @Nullable List<String> getGroupSummary(int slot) {
        if (this.mRowType != TimelineRowType.GROUP) {
            return null;
        }
        ArrayList<String> summaries = new ArrayList<String>();
        int dataEndIndex = this.getTimelineMap().getAnalysis().getBinCount() - 1;
        if (slot > dataEndIndex || slot < 0) {
            return summaries;
        }
        @NonNull List<@NonNull ITimelineRowProvider> children = this.getChildren();
        for (ITimelineRowProvider child : children) {
            summaries.addAll(((TimelineRow)child).getAnnotationSummary(slot));
        }
        return summaries;
    }

    private MapData getMapObject(int start, int stop, boolean averagePerCore) {
        switch (this.mRowType) {
            case GROUP: 
            case ANNOTATION: 
            case VMUID: 
            case CPU: {
                return null;
            }
            case PROCESS: {
                IUniqueID mThreadLike = (IUniqueID)NullChecking.neverNull((Object)this.mThreadLike);
                TimelineMap tlm = this.getTimelineMap();
                HeatmapDataCompute hdc = tlm.getHeatmapDataCompute();
                UniqueProcess process = this.mThreadProcInfo.findProcess(mThreadLike.getUID()).orElse(null);
                if (process == null) {
                    throw new AssertionError((Object)"missing process for thread");
                }
                HeatmapDataCompute.HeatmapData data = hdc.computeHeatmapData(start, stop);
                return TimelineRow.convertMapData(data, (IUniqueProcessID)process, averagePerCore);
            }
            case THREAD: {
                IUniqueID mThreadLike = (IUniqueID)NullChecking.neverNull((Object)this.mThreadLike);
                TimelineMap tlm = this.getTimelineMap();
                HeatmapDataCompute hdc = tlm.getHeatmapDataCompute();
                HeatmapDataCompute.HeatmapData data = hdc.computeHeatmapData(start, stop);
                return TimelineRow.convertMapData(data, (IUniqueThreadID)mThreadLike, averagePerCore);
            }
        }
        throw new AssertionError((Object)this.mRowType);
    }

    private static MapData convertMapData(@NonNull HeatmapDataCompute.HeatmapData data, @NonNull IUniqueProcessID upid, boolean averagePerCore) {
        HeatmapDataCompute.PerUIDData entry = data.get(upid);
        return TimelineRow.convertMapData(entry, data.rangeSize, averagePerCore ? data.numberOfCores : 1);
    }

    private static MapData convertMapData(@Nullable HeatmapDataCompute.PerUIDData data, int rangeSize, int coreDivisor) {
        assert (coreDivisor >= 1);
        if (data == null) {
            return new MapData(-1, rangeSize);
        }
        MapData result = new MapData(new int[rangeSize], new int[rangeSize], new int[rangeSize]);
        System.arraycopy(data.coreNoOrCode, 0, result.getCpuData(), 0, rangeSize);
        System.arraycopy(data.clusterNoOrCode, 0, result.getClusterData(), 0, rangeSize);
        if (coreDivisor > 1) {
            int[] pd = result.getProcessData();
            int i = 0;
            while (i < rangeSize) {
                int percentage = data.percentageOrCode[i];
                pd[i] = percentage > 0 ? Math.max(1, (percentage + coreDivisor / 2) / coreDivisor) : percentage;
                ++i;
            }
        } else {
            System.arraycopy(data.percentageOrCode, 0, result.getProcessData(), 0, rangeSize);
        }
        return result;
    }

    private static MapData convertMapData(@NonNull HeatmapDataCompute.HeatmapData data, @NonNull IUniqueThreadID utid, boolean averagePerCore) {
        HeatmapDataCompute.PerUIDData entry = data.get(utid);
        return TimelineRow.convertMapData(entry, data.rangeSize, averagePerCore ? data.numberOfCores : 1);
    }

    @Override
    public boolean isAlwaysDrawBarsAsAverageColour() {
        switch (this.mRowType) {
            case GROUP: 
            case ANNOTATION: 
            case VMUID: 
            case CPU: {
                return false;
            }
            case THREAD: {
                return this.isIdle();
            }
            case PROCESS: {
                return this.hasThreadChildren || this.isIdle();
            }
        }
        throw new AssertionError((Object)this.mRowType);
    }
}

