/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.process.IProcessCounter;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SimpleProcessCounter
implements IProcessCounter {
    private final Analysis mAnalysis;
    private final @NonNull CounterRecord mCounterRecord;
    private final @NonNull ExpressionData mExpressionData;
    private final @NonNull String mTitle;

    public SimpleProcessCounter(@NonNull Analysis analysis, @NonNull IBinDataProvider provider) {
        this.mAnalysis = analysis;
        this.mCounterRecord = provider.getCounterRecord();
        this.mExpressionData = new ExpressionData(this.mCounterRecord.getExpression());
        String chartName = ((String)NullChecking.neverNullOr((Object)this.mCounterRecord.getTitle(), (Object)"")).strip();
        String seriesName = ((String)NullChecking.neverNullOr((Object)this.mCounterRecord.getName(), (Object)"")).strip();
        this.mTitle = chartName.contentEquals(seriesName) ? seriesName : String.format("%s: %s", chartName, seriesName);
    }

    @Override
    public final long getData(int start, int end, int uid, boolean isKernel) {
        TIntHashSet tids = this.mAnalysis.getUniqueIdMap().toThreadUids(uid).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
        SeriesRangeInfo info = new SeriesRangeInfo(this.mCounterRecord.getDisplay(), this.mExpressionData, this.mCounterRecord.isAverageCores(), this.mCounterRecord.isAverageSelection(), tids, this.mAnalysis.getCores(this.mCounterRecord), ChartUtility.getVariableSetFromExpression(this.mExpressionData), ChartUtility.isExpressionComplex(this.mExpressionData));
        return Math.round(this.mAnalysis.getCharts().getAnalysis().getSeriesRangeCalculator().getAggregateRange(info, start, end));
    }

    @Override
    public @NonNull String getDescription() {
        return (String)NullChecking.neverNullOr((Object)this.mCounterRecord.getDescription(), (Object)"");
    }

    @Override
    public @NonNull String getTitle() {
        return this.mTitle;
    }

    @Override
    public boolean isPercentage() {
        return this.mCounterRecord.isPercentage();
    }

    @Override
    public boolean isDefaultSortItem() {
        return false;
    }

    @Override
    public @Nullable Integer getChartRGB() {
        return this.mCounterRecord.getColor();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference getColourPreference() {
        Integer colour = this.mCounterRecord.getColor();
        if (colour == null) {
            return IColumnDescriptor.ColourPreference.neutral;
        }
        return IColumnDescriptor.ColourPreference.user_defined;
    }
}

