/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.legacyimpl;

import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.icounters.legacyimpl.InstructionCountersModel;
import com.arm.utils.function.Throwing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCounterSource
implements IInstructionCounterSource,
AutoCloseable {
    private @NonNull Bounds bounds = new Bounds();
    private final @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathRowValue>> cachedAssociatedCallPaths = new HashMap<ReferencedSymbol, Set<CallPathRowValue>>();
    private @NonNull ISamplesReportData data;
    private final @NonNull List<@NonNull FunctionRowValue> mappedFunctionRowValues = new ArrayList<FunctionRowValue>();
    private @NonNull List<@NonNull CallPathRowValue> mappedRootCallPathValues = Collections.emptyList();
    private final @NonNull InstructionCountersModel model;
    private final @NonNull ISamplesReport report;

    private static boolean canShowCallPathTotalsColumns(@NonNull List<@NonNull IColumnDescriptor> columns) {
        for (IColumnDescriptor column : columns) {
            if (column.supportsTogglingTotalOrSelfViewInCallPathsData()) {
                return true;
            }
            IColumnDescriptor[] children = column.getChildren();
            if (children == null || children.length <= 0 || !InstructionCounterSource.canShowCallPathTotalsColumns(Arrays.asList(children))) continue;
            return true;
        }
        return false;
    }

    private static @NonNull String max(@NonNull String a, @NonNull String b) {
        if (a.length() >= b.length()) {
            return a;
        }
        return b;
    }

    private static @NonNull CallPathRowValue updateCachedMappedCallPath(@NonNull IInstructionCounterSource source, @NonNull Bounds bounds, @NonNull List<@NonNull FunctionRowValue> mappedFunctionRowValues, @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathRowValue>> cachedAssociatedCallPaths, @Nullable CallPathRowValue parent, @NonNull CallPathNode node) {
        int lineNo;
        String symbolName;
        int functionCallPathCount;
        long functionSize;
        ArrayList<CallPathRowValue> children = new ArrayList<CallPathRowValue>();
        CallPathRowValue result = new CallPathRowValue(source, parent, node, children);
        ReferencedSymbol symbol = node.symbol;
        if (symbol != null) {
            Set set = cachedAssociatedCallPaths.computeIfAbsent(symbol, k -> {
                HashSet cpSet = new HashSet();
                FunctionRowValue functionRow = new FunctionRowValue(source, symbol, cpSet);
                mappedFunctionRowValues.add(functionRow);
                return cpSet;
            });
            set.add(result);
            functionSize = symbol.symbol.sizeInBytes;
            functionCallPathCount = set.size();
            symbolName = symbol.symbol.getName();
            SourceLocation loc = symbol.symbol.sourceLocation;
            lineNo = loc != null ? loc.lineNo : 0;
        } else {
            functionSize = 0L;
            functionCallPathCount = 0;
            symbolName = "";
            lineNo = 0;
        }
        bounds.largestCallPathName = InstructionCounterSource.max(bounds.largestCallPathName, result.getName());
        bounds.largestFunctionName = InstructionCounterSource.max(bounds.largestFunctionName, symbolName);
        bounds.largestCallPathStackValue = Math.max(bounds.largestCallPathStackValue, result.getStackSize());
        bounds.largestFunctionCallPathCount = Math.max(bounds.largestFunctionCallPathCount, functionCallPathCount);
        bounds.largestFunctionSize = Math.max(bounds.largestFunctionSize, functionSize);
        bounds.largestLineNo = Math.max(bounds.largestLineNo, lineNo);
        CallPathNode[] callPathNodeArray = node.children;
        int n = node.children.length;
        int n2 = 0;
        while (n2 < n) {
            CallPathNode child = callPathNodeArray[n2];
            children.add(InstructionCounterSource.updateCachedMappedCallPath(source, bounds, mappedFunctionRowValues, cachedAssociatedCallPaths, result, child));
            ++n2;
        }
        return result;
    }

    public InstructionCounterSource(@NonNull InstructionCountersModel model, @NonNull ISamplesReport report, @NonNull ISamplesReportData data) {
        this.model = model;
        this.report = report;
        this.data = data;
        this.updateCachedMappedCallPaths();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong calculateCallPathTabSelectionValue(@NonNull Stream<@NonNull CallPathRowValue> selectionStream) {
        if (!this.report.hasPeriodicSamplesCount()) {
            return null;
        }
        return this.data.computePercentOfTotalOfCallPathSamplesCount(selectionStream.mapToLong(r -> r.getCallPathNode().uid));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong calculateFunctionTabSelectionValue(@NonNull Stream<@NonNull FunctionRowValue> selectionStream) {
        if (!this.report.hasPeriodicSamplesCount()) {
            return null;
        }
        return this.data.computePercentOfTotalOfReferencedSymbolSamplesCount(selectionStream.mapToLong(r -> r.getReferencedSymbol().uid));
    }

    public boolean canFilterStacksDynamically() {
        return this.report.canFilterStacksDynamically();
    }

    public boolean canShowCallPathTotalsColumns() {
        if (!this.report.hasNestedCallStacks()) {
            return false;
        }
        return InstructionCounterSource.canShowCallPathTotalsColumns(this.report.getCallPathColumns());
    }

    @Override
    public void close() throws Exception {
        Throwing.closeAllIfCloseable((Iterable[])new Iterable[]{List.of(this.data, this.report)});
        this.bounds = new Bounds();
        this.cachedAssociatedCallPaths.clear();
        this.mappedFunctionRowValues.clear();
        this.mappedRootCallPathValues = Collections.emptyList();
    }

    public @NonNull ISamplesReportData getActiveReportData() {
        return this.data;
    }

    public @NonNull List<@NonNull IColumnDescriptor> getCallPathColumns() {
        return this.report.getCallPathColumns();
    }

    public @NonNull List<@NonNull IColumnDescriptor> getCallPathFunctionColumns() {
        return this.report.getCallPathFunctionColumns();
    }

    public @NonNull List<@NonNull CallPathRowValue> getCallPathRoots() {
        return this.mappedRootCallPathValues;
    }

    public @NonNull List<@NonNull IColumnDescriptor> getFunctionColumns() {
        return this.report.getFunctionColumns();
    }

    public @NonNull List<@NonNull IColumnDescriptor> getInstructionAndSourceLineColumns() {
        return this.report.getInstructionAndSourceLineColumns();
    }

    public @NonNull String getLargestCallPathName() {
        return this.bounds.largestCallPathName;
    }

    public int getLargestFunctionCallPathCount() {
        return this.bounds.largestFunctionCallPathCount;
    }

    public @NonNull String getLargestFunctionName() {
        return this.bounds.largestFunctionName;
    }

    public long getLargestFunctionSize() {
        return this.bounds.largestFunctionSize;
    }

    public int getMaxLine() {
        return this.bounds.largestLineNo;
    }

    public long getMaxStack() {
        return this.bounds.largestCallPathStackValue;
    }

    public @NonNull IInstructionCounterModel getModel() {
        return this.model;
    }

    public @NonNull String getName() {
        return this.report.getLabel();
    }

    public @NonNull List<@NonNull FunctionRowValue> getSymbols() {
        return this.mappedFunctionRowValues;
    }

    public @NonNull Set<@NonNull CallPathRowValue> mapCallPathsForSymbol(@NonNull ReferencedSymbol referencedSymbol) {
        Set<CallPathRowValue> result = this.cachedAssociatedCallPaths.get(referencedSymbol);
        if (result == null) {
            throw new AssertionError((Object)"Unexpected symbol");
        }
        return result;
    }

    protected synchronized void update(@NonNull ISamplesReportData data) throws Exception {
        ISamplesReportData oldData = this.data;
        Throwing.closeAll((AutoCloseable[])new AutoCloseable[]{oldData});
        this.data = data;
        this.mappedFunctionRowValues.clear();
        this.cachedAssociatedCallPaths.clear();
        this.updateCachedMappedCallPaths();
    }

    void updateCachedMappedCallPaths() {
        ArrayList<CallPathRowValue> mappedRoots = new ArrayList<CallPathRowValue>();
        this.bounds = new Bounds();
        for (Set<CallPathRowValue> set : this.cachedAssociatedCallPaths.values()) {
            set.clear();
        }
        for (CallPathNode root : this.data.getCallPathRoots()) {
            mappedRoots.add(InstructionCounterSource.updateCachedMappedCallPath(this, this.bounds, this.mappedFunctionRowValues, this.cachedAssociatedCallPaths, null, root));
        }
        this.mappedRootCallPathValues = mappedRoots;
    }

    private static final class Bounds {
        public @NonNull String largestCallPathName = "";
        public long largestCallPathStackValue;
        public int largestFunctionCallPathCount;
        public @NonNull String largestFunctionName = "";
        public long largestFunctionSize;
        public int largestLineNo;

        private Bounds() {
        }
    }
}

