/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class ColorPalette {
    private static final @NonNull RGB @NonNull [] PALETTE_1 = new RGB[]{new RGB(120, 210, 136), new RGB(145, 214, 154), new RGB(178, 218, 178), new RGB(209, 195, 201), new RGB(255, 194, 168), new RGB(254, 163, 127), new RGB(242, 91, 62), new RGB(242, 62, 78)};
    private static final @NonNull RGB @NonNull [] PALETTE_2 = new RGB[]{new RGB(242, 166, 62), new RGB(252, 199, 74), new RGB(254, 216, 127), new RGB(255, 231, 168), new RGB(209, 202, 195), new RGB(178, 185, 218), new RGB(145, 147, 214), new RGB(122, 120, 210)};
    private static final @NonNull RGB @NonNull [] PALETTE_3 = new RGB[]{new RGB(94, 142, 235), new RGB(125, 166, 233), new RGB(166, 200, 229), new RGB(186, 189, 196), new RGB(159, 228, 217), new RGB(132, 238, 196), new RGB(84, 233, 154), new RGB(72, 223, 104)};
    private static final @NonNull RGB @NonNull [] PALETTE_4 = new RGB[]{new RGB(242, 76, 62), new RGB(252, 110, 74), new RGB(254, 153, 127), new RGB(255, 187, 168), new RGB(209, 195, 195), new RGB(178, 205, 218), new RGB(145, 181, 214), new RGB(120, 163, 210)};
    private static final @NonNull RGB @NonNull [] @NonNull [] PALETTES = new RGB[][]{PALETTE_1, PALETTE_2, PALETTE_3, PALETTE_4};
    private int mPaletteId = 0;
    private int mSeriesCount = 1;
    private int mCurrentSeries = 0;
    private boolean mCurrentPaletteUsed = false;

    private static @NonNull RGB getColor(@NonNull RGB @NonNull [] palette, int seriesIndex, int seriesCount) {
        switch (seriesCount) {
            case 1: {
                return palette[0];
            }
            case 2: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                return palette[7];
            }
            case 3: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                if (seriesIndex == 1) {
                    return palette[4];
                }
                return palette[7];
            }
            case 4: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                if (seriesIndex == 1) {
                    return palette[2];
                }
                if (seriesIndex == 2) {
                    return palette[5];
                }
                return palette[7];
            }
            case 5: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                if (seriesIndex == 1) {
                    return palette[2];
                }
                if (seriesIndex == 2) {
                    return palette[4];
                }
                if (seriesIndex == 3) {
                    return palette[5];
                }
                return palette[7];
            }
            case 6: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                if (seriesIndex == 1) {
                    return palette[1];
                }
                if (seriesIndex == 2) {
                    return palette[3];
                }
                if (seriesIndex == 3) {
                    return palette[4];
                }
                if (seriesIndex == 4) {
                    return palette[6];
                }
                return palette[7];
            }
            case 7: {
                if (seriesIndex == 0) {
                    return palette[0];
                }
                if (seriesIndex == 1) {
                    return palette[1];
                }
                if (seriesIndex == 2) {
                    return palette[2];
                }
                if (seriesIndex == 3) {
                    return palette[3];
                }
                if (seriesIndex == 4) {
                    return palette[5];
                }
                if (seriesIndex == 5) {
                    return palette[6];
                }
                return palette[7];
            }
        }
        if (seriesIndex > seriesCount - 1) {
            seriesIndex %= seriesCount;
        }
        return palette[seriesIndex];
    }

    public @NonNull RGB nextColor() {
        this.mCurrentPaletteUsed = true;
        @NonNull RGB @NonNull [] palette = PALETTES[this.mPaletteId];
        int seriesIndex = this.mCurrentSeries;
        RGB color = ColorPalette.getColor(palette, seriesIndex, this.mSeriesCount);
        this.mCurrentSeries = this.mCurrentSeries < palette.length - 1 ? ++this.mCurrentSeries : 0;
        return color;
    }

    public void nextPalette() {
        if (!this.mCurrentPaletteUsed) {
            return;
        }
        if (++this.mPaletteId >= PALETTES.length) {
            this.mPaletteId = 0;
        }
        this.mCurrentSeries = 0;
        this.mCurrentPaletteUsed = false;
    }

    public void setSeriesCount(int value) {
        this.mSeriesCount = value;
    }

    public static final @NonNull RGB getNextColor(@NonNull Set<@NonNull RGB> colors) {
        @NonNull RGB @NonNull [] bestPalette = PALETTES[0];
        int numberNotInPalette = Integer.MAX_VALUE;
        RGB[][] rGBArray = PALETTES;
        int n = PALETTES.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull RGB @NonNull [] palette = rGBArray[n2];
            HashSet<@NonNull RGB> paletteColors = new HashSet<RGB>(colors);
            paletteColors.removeAll(Arrays.asList(palette));
            if (paletteColors.size() < numberNotInPalette) {
                numberNotInPalette = paletteColors.size();
                bestPalette = palette;
            }
            ++n2;
        }
        int seriesLength = colors.size() + 1;
        int i = 0;
        while (i < seriesLength) {
            RGB color = ColorPalette.getColor(bestPalette, i, seriesLength);
            if (!colors.contains(color)) {
                return color;
            }
            ++i;
        }
        return bestPalette[0];
    }
}

