/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.VisualChartDataProvider;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.model.timeline.TimelineChartDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Charts {
    public static final String CPU_ACTIVITY_USER_NAME = "CPUActivityUser";
    public static final String CPU_ACTIVITY_SYSTEM_NAME = "CPUActivitySystem";
    private final @NonNull Analysis mAnalysis;
    private final @NonNull List<@NonNull IChartDataProvider> mCharts = new ArrayList<IChartDataProvider>();
    private final @NonNull List<@NonNull IChartDataProvider> mProcCharts = new ArrayList<IChartDataProvider>();

    public Charts(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        if (this.mAnalysis.getUseDefaultTemplates()) {
            this.loadFromDefaultConfiguration();
        } else if (analysis.isTimelineConfigurationLoadedFromFile() || analysis.useTimelineConfiguration()) {
            this.loadFromTimelineConfiguration();
        } else {
            this.loadFromCapturedTemplates();
        }
    }

    private void loadFromDefaultConfiguration() {
        for (ChartAndSeriesConfig configChart : this.mAnalysis.getDefaultTimelineConfiguration().getCharts()) {
            this.addNewChart(configChart);
        }
    }

    private void loadFromTimelineConfiguration() {
        TimelineConfig timelineConfig = this.mAnalysis.getTimelineConfiguration();
        for (ChartAndSeriesConfig configChart : timelineConfig.getCharts()) {
            this.addNewChart(configChart);
        }
    }

    private void loadFromCapturedTemplates() {
        @NonNull List<@NonNull ChartAndSeriesConfig> templateCharts = this.mAnalysis.getTemplates().stream().flatMap(t -> TemplateUtils.getChartAndSeriesConfigsToBeApplied(t, false, this.mAnalysis).stream()).collect(Collectors.toList());
        if (templateCharts.isEmpty()) {
            this.loadFromTimelineConfiguration();
        } else {
            TimelineConfig timelineConfig = this.mAnalysis.getTimelineConfiguration();
            templateCharts.addAll(ChartUtility.diffChartsAndSeries(templateCharts, timelineConfig.getCharts(), this.mAnalysis));
            for (ChartAndSeriesConfig configChart : templateCharts) {
                this.addNewChart(configChart);
            }
        }
    }

    public @Nullable IChartDataProvider addNewChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        IChartDataProvider chart = null;
        ChartConfig configChart = chartAndSeriesConfig.getChart();
        try {
            if (configChart.getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
                chart = new VisualChartDataProvider(this.mAnalysis, configChart);
            } else {
                TimelineChartDataProvider timelineChart = new TimelineChartDataProvider(this.mAnalysis, configChart);
                chart = ChartUtility.addNewChartToChartDataProvider(chartAndSeriesConfig, timelineChart, this.mAnalysis);
            }
            this.mCharts.add(chart);
        }
        catch (Exception exception) {
            CommonPlugin.error((String)("Failed adding chart " + configChart.getTitle()), (Throwable)exception);
        }
        return chart;
    }

    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public @NonNull List<@NonNull IChartDataProvider> getCharts() {
        return this.mCharts;
    }

    public int getProcChartCount() {
        return this.mProcCharts.size();
    }
}

