/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.analysis.model.CounterRecordUtils;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.chart.ColorPalette;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.ExpressionNodeFactory;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class ChartUtility {
    private static final @NonNull List<@NonNull CounterDisplay> ABSOLUTE_OPTIONS = CounterDisplay.allCompatibleWith((CounterClass)CounterClass.ABSOLUTE);
    private static final @NonNull List<@NonNull CounterDisplay> ACTIVITY_OPTIONS = CounterDisplay.allCompatibleWith((CounterClass)CounterClass.ACTIVITY);
    private static final @NonNull List<@NonNull CounterDisplay> DELTA_OPTIONS = CounterDisplay.allCompatibleWith((CounterClass)CounterClass.DELTA);
    private static final @NonNull List<@NonNull CounterDisplay> INCIDENT_OPTIONS = CounterDisplay.allCompatibleWith((CounterClass)CounterClass.INCIDENT);
    private static final @NonNull List<@NonNull CounterDisplay> CONSTANT_OPTIONS = CounterDisplay.allCompatibleWith((CounterClass)CounterClass.CONSTANT);

    public static @NonNull TimelineConfig createChartFromSingleSource(@NonNull IBinDataProvider binData) {
        ArrayList<@NonNull IBinDataProvider> list = new ArrayList<IBinDataProvider>();
        list.add(binData);
        return ChartUtility.createTimelineConfig(list);
    }

    public static @NonNull TimelineConfig createChartForWildCard(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        TimelineConfig timelineConfig = new TimelineConfig();
        ChartAndSeriesConfig addNewChartConfiguration = chartAndSeriesConfig.clone();
        timelineConfig.addChartAndSeriesConfigs(List.of(addNewChartConfiguration));
        return timelineConfig;
    }

    public static @NonNull SeriesConfig createSeriesConfig(@NonNull IBinDataProvider binData, @NonNull List<@NonNull AbstractSeriesConfig> existingSeries) {
        return ChartUtility.createSeriesConfig(binData, () -> {
            Set<@NonNull RGB> existingColors = existingSeries.stream().map(AbstractSeriesConfig::getColor).collect(Collectors.toSet());
            return ColorPalette.getNextColor(existingColors);
        });
    }

    private static @NonNull SeriesConfig createSeriesConfig(@NonNull IBinDataProvider binData, @NonNull Supplier<@NonNull RGB> color) {
        CounterRecord counter = binData.getCounterRecord();
        RGB counterColor = CounterRecordUtils.getColorRGB(counter);
        RGB rgbColor = (RGB)NullChecking.neverNullOrCreate((Object)counterColor, color);
        return SeriesConfig.create(counter.getName(), counter.getDescription(), binData.getExpressionFormat(), counter.getDisplay(), counter.getUnits(), rgbColor);
    }

    public static @NonNull TimelineConfig createTimelineConfig(@NonNull List<? extends @NonNull IBinDataProvider> binProviders) {
        TimelineConfig timelineConfig = new TimelineConfig();
        ChartUtility.addToTimelineConfig(timelineConfig, StreamUtils.superOf(binProviders.stream()));
        return timelineConfig;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void addToTimelineConfig(@NonNull TimelineConfig timelineConfig, @NonNull Stream<@NonNull IBinDataProvider> binProviders) {
        @NonNull Map chartsMap = binProviders.filter(p -> !p.getCounterRecord().hideByDefault()).sorted().collect(Collectors.groupingBy(IBinDataProvider::getSeriesHash, LinkedHashMap::new, Collectors.toList()));
        ColorPalette colorPalette = new ColorPalette();
        for (Map.Entry entry : chartsMap.entrySet()) {
            ChartAndSeriesConfig config = timelineConfig.addNewChartConfiguration();
            ChartConfig chart = config.getChart();
            @NonNull List providers = (List)entry.getValue();
            String title = ((IBinDataProvider)providers.get(0)).getTitleFormat();
            chart.setTitle(title);
            boolean averageSelection = false;
            boolean averageCores = false;
            boolean percentage = false;
            colorPalette.setSeriesCount(providers.size());
            TObjectIntHashMap consensusSeriesComposition = new TObjectIntHashMap();
            TObjectIntHashMap consensusGraphRenderingType = new TObjectIntHashMap();
            for (IBinDataProvider provider : providers) {
                CounterRecord counter = provider.getCounterRecord();
                config.addSeries(ChartUtility.createSeriesConfig(provider, colorPalette::nextColor));
                averageSelection |= counter.isAverageSelection();
                averageCores |= counter.isAverageCores();
                percentage |= counter.isPercentage();
                consensusSeriesComposition.adjustOrPutValue((Object)counter.getSeriesComposition(), 1, 1);
                consensusGraphRenderingType.adjustOrPutValue((Object)counter.getRenderingType(), 1, 1);
            }
            chart.setAverageSelection(averageSelection);
            chart.setAverageCores(averageCores);
            chart.setPercentage(percentage);
            chart.setSeriesComposition(ChartUtility.vote(consensusSeriesComposition, SeriesComposition.DEFAULT));
            chart.setRenderingType(ChartUtility.vote(consensusGraphRenderingType, GraphRenderingType.DEFAULT));
            colorPalette.nextPalette();
        }
    }

    public static List<CounterDisplay> getDisplayOptions(CounterClass cclass) {
        switch (cclass) {
            case ABSOLUTE: {
                return ABSOLUTE_OPTIONS;
            }
            case ACTIVITY: {
                return ACTIVITY_OPTIONS;
            }
            case DELTA: {
                return DELTA_OPTIONS;
            }
            case INCIDENT: {
                return INCIDENT_OPTIONS;
            }
            case CONSTANT: {
                return CONSTANT_OPTIONS;
            }
        }
        return new ArrayList<CounterDisplay>();
    }

    public static @NonNull Set<@NonNull String> getVariableSetFromExpression(@NonNull ExpressionData expression) {
        @NonNull HashSet<@NonNull String> set = new HashSet<String>();
        try {
            ChartUtility.getVariableSetFromExpression(expression, set);
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
        return set;
    }

    public static void getVariableSetFromExpression(@NonNull ExpressionData expression, final @NonNull Set<@NonNull String> set) throws ExpressionException {
        ExpressionNodeFactory.IBaseExpressionNode tree = expression.getSyntaxTree();
        if (tree != null) {
            tree.accept(new ExpressionNodeFactory.IBaseExpressionNodeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void binaryOp(Void data,  @NonNull IExpressionNode.BinaryOp op,  @NonNull ExpressionNodeFactory.IBaseExpressionNode lhs,  @NonNull ExpressionNodeFactory.IBaseExpressionNode rhs) throws RuntimeException {
                    lhs.accept(this, data);
                    rhs.accept(this, data);
                    return null;
                }

                @Override
                public Void constant(Void data,  @NonNull IExpressionNode.BuiltInConstant constant) throws RuntimeException {
                    return null;
                }

                @Override
                public Void function(Void data,  @NonNull IExpressionNode.FunctionOp functionOp, @NonNull List< @NonNull ExpressionNodeFactory.IBaseExpressionNode> args) throws RuntimeException {
                    args.forEach(a -> {
                        Void void_2 = a.accept(this, data);
                    });
                    return null;
                }

                @Override
                public Void number(Void data, double value) throws RuntimeException {
                    return null;
                }

                @Override
                public Void unaryOp(Void data,  @NonNull IExpressionNode.UnaryOp op,  @NonNull ExpressionNodeFactory.IBaseExpressionNode value) throws RuntimeException {
                    value.accept(this, data);
                    return null;
                }

                @Override
                public Void variable(Void data, @NonNull String variable) throws RuntimeException {
                    set.add(variable);
                    return null;
                }
            }, null);
        }
    }

    public static boolean isAverageSelectionPossible(CounterDisplay display, boolean isComplex) {
        return !display.isMaximum() && !display.isMinimum() && !display.isAverage() && !isComplex;
    }

    public static boolean isCompatible(@NonNull CounterDisplay display, @NonNull CounterClass counterClass) {
        return counterClass.isConstant() || display.isCompatibleWith(counterClass);
    }

    public static boolean isExpressionComplex(@NonNull ExpressionData expression) {
        return !ChartUtility.isExpressionSingleSourceWithNoMathOperators(expression);
    }

    public static boolean isExpressionSingleSourceWithNoMathOperators(@NonNull ExpressionData expression) {
        try {
            ExpressionNodeFactory.IBaseExpressionNode tree = expression.getSyntaxTree();
            if (tree != null) {
                Boolean result = tree.accept(new ExpressionNodeFactory.IBaseExpressionNodeVisitor<Void, Boolean, RuntimeException>(){

                    @Override
                    public Boolean binaryOp(Void data,  @NonNull IExpressionNode.BinaryOp op,  @NonNull ExpressionNodeFactory.IBaseExpressionNode lhs,  @NonNull ExpressionNodeFactory.IBaseExpressionNode rhs) throws RuntimeException {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean constant(Void data,  @NonNull IExpressionNode.BuiltInConstant constant) throws RuntimeException {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean function(Void data,  @NonNull IExpressionNode.FunctionOp functionOp, @NonNull List< @NonNull ExpressionNodeFactory.IBaseExpressionNode> args) throws RuntimeException {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean number(Void data, double value) throws RuntimeException {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean unaryOp(Void data,  @NonNull IExpressionNode.UnaryOp op,  @NonNull ExpressionNodeFactory.IBaseExpressionNode value) throws RuntimeException {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean variable(Void data, @NonNull String variable) throws RuntimeException {
                        return Boolean.TRUE;
                    }
                }, null);
                return result;
            }
            return false;
        }
        catch (ExpressionException e) {
            return false;
        }
    }

    public static boolean isSourceFilterable(CounterRecord cr) {
        return cr.isSourceFilterable();
    }

    private static <T> T vote(TObjectIntHashMap<T> counts, T def) {
        if (counts.size() == 1) {
            TObjectIntIterator itr = counts.iterator();
            itr.hasNext();
            itr.advance();
            return (T)itr.key();
        }
        counts.remove(def);
        Object popular = def;
        int count = -1;
        TObjectIntIterator itr = counts.iterator();
        while (itr.hasNext()) {
            itr.advance();
            if (itr.value() <= count) continue;
            popular = itr.key();
            count = itr.value();
        }
        return popular;
    }

    public static @NonNull IChartDataProvider addNewChartToChartDataProvider(ChartAndSeriesConfig chartAndSeriesConfig, @NonNull IChartDataProvider timelineChart, @NonNull ICaptureDataProvider cdp) {
        chartAndSeriesConfig.getAllExpandedSeries(cdp).forEach(timelineChart::createSeries);
        chartAndSeriesConfig.getAllExpandedSeries(cdp).stream().filter(c -> c.isExpandedSeries()).map(c -> (WildcardSeriesConfig)NullChecking.neverNull((Object)c.getExpandedFromWildCard())).distinct().forEach(c -> {
            IWildcardSeriesDataProvider iWildcardSeriesDataProvider = timelineChart.createWildcardSeries((WildcardSeriesConfig)NullChecking.neverNull((Object)c));
        });
        return timelineChart;
    }

    public static boolean canBeRespresentedAsAHeatMapChart(@NonNull IChartDataProvider chartDataProvider) {
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chartDataProvider.getCoreInformationProvider();
        return coreInformationProvider.getDeviceType() != null && coreInformationProvider.getChannelCount() > 1;
    }

    public static @NonNull List<@NonNull ChartAndSeriesConfig> diffChartsAndSeries(@NonNull Collection<@NonNull ChartAndSeriesConfig> left, @NonNull Collection<@NonNull ChartAndSeriesConfig> right, @NonNull ICaptureDataProvider cdp) {
        Set<@NonNull T> variables = left.stream().flatMap(c -> c.getAllExpandedSeries(cdp).stream()).flatMap(e -> ChartUtility.getVariableSetFromExpression(e.getExpression()).stream()).collect(Collectors.toSet());
        ArrayList<@NonNull ChartAndSeriesConfig> charts = new ArrayList<ChartAndSeriesConfig>();
        for (ChartAndSeriesConfig configChart : right) {
            ChartAndSeriesConfig config = configChart.clone();
            config.reset();
            config.addAllSeries(configChart.getUnexpandedSeries().stream().filter(s -> s.createSeriesFromSources(cdp).stream().flatMap(m -> ChartUtility.getVariableSetFromExpression(m.getExpression()).stream()).anyMatch(v -> !variables.contains(v))).collect(Collectors.toSet()));
            if (config.getUnexpandedSeries().isEmpty()) continue;
            charts.add(config);
        }
        return charts;
    }

    public static @NonNull Optional<@NonNull IChartDataProvider> findExisitingChartForWildCardSeries(@NonNull Optional<@NonNull ChartAndSeriesConfig> csWithwildCardTemplateMatched, @NonNull List<@NonNull IChartDataProvider> charts, @NonNull List<@NonNull TemplateFile> templates) {
        if (csWithwildCardTemplateMatched.isEmpty()) {
            return Optional.empty();
        }
        return charts.stream().filter(chart -> {
            Optional<ChartAndSeriesConfig> allWildCardsMatchedCSfromTemplate;
            Optional<WildcardSeriesConfig> wildcardSeries;
            if (chart.getChartConfig().getTitle().equals(((ChartAndSeriesConfig)csWithwildCardTemplateMatched.get()).getChart().getTitle()) && (wildcardSeries = ((ChartAndSeriesConfig)csWithwildCardTemplateMatched.get()).getUnexpandedSeries().stream().filter(s -> s.isExpandedSeries()).map(s -> ((SeriesConfig)s).getExpandedFromWildCard()).findFirst()).isPresent() && (allWildCardsMatchedCSfromTemplate = templates.stream().flatMap(cs -> {
                List<ChartAndSeriesConfig> chartSeries = cs.getCharts();
                return chartSeries.stream().filter(i -> i.getChart().getTitle().equals(chart.getChartConfig().getTitle()));
            }).filter(fs -> fs.getUnexpandedSeries().stream().filter(u -> u.equals(wildcardSeries.get())).count() > 0L).findFirst()).isPresent()) {
                return chart.getSeries().stream().anyMatch(c -> c.getConfig().isExpandedSeries() && ((ChartAndSeriesConfig)allWildCardsMatchedCSfromTemplate.get()).getUnexpandedSeries().contains(c.getConfig().getExpandedFromWildCard()));
            }
            return false;
        }).findFirst();
    }

    public static void addWildCardSeriesToExistingChart(@NonNull Optional<@NonNull ChartAndSeriesConfig> csWithwildCardTemplateMatched, @NonNull IChartDataProvider existingChartWithWildCardMatched, @NonNull List<@NonNull SeriesConfig> allExpandedSeries, @NonNull Function<@NonNull WildcardSeriesConfig, @NonNull List<@NonNull SeriesConfig>> createSeriesFromSource, @NonNull Consumer<@NonNull ISeriesDataProvider> notifySeriesAdded) {
        if (csWithwildCardTemplateMatched.isEmpty()) {
            return;
        }
        List<ISeriesDataProvider> series = existingChartWithWildCardMatched.getSeries();
        allExpandedSeries.stream().filter(c -> !ChartUtility.isSeriesPresent(series, c)).forEach(c -> {
            WildcardSeriesConfig toBeMatched = c.getExpandedFromWildCard();
            Optional<AbstractSeriesConfig> chartSeriesMatchedForWildCard = ((ChartAndSeriesConfig)csWithwildCardTemplateMatched.get()).getUnexpandedSeries().stream().filter(s -> {
                WildcardSeriesConfig expandedFromWildCard = ((SeriesConfig)s).getExpandedFromWildCard();
                return expandedFromWildCard != null && expandedFromWildCard.equals(toBeMatched);
            }).findFirst();
            if (chartSeriesMatchedForWildCard.isPresent()) {
                List createSeriesFromSources = (List)createSeriesFromSource.apply((WildcardSeriesConfig)NullChecking.neverNull((Object)toBeMatched));
                List existingSeries = existingChartWithWildCardMatched.getSeries().stream().map(sc -> sc.getConfig()).collect(Collectors.toList());
                Optional<SeriesConfig> findFirst = createSeriesFromSources.stream().filter(conf -> !existingSeries.contains(conf)).findFirst();
                if (findFirst.isPresent()) {
                    SeriesConfig seriesConfig = findFirst.get();
                    WildcardSeriesConfig expandedFromWildCard = seriesConfig.getExpandedFromWildCard();
                    boolean noSereiesDataProviderFound = existingChartWithWildCardMatched.getWildcardSeries().stream().anyMatch(wsdp -> !wsdp.getSeriesConfig().equals(expandedFromWildCard));
                    if (noSereiesDataProviderFound && expandedFromWildCard != null) {
                        existingChartWithWildCardMatched.createWildcardSeries(expandedFromWildCard);
                    }
                    ISeriesDataProvider expandedSeries = existingChartWithWildCardMatched.createSeries(seriesConfig);
                    notifySeriesAdded.accept(expandedSeries);
                }
            }
        });
    }

    private static boolean isSeriesPresent(@NonNull List<@NonNull ISeriesDataProvider> series, @NonNull SeriesConfig c) {
        return series.stream().anyMatch(seriesConf -> seriesConf.getConfig().equals(c));
    }
}

