/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class CAMConfig
implements Cloneable {
    public static final String TAG = "cam";
    private static final String ATTR_VIEW_ID = "view_id";
    private static final String ATTR_SHOW_CONNECTIONS = "show_cam_connections";
    private boolean mShowCamConnections;
    private String mViewId;

    public CAMConfig() {
    }

    public CAMConfig(boolean showConnections) {
        this.mShowCamConnections = showConnections;
    }

    public CAMConfig(String viewId, boolean showConnections) {
        this.mShowCamConnections = showConnections;
        this.mViewId = viewId;
    }

    public @NonNull CAMConfig clone() {
        CAMConfig result = new CAMConfig();
        result.mShowCamConnections = this.mShowCamConnections;
        result.mViewId = this.mViewId;
        return result;
    }

    public void load(XMLParser in) {
        this.reset();
        this.mViewId = in.getAttribute(ATTR_VIEW_ID, "");
        this.mShowCamConnections = in.isAttributeSet(ATTR_SHOW_CONNECTIONS, false);
    }

    private void reset() {
        this.mViewId = "";
        this.mShowCamConnections = false;
    }

    public Object save(XMLGenerator xml) throws IOException {
        xml.startTag(TAG);
        xml.addAttribute(ATTR_VIEW_ID, this.mViewId);
        xml.addAttributeBool(ATTR_SHOW_CONNECTIONS, this.mShowCamConnections);
        xml.endTag();
        return null;
    }

    public boolean showAllCAMConnections() {
        return this.mShowCamConnections;
    }

    public String getViewId() {
        return this.mViewId;
    }
}

