/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.ISeriesConfigTemplate;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractSeriesConfig
implements ISeriesConfigTemplate {
    private @NonNull String mName = "";
    private @NonNull String mDescription = "";
    private boolean autoRotateColor = false;
    private @NonNull List<@NonNull String> colorList = new ArrayList<String>();
    private @NonNull String mUnits = "";
    private @NonNull CounterDisplay mDisplay = CounterDisplay.getDefault();
    private @NonNull RGB mRGB = (RGB)NullChecking.neverNull((Object)RGBUtils.decode("60,150,251"));

    public void setName(@NonNull String name) {
        this.mName = name;
    }

    public void setUnits(@Nullable String units) {
        if (units == null) {
            units = "";
        }
        this.mUnits = units;
    }

    public final @NonNull RGB getColor() {
        return this.mRGB;
    }

    public final @NonNull String getDescriptionFormat() {
        return this.mDescription;
    }

    public final @NonNull CounterDisplay getDisplay() {
        return this.mDisplay;
    }

    public final String getUnits() {
        return this.mUnits;
    }

    public final void setColor(@Nullable RGB rgb) {
        if (rgb == null) {
            rgb = (RGB)NullChecking.neverNull((Object)RGBUtils.decode("60,150,251"));
        }
        this.setColor(rgb.red, rgb.green, rgb.blue);
    }

    private final void setColor(int red, int green, int blue) {
        this.mRGB.red = red;
        this.mRGB.green = green;
        this.mRGB.blue = blue;
    }

    public final void setColor(@Nullable String color) {
        if (color == null || color.isEmpty()) {
            color = "60,150,251";
        }
        this.setColor(RGBUtils.decode(color));
    }

    public final void setDescriptionFormat(@Nullable String description) {
        if (description == null) {
            description = "";
        }
        this.mDescription = description;
    }

    public final void setDisplay(CounterDisplay display) {
        if (display == null) {
            display = CounterDisplay.getDefault();
        }
        if (this.mDisplay != display) {
            this.mDisplay = display;
            this.notifyListeners();
        }
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public abstract void addListener( @NonNull SeriesConfig.IListener var1);

    public abstract void removeListener( @NonNull SeriesConfig.IListener var1);

    public abstract void notifyListeners();

    public abstract @NonNull AbstractSeriesConfig clone();

    public abstract boolean matches(@NonNull AbstractSeriesConfig var1);

    public abstract boolean isExpandedSeries();

    public abstract boolean isWildcardSeries();

    public abstract @Nullable ExpressionData getExpression();

    public abstract @Nullable String getMatchWith();

    public abstract void setExpression(@NonNull String var1);

    public boolean isAutoRotateColor() {
        return this.autoRotateColor;
    }

    public void setAutoRotateColor(boolean autoRotateColor) {
        this.autoRotateColor = autoRotateColor;
    }

    public @NonNull List<@NonNull String> getColorList() {
        return this.colorList;
    }

    public void setColorList(@NonNull List<@NonNull String> colorList) {
        this.colorList = colorList;
    }
}

