/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.analysis.model.ChannelDescriptorUtils;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.CounterRecordFile;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.bindata.BinDataAtScale;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineBinDataProvider
implements IBinDataProvider {
    public static final String LIMITS_BIN = "limits.bin";
    private final @NonNull ProcessingElementReference @NonNull [] mChannelDescriptors;
    private final @NonNull CounterRecord mCounterRecord;
    private final @NonNull Map<CounterDisplay, TIntObjectHashMap<BinDataAtScale>> mDataAtScale = new HashMap<CounterDisplay, TIntObjectHashMap<BinDataAtScale>>();
    private final @NonNull File mDirectory;
    private final @NonNull Set<@NonNull CounterDisplay> mDisplaySet = new HashSet<CounterDisplay>();
    private final @NonNull ToIntFunction<@NonNull ProcessingElementReference> mFindChannelNumber;
    private final long @NonNull [] mLimits;
    private long mPrepareRangeEnd;
    private int mPrepareRangeScale;
    private long mPrepareRangeStart;
    private @NonNull ZoomLevel @NonNull [] mZoomLevels;

    private static long @NonNull [] calculateLimits(File dir) {
        File file = new File(dir, LIMITS_BIN);
        int length = (int)file.length();
        long[] limits = new long[length / 8];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                byte[] buffer = new byte[length];
                raf.readFully(buffer);
                int i = 0;
                while (i < length) {
                    limits[i / 8] = BufferUtils.readLELong((byte[])buffer, (int)i);
                    i += 8;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return limits;
    }

    public TimelineBinDataProvider(@NonNull File dir, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull StateFile stateFile) throws IOException {
        boolean channelDescriptorsIsSorted;
        this.mDirectory = dir;
        this.mCounterRecord = CounterRecordFile.counterRecordReader((File)this.mDirectory);
        this.mChannelDescriptors = (ProcessingElementReference[])NullChecking.neverNullOrCreate((Object)this.mCounterRecord.getChannelDescriptions(), () -> ChannelDescriptorUtils.makeChannelDescriptors((ProcessingElementReferenceSet)processingElementsReferenceSet, (CounterRecord)this.mCounterRecord));
        boolean bl = channelDescriptorsIsSorted = this.mChannelDescriptors.length > 4;
        if (channelDescriptorsIsSorted) {
            ProcessingElementReference lastProcessingElementReference = null;
            ProcessingElementReference[] processingElementReferenceArray = this.mChannelDescriptors;
            int n = this.mChannelDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessingElementReference peReference2 = processingElementReferenceArray[n2];
                if (lastProcessingElementReference == null) {
                    lastProcessingElementReference = peReference2;
                } else if (lastProcessingElementReference.compareTo(peReference2) > 0) {
                    channelDescriptorsIsSorted = false;
                }
                ++n2;
            }
        }
        this.mFindChannelNumber = channelDescriptorsIsSorted ? peReference -> Arrays.binarySearch(this.mChannelDescriptors, peReference) : peReference -> {
            int index = 0;
            while (index < this.mChannelDescriptors.length) {
                if (this.mChannelDescriptors[index].equals(peReference)) {
                    return index;
                }
                ++index;
            }
            return -1;
        };
        this.mZoomLevels = stateFile.getResolution().toZoomLevels();
        this.populateHashmap();
        this.mLimits = TimelineBinDataProvider.calculateLimits(this.mDirectory);
    }

    @Override
    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
        return this.mChannelDescriptors;
    }

    @Override
    public @NonNull CounterRecord getCounterRecord() {
        return this.mCounterRecord;
    }

    @Override
    public long[] getLimits() {
        return this.mLimits;
    }

    @Override
    public int getRescale(@NonNull ZoomLevel desiredZoomLevel) {
        if (desiredZoomLevel.getBps() > this.mZoomLevels[this.mZoomLevels.length - 1].getBps()) {
            return desiredZoomLevel.getBps() / this.mZoomLevels[this.mZoomLevels.length - 1].getBps();
        }
        return 1;
    }

    @Override
    public synchronized long getValue(@NonNull CounterDisplay display, int scale, long bin, int channelNumber, @Nullable TIntSet tids) {
        BinDataAtScale atScale;
        TIntObjectHashMap<BinDataAtScale> atDisplay;
        long value = 0L;
        if (!this.mDisplaySet.contains(display) && ChartUtility.getDisplayOptions(this.mCounterRecord.getCounterClass()).contains(display)) {
            this.mDisplaySet.add(display);
            if (this.mPrepareRangeScale != 0) {
                this.run();
            }
        }
        if ((atDisplay = this.mDataAtScale.get(display)) != null && (atScale = (BinDataAtScale)atDisplay.get(scale)) != null) {
            value = !this.isFilterable() ? atScale.getValue(bin, channelNumber, null) : atScale.getValue(bin, channelNumber, tids);
        }
        return value;
    }

    @Override
    public boolean isFilterable() {
        return ChartUtility.isSourceFilterable(this.mCounterRecord);
    }

    @Override
    public int mapChannelNumber(@NonNull ProcessingElementReference peReference) {
        return this.mFindChannelNumber.applyAsInt(peReference);
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel desiredZoomLevel, long start, long end) {
        int rescale = this.getRescale(desiredZoomLevel);
        this.mPrepareRangeScale = desiredZoomLevel.getBps() / rescale;
        this.mPrepareRangeStart = start;
        this.mPrepareRangeEnd = end;
    }

    @Override
    public synchronized void run() {
        int core = 0;
        for (CounterDisplay display : this.mDisplaySet) {
            BinDataAtScale data = (BinDataAtScale)((TIntObjectHashMap)NullChecking.neverNull(this.mDataAtScale.get(display))).get(this.mPrepareRangeScale);
            data.setAutoCloseFiles(false);
            long bin = this.mPrepareRangeStart;
            while (bin <= this.mPrepareRangeEnd) {
                data.getValue(bin, core, null);
                ++bin;
            }
            data.setAutoCloseFiles(true);
            data.closeFiles();
        }
    }

    private void populateHashmap() throws IOException {
        List<CounterDisplay> displays = ChartUtility.getDisplayOptions(this.mCounterRecord.getCounterClass());
        for (CounterDisplay display : displays) {
            ZoomLevel[] zoomLevelArray = this.mZoomLevels;
            int n = this.mZoomLevels.length;
            int n2 = 0;
            while (n2 < n) {
                ZoomLevel zoomLevel = zoomLevelArray[n2];
                BinDataAtScale data = new BinDataAtScale(this.mDirectory, display.getSelection(), zoomLevel);
                TIntObjectHashMap scaleData = this.mDataAtScale.get(display);
                if (scaleData == null) {
                    scaleData = new TIntObjectHashMap();
                    this.mDataAtScale.put(display, (TIntObjectHashMap<BinDataAtScale>)scaleData);
                }
                scaleData.put(zoomLevel.getBps(), (Object)data);
                ++n2;
            }
        }
    }

    @Override
    public void setBulkDataAccessMode(boolean mode) {
        if (mode) {
            this.mDataAtScale.forEach((key, value) -> value.forEachValue(atScale -> {
                atScale.setAutoCloseFiles(false);
                return true;
            }));
        } else {
            this.mDataAtScale.forEach((key, value) -> value.forEachValue(atScale -> {
                atScale.setAutoCloseFiles(true);
                atScale.closeFiles();
                return true;
            }));
        }
    }
}

