/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.ClusterNameUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EventBasedSampleInfo {
    private final @NonNull List<@NonNull Event> events;

    public static @Nullable EventBasedSampleInfo create(@NonNull List<@NonNull CounterRecord> counterList) {
        @NonNull ArrayList<@NonNull Event> events = new ArrayList<Event>();
        for (CounterRecord counter : counterList) {
            int eventCount = counter.getEventCount();
            if (eventCount <= 0) continue;
            String ebsCounter = counter.getTitle() + ": " + counter.getName();
            if (counter.getCluster() != null) {
                ebsCounter = ebsCounter + " (" + ClusterNameUtils.getArchName((String)counter.getCounter()) + ")";
            }
            events.add(new Event(ebsCounter, eventCount));
        }
        if (events.isEmpty()) {
            return null;
        }
        return new EventBasedSampleInfo(events);
    }

    public EventBasedSampleInfo(@NonNull Collection<@NonNull Event> events) {
        assert (!events.isEmpty());
        this.events = Collections.unmodifiableList(new ArrayList<Event>(new TreeSet<Event>(events)));
    }

    public @NonNull List<@NonNull Event> getEvents() {
        return this.events;
    }

    public static final class Event
    implements Comparable<Event> {
        private final @NonNull String mCounter;
        private final int mThreshold;

        public Event(@NonNull String counter, int threadhold) {
            this.mCounter = counter;
            this.mThreshold = threadhold;
        }

        @Override
        public int compareTo(Event o) {
            int result = this.mCounter.compareTo(o.mCounter);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.mThreshold, o.mThreshold);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Event) {
                Event that = (Event)obj;
                return this.mThreshold == that.mThreshold && this.mCounter.contentEquals(that.mCounter);
            }
            return false;
        }

        public @NonNull String getCounter() {
            return this.mCounter;
        }

        public int getThreshold() {
            return this.mThreshold;
        }

        public int hashCode() {
            return this.mCounter.hashCode() * 31 ^ this.mThreshold;
        }
    }
}

