/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.ISamplesCallback;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisRecompute {
    protected final @NonNull Analysis mAnalysis;
    private @Nullable AnalysisFilterThread mAnalysisFilterThread = null;
    private @Nullable AnalysisSamplesThread mAnalysisSamplesThread = null;

    public AnalysisRecompute(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
    }

    public void cancel() {
        this.cancelFilterThread();
        this.cancelSamplesThread();
    }

    public synchronized boolean isAlive() {
        if (this.mAnalysisFilterThread != null && this.mAnalysisFilterThread.isAlive()) {
            return true;
        }
        return this.mAnalysisSamplesThread != null && this.mAnalysisSamplesThread.isAlive();
    }

    public synchronized void recomputeFilter(@NonNull IProgressMonitorFactory progressMonitorFactory, long startTick, long endTick, @NonNull TIntSet upids, @NonNull TIntSet utids, @NonNull Runnable closeProgressDialog) {
        AnalysisFilterThread stream;
        this.cancelFilterThread();
        this.mAnalysisFilterThread = stream = new AnalysisFilterThread(progressMonitorFactory, startTick, endTick, upids, utids, closeProgressDialog);
        stream.start();
    }

    public synchronized void recomputeSamples(@NonNull IProgressMonitorFactory progressMonitorFactory, long startTick, long endTick, @NonNull ISamplesCallback callback) {
        AnalysisSamplesThread stream;
        this.cancelSamplesThread();
        this.mAnalysisSamplesThread = stream = new AnalysisSamplesThread(progressMonitorFactory, startTick, endTick, callback);
        stream.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFilterThread() {
        AnalysisFilterThread thread = null;
        AnalysisRecompute analysisRecompute = this;
        synchronized (analysisRecompute) {
            thread = this.mAnalysisFilterThread;
            this.mAnalysisFilterThread = null;
        }
        if (thread != null) {
            try {
                thread.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSamplesThread() {
        AnalysisSamplesThread thread = null;
        AnalysisRecompute analysisRecompute = this;
        synchronized (analysisRecompute) {
            thread = this.mAnalysisSamplesThread;
            this.mAnalysisSamplesThread = null;
        }
        if (thread != null) {
            try {
                thread.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class AnalysisFilterThread
    extends AnalysisThread {
        private final @NonNull Runnable closeProgressDialog;
        private final long @Nullable [] upids;
        private final long @Nullable [] utids;

        public AnalysisFilterThread(IProgressMonitorFactory progressMonitorFactory, long startTick, @NonNull long endTick, @NonNull TIntSet upids, @NonNull TIntSet utids, Runnable closeProgressDialog) {
            super(progressMonitorFactory, startTick, endTick, "RecomputeFilter");
            this.closeProgressDialog = closeProgressDialog;
            this.upids = AnalysisFilterThread.toLongs(upids);
            this.utids = AnalysisFilterThread.toLongs(utids);
        }

        private static long @Nullable [] toLongs(@NonNull TIntSet uids) {
            if (uids.isEmpty()) {
                return null;
            }
            long[] result = new long[uids.size()];
            int index = 0;
            TIntIterator it = uids.iterator();
            while (it.hasNext()) {
                result[index] = it.next();
                ++index;
            }
            Arrays.sort(result);
            return result;
        }

        @Override
        public void work() throws Exception {
            @NonNull Callable callable = AnalysisRecompute.this.mAnalysis.getInstructionCounterModel().createRecomputeSelectedCounterRange(this.cancellationPredicate, this.progressMonitorFactory, this.startTick, this.endTick, AnalysisRecompute.this.mAnalysis.shouldFilterCallStacks(), AnalysisRecompute.this.mAnalysis.shouldFilterKernelAddresses(), AnalysisRecompute.this.mAnalysis.shouldInvertCallStacks(), AnalysisRecompute.this.mAnalysis.shouldUseInlines(), this.upids, this.utids);
            callable.call();
            AnalysisRecompute.this.mAnalysis.notifyRecomputeFromModel();
            AnalysisRecompute.this.mAnalysis.notifyReAnalysisListenersOfCompletion();
            this.closeProgressDialog.run();
        }
    }

    private class AnalysisSamplesThread
    extends AnalysisThread {
        private final @NonNull ISamplesCallback callback;

        public AnalysisSamplesThread(IProgressMonitorFactory progressMonitorFactory, long startTick, @NonNull long endTick, ISamplesCallback callback) {
            super(progressMonitorFactory, startTick, endTick, "RecomputeSamples");
            this.callback = callback;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void work() throws Exception {
            @NonNull @NonNull @NonNull Callable callable = AnalysisRecompute.this.mAnalysis.getInstructionCounterModel().createRecomputeCSMSamplesData(this.cancellationPredicate, this.progressMonitorFactory, this.startTick, this.endTick, AnalysisRecompute.this.mAnalysis.shouldFilterCallStacks(), AnalysisRecompute.this.mAnalysis.shouldFilterKernelAddresses(), AnalysisRecompute.this.mAnalysis.shouldInvertCallStacks(), AnalysisRecompute.this.mAnalysis.shouldUseInlines());
            this.callback.setSamples((List)callable.call());
        }
    }

    private static abstract class AnalysisThread
    implements AutoCloseable,
    Runnable {
        protected final long endTick;
        protected final long startTick;
        protected final @NonNull CancellationPredicate cancellationPredicate = new CancellationPredicate();
        protected final @NonNull IProgressMonitorFactory progressMonitorFactory;
        private final @NonNull Thread workerThread;

        public AnalysisThread(@NonNull IProgressMonitorFactory progressMonitorFactory, long startTick, long endTick, @NonNull String threadName) {
            this.startTick = startTick;
            this.endTick = endTick;
            this.progressMonitorFactory = progressMonitorFactory;
            this.workerThread = new Thread(this);
            this.workerThread.setName(threadName);
            this.workerThread.setDaemon(true);
            this.workerThread.setPriority(6);
        }

        public void start() {
            this.workerThread.start();
        }

        @Override
        public final void close() throws Exception {
            this.cancellationPredicate.cancel();
            try {
                try {
                    this.workerThread.interrupt();
                    this.workerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    this.cancellationPredicate.close();
                }
            }
            finally {
                this.cancellationPredicate.close();
            }
        }

        @Override
        public final void run() {
            try {
                this.work();
            }
            catch (IOException | InterruptedException exception) {
            }
            catch (Throwable throwable) {
                CommonPlugin.error((Throwable)throwable);
            }
        }

        public final boolean isAlive() {
            return this.workerThread.isAlive();
        }

        protected abstract void work() throws Exception;
    }
}

