/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.gcwrapper;

import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public final class GC {
    public final org.eclipse.swt.graphics.GC realGC;
    private @Nullable Rectangle cachedClipping = null;
    private int cachedTranslationX = 0;
    private int cachedTranslationY = 0;
    private boolean isClippingCached = false;
    private boolean isTranslationKnown = false;

    public GC(Drawable drawable) {
        this.realGC = new org.eclipse.swt.graphics.GC(drawable);
    }

    public GC(Drawable drawable, int style) {
        this.realGC = new org.eclipse.swt.graphics.GC(drawable, style);
    }

    public GC(org.eclipse.swt.graphics.GC realGC) {
        this.realGC = realGC;
    }

    public void clearTranslate() {
        this.realGC.setTransform(null);
        if (this.isTranslationKnown) {
            this.translateClipping(-this.cachedTranslationX, -this.cachedTranslationY);
        }
        this.isTranslationKnown = true;
        this.cachedTranslationX = 0;
        this.cachedTranslationY = 0;
    }

    public void copyArea(Image image, int x, int y) {
        this.realGC.copyArea(image, x, y);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.realGC.copyArea(srcX, srcY, width, height, destX, destY);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        this.realGC.copyArea(srcX, srcY, width, height, destX, destY, paint);
    }

    public void dispose() {
        this.realGC.dispose();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.realGC.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawFocus(int x, int y, int width, int height) {
        this.realGC.drawFocus(x, y, width, height);
    }

    public void drawImage(Image image, int x, int y) {
        this.realGC.drawImage(image, x, y);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        this.realGC.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.realGC.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.realGC.drawOval(x, y, width, height);
    }

    public void drawPath(Path path) {
        this.realGC.drawPath(path);
    }

    public void drawPoint(int x, int y) {
        this.realGC.drawPoint(x, y);
    }

    public void drawPolygon(int[] pointArray) {
        this.realGC.drawPolygon(pointArray);
    }

    public void drawPolyline(int[] pointArray) {
        this.realGC.drawPolyline(pointArray);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.realGC.drawRectangle(x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        this.realGC.drawRectangle(rect);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.realGC.drawRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawString(String string, int x, int y) {
        this.realGC.drawString(string, x, y);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.realGC.drawString(string, x, y, isTransparent);
    }

    public void drawText(String string, int x, int y) {
        this.realGC.drawText(string, x, y);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        this.realGC.drawText(string, x, y, isTransparent);
    }

    public void drawText(String string, int x, int y, int flags) {
        this.realGC.drawText(string, x, y, flags);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.realGC.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.realGC.fillGradientRectangle(x, y, width, height, vertical);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.realGC.fillOval(x, y, width, height);
    }

    public void fillPath(Path path) {
        this.realGC.fillPath(path);
    }

    public void fillPolygon(int[] pointArray) {
        this.realGC.fillPolygon(pointArray);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.realGC.fillRectangle(x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        this.realGC.fillRectangle(rect);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.realGC.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    public boolean getAdvanced() {
        return this.realGC.getAdvanced();
    }

    public int getAdvanceWidth(char ch) {
        return this.realGC.getAdvanceWidth(ch);
    }

    public int getAlpha() {
        return this.realGC.getAlpha();
    }

    public int getAntialias() {
        return this.realGC.getAntialias();
    }

    public Color getBackground() {
        return this.realGC.getBackground();
    }

    public Pattern getBackgroundPattern() {
        return this.realGC.getBackgroundPattern();
    }

    public int getCharWidth(char ch) {
        return this.realGC.getCharWidth(ch);
    }

    public Rectangle getClipping() {
        Rectangle cachedClipping;
        if (!this.isTranslationKnown) {
            return this.realGC.getClipping();
        }
        if (!this.isClippingCached) {
            this.cachedClipping = this.realGC.getClipping();
            this.isClippingCached = true;
        }
        if ((cachedClipping = this.cachedClipping) != null) {
            return new Rectangle(cachedClipping.x, cachedClipping.y, cachedClipping.width, cachedClipping.height);
        }
        return cachedClipping;
    }

    public Device getDevice() {
        return this.realGC.getDevice();
    }

    public int getFillRule() {
        return this.realGC.getFillRule();
    }

    public Font getFont() {
        return this.realGC.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.realGC.getFontMetrics();
    }

    public Color getForeground() {
        return this.realGC.getForeground();
    }

    public Pattern getForegroundPattern() {
        return this.realGC.getForegroundPattern();
    }

    public int getInterpolation() {
        return this.realGC.getInterpolation();
    }

    public LineAttributes getLineAttributes() {
        return this.realGC.getLineAttributes();
    }

    public org.eclipse.swt.graphics.GC getRaw(boolean invalidate) {
        if (invalidate) {
            this.isClippingCached = false;
            this.isTranslationKnown = false;
        }
        return this.realGC;
    }

    public int getStyle() {
        return this.realGC.getStyle();
    }

    public int getTextAntialias() {
        return this.realGC.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.realGC.getXORMode();
    }

    public boolean isClipped() {
        return this.realGC.isClipped();
    }

    public boolean isDisposed() {
        return this.realGC.isDisposed();
    }

    public void setAdvanced(boolean advanced) {
        this.realGC.setAdvanced(advanced);
    }

    public void setAlpha(int alpha) {
        this.realGC.setAlpha(alpha);
    }

    public void setAntialias(int antialias) {
        this.realGC.setAntialias(antialias);
    }

    public void setBackground(Color color) {
        this.realGC.setBackground(color);
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.realGC.setBackgroundPattern(pattern);
    }

    public void setClipping(int x, int y, int width, int height) {
        this.setClipping(new Rectangle(x, y, width, height));
    }

    public void setClipping(Rectangle rect) {
        if (this.isClippingCached && NullChecking.equalsNullable((Object)this.cachedClipping, (Object)rect)) {
            return;
        }
        this.isClippingCached = this.isTranslationKnown;
        this.cachedClipping = rect;
        this.realGC.setClipping(rect);
    }

    public void setFillRule(int rule) {
        this.realGC.setFillRule(rule);
    }

    public void setFont(Font font) {
        this.realGC.setFont(font);
    }

    public void setForeground(Color color) {
        this.realGC.setForeground(color);
    }

    public void setForegroundPattern(Pattern pattern) {
        this.realGC.setForegroundPattern(pattern);
    }

    public void setInterpolation(int interpolation) {
        this.realGC.setInterpolation(interpolation);
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.realGC.setLineAttributes(attributes);
    }

    public void setLineDash(int[] dashes) {
        this.realGC.setLineDash(dashes);
    }

    public void setLineWidth(int lineWidth) {
        this.realGC.setLineWidth(lineWidth);
    }

    public void setTextAntialias(int antialias) {
        this.realGC.setTextAntialias(antialias);
    }

    public void setTranslate(int x, int y) {
        Transform transform = new Transform(this.realGC.getDevice());
        transform.translate((float)x, (float)y);
        this.realGC.setTransform(transform);
        transform.dispose();
        if (this.isTranslationKnown) {
            this.translateClipping(-this.cachedTranslationX, -this.cachedTranslationY);
        }
        this.isTranslationKnown = true;
        this.cachedTranslationX = x;
        this.cachedTranslationY = y;
        this.translateClipping(x, y);
    }

    public void setXORMode(boolean xor) {
        this.realGC.setXORMode(xor);
    }

    public Point stringExtent(String string) {
        return this.realGC.stringExtent(string);
    }

    public Point textExtent(String string) {
        return this.realGC.textExtent(string);
    }

    public Point textExtent(String string, int flags) {
        return this.realGC.textExtent(string, flags);
    }

    private void translateClipping(int x, int y) {
        if (!this.isClippingCached) {
            return;
        }
        Rectangle currentClipping = this.cachedClipping;
        if (currentClipping == null) {
            return;
        }
        this.cachedClipping = new Rectangle(currentClipping.x - x, currentClipping.y - y, currentClipping.width, currentClipping.height);
    }
}

