/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.samples;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.SamplesData;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;

public class SamplesRow
extends BlockRow
implements IExtractable {
    private SamplesData mSample;

    SamplesRow(SamplesData sample) {
        this.mSample = sample;
    }

    @Override
    public Image getImage(BlockColumn column) {
        if (column.getID() == 0) {
            ReferencedSymbol symbol = this.mSample.getSymbol();
            boolean isUnknown = symbol.isUnknown();
            String imageName = isUnknown ? "WarningSmall.png" : "Function.png";
            return StreamlinePlugin.getImage(imageName);
        }
        return null;
    }

    public <R, E extends Throwable> R accept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IExtractable.IExtractableVisitor<R, E> visitor) throws E {
        return (R)visitor.visit(this.mSample.getSymbol());
    }

    @Override
    public final double getDataAsDouble(BlockColumn column) {
        switch (column.getID()) {
            case 1: {
                return this.mSample.getValue().value();
            }
            case 2: {
                return this.mSample.getValue().percent();
            }
        }
        return -1.0;
    }

    @Override
    public final long getDataAsLong(BlockColumn column) {
        switch (column.getID()) {
            case 1: 
            case 2: {
                return this.mSample.getValue().value();
            }
        }
        return -1L;
    }

    @Override
    public final String getDataAsText(BlockColumn column) {
        switch (column.getID()) {
            case 0: {
                return this.mSample.getSymbol().symbol.getName();
            }
            case 1: {
                return NumberUtils.format((long)this.mSample.getValue().value());
            }
            case 2: {
                return NumberUtils.formatPercentage((double)this.mSample.getValue().percent(), (boolean)false);
            }
        }
        return "";
    }

    @Override
    public final void setData(BlockColumn column, Object data) {
    }
}

