/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.ruler;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineContextMenu;
import com.arm.streamline.editortabs.timeline.common.bookmarks.BookmarkPopOver;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.charts.ChartDragScrollTracker;
import com.arm.streamline.editortabs.timeline.common.charts.IChartDragScrollable;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.csm.CrossSectionHandlePanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionReporter;
import com.arm.streamline.editortabs.timeline.common.ruler.CaliperEdgeTracker;
import com.arm.streamline.editortabs.timeline.common.ruler.CaliperTracker;
import com.arm.streamline.editortabs.timeline.common.ruler.TimeLabel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICalipersListener;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ZoomCentering;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ITimeStampedData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class RulerPanel
extends Block
implements IBookmarkListener,
ITimelinePositionReporter,
ITimelinePositionListener,
IHandleAreaListener,
IScaleListener,
ICalipersListener,
IChartDragScrollable {
    public static final int DEFAULT_SLOT_WIDTH = 6;
    public static final int MAX_SLOT_WIDTH = 100;
    public static final int MIN_SLOT_WIDTH = 6;
    private static final int TICK_HEIGHT = 6;
    private static final int SHORT_TICK_HEIGHT = 3;
    private static final int TEXT_PADDING = 10;
    private static final int H_MARGIN = 5;
    private static final int TOP_MARGIN = 2;
    private static final int RADIUS = 16;
    private static final Color CSM_BACKGROUND = Colors.create(171, 186, 220);
    private BaseTimelineContent mContent;
    private DragTracker mTracker;
    private long mLastTextRight;
    private long mHighlightedMouseSlot = -1L;
    private boolean mSkipOdd;
    private boolean mAutoScrollPending;
    private static int slotWidth = 6;

    public static int getSlotWidth() {
        return slotWidth;
    }

    public static void increaseSlotWidth() {
        slotWidth = Math.min(slotWidth + 1, 100);
    }

    public static void decreaseSlotWidth() {
        slotWidth = Math.max(slotWidth - 1, 6);
    }

    public static void setSlotWidth(int width) {
        slotWidth = width;
    }

    public RulerPanel(BaseTimelineContent content) {
        this.setRemovesOtherFocus(true);
        this.mContent = content;
        this.mContent.addBookmarkListener(this);
    }

    @Override
    public final void bookmarkChanged() {
        this.repaint();
    }

    @Override
    public final void calipersChanged(Calipers calipers) {
        this.repaint();
    }

    public final void changeZoom(@NonNull ZoomLevel newZoomLevel, int newSlotWidth, long zoomOnHoverSlot) {
        ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
        Scales scales = dataProvider.getScales();
        ZoomLevel currentZoomLevel = scales.getZoomLevel();
        int currentSlotWidth = RulerPanel.getSlotWidth();
        ZoomLevel densestZoomLevel = scales.getDensestZoomLevel();
        newSlotWidth = Math.max(Math.min(100, newSlotWidth), 6);
        if (newZoomLevel.getBps() == currentZoomLevel.getBps() && currentSlotWidth == newSlotWidth && zoomOnHoverSlot < 0L) {
            return;
        }
        if (zoomOnHoverSlot < 0L) {
            long newLeftPx;
            CrossSectionMarker csm = dataProvider.getCrossSectionMarker();
            long leftSlotAtDensestZoomLevel = csm.getLeftAtDensestScale();
            Rectangle bounds = this.getBounds();
            int handleAreaWidth = this.mContent.getChartsPanel().getHandleAreaWidth();
            int availablePixelsWidth = bounds.width - handleAreaWidth;
            ZoomCentering zoomCentering = csm.getZoomCentering();
            if (!csm.isParked() && zoomCentering != ZoomCentering.VIEW) {
                long centerOnSlotAtNewZoomLevel = Position.scale((long)(leftSlotAtDensestZoomLevel + Math.max(0L, (csm.getRightAtDensestScale() - leftSlotAtDensestZoomLevel) / 2L)), (ZoomLevel)densestZoomLevel, (ZoomLevel)newZoomLevel);
                long centerPixelAtNewZoomLevel = centerOnSlotAtNewZoomLevel * (long)newSlotWidth + (long)(newSlotWidth / 2);
                newLeftPx = Math.max(0L, centerPixelAtNewZoomLevel - (long)(availablePixelsWidth / 2));
            } else {
                int half = availablePixelsWidth / 2;
                int x = bounds.x + handleAreaWidth + half;
                long centerOnSlotAtNewZoomLevel = Position.scale((long)this.translateToSlot(x), (ZoomLevel)currentZoomLevel, (ZoomLevel)newZoomLevel);
                long centerPixelAtNewZoomLevel = centerOnSlotAtNewZoomLevel * (long)newSlotWidth + (long)(newSlotWidth / 2);
                newLeftPx = Math.max(0L, centerPixelAtNewZoomLevel - (long)(availablePixelsWidth / 2));
            }
            RulerPanel.setSlotWidth(newSlotWidth);
            scales.setZoomLevel(newZoomLevel);
            this.mContent.getDividerPanel().setPosition(newLeftPx);
        } else {
            long newHoverSlot = Position.scale((long)zoomOnHoverSlot, (ZoomLevel)currentZoomLevel, (ZoomLevel)newZoomLevel);
            long centerPixelAtCurrentZoomLevel = zoomOnHoverSlot * (long)currentSlotWidth + (long)(currentSlotWidth / 2);
            long centerPixelAtNewZoomLevel = newHoverSlot * (long)newSlotWidth + (long)(newSlotWidth / 2);
            long availablePixelsOnLeft = Math.max(0L, centerPixelAtCurrentZoomLevel - this.mContent.getDividerPanel().getPosition());
            long newLeftPx = Math.max(0L, centerPixelAtNewZoomLevel - availablePixelsOnLeft);
            RulerPanel.setSlotWidth(newSlotWidth);
            scales.setZoomLevel(newZoomLevel);
            this.mContent.getDividerPanel().setPosition(newLeftPx);
            if (newHoverSlot >= 0L) {
                this.mContent.updateCurrentPosition(newHoverSlot);
            }
        }
    }

    @Override
    public final BaseTimelineContent getBaseTimelineContent() {
        return this.mContent;
    }

    public final long getHighlightedMouseSlot() {
        return this.mHighlightedMouseSlot;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        FontInfo fi = FontInfo.get(Fonts.getSmall());
        return new Point(widthHint == -1 ? 100 : widthHint, StreamlinePlugin.getImage((String)"CaliperLeft.png").getBounds().height + fi.getHeight() + 6);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    private final @NonNull ZoomLevel getScale() {
        return this.mContent.getCaptureDataProvider().getScales().getZoomLevel();
    }

    private final @NonNull TimeUnit getTimeUnit() {
        return this.mContent.getCaptureDataProvider().getTimeUnit();
    }

    @Override
    public final void handleAreaWidthChanged() {
        this.repaint();
    }

    @Override
    public final boolean handleMouseUpWithoutDrag(Point where, int button, int stateMask, int count) {
        return false;
    }

    public final void scaleChanged(Scales scales) {
        this.repaint();
    }

    public final void setHighlightedMouseSlot(long slot) {
        if (this.mHighlightedMouseSlot != slot) {
            this.mHighlightedMouseSlot = slot;
            this.repaint();
            this.getBaseTimelineContent().getCrossSectionHandlePanel().repaint();
        }
    }

    public final void setupAutoScroll(int x) {
        if (!this.mAutoScrollPending) {
            int amount = 0;
            if (this.isOverAutoScrollLeft(x)) {
                amount = -RulerPanel.getSlotWidth() * 5;
            } else if (this.isOverAutoScrollRight(x)) {
                amount = RulerPanel.getSlotWidth() * 5;
            }
            if (amount != 0) {
                this.mAutoScrollPending = true;
                int scroll = amount;
                Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.MILLISECONDS);
            }
        }
    }

    public final void showBookmarksForSlot(long slot) {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        @NonNull ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
        BookmarkPopOver bookmarkPopOver = this.mContent.getBookmarkPopOver();
        if (bookmarkPopOver != null && bookmarkPopOver.getSlot() == slot && bookmarkPopOver.getZoomLevel().equals((Object)zoomLevel)) {
            return;
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        List<Bookmark> bookmarks = cdp.getBookmarks();
        int count = bookmarks.size();
        if (count > 0) {
            int pos = ITimeStampedData.binarySearch(bookmarks, (long)Position.scale((long)slot, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            if (pos < 0) {
                pos = -pos - 1;
            }
            while (pos < count && result.size() < 50) {
                Bookmark bookmark;
                if (slot != Position.scale((long)(bookmark = bookmarks.get(pos++)).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) break;
                result.add(bookmark);
            }
        }
        if (result.isEmpty()) {
            this.mContent.setBookmarkPopOver(null);
        } else {
            this.mContent.setBookmarkPopOver(new BookmarkPopOver(this.mContent, slot, zoomLevel, result));
        }
    }

    @Override
    public final void timelinePositionChanged() {
        this.repaint();
    }

    public final long translateFromSlot(long index) {
        Rectangle bounds = this.getLocalBounds();
        long startIndex = 0L;
        long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (startX < 0L) {
            startIndex = -startX / (long)RulerPanel.getSlotWidth();
            startX += startIndex * (long)RulerPanel.getSlotWidth();
        }
        return startX + (index - startIndex) * (long)RulerPanel.getSlotWidth();
    }

    @Override
    public final long translateToSlot(long x) {
        Rectangle bounds = this.getLocalBounds();
        long startIndex = 0L;
        long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (startX < 0L) {
            startIndex = -startX / (long)RulerPanel.getSlotWidth();
            startX += startIndex * (long)RulerPanel.getSlotWidth();
        }
        return startIndex + (x - startX) / (long)RulerPanel.getSlotWidth();
    }

    public final void zoomIn() {
        Scales scales = this.mContent.getCaptureDataProvider().getScales();
        this.changeZoom((ZoomLevel)NullChecking.neverNullOr((Object)scales.getNextScaleUp(), (Object)scales.getZoomLevel()), 6, -1L);
    }

    public final void zoomOut() {
        Scales scales = this.mContent.getCaptureDataProvider().getScales();
        this.changeZoom((ZoomLevel)NullChecking.neverNullOr((Object)scales.getNextScaleDown(), (Object)scales.getZoomLevel()), 6, -1L);
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        this.adjustCursor(where);
        if (button == 1) {
            this.mTracker = this.isOverLeftCaliper(where.x, where.y) ? new CaliperEdgeTracker(this, this, true) : (this.isOverRightCaliper(where.x, where.y) ? new CaliperEdgeTracker(this, this, false) : (this.isOverCaliperBar(where.x, where.y) ? new CaliperTracker(this, this, where.x) : new ChartDragScrollTracker(this, where.x, where.y)));
        } else if (button == 3) {
            TimelineContextMenu.showContextMenu(this.mContent, this.toDisplay(where.x, where.y));
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.setToolTip(null);
            this.mTracker.mouseDrag(where, stateMask);
            this.getBaseTimelineContent().updateCurrentPosition(this.translateToSlot(where.x));
        } else {
            this.mouseMove(where, stateMask);
        }
    }

    @Override
    protected final void mouseExit() {
        this.getBaseTimelineContent().clearPositionReadoutIfNeeded();
        this.setHighlightedMouseSlot(-1L);
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        Rectangle bounds = this.getLocalBounds();
        long slot = this.translateToSlot(where.x);
        if (where.y >= bounds.y + bounds.height - 6) {
            this.showBookmarksForSlot(slot);
        } else {
            this.mContent.setBookmarkPopOver(null);
        }
        this.adjustCursor(where);
        this.getBaseTimelineContent().updateCurrentPosition(slot);
        this.setHighlightedMouseSlot(slot);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursor(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.drawBackground(gc);
        long index = 0L;
        long x = (long)(this.getLocalBounds().x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (x < 0L) {
            index = -x / (long)RulerPanel.getSlotWidth();
            x += index * (long)RulerPanel.getSlotWidth();
        }
        this.drawTimeLabels(gc, this.collectLabels(gc, x, index));
        this.drawCSMInfo(gc);
        this.drawTickMarks(gc, x, index);
        this.drawBookmarks(gc, index);
        this.drawCalipers(gc, x, index);
    }

    @Override
    protected final void wasAdded(Block parent) {
        super.wasAdded(parent);
        ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
        dataProvider.getScales().addListener((IScaleListener)this);
        dataProvider.getCalipers().addListener(this);
        BlockRoot root = this.getRoot();
        root.addKeyHandler(() -> this.zoomOut(), '-', '_');
        root.addKeyHandler(() -> this.zoomIn(), '+', '=');
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
        dataProvider.getScales().removeListener((IScaleListener)this);
        dataProvider.getCalipers().removeListener(this);
    }

    private final TimeLabel addTimeLabel(GC gc, long index, long x) {
        TimeLabel label = new TimeLabel(gc, index, x, this.getScale(), this.getTimeUnit());
        if (!this.mSkipOdd) {
            if (label.getTextLeft() < this.mLastTextRight + 10L) {
                this.mSkipOdd = true;
            } else {
                this.mLastTextRight = label.getTextRight();
            }
        }
        return label;
    }

    private final void adjustCursor(Point where) {
        int cursorID = 0;
        Cursor cursor = null;
        if (this.isOverLeftCaliper(where.x, where.y)) {
            cursorID = 9;
        } else if (this.isOverRightCaliper(where.x, where.y)) {
            cursorID = 9;
        } else if (this.isOverCaliperBar(where.x, where.y)) {
            cursor = StreamlinePlugin.getOpenHandCursor();
        }
        if (cursor == null) {
            cursor = this.getDisplay().getSystemCursor(cursorID);
        }
        this.setCursor(cursor);
    }

    private final void autoScroll(int amount) {
        this.mAutoScrollPending = false;
        int x = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).x;
        if (amount < 0 && this.isOverAutoScrollLeft(x) || amount > 0 && this.isOverAutoScrollRight(x)) {
            this.mContent.getDividerPanel().setPosition(this.mContent.getDividerPanel().getPosition() + (long)amount);
            if (this.mTracker != null) {
                this.mTracker.mouseDrag(new Point(x, 0), 0);
            }
        }
    }

    private final List<TimeLabel> collectLabels(GC gc, long x, long index) {
        Rectangle bounds = this.getLocalBounds();
        int right = bounds.x + bounds.width - 1;
        this.mSkipOdd = false;
        this.mLastTextRight = -1000L;
        ArrayList<TimeLabel> labels = new ArrayList<TimeLabel>();
        while (x <= (long)right) {
            if (index % 10L == 0L) {
                if (index >= 10L && labels.isEmpty()) {
                    labels.add(this.addTimeLabel(gc, index - 10L, x - (long)(10 * RulerPanel.getSlotWidth())));
                }
                labels.add(this.addTimeLabel(gc, index, x));
            }
            x += (long)RulerPanel.getSlotWidth();
            ++index;
        }
        int count = labels.size();
        if (count > 0) {
            TimeLabel last = (TimeLabel)labels.get(count - 1);
            labels.add(this.addTimeLabel(gc, last.getIndex() + 10L, last.getX() + (long)(10 * RulerPanel.getSlotWidth())));
        }
        return labels;
    }

    private final void drawBackground(GC gc) {
        long x;
        Rectangle bounds = this.getLocalBounds();
        int bottom = bounds.y + bounds.height - 1;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(bounds);
        if (this.mHighlightedMouseSlot >= 0L && (x = this.translateFromSlot(this.mHighlightedMouseSlot)) > (long)(bounds.x - RulerPanel.getSlotWidth()) && x < (long)(bounds.x + bounds.width)) {
            gc.setBackground(Colors.darken(Colors.getWidgetBackground(), 10));
            gc.fillRectangle((int)x + 1, bounds.y, RulerPanel.getSlotWidth() - 1, bounds.height);
        }
        gc.setForeground(Colors.getWidgetNormalShadow());
        gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        gc.setAntialias(savedAA);
    }

    private final void drawBookmarks(GC gc, long index) {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        List<Bookmark> bookmarks = cdp.getBookmarks();
        int count = bookmarks.size();
        if (count > 0) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            Rectangle bounds = this.getLocalBounds();
            int right = bounds.x + bounds.width;
            int top = bounds.y + bounds.height - 6;
            @NonNull ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
            int pos = ITimeStampedData.binarySearch(bookmarks, (long)Position.scale((long)index, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            if (pos < 0) {
                pos = -pos - 1;
            }
            long last = -1L;
            while (pos < count) {
                Bookmark bookmark;
                long bi;
                if ((bi = Position.scale((long)(bookmark = bookmarks.get(pos++)).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) == last) continue;
                last = bi;
                long x = this.translateFromSlot(bi);
                if (x >= (long)right) break;
                int xx = (int)(x + 1L);
                gc.setBackground(Colors.getDarkGray());
                gc.fillRectangle(xx++, top, RulerPanel.getSlotWidth() - 1, 6);
                RGB rgb = bookmark.getRGB();
                gc.setBackground(Colors.create(rgb));
                gc.fillRectangle(xx, top + 1, RulerPanel.getSlotWidth() - 3, 5);
                if (bookmark.getTitle().isEmpty()) continue;
                gc.setBackground(RGBUtils.isDark(rgb) ? Colors.getWhite() : Colors.getBlack());
                gc.fillRectangle(xx, top + 2, RulerPanel.getSlotWidth() - 3, 2);
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawCalipers(GC gc, long x, long index) {
        Calipers calipers = this.mContent.getCaptureDataProvider().getCalipers();
        Rectangle bounds = this.getLocalBounds();
        int top = bounds.y;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Image image = StreamlinePlugin.getImage("CaliperLeft.png");
        Rectangle leftImgBounds = image.getBounds();
        long left = x + (calipers.getLeft() - index) * (long)RulerPanel.getSlotWidth() - (long)(leftImgBounds.width / 2);
        if (left + (long)leftImgBounds.width >= (long)bounds.x && left < (long)(bounds.x + bounds.width)) {
            gc.drawImage(image, (int)left, top);
        }
        image = StreamlinePlugin.getImage("CaliperRight.png");
        Rectangle rightImgBounds = image.getBounds();
        long right = x + (calipers.getRight() - index) * (long)RulerPanel.getSlotWidth() - (long)(rightImgBounds.width / 2);
        if (right + (long)rightImgBounds.width >= (long)bounds.x && left < (long)(bounds.x + bounds.width)) {
            gc.drawImage(image, (int)right, top);
        }
        if ((left += (long)leftImgBounds.width) < right) {
            image = StreamlinePlugin.getImage("CaliperMiddle.png");
            Rectangle imgBounds = image.getBounds();
            if (left < (long)bounds.x) {
                left = bounds.x;
            }
            if (right > (long)(bounds.x + bounds.width)) {
                right = bounds.x + bounds.width;
            }
            Rectangle fillArea = new Rectangle((int)left, top, (int)(right - left), imgBounds.height);
            fillArea.intersect(bounds);
            if (!fillArea.isEmpty()) {
                gc.drawImage(image, 0, 0, imgBounds.width, imgBounds.height, fillArea.x, fillArea.y, fillArea.width, fillArea.height);
            }
        }
        gc.setAntialias(savedAA);
    }

    private final void drawCSMInfo(GC gc) {
        CrossSectionHandlePanel csmPanel = this.mContent.getCrossSectionHandlePanel();
        if (csmPanel.needsExternalText()) {
            gc.setFont(Fonts.getSmall());
            String text = csmPanel.getCSMText();
            TextDrawingState state = new TextDrawingState(gc);
            Point textSize = gc.stringExtent(text);
            state.restore();
            int width = textSize.x + 10;
            long xx = csmPanel.getMiddleLeft() + (csmPanel.getMiddleWidth() - (long)width) / 2L;
            Rectangle bounds = this.getLocalBounds();
            if (xx < (long)bounds.x) {
                xx = bounds.x;
            }
            if (xx + (long)width > (long)(bounds.x + bounds.width)) {
                xx -= xx + (long)width - (long)(bounds.x + bounds.width);
            }
            int x = (int)xx;
            int caliperHeight = StreamlinePlugin.getImage((String)"CaliperLeft.png").getBounds().height;
            int height = bounds.height - (caliperHeight - 2);
            int y = bounds.y + bounds.height - height;
            int savedAA = gc.getAntialias();
            gc.setAntialias(1);
            gc.setBackground(CSM_BACKGROUND);
            gc.fillRoundRectangle(x, y, width, height + 16, 16, 16);
            gc.setForeground(Colors.getBlack());
            gc.setAlpha(64);
            gc.drawRoundRectangle(x, y, width - 1, height + 16, 16, 16);
            gc.setAntialias(savedAA);
            gc.setAlpha(255);
            TextDrawing.drawString(gc, text, x + 5, y + 2);
        }
    }

    private final void drawTickMarks(GC gc, long x, long index) {
        Rectangle bounds = this.getLocalBounds();
        int right = bounds.x + bounds.width - 1;
        int bottom = bounds.y + bounds.height - 1;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setForeground(Colors.getWidgetForeground());
        this.mSkipOdd = false;
        this.mLastTextRight = -1000L;
        int xx = (int)x;
        while (xx <= right) {
            gc.drawLine(xx, bottom - (index % 10L != 0L ? 3 : 6), xx, bottom);
            xx += RulerPanel.getSlotWidth();
            ++index;
        }
        gc.setAntialias(savedAA);
    }

    private final void drawTimeLabels(GC gc, List<TimeLabel> labels) {
        int y = this.getLocalBounds().y + StreamlinePlugin.getImage((String)"CaliperLeft.png").getBounds().height;
        for (TimeLabel label : labels) {
            if (this.mSkipOdd && label.isOdd()) continue;
            label.draw(gc, y);
        }
    }

    private final boolean isOverAutoScrollLeft(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x < bounds.x + this.mContent.getHandleAreaWidth() + RulerPanel.getSlotWidth();
    }

    private final boolean isOverAutoScrollRight(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x > bounds.x + bounds.width - StreamlinePlugin.getImage((String)"CaliperRight.png").getBounds().width;
    }

    private final boolean isOverCaliperBar(int x, int y) {
        Rectangle bounds = this.getLocalBounds();
        Rectangle imgBounds = StreamlinePlugin.getImage("CaliperLeft.png").getBounds();
        if (y < bounds.y + imgBounds.height) {
            Calipers calipers;
            long left;
            long startIndex = 0L;
            long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
            if (startX < 0L) {
                startIndex = -startX / (long)RulerPanel.getSlotWidth();
                startX += startIndex * (long)RulerPanel.getSlotWidth();
            }
            if ((long)x >= (left = startX + ((calipers = this.mContent.getCaptureDataProvider().getCalipers()).getLeft() - startIndex) * (long)RulerPanel.getSlotWidth() - (long)(imgBounds.width / 2)) + (long)imgBounds.width) {
                imgBounds = StreamlinePlugin.getImage("CaliperRight.png").getBounds();
                return (long)x < startX + (calipers.getRight() - startIndex) * (long)RulerPanel.getSlotWidth() - (long)(imgBounds.width / 2);
            }
        }
        return false;
    }

    private final boolean isOverLeftCaliper(int x, int y) {
        Rectangle bounds = this.getLocalBounds();
        Rectangle imgBounds = StreamlinePlugin.getImage("CaliperLeft.png").getBounds();
        if (y < bounds.y + imgBounds.height) {
            Calipers calipers;
            long left;
            long startIndex = 0L;
            long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
            if (startX < 0L) {
                startIndex = -startX / (long)RulerPanel.getSlotWidth();
                startX += startIndex * (long)RulerPanel.getSlotWidth();
            }
            return (long)x >= (left = startX + ((calipers = this.mContent.getCaptureDataProvider().getCalipers()).getLeft() - startIndex) * (long)RulerPanel.getSlotWidth() - (long)(imgBounds.width / 2)) && (long)x < left + (long)imgBounds.width;
        }
        return false;
    }

    private final boolean isOverRightCaliper(int x, int y) {
        Rectangle bounds = this.getLocalBounds();
        Rectangle imgBounds = StreamlinePlugin.getImage("CaliperRight.png").getBounds();
        if (y < bounds.y + imgBounds.height) {
            Calipers calipers;
            long left;
            long startIndex = 0L;
            long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
            if (startX < 0L) {
                startIndex = -startX / (long)RulerPanel.getSlotWidth();
                startX += startIndex * (long)RulerPanel.getSlotWidth();
            }
            return (long)x >= (left = startX + ((calipers = this.mContent.getCaptureDataProvider().getCalipers()).getRight() - startIndex) * (long)RulerPanel.getSlotWidth() - (long)(imgBounds.width / 2)) && (long)x < left + (long)imgBounds.width;
        }
        return false;
    }
}

