/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.editortabs.timeline.common.process.ProcessColumn;
import com.arm.streamline.editortabs.timeline.common.process.ProcessPanel;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class ProcessRow
extends BlockRow {
    private static final Color EXITED_BACKGROUND = Colors.create(240, 240, 240);
    private final @NonNull List<@NonNull ProcessColumn> mColumns;
    private final @NonNull ProcessData mProcessData;
    private final @NonNull ProcessPanel mProcessPanel;
    private final int mSequence;

    public ProcessRow(@NonNull ProcessPanel processPanel, @NonNull ProcessData processData, @NonNull List<@NonNull ProcessColumn> columns, int sequence) {
        this.mProcessPanel = processPanel;
        this.mProcessData = processData;
        this.mColumns = columns;
        this.mSequence = sequence;
    }

    @Override
    public final Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return selected || this.isAlive() ? super.getBackgroundColor(device, selected, active) : EXITED_BACKGROUND;
    }

    @Override
    public final double getDataAsDouble(BlockColumn column) {
        return this.mColumns.get(column.getID()).getDataAsDouble(this);
    }

    @Override
    public final long getDataAsLong(BlockColumn column) {
        return this.mColumns.get(column.getID()).getDataAsLong(this);
    }

    @Override
    public final String getDataAsText(BlockColumn column) {
        String dataAsText = this.mColumns.get(column.getID()).getDataAsText(this);
        if (dataAsText != null && !dataAsText.isEmpty()) {
            dataAsText = dataAsText.replace('\n', ' ');
        }
        return dataAsText;
    }

    public final long @NonNull [] getDensestRange() {
        return this.mProcessPanel.getDataProvider().getCrossSectionMarker().getDensestRange();
    }

    @Override
    public Image getImage(BlockColumn column) {
        return this.mColumns.get(column.getID()).getImage(this);
    }

    public final @NonNull ProcessData getProcessData() {
        return this.mProcessData;
    }

    public final IProcessDataProvider getProcessDataProvider() {
        return this.mProcessPanel.getDataProvider().getProcessDataProvider();
    }

    public final int getSequence() {
        return this.mSequence;
    }

    public final boolean isAlive() {
        return !this.mProcessData.hasExited();
    }

    @Override
    public void setData(BlockColumn column, Object data) {
    }
}

