/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.IProcessSelectionBlock;
import com.arm.streamline.editortabs.timeline.common.process.ProcessColumn;
import com.arm.streamline.editortabs.timeline.common.process.ProcessOutline;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.IProcessListener;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockHeader;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineSortState;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineListener;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class ProcessPanel
extends Block
implements IProcessListener,
IProcessSelectionBlock {
    private final @NonNull BaseTimelineContent mContent;
    private final @NonNull ICaptureDataProvider mDataProvider;
    private final @NonNull ProcessOutline mOutline;
    private boolean mReady;
    private final @NonNull ScrollingBlock mScroller;
    private @NonNull Set<@NonNull ProcessData> mSeen = new HashSet<ProcessData>();
    private @NonNull Set<@NonNull ProcessData> mTransactions = new HashSet<ProcessData>();
    private @NonNull List<@NonNull ProcessColumn> processColumns;
    private @NonNull IProcessDataProvider.ThreadMode threadMode;
    private boolean notifySelectionChanged = true;

    public ProcessPanel(@NonNull BaseTimelineContent content, @NonNull IProcessDataProvider.ThreadMode threadMode) {
        this.threadMode = threadMode;
        this.mContent = content;
        this.mDataProvider = (ICaptureDataProvider)NullChecking.neverNull((Object)this.mContent.getCaptureDataProvider());
        BlockOutlineModel model = new BlockOutlineModel();
        model.setShowOutline(false);
        IProcessDataProvider pdp = this.mDataProvider.getProcessDataProvider();
        List<IProcessDataProvider.ColumnLabel> pdpColumns = pdp.getColumns();
        this.processColumns = ProcessColumn.makeColumns(pdpColumns);
        BlockHeader header = new BlockHeader();
        header.setLayoutData(new PrecisionLayoutData().setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        this.add(header);
        this.mOutline = new ProcessOutline(pdp, model);
        this.mOutline.addOutlineListener(new IBlockOutlineListener(){

            @Override
            public void deleteSelectionRequested(BlockOutline outline) {
            }

            @Override
            public void editorChanged(BlockOutline outline) {
            }

            @Override
            public void openSelectionRequested(BlockOutline outline) {
            }

            @Override
            public void selectionChanged(BlockOutline outline) {
                ProcessPanel.this.mContent.getChartsPanel().repaint();
                if (ProcessPanel.this.notifySelectionChanged) {
                    ProcessPanel.this.mContent.setProcessAndThreadSelectionFromUIDs(ProcessPanel.this, ProcessPanel.this.getSelectedUIDs());
                }
            }
        });
        this.mOutline.setHeader(header);
        pdp.addProcessListener(this);
        this.recomputeColumnsOnThread();
        this.recomputeRowsOnThread();
        this.mOutline.sizeColumnsToFit();
        this.mOutline.pack();
        this.mOutline.getDefaultConfig();
        this.mScroller = new ScrollingBlock(this.mOutline);
        this.mScroller.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setFill().setMinimumHeight(0).setMinimumWidth(0));
        this.add(this.mScroller);
        this.setLayout(new PrecisionLayout());
        this.mDataProvider.getCrossSectionMarker().addListener(csm -> this.updateDataValues());
        this.mDataProvider.getScales().addListener(scales -> this.updateDataValues());
        this.mReady = true;
    }

    public final ICaptureDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final BlockOutline getOutline() {
        return this.mOutline;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @NonNull TIntSet getSelectedUIDs() {
        TIntHashSet selectedIds = new TIntHashSet();
        for (BlockRow row : this.mOutline.getModel().getSelectionAsList()) {
            void processRow;
            BlockRow blockRow = row;
            if (!(blockRow instanceof ProcessRow)) continue;
            ProcessRow cfr_ignored_0 = (ProcessRow)blockRow;
            ProcessRow cfr_ignored_1 = (ProcessRow)blockRow;
            selectedIds.add(processRow.getProcessData().getUID());
        }
        return selectedIds;
    }

    @Override
    public void notifyChartsChanged() {
        Task.callOnUIThread(() -> this.recomputeColumnsOnThread());
    }

    @Override
    public final void processChanged(@NonNull ProcessData processData) {
        Task.callOnUIThread(() -> {
            switch (this.threadMode) {
                case PROCESS_AND_THREADS: {
                    this.mTransactions.add(processData);
                    break;
                }
                case PROCESS_ONLY: {
                    if (processData.isThread()) break;
                    this.mTransactions.add(processData);
                    break;
                }
                case THREAD_ONLY: {
                    if (!processData.isThread()) break;
                    this.mTransactions.add(processData);
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.threadMode);
                }
            }
        });
    }

    @Override
    public void selectUIDs(@NonNull TIntSet selection, boolean notifyChange) {
        Task.callOnUIThread(() -> {
            boolean previousNotify = this.notifySelectionChanged;
            this.notifySelectionChanged = notifyChange;
            try {
                TIntSet actualSelection = this.getSelectedUIDs();
                if (actualSelection.containsAll((TIntCollection)selection) && actualSelection.size() == selection.size()) {
                    return;
                }
                BlockOutlineModel model = this.mOutline.getModel();
                if (selection.isEmpty()) {
                    model.removeSelection();
                    return;
                }
                StdSelection modelSelection = model.getSelection();
                boolean canNotify = modelSelection.canNotify();
                modelSelection.setNotify(false);
                modelSelection.deselect();
                int rowIndex = 0;
                while (rowIndex < model.getRowCount()) {
                    BlockRow row = model.getRowAtIndex(rowIndex);
                    BlockRow blockRow = row;
                    if (blockRow instanceof ProcessRow) {
                        void processRow;
                        ProcessRow cfr_ignored_0 = (ProcessRow)blockRow;
                        ProcessRow cfr_ignored_1 = (ProcessRow)blockRow;
                        if (selection.contains(processRow.getProcessData().getUID())) {
                            modelSelection.select(rowIndex, true);
                        }
                    }
                    ++rowIndex;
                }
                modelSelection.setNotify(canNotify);
                this.mOutline.notifyOfSelectionChange();
            }
            finally {
                this.notifySelectionChanged = previousNotify;
            }
        });
    }

    @Override
    public void setThreadMode(@NonNull IProcessDataProvider.ThreadMode threadMode) {
        Task.callOnUIThread(() -> {
            if (this.threadMode == threadMode) {
                return;
            }
            this.threadMode = threadMode;
            this.recomputeRowsOnThread();
        });
    }

    @Override
    public final void transactionCommitted() {
        if (this.mReady) {
            Task.callOnUIThread(() -> {
                BlockOutlineModel model = this.mOutline.getModel();
                int rowCount = model.getRowCount();
                ArrayList<ProcessRow> rowsToAdd = new ArrayList<ProcessRow>();
                for (ProcessData one : this.mTransactions) {
                    if (this.mSeen.contains(one)) continue;
                    this.mSeen.add(one);
                    ProcessRow row = new ProcessRow(this, one, this.processColumns, rowCount++);
                    rowsToAdd.add(row);
                }
                this.mTransactions.clear();
                List<BlockOutlineSortState> state = BlockOutlineSortState.captureCurrentSortState(model);
                if (!rowsToAdd.isEmpty()) {
                    model.addNonHierarchicalRowsFast(rowsToAdd, false);
                    model.sort();
                    this.mOutline.pack();
                }
                BlockOutlineSortState.restoreSortState(model, state);
                this.mOutline.repaint();
            });
        }
    }

    private void recomputeColumnsOnThread() {
        BlockOutlineModel model = this.mOutline.getModel();
        model.removeAllColumns();
        IProcessDataProvider pdp = this.mDataProvider.getProcessDataProvider();
        List<IProcessDataProvider.ColumnLabel> pdpColumns = pdp.getColumns();
        this.processColumns = ProcessColumn.makeColumns(pdpColumns);
        int pcIndex = 0;
        while (pcIndex < this.processColumns.size()) {
            ProcessColumn one = this.processColumns.get(pcIndex);
            BlockColumn column = new BlockColumn(pcIndex, one.getTitle(), one.getTooltip(), one.getCell());
            ProcessColumn.InitialSort initialSort = one.getInitialSort();
            if (initialSort != null) {
                column.setSortCriteria(initialSort.index(), initialSort.sortAscending());
            }
            column.setPreferredWidth(one.getPreferredWidth());
            model.addColumn(column);
            ++pcIndex;
        }
        this.recomputeRowsOnThread();
    }

    private void recomputeRowsOnThread() {
        BlockOutlineModel model = this.mOutline.getModel();
        IProcessDataProvider pdp = this.mDataProvider.getProcessDataProvider();
        List<BlockOutlineSortState> state = BlockOutlineSortState.captureCurrentSortState(model);
        this.mSeen.clear();
        model.removeAllRows();
        ArrayList<ProcessRow> rows = new ArrayList<ProcessRow>();
        List<ProcessData> processData = pdp.getProcessData(this.threadMode);
        int pdIndex = 0;
        while (pdIndex < processData.size()) {
            ProcessData one = processData.get(pdIndex);
            ProcessRow row = new ProcessRow(this, one, this.processColumns, pdIndex);
            rows.add(row);
            this.mSeen.add(one);
            ++pdIndex;
        }
        model.addNonHierarchicalRowsFast(rows, false);
        model.sort();
        BlockOutlineSortState.restoreSortState(model, state);
        this.mOutline.pack();
        this.mOutline.repaint();
    }

    private final void updateDataValues() {
        BlockOutlineModel model = this.mOutline.getModel();
        BlockOutlineSortState.restoreSortState(model, BlockOutlineSortState.captureCurrentSortState(model));
        this.mOutline.repaint();
    }
}

