/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.process.ProcessMessages;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.widget.lightweight.outline.BlockPercentageCell;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ProcessColumn {
    private final @Nullable InitialSort mInitialSort;
    private final @NonNull String mTitle;
    private final @NonNull String mTooltip;

    public static final @NonNull List<@NonNull ProcessColumn> makeColumns(@NonNull List< @NonNull IProcessDataProvider.ColumnLabel> columns) {
        ArrayList<ProcessColumn> result = new ArrayList<ProcessColumn>();
        int sortIndex = 0;
        int index = 0;
        while (index < columns.size()) {
            IProcessDataProvider.ColumnLabel col = columns.get(index);
            InitialSort initialSort = col.defaultSortItem() ? new InitialSort(sortIndex, false) : null;
            sortIndex += col.defaultSortItem() ? 1 : 0;
            result.add(new CounterProcessColumn(col.title(), col.description(), initialSort, index, col.percentage(), col.colourPreference(), col.chartRGB()));
            ++index;
        }
        result.add(0, new NameProcessColumn(new InitialSort(sortIndex, true)));
        result.add(1, new IdProcessColumn(new InitialSort(sortIndex + 1, true)));
        return result;
    }

    protected ProcessColumn(@NonNull String title, @Nullable InitialSort initialSort) {
        this(title, "", initialSort);
    }

    protected ProcessColumn(@NonNull String title, @NonNull String tooltip, @Nullable InitialSort initialSort) {
        this.mTitle = title;
        this.mTooltip = tooltip;
        this.mInitialSort = initialSort;
    }

    public abstract IBlockCell getCell();

    public abstract double getDataAsDouble(@NonNull ProcessRow var1);

    public abstract long getDataAsLong(@NonNull ProcessRow var1);

    public abstract String getDataAsText(@NonNull ProcessRow var1);

    public abstract @Nullable Image getImage(@NonNull ProcessRow var1);

    public @Nullable InitialSort getInitialSort() {
        return this.mInitialSort;
    }

    public int getPreferredWidth() {
        return -1;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }

    public @NonNull String getTooltip() {
        return this.mTooltip;
    }

    public static final class CounterProcessColumn
    extends ProcessColumn {
        private final int columnIndex;
        private final boolean percentage;
        private final @Nullable Integer chartRGB;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IColumnDescriptor.ColourPreference colourPreference;

        public CounterProcessColumn(@NonNull String title, @NonNull String description, @Nullable InitialSort initialSort, int columnIndex, boolean percentage, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer chartRGB) {
            super(title, description, initialSort);
            this.columnIndex = columnIndex;
            this.percentage = percentage;
            this.colourPreference = colourPreference;
            this.chartRGB = chartRGB;
        }

        @Override
        public IBlockCell getCell() {
            if (this.percentage) {
                return new BlockPercentageCell(200, false, this.colourPreference, this.chartRGB);
            }
            return new BlockTextCell(131072, IBlockColumnCompareType.INTEGER);
        }

        @Override
        public double getDataAsDouble(@NonNull ProcessRow row) {
            if (this.percentage) {
                return (double)this.getDataAsLong(row) / 100.0;
            }
            return this.getDataAsLong(row);
        }

        @Override
        public long getDataAsLong(@NonNull ProcessRow row) {
            long[] range = row.getDensestRange();
            return row.getProcessDataProvider().getColumnValue(this.columnIndex, Math.toIntExact(range[0]), Math.toIntExact(range[1]), row.getProcessData());
        }

        @Override
        public String getDataAsText(@NonNull ProcessRow row) {
            if (this.percentage) {
                return NumberUtils.formatPercentage((double)this.getDataAsDouble(row), (boolean)false);
            }
            return NumberUtils.format((long)this.getDataAsLong(row));
        }

        @Override
        public @Nullable Image getImage(@NonNull ProcessRow row) {
            return null;
        }

        @Override
        public int getPreferredWidth() {
            return this.getCell().getMinimumContentWidth() + 200;
        }
    }

    public static final class IdProcessColumn
    extends ProcessColumn {
        public IdProcessColumn(@Nullable InitialSort initialSort) {
            super(ProcessMessages.ID_TITLE, initialSort);
        }

        @Override
        public IBlockCell getCell() {
            return new BlockTextCell(131072, IBlockColumnCompareType.INTEGER);
        }

        @Override
        public long getDataAsLong(@NonNull ProcessRow row) {
            return row.getProcessData().getProcessID();
        }

        @Override
        public double getDataAsDouble(@NonNull ProcessRow row) {
            return row.getProcessData().getProcessID();
        }

        @Override
        public String getDataAsText(@NonNull ProcessRow row) {
            int id = row.getProcessData().getProcessID();
            return id >= 0 ? Integer.toString(id) : "-";
        }

        @Override
        public @Nullable Image getImage(@NonNull ProcessRow row) {
            return null;
        }
    }

    public record InitialSort(int index, boolean sortAscending) {
    }

    public static final class NameProcessColumn
    extends ProcessColumn {
        public NameProcessColumn(@Nullable InitialSort initialSort) {
            super(ProcessMessages.NAME_TITLE, initialSort);
        }

        @Override
        public IBlockCell getCell() {
            return new BlockTextCell(){

                @Override
                protected Rectangle getDesiredImageBoundsWithGap(Image image) {
                    Rectangle bounds = StreamlinePlugin.getImage("Download.png").getBounds();
                    bounds.width += this.getIconGap();
                    return bounds;
                }
            };
        }

        @Override
        public long getDataAsLong(@NonNull ProcessRow row) {
            return 0L;
        }

        @Override
        public double getDataAsDouble(@NonNull ProcessRow row) {
            return 0.0;
        }

        @Override
        public String getDataAsText(@NonNull ProcessRow row) {
            return row.getProcessData().getProcessName();
        }

        @Override
        public @Nullable Image getImage(@NonNull ProcessRow row) {
            if (row.getProcessData().isThread()) {
                return StreamlinePlugin.getImage("Thread.gif");
            }
            return StreamlinePlugin.getImage("Process.png");
        }
    }
}

