/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.csm;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineContextMenu;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.charts.ChartDragScrollTracker;
import com.arm.streamline.editortabs.timeline.common.charts.IChartDragScrollable;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.csm.HandleEdgeTracker;
import com.arm.streamline.editortabs.timeline.common.csm.HandleTracker;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionReporter;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.collections.ITimeStampedData;
import java.lang.invoke.StringConcatFactory;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CrossSectionHandlePanel
extends Block
implements IBookmarkListener,
ITimelinePositionReporter,
ITimelinePositionListener,
IHandleAreaListener,
IScaleListener,
ICrossSectionMarkerListener,
IChartDragScrollable {
    private static final String MICROSECONDS_SUFFIX = "\u00b5s";
    private static final String MILLISECONDS_SUFFIX = "ms";
    private static final String SECONDS_SUFFIX = "s";
    private static final double NANOS_PER_MICROSECOND = 1000.0;
    private static final double NANOS_PER_MILLISECOND = 1000000.0;
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.###");
    private BaseTimelineContent mContent;
    private DragTracker mTracker;
    private boolean mAutoScrollPending;

    public CrossSectionHandlePanel(BaseTimelineContent content) {
        this.setRemovesOtherFocus(true);
        this.mContent = content;
        this.mContent.addBookmarkListener(this);
    }

    @Override
    public final void bookmarkChanged() {
        this.repaint();
    }

    @Override
    public final void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.repaint();
    }

    @Override
    public final BaseTimelineContent getBaseTimelineContent() {
        return this.mContent;
    }

    public final @NonNull String getCSMText() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        CrossSectionMarker csm = cdp.getCrossSectionMarker();
        if (csm.isParked()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        long leftAtDensestScale = csm.getRangeLeftAtDensestScale();
        @NonNull ZoomLevel densestZoomLevel = csm.getDensestZoomLevel();
        buffer.append(this.getTimeUnit().formatBin(leftAtDensestScale, densestZoomLevel, TimeUnit.Style.SYMBOL_UNIT, false));
        buffer.append(" [");
        long duration = csm.getRangeRightAtDensestScale() - leftAtDensestScale;
        long durationTime = densestZoomLevel.convertBinToNanoseconds(duration);
        String scaledDuration = CrossSectionHandlePanel.scaleDuration(durationTime);
        buffer.append(scaledDuration);
        buffer.append("]");
        return buffer.toString();
    }

    public final long getMiddleLeft() {
        CrossSectionMarker csm = this.mContent.getCaptureDataProvider().getCrossSectionMarker();
        long left = this.translateFromSlot(csm.getLeft()) + (long)(RulerPanel.getSlotWidth() / 2);
        long right = this.translateFromSlot(csm.getRight() - 1L) + (long)(RulerPanel.getSlotWidth() / 2);
        return left + (Math.max(right - left, 0L) - this.getMiddleWidth()) / 2L;
    }

    public final long getMiddleWidth() {
        CrossSectionMarker csm = this.mContent.getCaptureDataProvider().getCrossSectionMarker();
        return (1L + csm.getRight() - csm.getLeft()) * (long)RulerPanel.getSlotWidth();
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        return new Point(widthHint == -1 ? 100 : widthHint, StreamlinePlugin.getImage((String)"CrossSectionHandleMiddle.png").getBounds().height);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    private @NonNull TimeUnit getTimeUnit() {
        return this.mContent.getCaptureDataProvider().getTimeUnit();
    }

    @Override
    public final void handleAreaWidthChanged() {
        this.repaint();
    }

    @Override
    public final boolean handleMouseUpWithoutDrag(Point where, int button, int stateMask, int count) {
        return false;
    }

    public final boolean needsExternalText() {
        String csmText;
        Rectangle bounds = this.getLocalBounds();
        int right = bounds.x + bounds.width - 1;
        if (this.getLeftEdge() <= (long)right && this.getRightEdge() >= (long)bounds.x && !(csmText = this.getCSMText()).isEmpty()) {
            long rightCapStart;
            long middleLeft = this.getMiddleLeft();
            if (middleLeft < (long)bounds.x) {
                middleLeft = bounds.x;
            }
            if ((rightCapStart = this.getRightCapStart()) >= (long)right) {
                rightCapStart = right;
            }
            GC gc = FontInfo.get(Fonts.getSmall()).getMeasurementGC();
            TextDrawingState state = new TextDrawingState(gc);
            boolean needed = (long)gc.stringExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u00010000"}, (String)csmText))).x > rightCapStart + 1L - middleLeft;
            state.restore();
            return needed;
        }
        return false;
    }

    public final void nudgeCrossSectionMarker(boolean leftSide, boolean range) {
        CrossSectionMarker csm = this.mContent.getCaptureDataProvider().getCrossSectionMarker();
        long left = csm.getLeft();
        long right = csm.getRight();
        if (range) {
            Long selectionStart;
            if (csm.getSelectionStart() == null) {
                if (leftSide) {
                    csm.setInitialPosition(right);
                } else {
                    csm.setInitialPosition(left);
                }
            }
            if ((selectionStart = csm.getSelectionStart()) != null && selectionStart > left) {
                long tmp = left;
                left = right;
                right = tmp;
            }
            if (leftSide) {
                if (right >= 0L) {
                    csm.setWithInitialPosition(left, right - 1L);
                }
            } else if (right < csm.getMax() + 1L) {
                csm.setWithInitialPosition(left, right + 1L);
            }
        } else if (leftSide) {
            if (left > 0L) {
                csm.set(left - 1L, right - 1L);
            } else if (left == right) {
                csm.reset();
            }
        } else if (right < csm.getMax() + 1L) {
            csm.set(left + 1L, right + 1L);
        }
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        super.repaint(x, y, width, height);
        RulerPanel rulerPanel = this.mContent.getRulerPanel();
        rulerPanel.repaint(x, 0, width, rulerPanel.getHeight());
    }

    public final void scaleChanged(Scales scales) {
        this.repaint();
    }

    @Override
    public final void timelinePositionChanged() {
        this.repaint();
    }

    public final long translateFromSlot(long index) {
        Rectangle bounds = this.getLocalBounds();
        long startIndex = 0L;
        long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (startX < 0L) {
            startIndex = -startX / (long)RulerPanel.getSlotWidth();
            startX += startIndex * (long)RulerPanel.getSlotWidth();
        }
        return startX + (index - startIndex) * (long)RulerPanel.getSlotWidth();
    }

    @Override
    public final long translateToSlot(long x) {
        Rectangle bounds = this.getLocalBounds();
        long startIndex = 0L;
        long startX = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (startX < 0L) {
            startIndex = -startX / (long)RulerPanel.getSlotWidth();
            startX += startIndex * (long)RulerPanel.getSlotWidth();
        }
        return startIndex + (x - startX) / (long)RulerPanel.getSlotWidth();
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        this.adjustCursor(where.x);
        if (button == 1) {
            this.mTracker = this.isOverHandleLeft(where.x) ? new HandleEdgeTracker(this, this, where.x, true) : (this.isOverHandleRight(where.x) ? new HandleEdgeTracker(this, this, where.x, false) : (this.isOverHandleBar(where.x) ? new HandleTracker(this, this, where.x) : new ChartDragScrollTracker(this, where.x, where.y)));
        } else if (button == 3) {
            TimelineContextMenu.showContextMenu(this.mContent, this.toDisplay(where.x, where.y));
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
            this.getBaseTimelineContent().updateCurrentPosition(this.translateToSlot(where.x));
        } else {
            this.mouseMove(where, stateMask);
        }
    }

    @Override
    protected final void mouseExit() {
        BaseTimelineContent content = this.getBaseTimelineContent();
        content.clearPositionReadoutIfNeeded();
        content.getRulerPanel().setHighlightedMouseSlot(-1L);
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        long slot = this.translateToSlot(where.x);
        BaseTimelineContent content = this.getBaseTimelineContent();
        if (!(this.isOverHandleLeft(where.x) || this.isOverHandleRight(where.x) || this.isOverHandleBar(where.x))) {
            content.getRulerPanel().showBookmarksForSlot(slot);
        }
        this.adjustCursor(where.x);
        content.updateCurrentPosition(slot);
        content.getRulerPanel().setHighlightedMouseSlot(slot);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursor(where.x);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.drawBackground(gc);
        this.drawTickMarks(gc);
        this.drawBookmarks(gc);
        this.drawHandle(gc);
    }

    @Override
    protected final void wasAdded(Block parent) {
        super.wasAdded(parent);
        ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
        dataProvider.getScales().addListener((IScaleListener)this);
        dataProvider.getCrossSectionMarker().addListener(this);
        BlockRoot root = this.getRoot();
        root.addKeyCodeHandler(() -> this.nudgeCrossSectionMarker(true, false), 0x1000003, 0);
        root.addKeyCodeHandler(() -> this.nudgeCrossSectionMarker(true, true), 0x1000003, 131072);
        root.addKeyCodeHandler(() -> this.nudgeCrossSectionMarker(false, false), 0x1000004, 0);
        root.addKeyCodeHandler(() -> this.nudgeCrossSectionMarker(false, true), 0x1000004, 131072);
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
        dataProvider.getScales().removeListener((IScaleListener)this);
        dataProvider.getCrossSectionMarker().removeListener(this);
    }

    private final void adjustCursor(int x) {
        int cursorID = 0;
        Cursor cursor = null;
        if (this.isOverHandleLeft(x)) {
            cursorID = 9;
        } else if (this.isOverHandleRight(x)) {
            cursorID = 9;
        } else if (this.isOverHandleBar(x)) {
            cursor = StreamlinePlugin.getOpenHandCursor();
        }
        if (cursor == null) {
            cursor = this.getDisplay().getSystemCursor(cursorID);
        }
        this.setCursor(cursor);
    }

    private final void autoScroll(int amount) {
        this.mAutoScrollPending = false;
        int x = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).x;
        if (amount < 0 && this.isOverAutoScrollLeft(x) || amount > 0 && this.isOverAutoScrollRight(x)) {
            this.mContent.getDividerPanel().setPosition(this.mContent.getDividerPanel().getPosition() + (long)amount);
            if (this.mTracker != null) {
                this.mTracker.mouseDrag(new Point(x, 0), 0);
            }
        }
    }

    private final void drawBackground(GC gc) {
        long x;
        Rectangle bounds = this.getLocalBounds();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Color bg = Colors.darken(Colors.getWidgetBackground(), 10);
        gc.setBackground(bg);
        gc.fillRectangle(bounds);
        long slot = this.getBaseTimelineContent().getRulerPanel().getHighlightedMouseSlot();
        if (slot >= 0L && (x = this.translateFromSlot(slot)) > (long)(bounds.x - RulerPanel.getSlotWidth()) && x < (long)(bounds.x + bounds.width)) {
            gc.setBackground(Colors.darken(Colors.getWidgetBackground(), 20));
            gc.fillRectangle((int)x + 1, bounds.y, RulerPanel.getSlotWidth() - 1, bounds.height);
        }
        int bottom = bounds.y + bounds.height - 1;
        gc.setForeground(Colors.getWidgetNormalShadow());
        gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        gc.setAntialias(savedAA);
    }

    private final void drawBookmarks(GC gc) {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        List<Bookmark> bookmarks = cdp.getBookmarks();
        int count = bookmarks.size();
        if (count > 0) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            Rectangle bounds = this.getLocalBounds();
            int right = bounds.x + bounds.width;
            int top = bounds.y - 1;
            int bottom = bounds.y + bounds.height - 3;
            @NonNull ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
            int pos = ITimeStampedData.binarySearch(bookmarks, (long)Position.scale((long)this.translateToSlot(0L), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            if (pos < 0) {
                pos = -pos - 1;
            }
            long last = -1L;
            while (pos < count) {
                Bookmark bookmark;
                long bi;
                if ((bi = Position.scale((long)(bookmark = bookmarks.get(pos++)).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) == last) continue;
                last = bi;
                long x = this.translateFromSlot(bi);
                if (x >= (long)right) break;
                gc.setBackground(Colors.create(bookmark.getRGB()));
                int bLeft = (int)x + 1;
                int bRight = (int)x + RulerPanel.getSlotWidth() - 1;
                int[] polygon = new int[]{bLeft, top, bRight, top, bRight, bottom, bLeft + (bRight - bLeft) / 2, bottom - 2, bLeft, bottom};
                gc.fillPolygon(polygon);
                gc.setForeground(Colors.getDarkGray());
                gc.drawPolygon(polygon);
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawHandle(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int right = bounds.x + bounds.width - 1;
        long leftEdge = this.getLeftEdge();
        if (leftEdge <= (long)right && this.getRightEdge() >= (long)bounds.x) {
            int top = bounds.y;
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            Image image = StreamlinePlugin.getImage("CrossSectionHandleLeft.png");
            Rectangle imgBounds = image.getBounds();
            if (leftEdge + (long)imgBounds.width >= (long)bounds.x && leftEdge < (long)(bounds.x + bounds.width)) {
                gc.drawImage(image, (int)leftEdge, top);
            }
            long rightCapStart = this.getRightCapStart();
            image = StreamlinePlugin.getImage("CrossSectionHandleRight.png");
            imgBounds = image.getBounds();
            if (rightCapStart + (long)imgBounds.width >= (long)bounds.x && rightCapStart < (long)(bounds.x + bounds.width)) {
                gc.drawImage(image, (int)rightCapStart, top);
            }
            image = StreamlinePlugin.getImage("CrossSectionHandleMiddle.png");
            imgBounds = image.getBounds();
            long middleLeft = this.getMiddleLeft();
            if (middleLeft < (long)bounds.x) {
                middleLeft = bounds.x;
            }
            if (rightCapStart >= (long)right) {
                rightCapStart = right;
            }
            Rectangle fillArea = new Rectangle((int)middleLeft, top, (int)(rightCapStart - middleLeft), imgBounds.height);
            fillArea.intersect(bounds);
            if (!fillArea.isEmpty()) {
                gc.drawImage(image, 0, 0, imgBounds.width, imgBounds.height, fillArea.x, fillArea.y, fillArea.width, fillArea.height);
            }
            gc.setAntialias(savedAA);
            if (!this.needsExternalText()) {
                if (rightCapStart >= (long)right) {
                    rightCapStart = right;
                }
                gc.setFont(Fonts.getSmall());
                gc.setForeground(Colors.getBlack());
                TextDrawing.drawString(gc, this.getCSMText(), (int)middleLeft, top, (int)(rightCapStart + 1L - middleLeft), imgBounds.height, 0x1000000, 0x1000000);
            }
        }
    }

    private final void drawTickMarks(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int top = bounds.y;
        int right = bounds.x + bounds.width - 1;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        long index = 0L;
        long x = (long)(bounds.x + this.mContent.getHandleAreaWidth()) - this.mContent.getDividerPanel().getPosition();
        if (x < 0L) {
            index = -x / (long)RulerPanel.getSlotWidth();
            x += index * (long)RulerPanel.getSlotWidth();
        }
        int bottom = bounds.y + bounds.height - 2;
        Color bg = Colors.darken(Colors.getWidgetBackground(), 10);
        Color fg1 = Colors.darken(bg, 20);
        Color fg2 = Colors.darken(bg, 5);
        int xx = (int)x;
        while (xx <= right) {
            gc.setForeground(index % 10L == 0L ? fg1 : fg2);
            gc.drawLine(xx, top, xx, bottom);
            xx += RulerPanel.getSlotWidth();
            ++index;
        }
        gc.setAntialias(savedAA);
    }

    private final long getLeftEdge() {
        return this.getMiddleLeft() - (long)StreamlinePlugin.getImage((String)"CrossSectionHandleLeft.png").getBounds().width;
    }

    private final long getRightCapStart() {
        return this.getMiddleLeft() + this.getMiddleWidth();
    }

    private final long getRightEdge() {
        return this.getRightCapStart() + (long)StreamlinePlugin.getImage((String)"CrossSectionHandleRight.png").getBounds().width;
    }

    private final boolean isOverAutoScrollLeft(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x < bounds.x + this.mContent.getHandleAreaWidth() + RulerPanel.getSlotWidth();
    }

    private final boolean isOverAutoScrollRight(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x > bounds.x + bounds.width - StreamlinePlugin.getImage((String)"CrossSectionHandleRight.png").getBounds().width;
    }

    private final boolean isOverHandleBar(int x) {
        long left = this.getMiddleLeft();
        return (long)x >= left && (long)x < left + this.getMiddleWidth();
    }

    private final boolean isOverHandleLeft(int x) {
        return (long)x >= this.getLeftEdge() && (long)x < this.getMiddleLeft();
    }

    private final boolean isOverHandleRight(int x) {
        return (long)x >= this.getRightCapStart() && (long)x < this.getRightEdge();
    }

    final void setupAutoScroll(int x) {
        if (!this.mAutoScrollPending) {
            int amount = 0;
            if (this.isOverAutoScrollLeft(x)) {
                amount = -RulerPanel.getSlotWidth() * 5;
            } else if (this.isOverAutoScrollRight(x)) {
                amount = RulerPanel.getSlotWidth() * 5;
            }
            if (amount != 0) {
                this.mAutoScrollPending = true;
                int scroll = amount;
                Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.MILLISECONDS);
            }
        }
    }

    private static final String scaleDuration(long duration) {
        if ((double)duration >= 1.0E9) {
            return decimalFormat.format((double)duration / 1.0E9) + SECONDS_SUFFIX;
        }
        if ((double)duration >= 1000000.0) {
            return decimalFormat.format((double)duration / 1000000.0) + MILLISECONDS_SUFFIX;
        }
        return decimalFormat.format((double)duration / 1000.0) + MICROSECONDS_SUFFIX;
    }
}

