/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfigUtility;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.utility.expression2.ExpressionData;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class WildcardSeriesConfigUtility {
    private static @NonNull Pattern SPLIT_COLOR_LIST = Pattern.compile("\\((.*?)\\)+");

    public static @NonNull String deriveNextUntitledSeriesName(@NonNull List<@NonNull IWildcardSeriesDataProvider> list) {
        OptionalInt max = list.stream().map(c -> {
            String name = c.getSeriesConfig().getName();
            int lastIndexOf = name.lastIndexOf("${*}");
            return lastIndexOf > -1 ? name.substring(0, lastIndexOf) : name;
        }).filter(c -> c.startsWith(ChartMessages.WILDCARD_UNTITLED_SERIES)).mapToInt(c -> {
            try {
                return Integer.parseInt(c.replaceFirst(ChartMessages.WILDCARD_UNTITLED_SERIES, "").trim());
            }
            catch (Exception e) {
                return 0;
            }
        }).distinct().sorted().reduce(Integer::max);
        int counter = max.isPresent() ? max.getAsInt() + 1 : 1;
        return ChartMessages.WILDCARD_UNTITLED_SERIES + " " + counter + " ${*}";
    }

    public static @Nullable String getUpdatedNameforExpandedSeries(@NonNull AbstractSeriesConfig config, @NonNull WildcardSeriesConfig wildcardSeriesConfig) {
        Set<String> variableSetFromExpression;
        ExpressionData expression;
        if (config.isExpandedSeries() && (expression = config.getExpression()) != null && (variableSetFromExpression = ChartUtility.getVariableSetFromExpression(expression)).size() == 1) {
            return SeriesConfigUtility.deriveSeriesConfNameFromWildcard(wildcardSeriesConfig.getName(), variableSetFromExpression.iterator().next(), wildcardSeriesConfig.getMatchWith());
        }
        return null;
    }

    public static @NonNull List<@NonNull String> getColorList(@NonNull String colorList) {
        @NonNull ArrayList<@NonNull String> colors = new ArrayList<String>();
        Matcher matcher = SPLIT_COLOR_LIST.matcher(colorList);
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group == null) continue;
            colors.add(group);
        }
        return colors;
    }

    public static @NonNull String getStringFromColorList(@NonNull List<@NonNull String> colorList) {
        return colorList.stream().map(n -> String.format("(%s)", n)).collect(Collectors.joining(","));
    }
}

