/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.utility.text.ScaledFormat;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SharedLimitCalculator {
    private ICaptureDataProvider captureDataProvider;
    private Key lastKey = null;
    private Result lastResult = null;

    public static double getPlateau(@NonNull IChartDataProvider chart, boolean open, boolean applyLog10IfNeeded) {
        double plateau;
        if (chart.isPercentage()) {
            return 1.0;
        }
        double d = plateau = open ? chart.getCoreLimit() : chart.getAggregateLimit();
        if (applyLog10IfNeeded && chart.getSeriesComposition() == SeriesComposition.LOG10) {
            plateau = Math.log10(plateau);
        }
        return NumberUtils.calculateLimit((double)plateau, (boolean)ScaledFormat.shouldUseKibi(chart.getUnits()));
    }

    public static double getPlateau(@NonNull IChartDataProvider chart, boolean open, boolean applyLog10IfNeeded, double[] data) {
        double plateau;
        try {
            plateau = SharedLimitCalculator.getMax(data);
        }
        catch (IllegalArgumentException e) {
            double d = plateau = open ? chart.getCoreLimit() : chart.getAggregateLimit();
        }
        if (applyLog10IfNeeded && chart.getSeriesComposition() == SeriesComposition.LOG10) {
            plateau = Math.log10(plateau);
        }
        return NumberUtils.calculateLimit((double)plateau, (boolean)ScaledFormat.shouldUseKibi(chart.getUnits()));
    }

    private static @NonNull Result createResultNormalChart(@NonNull IChartDataProvider chart, int first, int last, @Nullable TIntSet selection, boolean open) {
        ProcessingElementReference[] channelDescriptors = open ? chart.getCoreInformationProvider().getChannelDescriptors() : null;
        @NonNull List<@NonNull ISeriesDataProvider> seriesList = chart.getSeries();
        boolean stacked = chart.getSeriesComposition() == SeriesComposition.STACKED;
        boolean updateLimit = false;
        boolean getLimitFromChartFirstIter = true;
        double limit = 0.0;
        boolean mLimitIsDirty = false;
        int channelCount = channelDescriptors != null ? channelDescriptors.length : 1;
        double[][][] perSeriesData = new double[channelCount][seriesList.size()][];
        int channelIndex = 0;
        while (channelIndex < channelCount) {
            double currentCoreLimit = 0.0;
            int seriesIndex = seriesList.size();
            while (--seriesIndex >= 0) {
                ISeriesDataProvider series = seriesList.get(seriesIndex);
                double[] data = channelDescriptors != null ? series.getData(channelDescriptors[channelIndex], first, last, selection) : series.getData(first, last, selection);
                perSeriesData[channelIndex][seriesIndex] = data;
                if (selection != null && series.isFilterable()) {
                    updateLimit = true;
                    double currentSeriesLimit = SharedLimitCalculator.getPlateau(chart, open, true, data);
                    if (stacked) {
                        currentCoreLimit += currentSeriesLimit;
                    }
                    if (!(currentSeriesLimit > limit)) continue;
                    limit = currentSeriesLimit;
                    continue;
                }
                if (!getLimitFromChartFirstIter) continue;
                limit = SharedLimitCalculator.getPlateau(chart, open, true);
                mLimitIsDirty = true;
                getLimitFromChartFirstIter = false;
            }
            if (currentCoreLimit > limit) {
                limit = currentCoreLimit;
            }
            ++channelIndex;
        }
        return new Result(updateLimit, mLimitIsDirty, limit, perSeriesData, seriesList, channelDescriptors);
    }

    private static double getMax(double[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException();
        }
        double max = data[0];
        int i = 1;
        while (i < data.length) {
            if (data[i] > max) {
                max = data[i];
            }
            ++i;
        }
        return max;
    }

    public SharedLimitCalculator(ICaptureDataProvider captureDataProvider) {
        this.captureDataProvider = captureDataProvider;
    }

    public @NonNull Result calculateHeatMap(@NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
        Key key = new Key(Type.HEAT_MAP, chart, zoomLevel, first, last, slots, selection);
        if (!NullChecking.equalsNullable((Object)this.lastKey, (Object)key)) {
            @NonNull List<@NonNull ISeriesDataProvider> seriesList = chart.getSeries();
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channelDescriptors = coreInformationProvider.getChannelDescriptors();
            if (this.lastKey != null && this.lastResult != null && this.lastKey.zoomLevel == zoomLevel && chart.equals(this.lastKey.chart) && key.selectionHashCode == this.lastKey.selectionHashCode) {
                int previousFirst = this.lastKey.first;
                int previousLast = this.lastKey.last;
                boolean isSuccess = false;
                if (previousLast > first && previousFirst < first && last > previousLast) {
                    isSuccess = this.updateResultHeatMapChart(first, last, selection, seriesList, channelDescriptors, previousFirst, previousLast, HorizontalScrollDirection.RIGHT, chart);
                } else if (last > previousFirst && previousLast > last && previousFirst > first) {
                    isSuccess = this.updateResultHeatMapChart(first, last, selection, seriesList, channelDescriptors, previousFirst, previousLast, HorizontalScrollDirection.LEFT, chart);
                }
                if (isSuccess) {
                    this.lastKey = key;
                    return (Result)NullChecking.neverNull((Object)this.lastResult);
                }
            }
            double[][][] perSeriesData = new double[channelDescriptors.length][seriesList.size()][];
            Result result = this.createResultHeatMapChart(chart, first, last, selection, seriesList, channelDescriptors, perSeriesData);
            this.lastKey = key;
            this.lastResult = result;
        }
        return (Result)NullChecking.neverNull((Object)this.lastResult);
    }

    public @NonNull Result calculateNormal(boolean open, @NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
        Type type = open ? Type.OPEN : Type.CLOSED;
        Key key = new Key(type, chart, zoomLevel, first, last, slots, selection);
        if (!NullChecking.equalsNullable((Object)this.lastKey, (Object)key)) {
            List<@NonNull ISeriesDataProvider> seriesList = chart.getSeries();
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channelDescriptors = coreInformationProvider.getChannelDescriptors();
            if (this.lastKey != null && this.lastResult != null && this.lastKey.zoomLevel == zoomLevel && chart.equals(this.lastKey.chart) && key.selectionHashCode == this.lastKey.selectionHashCode) {
                int previousFirst = this.lastKey.first;
                int previousLast = this.lastKey.last;
                boolean isSuccess = false;
                if (previousLast > first && previousFirst < first && last > previousLast) {
                    isSuccess = this.updateResultNormalChart(open, first, last, selection, seriesList, channelDescriptors, previousFirst, previousLast, HorizontalScrollDirection.RIGHT, chart);
                } else if (last > previousFirst && previousLast > last && previousFirst > first) {
                    isSuccess = this.updateResultNormalChart(open, first, last, selection, seriesList, channelDescriptors, previousFirst, previousLast, HorizontalScrollDirection.LEFT, chart);
                }
                if (isSuccess) {
                    this.lastKey = key;
                    return (Result)NullChecking.neverNull((Object)this.lastResult);
                }
            }
            @NonNull Result result = SharedLimitCalculator.createResultNormalChart(chart, first, last, selection, open);
            this.lastKey = key;
            this.lastResult = result;
            return result;
        }
        return (Result)NullChecking.neverNull((Object)this.lastResult);
    }

    public void clear() {
        this.lastKey = null;
        this.lastResult = null;
    }

    private Result createResultHeatMapChart(IChartDataProvider chart, int first, int last, TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, double[][][] perSeriesData) {
        boolean updateLimit = false;
        boolean getLimitFromChartFirstIter = true;
        double limit = 0.0;
        boolean mLimitIsDirty = false;
        boolean isStacked = chart.getSeriesComposition() == SeriesComposition.STACKED;
        int channelIndex = 0;
        while (channelIndex < channelDescriptors.length) {
            ProcessingElementReference channel = channelDescriptors[channelIndex];
            double currentCoreLimit = 0.0;
            int seriesIndex = seriesList.size();
            while (--seriesIndex >= 0) {
                ISeriesDataProvider series = seriesList.get(seriesIndex);
                double[] data = series.getData(channel, first, last, selection);
                perSeriesData[channelIndex][seriesIndex] = data;
                if (selection != null && series.isFilterable()) {
                    updateLimit = true;
                    double currentSeriesLimit = SharedLimitCalculator.getPlateau(chart, true, true, data);
                    if (isStacked) {
                        currentCoreLimit += currentSeriesLimit;
                    }
                    if (!(currentSeriesLimit > limit)) continue;
                    limit = currentSeriesLimit;
                    continue;
                }
                if (!getLimitFromChartFirstIter) continue;
                limit = SharedLimitCalculator.getPlateau(chart, true, true);
                mLimitIsDirty = true;
                getLimitFromChartFirstIter = false;
            }
            if (currentCoreLimit > limit) {
                limit = currentCoreLimit;
            }
            ++channelIndex;
        }
        Result result = new Result(updateLimit, mLimitIsDirty, limit, perSeriesData, seriesList, channelDescriptors);
        return result;
    }

    private int getLastBinCount(HorizontalScrollDirection dir) {
        int lastBinCount = 0;
        if (((ICaptureDataProvider)NullChecking.neverNull((Object)this.captureDataProvider)).isLive() && dir == HorizontalScrollDirection.RIGHT) {
            lastBinCount = this.captureDataProvider.getLastBinCount() - 10;
        }
        return lastBinCount;
    }

    private double[] getSeriesData(int first, TIntSet selection, ProcessingElementReference @NonNull [] channelDescriptors, int previousLast, HorizontalScrollDirection dir, int channelIndex, int remaning, ISeriesDataProvider series, boolean open) {
        double[] data = null;
        int start = dir == HorizontalScrollDirection.RIGHT ? previousLast + 1 : first;
        int end = dir == HorizontalScrollDirection.RIGHT ? previousLast + remaning : first + remaning - 1;
        data = open ? series.getData(channelDescriptors[channelIndex], start, end, selection) : series.getData(start, end, selection);
        return data;
    }

    private boolean updateResultHeatMapChart(int first, int last, TIntSet selection, List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, int previousFirst, int previousLast, HorizontalScrollDirection dir, @NonNull IChartDataProvider chart) {
        boolean updateLimit = false;
        boolean getLimitFromChartFirstIter = true;
        double limit = 0.0;
        boolean mLimitIsDirty = false;
        boolean isStacked = chart.getSeriesComposition() == SeriesComposition.STACKED;
        double[][][] perSeriesData = this.lastResult.perSeriesData;
        int newRange = last - first + 1;
        int startingIndex = dir == HorizontalScrollDirection.RIGHT ? first - previousFirst : previousFirst - first;
        int liveDelta = 0;
        int lastBinCount = this.getLastBinCount(dir);
        if (lastBinCount > 0) {
            liveDelta = previousLast - lastBinCount;
            previousLast = lastBinCount;
        }
        int channelIndex = 0;
        while (channelIndex < channelDescriptors.length) {
            ProcessingElementReference channel = channelDescriptors[channelIndex];
            double currentCoreLimit = 0.0;
            int mseriesIndex = seriesList.size();
            while (--mseriesIndex >= 0) {
                double[] ds = perSeriesData[channelIndex][mseriesIndex];
                if (ds.length >= previousLast - previousFirst + 1) {
                    int copyStartIndex;
                    double[] newSetofData = new double[newRange];
                    int remaning = 0;
                    int n = copyStartIndex = dir == HorizontalScrollDirection.RIGHT ? ds.length - startingIndex - liveDelta : 0;
                    if (dir == HorizontalScrollDirection.RIGHT) {
                        System.arraycopy(ds, startingIndex, newSetofData, 0, ds.length - startingIndex - liveDelta);
                        remaning = newSetofData.length - (ds.length - startingIndex - liveDelta);
                    } else {
                        System.arraycopy(ds, 0, newSetofData, startingIndex, newSetofData.length - startingIndex);
                        remaning = startingIndex;
                    }
                    ISeriesDataProvider series = seriesList.get(mseriesIndex);
                    double[] data = series.getData(channel, dir == HorizontalScrollDirection.RIGHT ? previousLast + 1 : first, dir == HorizontalScrollDirection.RIGHT ? previousLast + remaning : first + remaning - 1, selection);
                    int j = 0;
                    while (j < data.length && copyStartIndex < newSetofData.length) {
                        newSetofData[copyStartIndex] = data[j];
                        ++copyStartIndex;
                        ++j;
                    }
                    perSeriesData[channelIndex][mseriesIndex] = newSetofData;
                    if (selection != null && series.isFilterable()) {
                        updateLimit = true;
                        double currentSeriesLimit = SharedLimitCalculator.getPlateau(chart, true, true, newSetofData);
                        if (isStacked) {
                            currentCoreLimit += currentSeriesLimit;
                        }
                        if (!(currentSeriesLimit > limit)) continue;
                        limit = currentSeriesLimit;
                        continue;
                    }
                    if (!getLimitFromChartFirstIter) continue;
                    limit = SharedLimitCalculator.getPlateau(chart, true, true);
                    mLimitIsDirty = true;
                    getLimitFromChartFirstIter = false;
                    continue;
                }
                return false;
            }
            if (currentCoreLimit > limit) {
                this.lastResult.limit = limit = currentCoreLimit;
                this.lastResult.updateLimit = updateLimit;
                this.lastResult.mLimitIsDirty = mLimitIsDirty;
            }
            ++channelIndex;
        }
        return true;
    }

    private boolean updateResultNormalChart(boolean open, int first, int last, @Nullable TIntSet selection, List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, int previousFirst, int previousLast, HorizontalScrollDirection dir, @NonNull IChartDataProvider chart) {
        boolean updateLimit = false;
        boolean getLimitFromChartFirstIter = true;
        double limit = 0.0;
        boolean mLimitIsDirty = false;
        boolean isStacked = chart.getSeriesComposition() == SeriesComposition.STACKED;
        double[][][] perSeriesData = this.lastResult.perSeriesData;
        int newRange = last - first + 1;
        int startingIndex = dir == HorizontalScrollDirection.RIGHT ? first - previousFirst : previousFirst - first;
        int count = open ? channelDescriptors.length : 1;
        int liveDelta = 0;
        int lastBinCount = this.getLastBinCount(dir);
        if (lastBinCount > 0) {
            liveDelta = previousLast - lastBinCount;
            previousLast = lastBinCount;
        }
        int channelIndex = 0;
        while (channelIndex < count) {
            double currentCoreLimit = 0.0;
            int mseriesIndex = seriesList.size();
            while (--mseriesIndex >= 0) {
                double[] ds = perSeriesData[channelIndex][mseriesIndex];
                if (ds.length >= previousLast - previousFirst + 1) {
                    int copyStartIndex;
                    double[] newSetofData = new double[newRange];
                    int remaning = 0;
                    int n = copyStartIndex = dir == HorizontalScrollDirection.RIGHT ? ds.length - startingIndex - liveDelta : 0;
                    if (dir == HorizontalScrollDirection.RIGHT) {
                        int nToCopy = ds.length - startingIndex - liveDelta;
                        assert (nToCopy <= newSetofData.length);
                        assert (startingIndex + nToCopy <= ds.length);
                        System.arraycopy(ds, startingIndex, newSetofData, 0, nToCopy);
                        remaning = newSetofData.length - (ds.length - startingIndex - liveDelta);
                    } else {
                        System.arraycopy(ds, 0, newSetofData, startingIndex, newSetofData.length - startingIndex);
                        remaning = startingIndex;
                    }
                    ISeriesDataProvider series = seriesList.get(mseriesIndex);
                    double[] data = this.getSeriesData(first, selection, channelDescriptors, previousLast, dir, channelIndex, remaning, series, open);
                    int j = 0;
                    while (j < data.length && copyStartIndex < newSetofData.length) {
                        newSetofData[copyStartIndex] = data[j];
                        ++copyStartIndex;
                        ++j;
                    }
                    perSeriesData[channelIndex][mseriesIndex] = newSetofData;
                    if (selection != null && series.isFilterable()) {
                        updateLimit = true;
                        double currentSeriesLimit = SharedLimitCalculator.getPlateau(chart, open, true, newSetofData);
                        if (isStacked) {
                            currentCoreLimit += currentSeriesLimit;
                        }
                        if (!(currentSeriesLimit > limit)) continue;
                        limit = currentSeriesLimit;
                        continue;
                    }
                    if (!getLimitFromChartFirstIter) continue;
                    limit = SharedLimitCalculator.getPlateau(chart, open, true);
                    mLimitIsDirty = true;
                    getLimitFromChartFirstIter = false;
                    continue;
                }
                return false;
            }
            if (currentCoreLimit > limit) {
                this.lastResult.limit = limit = currentCoreLimit;
                this.lastResult.updateLimit = updateLimit;
                this.lastResult.mLimitIsDirty = mLimitIsDirty;
            }
            ++channelIndex;
        }
        return true;
    }

    public static enum HorizontalScrollDirection {
        LEFT,
        RIGHT;

    }

    private static final class Key {
        public final @NonNull IChartDataProvider chart;
        public final int first;
        public final int last;
        public final int selectionHashCode;
        public final @NonNull List<@NonNull ISeriesDataProvider> series;
        public final int slots;
        public final @NonNull Type type;
        public final @NonNull ZoomLevel zoomLevel;

        public Key(@NonNull Type type, @NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
            this.type = type;
            this.chart = chart;
            this.zoomLevel = zoomLevel;
            this.first = first;
            this.last = last;
            this.slots = slots;
            this.selectionHashCode = selection != null ? selection.hashCode() : 0;
            this.series = new ArrayList<ISeriesDataProvider>(chart.getSeries());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                int end = Math.min(this.last, this.slots);
                int thatEnd = Math.min(that.last, that.slots);
                return this.type == that.type && this.first == that.first && end == thatEnd && this.chart.equals(that.chart) && this.zoomLevel.equals((Object)that.zoomLevel) && this.series.equals(that.series) && this.selectionHashCode == that.selectionHashCode;
            }
            return false;
        }

        public int hashCode() {
            return ((((((this.chart.hashCode() * 31 + this.first) * 31 + this.last) * 31 + this.zoomLevel.hashCode()) * 31 + this.selectionHashCode) * 31 + this.slots) * 31 + this.series.hashCode()) * 31 + this.type.hashCode();
        }

        public String toString() {
            return String.format("Key [chart=%s, first=%s, last=%s, slots=%s, type=%s, selectionHashCode=%s]", new Object[]{this.chart.getTitle(), this.first, this.last, this.slots, this.type, this.selectionHashCode});
        }
    }

    public static final class Result {
        public double limit;
        public boolean mLimitIsDirty;
        public final double[][][] perSeriesData;
        public final @NonNull List<@NonNull ISeriesDataProvider> seriesList;
        public boolean updateLimit;
        private final @NonNull ProcessingElementReference @Nullable [] channelDescriptors;

        public Result(boolean updateLimit, boolean mLimitIsDirty, double limit, double[][][] perSeriesData, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @Nullable [] channelDescriptors) {
            this.updateLimit = updateLimit;
            this.mLimitIsDirty = mLimitIsDirty;
            this.limit = limit;
            this.perSeriesData = perSeriesData;
            this.seriesList = seriesList;
            this.channelDescriptors = channelDescriptors;
        }

        public double[] getPerSeriesData(int channelIndex, int seriesIndex) {
            @NonNull ProcessingElementReference @Nullable [] channelDescriptors = this.channelDescriptors;
            if (channelDescriptors == null) {
                assert (channelIndex <= 0);
                return this.perSeriesData[0][seriesIndex];
            }
            return this.perSeriesData[channelIndex][seriesIndex];
        }

        public int getTargetChannelIndex(@Nullable ProcessingElementReference channelDescriptor) {
            @NonNull Object @Nullable [] channelDescriptors = this.channelDescriptors;
            if (channelDescriptor == null || channelDescriptors == null) {
                return -1;
            }
            return ArrayUtils.indexOf((Object[])channelDescriptors, (Object)channelDescriptor);
        }
    }

    private static enum Type {
        CLOSED,
        HEAT_MAP,
        OPEN;

    }
}

