/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.ContentWrapper;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartPanel;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.charts.SeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartAndSeriesListener;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ChartsPanel
extends Block
implements IBookmarkListener,
ITimelinePositionListener,
IChartAndSeriesListener,
IBlockLayout,
IScrollableBlock {
    public static final int MIN_HANDLE_WIDTH = 100;
    private static final int MAX_HANDLE_WIDTH = 400;
    private final @NonNull BaseTimelineContent mBaseTimelineContent;
    private int mHandleAreaWidth;
    private List<IHandleAreaListener> mListeners = new ArrayList<IHandleAreaListener>();
    private boolean mLayoutBaseContentOnPack;
    private boolean mShouldDrawSeriesValuesOnLeft;
    private boolean mFilteringIsActive;

    public ChartsPanel(@NonNull BaseTimelineContent baseTimelineContent, int handleWidth) {
        this.setFocusable(true);
        this.setLayout(this);
        this.mBaseTimelineContent = baseTimelineContent;
        this.mBaseTimelineContent.addBookmarkListener(this);
        this.refreshCaptureData();
        this.mHandleAreaWidth = handleWidth > 0 ? handleWidth : this.getDefaultHandleAreaWidth(0);
    }

    public void refreshCaptureData() {
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        cdp.addDynamicChartListener(this);
        Block[] blockArray = this.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block child = blockArray[n2];
            this.remove(child);
            ++n2;
        }
        for (IChartDataProvider chart : cdp.getChartList()) {
            this.add(new ChartHandlePanel(this, chart));
        }
        this.pack();
    }

    public final synchronized void addHandleAreaListener(IHandleAreaListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public final void bookmarkChanged() {
        this.repaint();
    }

    @Override
    public final void chartWasAdded(@NonNull IChartDataProvider chart) {
        ChartHandlePanel handle = new ChartHandlePanel(this, chart);
        if (handle.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
            this.add(handle);
        } else if (chart.getCaptureDataProvider() instanceof LiveCaptureDataProvider) {
            int atIndex = this.findIndexToAddNewChart(chart);
            this.add(handle, atIndex);
        } else {
            this.add(handle, 0);
        }
        ContentWrapper wrapper = this.mBaseTimelineContent.getContentWrapper();
        if (wrapper.getDividerPosition() == -1) {
            wrapper.setDividerPosition(-1);
        }
        this.pack();
    }

    private int findIndexToAddNewChart(@NonNull IChartDataProvider chart) {
        List<ChartAndSeriesConfig> charts;
        OptionalInt first;
        List chartHandles = this.getFlattenedChildren().filter(c -> c instanceof ChartHandlePanel).map(c -> (ChartHandlePanel)c).collect(Collectors.toList());
        int childCount = chartHandles.size();
        LiveCaptureDataProvider liveDataProvider = (LiveCaptureDataProvider)chart.getCaptureDataProvider();
        List<TemplateFile> templatesApplied = liveDataProvider.getTemplatesApplied();
        if (templatesApplied.size() > 0 && (first = IntStream.range(0, (charts = templatesApplied.get(0).getCharts()).size()).filter(i -> ((ChartAndSeriesConfig)charts.get(i)).getChart().matches(chart.getChartConfig())).findFirst()).isPresent()) {
            int asInt = first.getAsInt();
            return asInt > childCount ? 0 : asInt;
        }
        return 0;
    }

    public final BaseTimelineContent getBaseTimelineContent() {
        return this.mBaseTimelineContent;
    }

    public final ICaptureDataProvider getCaptureDataProvider() {
        return this.mBaseTimelineContent.getCaptureDataProvider();
    }

    public final int getDefaultHandleAreaWidth(int extraPreferredWidth) {
        int minHandledWidth = Math.max(100, extraPreferredWidth);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IntStream widthStream = this.getChildPanelPreferredWidths();){
            int maxWidth = widthStream.max().orElse(minHandledWidth);
            return Math.min(maxWidth, this.getMaxHandleAreaWidth());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private @NonNull IntStream getChildPanelPreferredWidths() {
        return Arrays.stream(this.getChildren()).map(block -> (ChartHandlePanel)block).mapToInt(handlePanel -> handlePanel.getPreferredWidth());
    }

    private int getMaxHandleAreaWidth() {
        return Math.max(this.getWidth() / 2, 400);
    }

    public final int getHandleAreaWidth() {
        return this.mHandleAreaWidth;
    }

    @Override
    public final int getHorizontalIncrement() {
        return 1;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            Point size = this.getChild(i).getMinimumSize(widthHint, -1);
            height += size.y;
            if (width < size.x) {
                width = size.x;
            }
            ++i;
        }
        return new Point(widthHint == -1 ? width : widthHint, height);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            Point size = this.getChild(i).getPreferredSize(widthHint, -1);
            height += size.y;
            if (width < size.x) {
                width = size.x;
            }
            ++i;
        }
        return new Point(widthHint == -1 ? width : widthHint, height);
    }

    @Override
    public final int getVerticalIncrement() {
        return 30;
    }

    public final int getVisibleSlots() {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            ChartHandlePanel handlePanel = (ChartHandlePanel)this.getChild(i);
            int chartCount = handlePanel.getChildCount();
            if (chartCount > 0) {
                int width = handlePanel.getChild(0).getWidth();
                int slots = width / RulerPanel.getSlotWidth();
                if (slots * RulerPanel.getSlotWidth() != width) {
                    ++slots;
                }
                return slots;
            }
            ++i;
        }
        return 0;
    }

    public final boolean isFilteringActive() {
        return this.mFilteringIsActive;
    }

    @Override
    public final void layout(Block target) {
        Rectangle bounds = this.getLocalBounds();
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            Block child = this.getChild(i);
            int height = child.getPreferredSize((int)width, (int)-1).y;
            child.setBounds(x, y, width, height);
            y += height;
            ++i;
        }
        this.setHandleAreaWidth(this.mHandleAreaWidth);
    }

    @Override
    public final void pack() {
        BaseTimelineContent content;
        super.pack();
        if (this.mLayoutBaseContentOnPack && !(content = this.getBaseTimelineContent()).isDisposed()) {
            content.layout(true, true);
        }
    }

    public final void redrawCharts() {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            ChartHandlePanel handlePanel = (ChartHandlePanel)this.getChild(i);
            int chartCount = handlePanel.getChildCount();
            int j = 0;
            while (j < chartCount) {
                handlePanel.getChild(j).repaint();
                ++j;
            }
            ++i;
        }
    }

    public final synchronized void removeHandleAreaListener(IHandleAreaListener listener) {
        this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHandleAreaWidth(int width) {
        int maxHandleWidth = this.getMaxHandleAreaWidth();
        if (width < 100) {
            width = 100;
        } else if (width > maxHandleWidth) {
            width = maxHandleWidth;
        }
        if (this.mHandleAreaWidth != width) {
            IHandleAreaListener[] listeners;
            this.mHandleAreaWidth = width;
            ChartsPanel chartsPanel = this;
            synchronized (chartsPanel) {
                listeners = this.mListeners.toArray(new IHandleAreaListener[this.mListeners.size()]);
            }
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IHandleAreaListener listener = objectArray[n2];
                listener.handleAreaWidthChanged();
                ++n2;
            }
            this.layout();
            objectArray = this.getChildren();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                ((Block)child).layout();
                ++n2;
            }
        }
    }

    public final boolean shouldDrawSeriesValuesOnLeft() {
        return this.mShouldDrawSeriesValuesOnLeft;
    }

    public final void stop() {
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        if (cdp != null) {
            cdp.removeDynamicChartListener(this);
        }
    }

    @Override
    public final void timelinePositionChanged() {
        this.redrawCharts();
    }

    @Override
    protected final void childWasAdded(Block child) {
        super.childWasAdded(child);
        this.pack();
        NullChecking.consumeIfNonNull((Object)this.getRoot(), Block::layout);
    }

    @Override
    protected final void childWasRemoved(Block child) {
        super.childWasRemoved(child);
        this.pack();
        NullChecking.consumeIfNonNull((Object)this.getRoot(), Block::layout);
    }

    @Override
    protected final boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        if (vertical) {
            return false;
        }
        DividerPanel dividerPanel = this.mBaseTimelineContent.getDividerPanel();
        dividerPanel.setPosition(dividerPanel.getPosition() - (long)amount * dividerPanel.getScrollBar().getIncrement());
        return true;
    }

    @Override
    protected final void paintSelf(GC gc) {
        this.mFilteringIsActive = this.getCaptureDataProvider().convertToThreadUIDs(this.getBaseTimelineContent().getSelectedProcessAndThreadIds()) != null;
        this.mLayoutBaseContentOnPack = true;
        this.mShouldDrawSeriesValuesOnLeft = false;
        int i = this.getChildCount();
        block0: while (--i >= 0) {
            Block child = this.getChild(i);
            if (!(child instanceof ChartHandlePanel)) continue;
            ChartHandlePanel handle = (ChartHandlePanel)child;
            int j = handle.getChildCount();
            while (--j >= 0) {
                Block child2 = handle.getChild(j);
                if (!(child2 instanceof ChartPanel) || !((ChartPanel)child2).shouldDrawSeriesValuesOnLeft()) continue;
                this.mShouldDrawSeriesValuesOnLeft = true;
                continue block0;
            }
        }
        super.paintSelf(gc);
    }

    @Override
    public void chartWasRemoved(@NonNull IChartDataProvider chart) {
        this.removeMatching(b -> b instanceof ChartHandlePanel && ((ChartHandlePanel)b).getChart().equals(chart));
        this.pack();
    }

    @Override
    public void seriesWasAdded(@NonNull IChartDataProvider chart, @NonNull ISeriesDataProvider series) {
        NullChecking.consumeIfNonNull((Object)this.getHandleOf(chart), c -> c.addSeries(series, null));
    }

    @Override
    public void seriesWasRemoved(@NonNull IChartDataProvider chart, @NonNull ISeriesDataProvider series) {
        NullChecking.consumeIfNonNull((Object)this.getHandleOf(chart), c -> {
            SeriesConfigurationPanel seriesConfigurationPanel = c.removeSeries(series);
        });
    }

    private @Nullable ChartHandlePanel getHandleOf(@NonNull IChartDataProvider chart) {
        return Stream.of(this.getChildren()).filter(b -> b instanceof ChartHandlePanel && ((ChartHandlePanel)b).getChart().equals(chart)).findAny().orElse(null);
    }

    public void setHighlightedSources(@NonNull Set<@NonNull String> sources) {
        Stream.of(this.getChildren()).filter(b -> b instanceof ChartHandlePanel).forEach(b -> ((ChartHandlePanel)b).setHighlightedSources(sources));
    }
}

