/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.FilmStrip;
import com.arm.streamline.editortabs.timeline.common.charts.SharedLimitCalculator;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionReporter;
import com.arm.streamline.editortabs.timeline.common.images.ImageWrapper;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.annotation.VisualAnnotation;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICalipersListener;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.utility.Geometry;
import com.arm.streamline.utility.io.ImageCache;
import com.arm.streamline.utility.text.ScaledFormat;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.utility.ui.StreamlineUIUtils;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ITimeStampedData;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ChartPanel
extends GraphBlock
implements ITimelinePositionReporter,
ICrossSectionMarkerListener,
ICalipersListener,
IScaleListener,
ImageCache.IImageCacheListener {
    public static final int COLOUR_INDEX_DARK_GRAY = -1;
    public static final int COLOUR_INDEX_MULTI = -2;
    public static final Font FONT_TOOLTIP = Fonts.getSmall();
    public static final int FONT_TOOLTIP_HEIGHT;
    public static final int HEATMAPLINE_BLOCK_SPACING = 2;
    public static final int HEATMAPLINE_MAX_BLOCK_HEIGHT = 50;
    public static final int HEATMAPLINE_MIN_BLOCK_HEIGHT;
    public static final int VERTICAL_GROUPING_MARKER = 10;
    public static final int VISUAL_ANNOTATION_H_GUTTER = 1;
    public static final int VISUAL_ANNOTATION_V_GUTTER = 4;
    private static final String AVERAGE = " avg.";
    private static final int CORNER_RADIUS = 8;
    private static final int EXTENTS_INDENT = 4;
    private static final Color THEME_VISUAL_ANNOTATION_MARKER;
    private static final Color THEME_VISUAL_ANNOTATION_WITH_TEXT_MARKER;
    private final @Nullable ProcessingElementReference channelDescriptor;
    private final int colourIndex;
    private int heatmapZoomingFactor;
    private final @NonNull String label;
    private final @NonNull SharedLimitCalculator limitCalculator;
    private boolean mAutoScrollPending;
    private ChartHandlePanel mChartHandlePanel;
    private double mLastLimit;
    private boolean mLimitIsDirty;
    private ISeriesDataProvider mseriesDataprovider;
    private int mseriesIndex;
    private TLongObjectHashMap<SlotData> mSlotData = new TLongObjectHashMap();
    private boolean mSwapThemeValueColors;
    private Color mThemeLogarithmicLine;
    private Color mThemeValuesBackground;
    private Color mThemeValuesForeground;
    private ImageCache mThumbnailImageCache;

    static {
        HEATMAPLINE_MIN_BLOCK_HEIGHT = FONT_TOOLTIP_HEIGHT = FontInfo.get(FONT_TOOLTIP).getHeight();
        THEME_VISUAL_ANNOTATION_MARKER = Colors.create(48, 131, 255);
        THEME_VISUAL_ANNOTATION_WITH_TEXT_MARKER = Colors.create(220, 220, 0);
    }

    public ChartPanel(@NonNull ChartHandlePanel chartHandlePanel, @NonNull SharedLimitCalculator limitCalculator, @Nullable ProcessingElementReference channelDescriptor, @NonNull String label, int colourIndex) {
        super(chartHandlePanel.getChartsPanel().getBaseTimelineContent());
        this.setRemovesOtherFocus(true);
        this.mChartHandlePanel = chartHandlePanel;
        this.channelDescriptor = channelDescriptor;
        this.label = label;
        this.colourIndex = colourIndex;
        this.limitCalculator = limitCalculator;
    }

    public ChartPanel(@NonNull ChartHandlePanel chartHandlePanel, @NonNull SharedLimitCalculator limitCalculator, @Nullable ProcessingElementReference channelDescriptor, @NonNull String label, int seriesIndex, ISeriesDataProvider seriesDataprovider, int zoomFactor) {
        this(chartHandlePanel, limitCalculator, channelDescriptor, label, -1);
        this.setType(Block.BlockType.HEAT_MAP_PANEL);
        this.heatmapZoomingFactor = zoomFactor;
        this.mseriesIndex = seriesIndex;
        this.mseriesDataprovider = seriesDataprovider;
    }

    @Override
    public final void calipersChanged(Calipers calipers) {
        this.repaint();
    }

    @Override
    public final void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.repaint();
    }

    public final @Nullable ProcessingElementReference getChannelDescriptor() {
        return this.channelDescriptor;
    }

    public @NonNull String getChannelLabel() {
        return this.label;
    }

    public final @NonNull IChartDataProvider getChart() {
        return this.mChartHandlePanel.getChart();
    }

    public final @Nullable Color getCoreColor() {
        if (this.colourIndex >= 0) {
            return Colors.getCoreColor(this.colourIndex);
        }
        if (this.colourIndex == -1) {
            return Colors.getDarkGray();
        }
        return null;
    }

    public ISeriesDataProvider getSeriesDataprovider() {
        return this.mseriesDataprovider;
    }

    public int getSeriesIndex() {
        return this.mseriesIndex;
    }

    @Override
    public final void imageWasLoaded(File file) {
        this.repaint();
    }

    public final void scaleChanged(Scales scales) {
        this.repaint();
    }

    public void setHeatmapZoomingFactor(int zoom) {
        this.heatmapZoomingFactor = zoom;
    }

    public void setSeriesIndex(int index) {
        this.mseriesIndex = index;
    }

    public final void setupAutoScroll(int x) {
        if (!this.mAutoScrollPending) {
            int amount = 0;
            if (this.isOverAutoScrollLeft(x)) {
                amount = -RulerPanel.getSlotWidth() * 5;
            } else if (this.isOverAutoScrollRight(x)) {
                amount = RulerPanel.getSlotWidth() * 5;
            }
            if (amount != 0) {
                this.mAutoScrollPending = true;
                int scroll = amount;
                Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.MILLISECONDS);
            }
        }
    }

    public final boolean shouldDrawSeriesValuesOnLeft() {
        CrossSectionMarker csm = this.getCaptureDataProvider().getCrossSectionMarker();
        long csmLeft = csm.getLeft();
        if (csmLeft >= 0L) {
            long csmRight = csm.getRight();
            long right = this.translateFromSlot(csmRight);
            boolean isRange = csm.isRange();
            long leftAtDensestScale = csm.getRangeLeftAtDensestScale();
            long rightAtDensestScale = csm.getRangeRightAtDensestScale() - 1L;
            if (isRange && csmLeft == csmRight) {
                right = this.translateFromSlot(csmLeft) + (long)RulerPanel.getSlotWidth();
            }
            return this.shouldDrawSeriesValuesOnLeft(right, leftAtDensestScale, rightAtDensestScale, isRange);
        }
        return false;
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1 && this.isFilmStrip() && this.showFullVisualAnnotation(where)) {
            this.setTracker(new VisualAnnotationTracker());
            return;
        }
        super.mouseDown(where, button, stateMask, count);
    }

    @Override
    protected final void paintSelf(GC gc) {
        boolean heatmapMode = this.getChart().isHeatMapLineEnabled();
        super.paintSelf(gc);
        this.updateThemeColors();
        this.drawBackground(gc);
        if (this.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
            this.drawVisualAnnotations(gc);
        } else {
            this.drawGraph(gc);
        }
        this.drawLogorithmicExponents(gc);
        this.drawCaliperEnds(gc);
        this.drawBookmarks(gc);
        this.drawCrossSectionMarker(gc);
        this.drawLimit(gc);
        this.drawCrossSectionMarkerSeriesValues(gc, heatmapMode);
        this.drawCursorMarker(gc, heatmapMode);
        this.drawVisualAnnotationText(gc);
    }

    @Override
    protected final void updateThemeColors() {
        super.updateThemeColors();
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mThemeLogarithmicLine = Colors.getWhite();
                this.mThemeValuesBackground = Colors.create(56, 56, 56);
                this.mThemeValuesForeground = Colors.getWhite();
                this.mSwapThemeValueColors = true;
                break;
            }
            case LIGHT: {
                this.mThemeLogarithmicLine = Colors.create(61, 56, 51);
                this.mThemeValuesBackground = Colors.create(204, 204, 230);
                this.mThemeValuesForeground = Colors.create(38, 38, 38);
                this.mSwapThemeValueColors = false;
            }
        }
    }

    @Override
    protected final void wasAdded(Block parent) {
        super.wasAdded(parent);
        ICaptureDataProvider dataProvider = this.getCaptureDataProvider();
        dataProvider.getScales().addListener((IScaleListener)this);
        dataProvider.getCrossSectionMarker().addListener(this);
        dataProvider.getCalipers().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        ChartPanel chartPanel = this;
        synchronized (chartPanel) {
            if (this.mThumbnailImageCache != null) {
                this.mThumbnailImageCache.dispose();
                this.mThumbnailImageCache = null;
            }
        }
        ICaptureDataProvider dataProvider = this.getCaptureDataProvider();
        dataProvider.getScales().removeListener((IScaleListener)this);
        dataProvider.getCrossSectionMarker().removeListener(this);
        dataProvider.getCalipers().removeListener(this);
    }

    private final void autoScroll(int amount) {
        this.mAutoScrollPending = false;
        int x = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).x;
        if (amount < 0 && this.isOverAutoScrollLeft(x) || amount > 0 && this.isOverAutoScrollRight(x)) {
            BaseTimelineContent content = this.getBaseTimelineContent();
            content.getDividerPanel().setPosition(content.getDividerPanel().getPosition() + (long)amount);
            DragTracker tracker = this.getTracker();
            if (tracker != null) {
                tracker.mouseDrag(new Point(x, 0), 0);
            }
        }
    }

    private final void createHeatMapPolygons(IChartDataProvider chart, long first, long last, TIntSet selection, int[][] seriesValues, GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int height = bounds.height - 2;
        int bottom = bounds.y + height;
        long firstForRequest = first >= 0L ? first : 0L;
        int slots = this.getCaptureDataProvider().getLastBinCount();
        SeriesComposition seriesComposition = chart.getSeriesComposition();
        boolean log10 = seriesComposition == SeriesComposition.LOG10;
        boolean percentage = chart.isPercentage();
        @NonNull ZoomLevel zoomLevel = this.mChartHandlePanel.getCaptureDataProvider().getScales().getZoomLevel();
        @NonNull SharedLimitCalculator.Result limitResult = this.limitCalculator.calculateHeatMap(chart, zoomLevel, (int)firstForRequest, (int)last, slots, selection);
        if (limitResult.updateLimit) {
            this.mLastLimit = limitResult.limit;
            this.mLimitIsDirty = false;
            this.updateLimit(gc, limitResult.limit);
        } else {
            this.mLimitIsDirty |= limitResult.mLimitIsDirty;
        }
        double limit = limitResult.limit;
        int channelIndex = 0;
        while (channelIndex < limitResult.perSeriesData.length) {
            double[] seriesData = limitResult.perSeriesData[channelIndex][this.mseriesIndex];
            int[] values = seriesValues[channelIndex];
            int index = 0;
            long i = first;
            while (i <= last) {
                if (i < (long)slots) {
                    double value;
                    if (i >= firstForRequest) {
                        value = seriesData[(int)(i - firstForRequest)];
                    } else {
                        double d = value = seriesData.length > 0 ? seriesData[0] : 0.0;
                    }
                    if (log10 && value > 0.0) {
                        value = Math.log10(percentage ? value * 10000.0 : value);
                    }
                    int y = value <= 0.0 ? bottom + 1 : bottom - (int)((double)height * value / limit);
                    values[index++] = (int)(this.translateFromSlot(i) + (long)(RulerPanel.getSlotWidth() / 2));
                    values[index++] = y;
                } else {
                    values[index++] = (int)(this.translateFromSlot(i - 1L) + (long)(RulerPanel.getSlotWidth() / 2));
                    values[index++] = bottom + 1;
                }
                ++i;
            }
            ++channelIndex;
        }
    }

    private final void createPolygons(IChartDataProvider chart, long first, long last, TIntSet selection, int[][] seriesValues, int[] heights, GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int height = bounds.height - 2;
        int bottom = bounds.y + height;
        int range = (int)(1L + last - first);
        long firstForRequest = first >= 0L ? first : 0L;
        int slots = this.getCaptureDataProvider().getLastBinCount();
        double[] lastData = new double[range];
        SeriesComposition seriesComposition = chart.getSeriesComposition();
        GraphRenderingType renderingType = chart.getRenderingType();
        boolean stacked = seriesComposition == SeriesComposition.STACKED;
        boolean log10 = seriesComposition == SeriesComposition.LOG10;
        boolean filled = renderingType == GraphRenderingType.FILLED;
        boolean percentage = chart.isPercentage();
        boolean isOpen = this.mChartHandlePanel.isOpen();
        @NonNull ZoomLevel zoomLevel = this.mChartHandlePanel.getCaptureDataProvider().getScales().getZoomLevel();
        @NonNull SharedLimitCalculator.Result limitResult = this.limitCalculator.calculateNormal(isOpen, chart, zoomLevel, (int)firstForRequest, (int)last, slots, selection);
        if (limitResult.updateLimit) {
            this.mLastLimit = limitResult.limit;
            this.mLimitIsDirty = false;
            this.updateLimit(gc, limitResult.limit);
        } else {
            this.mLimitIsDirty |= limitResult.mLimitIsDirty;
        }
        double limit = limitResult.limit;
        @NonNull List<ISeriesDataProvider> seriesList = limitResult.seriesList;
        int count = seriesList.size();
        int channelIndex = limitResult.getTargetChannelIndex(this.channelDescriptor);
        int seriesIndex = count;
        while (--seriesIndex >= 0) {
            if (log10 && percentage) {
                limit = Math.log10(10000.0);
            }
            int[] values = seriesValues[seriesIndex];
            int index = 0;
            heights[seriesIndex] = bottom;
            double[] data = limitResult.getPerSeriesData(channelIndex, seriesIndex);
            long i = first;
            while (i <= last) {
                if (i < (long)slots) {
                    int y;
                    double value;
                    if (i >= firstForRequest) {
                        value = data[(int)(i - firstForRequest)];
                    } else {
                        double d = value = data.length > 0 ? data[0] : 0.0;
                    }
                    if (log10 && value > 0.0) {
                        value = Math.log10(percentage ? value * 10000.0 : value);
                    }
                    if (stacked) {
                        lastData[(int)(i - first)] = value += lastData[(int)(i - first)];
                    }
                    int n = y = value <= 0.0 ? bottom + 1 : bottom - (int)((double)height * value / limit);
                    if (y < heights[seriesIndex]) {
                        heights[seriesIndex] = y;
                    }
                    values[index++] = (int)(this.translateFromSlot(i) + (long)(RulerPanel.getSlotWidth() / 2));
                    values[index++] = y;
                } else {
                    values[index++] = (int)(this.translateFromSlot(i - 1L) + (long)(RulerPanel.getSlotWidth() / 2));
                    values[index++] = bottom + 1;
                }
                ++i;
            }
            if (!filled) continue;
            values[index++] = (int)this.translateFromSlot(last);
            values[index++] = bottom + 1;
            values[index++] = bounds.x - RulerPanel.getSlotWidth();
            values[index++] = bottom + 1;
        }
    }

    private ScaledFormat determineFormat(long leftSlotAtDensestLevel, long rightSlotAtDensestLevel, double[] values) {
        IChartDataProvider chart = this.getChart();
        TIntSet selectedIds = this.getSelectedIds();
        boolean isPercentage = this.getChart().isPercentage();
        int count = chart.getSeries().size();
        ScaledFormat chosenFormat = null;
        int i = 0;
        while (i < count) {
            @Nullable ProcessingElementReference channelDescriptor = this.channelDescriptor;
            ISeriesDataProvider series = chart.getSeries().get(i);
            values[i] = channelDescriptor == null ? series.getAggregateValueOfRangeFromDensestLevel((int)leftSlotAtDensestLevel, (int)rightSlotAtDensestLevel, selectedIds) : series.getCoreValueOfRangeFromDensestLevel(channelDescriptor, (int)leftSlotAtDensestLevel, (int)rightSlotAtDensestLevel, selectedIds);
            ScaledFormat format = ScaledFormat.getBestFormat(values[i], isPercentage, -1, series.getConfig().getUnits());
            chosenFormat = chosenFormat != null ? format.mergeWith(chosenFormat) : format;
            ++i;
        }
        return chosenFormat != null ? chosenFormat : ScaledFormat.getBestFormat(1.0, isPercentage, -1, null);
    }

    private final void drawBackground(GC gc) {
        if (this.isFilmStrip()) {
            this.drawFilmStripBackground(gc);
        } else {
            this.drawBackgroundWithVerticalGroupingMarkers(gc, true);
        }
    }

    private final void drawBarChart(GC gc, int[][] seriesValues, boolean desaturate) {
        IChartDataProvider chart = this.getChart();
        int count = chart.getSeries().size();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        if (count > 0) {
            Rectangle bounds = this.getLocalBounds();
            StreamlineTheme theme = StreamlinePreferences.getTheme();
            int height = bounds.height;
            int width = RulerPanel.getSlotWidth() - 1;
            int i = 0;
            while (i < count) {
                RGB baseColor = chart.getSeries().get(i).getConfig().getColor();
                if (desaturate) {
                    baseColor = theme.desaturate(baseColor);
                }
                int bottom = bounds.y + height - 1;
                int valueCount = seriesValues[0].length;
                int j = 0;
                while (j < valueCount) {
                    int[] values = seriesValues[i];
                    gc.setBackground(Colors.darken(baseColor, 30));
                    int y = values[j + 1];
                    int x = values[j] + 1 - RulerPanel.getSlotWidth() / 2;
                    int barHeight = (i == count - 1 ? bottom : seriesValues[i + 1][j + 1]) + 1 - y;
                    gc.fillRectangle(x, y, width, barHeight);
                    j += 2;
                }
                ++i;
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawCrossSectionMarkerSeriesValues(GC gc, boolean heatmapMode) {
        CrossSectionMarker csm;
        long csmLeft;
        if (!this.shouldHideData() && (csmLeft = (csm = this.getCaptureDataProvider().getCrossSectionMarker()).getLeft()) >= 0L) {
            long csmRight = csm.getRight();
            long left = this.translateFromSlot(csmLeft);
            long right = this.translateFromSlot(csmRight);
            boolean isRange = csm.isRange();
            long leftAtDensestScale = csm.getRangeLeftAtDensestScale();
            long rightAtDensestScale = csm.getRangeRightAtDensestScale() - 1L;
            if (isRange && csmLeft == csmRight) {
                right = left + (long)RulerPanel.getSlotWidth();
            }
            this.drawSeriesValues(gc, heatmapMode, left, right, leftAtDensestScale, rightAtDensestScale, isRange, this.mChartHandlePanel.getChartsPanel().shouldDrawSeriesValuesOnLeft());
        }
    }

    private final void drawCursorMarker(GC gc, boolean heatmapMode) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION && !this.shouldHideData()) {
            this.updatePositionReadout();
            long lastMouseSlot = this.getLastMouseSlot();
            if (lastMouseSlot != -1000L) {
                Rectangle bounds = this.getLocalBounds();
                long x = this.translateFromSlot(lastMouseSlot) + (long)(RulerPanel.getSlotWidth() / 2);
                if (x + 2L >= (long)bounds.x && x - 1L < (long)(bounds.x + bounds.width)) {
                    int xx = (int)x;
                    int savedAA = gc.getAntialias();
                    gc.setAntialias(0);
                    gc.setAlpha(102);
                    gc.setForeground(Colors.getWhite());
                    gc.drawLine(xx, bounds.y, xx, bounds.y + bounds.height - 1);
                    gc.setForeground(Colors.getBlack());
                    gc.drawLine(--xx, bounds.y, xx, bounds.y + bounds.height - 1);
                    gc.drawLine(xx += 2, bounds.y, xx, bounds.y + bounds.height - 1);
                    gc.setAlpha(255);
                    gc.setAntialias(savedAA);
                }
                x = this.getMouseX() / RulerPanel.getSlotWidth();
                x *= (long)RulerPanel.getSlotWidth();
                Scales scales = this.getCaptureDataProvider().getScales();
                @NonNull ZoomLevel zoomLevel = scales.getZoomLevel();
                @NonNull ZoomLevel densestZoomLevel = scales.getDensestZoomLevel();
                long leftSlotAtDensestLevel = Position.scale((long)lastMouseSlot, (ZoomLevel)zoomLevel, (ZoomLevel)densestZoomLevel);
                long rightSlotAtDensestLevel = Position.scale((long)(lastMouseSlot + 1L), (ZoomLevel)zoomLevel, (ZoomLevel)densestZoomLevel) - 1L;
                this.drawSeriesValues(gc, heatmapMode, x, x, leftSlotAtDensestLevel, rightSlotAtDensestLevel, false, this.shouldDrawSeriesValuesOnLeft(x, leftSlotAtDensestLevel, rightSlotAtDensestLevel, false));
            }
        }
    }

    private final void drawFillChart(GC gc, int[][] seriesValues, int[] heights, boolean desaturate) {
        IChartDataProvider chart = this.getChart();
        int count = chart.getSeries().size();
        Rectangle bounds = this.getLocalBounds();
        int left = bounds.x;
        int bottom = bounds.y + bounds.height - 1;
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        long last = this.getLastVisibleSlot() + 1L;
        long lastBinCount = this.getCaptureDataProvider().getLastBinCount();
        int trim = last > lastBinCount ? (int)(1L + last - lastBinCount) : 0;
        int i = 0;
        while (i < count) {
            Color c2;
            Color c1;
            RGB baseColor = chart.getSeries().get(i).getConfig().getColor();
            if (desaturate) {
                baseColor = theme.desaturate(baseColor);
            }
            if (theme == StreamlineTheme.DARK || !desaturate) {
                c1 = Colors.darken(baseColor, 10);
                c2 = Colors.darken(baseColor, 35);
            } else {
                c1 = Colors.darken(baseColor, 5);
                c2 = Colors.darken(baseColor, 15);
            }
            Pattern pattern = new Pattern(gc.getDevice(), (float)left, (float)heights[i], (float)left, (float)bottom, c1, 255, c2, 255);
            gc.setBackgroundPattern(pattern);
            int[] values = seriesValues[i];
            if (trim > 0) {
                int n = values.length - (trim * 2 + 6);
                values[n] = values[n] + RulerPanel.getSlotWidth() / 2;
                int n2 = values.length - (trim * 2 + 4);
                values[n2] = values[n2] + RulerPanel.getSlotWidth() / 2;
            }
            gc.fillPolygon(values);
            pattern.dispose();
            gc.setForeground(Colors.create(baseColor));
            gc.drawPolygon(values);
            if (trim > 0) {
                int n = values.length - (trim * 2 + 6);
                values[n] = values[n] - RulerPanel.getSlotWidth() / 2;
                int n3 = values.length - (trim * 2 + 4);
                values[n3] = values[n3] - RulerPanel.getSlotWidth() / 2;
            }
            ++i;
        }
        gc.setAntialias(savedAA);
    }

    private final void drawFilmStripBackground(GC gc) {
        List<VisualAnnotation> annotations;
        int count;
        Rectangle bounds = this.getLocalBounds();
        gc.setBackground(this.getThemeBackground());
        gc.fillRectangle(bounds);
        gc.setForeground(this.getThemeBorder());
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int top = bounds.y;
        int bottom = top + bounds.height - 1;
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        this.mSlotData.clear();
        if (StreamlinePreferences.getTheme() == StreamlineTheme.LIGHT) {
            gc.setBackground(DARK_BACKGROUND);
            gc.fillRectangle(bounds.x, bounds.y + 4, bounds.width, bounds.height - 8);
        }
        Image image = StreamlinePlugin.getImage("VisualAnnotationBlank.png");
        int imgWidth = image.getBounds().width;
        int slotsPerImage = (imgWidth + 2) / RulerPanel.getSlotWidth();
        long firstForImage = first - first % (long)slotsPerImage;
        top += 4;
        long i = firstForImage;
        while (i <= last) {
            long x = this.translateFromSlot(i) + 1L;
            if (x + (long)imgWidth >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                gc.drawImage(image, (int)x, top);
            }
            i += (long)slotsPerImage;
        }
        @NonNull ZoomLevel zoomLevel = this.getCaptureDataProvider().getScales().getZoomLevel();
        @Nullable VisualAnnotationData visualAnnotationData = this.getChart().getVisualAnnotationData();
        if (visualAnnotationData != null && (count = (annotations = visualAnnotationData.getAnnotations()).size()) > 0) {
            top -= 4;
            bottom -= 3;
            long i2 = first;
            while (i2 < last) {
                VisualAnnotation annotation;
                int index = ITimeStampedData.binarySearch(annotations, (long)Position.scale((long)i2, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
                if (index < 0) {
                    index = -index - 1;
                }
                if (index < count && i2 == Position.scale((long)(annotation = annotations.get(index)).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) {
                    int width;
                    long x = this.translateFromSlot(i2) + 1L;
                    if (x + (long)(width = RulerPanel.getSlotWidth() - 2) >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                        gc.setBackground(annotation.getText() != null ? THEME_VISUAL_ANNOTATION_WITH_TEXT_MARKER : THEME_VISUAL_ANNOTATION_MARKER);
                        gc.fillRectangle((int)x, top, width, 4);
                        gc.fillRectangle((int)x, bottom, width, 4);
                    }
                    int total = 1;
                    while (++index < count) {
                        VisualAnnotation another = annotations.get(index);
                        if (i2 != Position.scale((long)another.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) break;
                        ++total;
                    }
                    this.mSlotData.put(i2, (Object)new SlotData(annotation, total));
                    if (total > 1 && ++x + (long)(width = RulerPanel.getSlotWidth() - 4) >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                        gc.setBackground(Colors.getDarkGray());
                        gc.fillRectangle((int)x, top + 1, width, 2);
                        gc.fillRectangle((int)x, bottom + 1, width, 2);
                    }
                }
                ++i2;
            }
        }
        gc.setAntialias(savedAA);
    }

    private final void drawGraph(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        IChartDataProvider chart = this.getChart();
        if (this.shouldHideData()) {
            gc.setForeground(Colors.isDark(this.getThemeBackground()) ? Colors.getWhite() : Colors.getBlack());
            TextDrawing.drawText(gc, ChartMessages.HIDDEN, bounds.x, bounds.y, bounds.width, bounds.height, 0x1000000, 0x1000000);
            return;
        }
        GraphRenderingType renderingType = chart.getRenderingType();
        boolean filled = renderingType == GraphRenderingType.FILLED;
        long first = this.getFirstVisibleSlot() - 1L;
        long last = this.getLastVisibleSlot() + 1L;
        int count = this.getChart().isHeatMapLineEnabled() ? chart.getCoreInformationProvider().getChannelCount() : chart.getSeries().size();
        int range = (int)(1L + last - first);
        TIntSet selectedIds = this.getSelectedIds();
        if (selectedIds != null) {
            this.preflightData(chart, first, last, selectedIds);
        }
        int[][] seriesValues = new int[count][range * 2 + (filled ? 4 : 0)];
        int[] heights = new int[count];
        if (!this.getChart().isHeatMapLineEnabled()) {
            this.createPolygons(chart, first, last, selectedIds, seriesValues, heights, gc);
        } else {
            this.createHeatMapPolygons(chart, first, last, selectedIds, seriesValues, gc);
        }
        Rectangle clip = gc.getClipping();
        Calipers calipers = this.getCaptureDataProvider().getCalipers();
        long left = calipers.getLeft();
        long right = calipers.getRight();
        if (left > first && left <= last || right < last && right >= first) {
            int x1 = (int)this.translateFromSlot(left > first ? left : first);
            int x2 = (int)this.translateFromSlot(right < last ? right : last);
            gc.setClipping(clip.intersection(new Rectangle(x1, bounds.y, x2 - x1, bounds.height)));
        }
        this.drawGraph(gc, seriesValues, heights, false);
        if (left > Math.max(first, 0L)) {
            gc.setClipping(Geometry.intersect(clip, bounds.x, bounds.y, Math.min(this.translateFromSlot(left) - (long)bounds.x, (long)bounds.width), bounds.height));
            this.drawGraph(gc, seriesValues, heights, true);
        }
        if (right < last) {
            right = this.translateFromSlot(right);
            gc.setClipping(Geometry.intersect(clip, right, bounds.y, (long)bounds.width - right, bounds.height));
            this.drawGraph(gc, seriesValues, heights, true);
        }
        gc.setClipping(clip);
        gc.setForeground(this.getThemeBorder());
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int bottom = bounds.y + bounds.height - 1;
        gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        gc.setAntialias(savedAA);
    }

    private final void drawGraph(GC gc, int[][] seriesValues, int[] heights, boolean desaturate) {
        switch (this.getChart().getRenderingType()) {
            case BAR: {
                this.drawBarChart(gc, seriesValues, desaturate);
                break;
            }
            default: {
                this.drawFillChart(gc, seriesValues, heights, desaturate);
                break;
            }
            case HEATMAP: {
                this.drawHeatMapLines(gc, seriesValues, desaturate);
                break;
            }
            case LINE: {
                this.drawLineChart(gc, seriesValues, desaturate);
            }
        }
    }

    private final void drawHeatMapLines(GC gc, int[][] seriesValues, boolean desaturate) {
        IChartDataProvider chart = this.getChart();
        int width = RulerPanel.getSlotWidth() - 1;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        long last = this.getLastVisibleSlot();
        long lastBinCount = this.getCaptureDataProvider().getLastBinCount();
        int trim = last > lastBinCount ? (int)(last + 1L - lastBinCount) : 0;
        int blockHeight = Math.max(this.heatmapZoomingFactor, HEATMAPLINE_MIN_BLOCK_HEIGHT);
        int blockOffset = (blockHeight + 1) / 2;
        gc.setLineWidth(blockHeight);
        int totalHeight = this.getHeight();
        int channelCount = chart.getCoreInformationProvider().getChannelCount();
        double nextBlockGap = Math.max((double)(totalHeight - (channelCount - 1) * 2) / (double)channelCount, (double)blockHeight) + 2.0;
        int y_pos = blockOffset;
        int coreIndex = 0;
        while (coreIndex < channelCount) {
            int[] values = seriesValues[coreIndex];
            if (trim > 0) {
                int[] line = new int[values.length - trim * 2];
                System.arraycopy(values, 0, line, 0, line.length);
                int n = line.length - 2;
                line[n] = line[n] + RulerPanel.getSlotWidth() / 2;
                values = line;
            }
            boolean filled = chart.getRenderingType() == GraphRenderingType.FILLED;
            int extra = filled ? 4 : 2;
            int valueCount = values.length - extra;
            int next_y_pos = (int)((double)(coreIndex + 1) * nextBlockGap) + blockOffset;
            int j = 0;
            while (j < valueCount) {
                int pos_x = values[j] + 1 - RulerPanel.getSlotWidth() / 2;
                int y = values[j + 1];
                double percentage = 100 * y / totalHeight;
                gc.setForeground(this.getHeatMapColorMapping(percentage, desaturate));
                gc.drawLine(pos_x, y_pos, pos_x + width, y_pos);
                j += 2;
            }
            y_pos = next_y_pos;
            ++coreIndex;
        }
        gc.setLineWidth(1);
        gc.setAntialias(savedAA);
    }

    private final void drawHeatmapSeriesValues(GC gc, long leftEdge, long rightEdge, long leftSlotAtDensestLevel, long rightSlotAtDensestLevel, boolean isRange, boolean drawOnLeft) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            long x;
            Rectangle bounds = this.getLocalBounds();
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            @NonNull ISeriesDataProvider series = chart.getSeries().get(this.mseriesIndex);
            @NonNull IChartDataProvider.IChartCoreInformationProvider chartCoreInfoProvider = chart.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channelDescriptors = chartCoreInfoProvider.getChannelDescriptors();
            int channelCount = channelDescriptors.length;
            String[] text = new String[channelCount];
            int[] widths = new int[channelCount];
            int width = 0;
            gc.setFont(FONT_TOOLTIP);
            boolean average = isRange && chart.isAverageSelection();
            double[] values = new double[channelCount];
            TIntSet selectedIds = this.getSelectedIds();
            boolean isPercentage = this.getChart().isPercentage();
            ScaledFormat chosenFormat = null;
            int i = 0;
            while (i < channelCount) {
                values[i] = series.getCoreValueOfRangeFromDensestLevel(channelDescriptors[i], (int)leftSlotAtDensestLevel, (int)rightSlotAtDensestLevel, selectedIds);
                ScaledFormat format = ScaledFormat.getBestFormat(values[i], isPercentage, -1, series.getConfig().getUnits());
                chosenFormat = chosenFormat != null ? format.mergeWith(chosenFormat) : format;
                ++i;
            }
            if (chosenFormat == null) {
                chosenFormat = ScaledFormat.getBestFormat(1.0, isPercentage, -1, null);
            }
            i = 0;
            while (i < channelCount) {
                text[i] = chosenFormat.format(values[i], series.getConfig().getUnits());
                if (average && series.isAverageSelectionPossible()) {
                    int n = i;
                    text[n] = String.valueOf(text[n]) + AVERAGE;
                }
                widths[i] = gc.stringExtent((String)text[i]).x;
                if (width < widths[i]) {
                    width = widths[i];
                }
                ++i;
            }
            int height = bounds.height;
            int blockHeight = Math.max(this.heatmapZoomingFactor, HEATMAPLINE_MIN_BLOCK_HEIGHT);
            double nextBlockGap = Math.max((double)(height - (channelCount - 1) * 2) / (double)channelCount, (double)blockHeight) + 2.0;
            int offset = (blockHeight - FONT_TOOLTIP_HEIGHT) / 2;
            int y = offset + 1;
            width += 8;
            if (drawOnLeft) {
                x = leftEdge - (long)(8 + width);
                if (x < (long)bounds.x) {
                    x = bounds.x;
                }
            } else {
                x = rightEdge + 8L;
            }
            gc.setAntialias(1);
            gc.setBackground(this.mSwapThemeValueColors ? this.mThemeValuesForeground : this.mThemeValuesBackground);
            gc.setAlpha(204);
            gc.fillRoundRectangle((int)x, 0, width, height, 8, 8);
            gc.setForeground(this.mSwapThemeValueColors ? this.mThemeValuesBackground : this.mThemeValuesForeground);
            gc.setAlpha(59);
            gc.drawRoundRectangle((int)x, 0, width, height, 8, 8);
            gc.setAlpha(255);
            int right = (int)x + width - 4;
            x += 4L;
            int i2 = 0;
            while (i2 < channelCount) {
                gc.setForeground(this.mSwapThemeValueColors ? this.mThemeValuesBackground : this.mThemeValuesForeground);
                TextDrawing.drawString(gc, text[i2], right, y, 131072);
                y = (int)((double)(i2 + 1) * nextBlockGap) + offset + 1;
                ++i2;
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawLimit(GC gc) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(1);
            Rectangle bounds = this.getLocalBounds();
            bounds.x += 4;
            bounds.y += 4;
            double plateau = this.mLimitIsDirty ? SharedLimitCalculator.getPlateau(chart, this.mChartHandlePanel.isOpen(), false) : this.mLastLimit;
            String limit = ScaledFormat.format(plateau, chart.isPercentage(), 0, chart.getUnits());
            gc.setFont(FONT_TOOLTIP);
            TextDrawingState state = new TextDrawingState(gc);
            Point extent = gc.textExtent(limit);
            state.restore();
            bounds.width = 8 + extent.x;
            bounds.height = 4 + extent.y;
            gc.setAlpha(128);
            gc.setBackground(this.mThemeValuesBackground);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 8, 8);
            gc.setAntialias(savedAA);
            gc.setAlpha(255);
            gc.setForeground(this.mThemeValuesForeground);
            TextDrawing.drawString(gc, limit, bounds.x + 4, bounds.y + 2);
        }
    }

    private final void drawLineChart(GC gc, int[][] seriesValues, boolean desaturate) {
        IChartDataProvider chart = this.getChart();
        int count = chart.getSeries().size();
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        gc.setLineWidth(2);
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        long last = this.getLastVisibleSlot() + 1L;
        long lastBinCount = this.getCaptureDataProvider().getLastBinCount();
        int trim = last > lastBinCount ? (int)(1L + last - lastBinCount) : 0;
        int seriesIndex = 0;
        while (seriesIndex < count) {
            int i;
            RGB baseColor = chart.getSeries().get(seriesIndex).getConfig().getColor();
            if (desaturate) {
                baseColor = theme.desaturate(baseColor);
            }
            gc.setForeground(Colors.create(baseColor));
            int[] values = seriesValues[seriesIndex];
            if (trim > 0 && (i = values.length - trim * 2) >= 2) {
                int[] line = new int[i];
                System.arraycopy(values, 0, line, 0, line.length);
                int n = line.length - 2;
                line[n] = line[n] + RulerPanel.getSlotWidth() / 2;
                values = line;
            }
            gc.drawPolyline(values);
            ++seriesIndex;
        }
        gc.setLineWidth(1);
        gc.setAntialias(savedAA);
    }

    private final void drawLogorithmicExponents(GC gc) {
        @NonNull IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() == SeriesComposition.LOG10) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            gc.setAlpha(26);
            gc.setForeground(this.mThemeLogarithmicLine);
            Rectangle bounds = this.getLocalBounds();
            int x1 = bounds.x;
            int x2 = x1 + bounds.width - 1;
            double max = Math.ceil(SharedLimitCalculator.getPlateau(chart, this.mChartHandlePanel.isOpen(), true));
            int bottom = bounds.y + bounds.height;
            int i = (int)max;
            while (i >= 1) {
                int y = bottom - (int)((double)bounds.height * Math.log10(Math.pow(10.0, i)) / max);
                gc.drawLine(x1, y, x2, y);
                --i;
            }
            gc.setAlpha(255);
            gc.setAntialias(savedAA);
        }
    }

    private final void drawNormalSeriesValues(GC gc, long leftEdge, long rightEdge, long leftSlotAtDensestLevel, long rightSlotAtDensestLevel, boolean isRange, boolean drawOnLeft) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            long x;
            Rectangle bounds = this.getLocalBounds();
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            int seriesCount = chart.getSeries().size();
            String[] text = new String[seriesCount];
            int[] widths = new int[seriesCount];
            int width = 0;
            gc.setFont(FONT_TOOLTIP);
            boolean average = isRange && chart.isAverageSelection();
            double[] values = new double[seriesCount];
            ScaledFormat chosenFormat = this.determineFormat(leftSlotAtDensestLevel, rightSlotAtDensestLevel, values);
            int i = 0;
            while (i < seriesCount) {
                ISeriesDataProvider series = chart.getSeries().get(i);
                text[i] = chosenFormat.format(values[i], series.getConfig().getUnits());
                if (average && series.isAverageSelectionPossible()) {
                    int n = i;
                    text[n] = String.valueOf(text[n]) + AVERAGE;
                }
                widths[i] = gc.stringExtent((String)text[i]).x;
                if (width < widths[i]) {
                    width = widths[i];
                }
                ++i;
            }
            int height = 4 + seriesCount * FONT_TOOLTIP_HEIGHT;
            width += 20;
            if (drawOnLeft) {
                x = leftEdge - (long)(8 + width);
                if (x < (long)bounds.x) {
                    x = bounds.x;
                }
            } else {
                x = rightEdge + 8L;
            }
            int y = bounds.y + (bounds.height - height) / 2;
            gc.setAntialias(1);
            gc.setBackground(this.mSwapThemeValueColors ? this.mThemeValuesForeground : this.mThemeValuesBackground);
            gc.setAlpha(204);
            gc.fillRoundRectangle((int)x, y, width, height, 8, 8);
            gc.setForeground(this.mSwapThemeValueColors ? this.mThemeValuesBackground : this.mThemeValuesForeground);
            gc.setAlpha(59);
            gc.drawRoundRectangle((int)x, y, width, height, 8, 8);
            gc.setAlpha(255);
            int right = (int)x + width - 4;
            x += 4L;
            y += 2;
            int i2 = 0;
            while (i2 < seriesCount) {
                gc.setBackground(Colors.create(chart.getSeries().get(i2).getConfig().getColor()));
                gc.fillOval((int)x, y + (FONT_TOOLTIP_HEIGHT - 8) / 2, 8, 8);
                gc.setForeground(Colors.getMarker());
                gc.drawOval((int)x, y + (FONT_TOOLTIP_HEIGHT - 8) / 2, 8, 8);
                gc.setForeground(this.mSwapThemeValueColors ? this.mThemeValuesBackground : this.mThemeValuesForeground);
                TextDrawing.drawString(gc, text[i2], right, y, 131072);
                y += FONT_TOOLTIP_HEIGHT;
                ++i2;
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawSeriesValues(GC gc, boolean heatmapMode, long leftEdge, long rightEdge, long leftSlotAtDensestLevel, long rightSlotAtDensestLevel, boolean isRange, boolean drawOnLeft) {
        if (heatmapMode) {
            this.drawHeatmapSeriesValues(gc, leftEdge, rightEdge, leftSlotAtDensestLevel, rightSlotAtDensestLevel, isRange, drawOnLeft);
        } else {
            this.drawNormalSeriesValues(gc, leftEdge, rightEdge, leftSlotAtDensestLevel, rightSlotAtDensestLevel, isRange, drawOnLeft);
        }
    }

    private final void drawVisualAnnotations(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        if (cdp.isLive()) {
            gc.setFont(Fonts.getNormalStandout());
            gc.setForeground(Colors.getWhite());
            TextDrawing.drawText(gc, ChartMessages.VISUAL_ANNOTATION_NOT_VISIBLE_IN_LIVE, bounds.x + bounds.width / 2, bounds.y + (bounds.height - gc.textExtent((String)ChartMessages.VISUAL_ANNOTATION_NOT_VISIBLE_IN_LIVE).y) / 2, 0x1000000, true);
        } else {
            Rectangle clip = gc.getClipping();
            Calipers calipers = cdp.getCalipers();
            long left = calipers.getLeft();
            long right = calipers.getRight();
            long first = this.getFirstVisibleSlot() - 1L;
            long last = this.getLastVisibleSlot() + 1L;
            if (left > first && left <= last || right < last && right >= first) {
                long x1 = this.translateFromSlot(left > first ? left : first);
                long x2 = this.translateFromSlot(right < last ? right : last);
                gc.setClipping(Geometry.intersect(clip, x1, bounds.y, x2 - x1, bounds.height));
            }
            this.drawVisualAnnotations(gc, first, last, false);
            if (left > first) {
                gc.setClipping(Geometry.intersect(clip, bounds.x, bounds.y, Math.min(this.translateFromSlot(left) - (long)bounds.x, (long)bounds.width), bounds.height));
                this.drawVisualAnnotations(gc, first, left, true);
            }
            if (right < last) {
                long x = this.translateFromSlot(right);
                gc.setClipping(Geometry.intersect(clip, x, bounds.y, (long)bounds.width - x, bounds.height));
                this.drawVisualAnnotations(gc, right, last, true);
            }
            gc.setClipping(clip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawVisualAnnotations(GC gc, long first, long last, boolean desaturate) {
        List<VisualAnnotation> annotations;
        int count;
        @NonNull ZoomLevel zoomLevel = this.getCaptureDataProvider().getScales().getZoomLevel();
        VisualAnnotationData visualAnnotationData = this.getChart().getVisualAnnotationData();
        if (visualAnnotationData != null && (count = (annotations = visualAnnotationData.getAnnotations()).size()) > 0) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            Rectangle bounds = this.getLocalBounds();
            int top = bounds.y;
            int slotsPerImage = (StreamlineUIUtils.getAnnotationBlankImageWidth() + 2) / RulerPanel.getSlotWidth();
            long firstForImage = first - first % (long)slotsPerImage;
            top += 4;
            ImageCache imageCache = null;
            long i = firstForImage;
            while (i <= last) {
                Object next;
                boolean overImageBlock;
                int index = ITimeStampedData.binarySearch(annotations, (long)Position.scale((long)i, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
                if (index < 0) {
                    index = -index - 1;
                }
                VisualAnnotation annotation = null;
                long annotationIndex = -1L;
                long lastMouseSlot = this.getLastMouseSlot();
                boolean bl = overImageBlock = lastMouseSlot != -1000L && lastMouseSlot >= i && lastMouseSlot < i + (long)slotsPerImage;
                if (overImageBlock) {
                    int j = index;
                    while (j < count) {
                        next = annotations.get(j);
                        long nextIndex = Position.scale((long)((VisualAnnotation)next).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                        if (nextIndex > lastMouseSlot) break;
                        annotation = next;
                        annotationIndex = nextIndex;
                        ++j;
                    }
                }
                if (annotation == null && index < count) {
                    annotation = annotations.get(index);
                    annotationIndex = Position.scale((long)annotation.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                }
                if (annotation != null && annotationIndex >= i && annotationIndex < i + (long)slotsPerImage) {
                    int width;
                    File file = new File(((VisualAnnotationData)NullChecking.neverNull((Object)visualAnnotationData)).getThumbnailDir(), FilePath.enforceExtension((String)annotation.getFilename(), (String)".png", (boolean)true));
                    if (imageCache == null) {
                        next = this;
                        synchronized (next) {
                            if (this.mThumbnailImageCache == null) {
                                this.mThumbnailImageCache = new ImageCache(40, this);
                            }
                            imageCache = this.mThumbnailImageCache;
                        }
                    }
                    Image image = imageCache.get(file, overImageBlock);
                    long x = this.translateFromSlot(i) + 1L;
                    if (x + (long)(width = image.getBounds().width) >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                        if (desaturate) {
                            image = new Image(gc.getDevice(), image, 2);
                        }
                        gc.drawImage(image, (int)x, top);
                        if (desaturate) {
                            image.dispose();
                            int bottom = bounds.y + bounds.height - 4;
                            gc.setAlpha(128);
                            gc.setForeground(Colors.getBlack());
                            int y = top;
                            while (y < bottom) {
                                gc.drawLine((int)x, y, (int)x + StreamlineUIUtils.getAnnotationBlankImageWidth() - 1, y);
                                y += 2;
                            }
                            gc.setAlpha(255);
                        }
                    }
                    if (overImageBlock && (x = this.translateFromSlot(annotationIndex) + 1L) + (long)(width = RulerPanel.getSlotWidth() - 2) >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                        gc.setBackground(Colors.getRed());
                        gc.fillRectangle((int)x, bounds.y, width, 4);
                        gc.fillRectangle((int)x, bounds.y + bounds.height - 1 - 3, width, 4);
                    }
                }
                i += (long)slotsPerImage;
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawVisualAnnotationText(GC gc) {
        long lastMouseSlot = this.getLastMouseSlot();
        SlotData slotData = (SlotData)this.mSlotData.get(lastMouseSlot);
        if (slotData != null) {
            VisualAnnotation annotation = slotData.mTopAnnotation;
            Rectangle bounds = this.getLocalBounds();
            int mouseY = this.getMouseY();
            if (annotation != null && (mouseY <= bounds.y + 8 || mouseY > bounds.y + bounds.height - 8)) {
                String more;
                int textHeight;
                TimeUnit timeUnit = this.mChartHandlePanel.getCaptureDataProvider().getTimeUnit();
                String timestamp = timeUnit.formatInBaseSymbolUnits(annotation.getTimestamp());
                TextDrawingState state = new TextDrawingState(gc);
                String text = annotation.getText();
                gc.setFont(FONT_TOOLTIP);
                Point timestampExtent = gc.stringExtent(timestamp);
                int width = timestampExtent.x;
                int height = timestampExtent.y;
                if (text != null) {
                    Point textExtent = gc.textExtent(text);
                    if (width < textExtent.x) {
                        width = textExtent.x;
                    }
                    textHeight = textExtent.y;
                    height += textHeight;
                } else {
                    textHeight = 0;
                }
                int total = slotData.mTotalAnnotations;
                if (total > 1) {
                    more = String.format(ChartMessages.MORE, total - 1);
                    Point moreExtent = gc.textExtent(more);
                    if (width < moreExtent.x) {
                        width = moreExtent.x;
                    }
                    height += moreExtent.y;
                } else {
                    more = null;
                }
                state.restore();
                int top = mouseY > bounds.y + bounds.height / 2 ? bounds.y + bounds.height - (4 + (height += 4)) : bounds.y + 4;
                long x = this.translateFromSlot(lastMouseSlot) + (long)(RulerPanel.getSlotWidth() / 2);
                int right = bounds.x + bounds.width;
                if ((x -= (long)((width += 8) / 2)) + (long)width >= (long)bounds.x && x < (long)right) {
                    int xx = (int)x;
                    if (xx < bounds.x) {
                        xx = bounds.x;
                    } else if (xx + width > right) {
                        xx = right - width;
                    }
                    gc.setBackground(Colors.getInfoBackground());
                    gc.fillRectangle(xx, top, width, height);
                    int y = top + 2;
                    int left = xx + 4;
                    Color textBlueColor = Colors.isDark(Colors.getInfoBackground()) ? Colors.getCyan() : Colors.getDarkBlue();
                    gc.setForeground(textBlueColor);
                    TextDrawing.drawString(gc, timestamp, left, y);
                    y += timestampExtent.y;
                    if (text != null) {
                        gc.setForeground(Colors.getInfoForeground());
                        TextDrawing.drawString(gc, text, left, y);
                        y += textHeight;
                    }
                    if (more != null) {
                        gc.setForeground(textBlueColor);
                        TextDrawing.drawString(gc, more, left, y);
                    }
                    gc.setForeground(Colors.getDivider());
                    gc.drawRectangle(xx, top, width - 1, height - 1);
                }
            }
        }
    }

    private final List<FilmStrip> getFilmStrips() {
        ArrayList<FilmStrip> list = new ArrayList<FilmStrip>();
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        if (!cdp.isLive()) {
            List<VisualAnnotation> annotations;
            int count;
            long first = this.getFirstVisibleSlot() - 1L;
            long last = this.getLastVisibleSlot() + 1L;
            @NonNull ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
            VisualAnnotationData visualAnnotationData = this.getChart().getVisualAnnotationData();
            if (visualAnnotationData != null && (count = (annotations = visualAnnotationData.getAnnotations()).size()) > 0) {
                Rectangle bounds = this.getLocalBounds();
                int top = bounds.y;
                int slotsPerImage = (StreamlineUIUtils.getAnnotationBlankImageWidth() + 2) / RulerPanel.getSlotWidth();
                long firstForImage = first - first % (long)slotsPerImage;
                top += 4;
                long i = firstForImage;
                while (i <= last) {
                    long x;
                    boolean overImageBlock;
                    int index = ITimeStampedData.binarySearch(annotations, (long)Position.scale((long)i, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
                    if (index < 0) {
                        index = -index - 1;
                    }
                    VisualAnnotation annotation = null;
                    long annotationIndex = -1L;
                    long lastMouseSlot = this.getLastMouseSlot();
                    boolean bl = overImageBlock = lastMouseSlot != -1000L && lastMouseSlot >= i && lastMouseSlot < i + (long)slotsPerImage;
                    if (overImageBlock) {
                        int j = index;
                        while (j < count) {
                            VisualAnnotation next = annotations.get(j);
                            long nextIndex = Position.scale((long)next.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                            if (nextIndex > lastMouseSlot) break;
                            annotation = next;
                            annotationIndex = nextIndex;
                            ++j;
                        }
                    }
                    if (annotation == null && index < count) {
                        annotation = annotations.get(index);
                        annotationIndex = Position.scale((long)annotation.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                    }
                    if (annotation != null && annotationIndex >= i && annotationIndex < i + (long)slotsPerImage && (x = this.translateFromSlot(i) + 1L) + (long)StreamlineUIUtils.getAnnotationBlankImageWidth() >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                        list.add(new FilmStrip(new File(((VisualAnnotationData)NullChecking.neverNull((Object)visualAnnotationData)).getImagesDir(), annotation.getFilename()), new Rectangle((int)x, top, StreamlineUIUtils.getAnnotationBlankImageWidth(), StreamlineUIUtils.getAnnotationBlankImageHeight())));
                    }
                    i += (long)slotsPerImage;
                }
            }
        }
        return list;
    }

    private Color getHeatMapColorMapping(double percentage, boolean desaturate) {
        Color result;
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        RGB baseColor = theme.getHeatMapColor(this.mseriesIndex);
        if (desaturate) {
            baseColor = theme.desaturate(baseColor);
        }
        if (theme == StreamlineTheme.DARK) {
            Color c1 = Colors.lighten(baseColor, 50);
            result = Colors.darken(c1, (int)percentage - 50);
        } else {
            Color c1 = Colors.lighten(baseColor, 5);
            result = Colors.lighten(baseColor, (int)percentage - 5);
        }
        return result;
    }

    private final TIntSet getSelectedIds() {
        return this.getBaseTimelineContent().getSelectedProcessAndThreadIds();
    }

    private final boolean isFilmStrip() {
        return this.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION;
    }

    private final boolean isOverAutoScrollLeft(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x < bounds.x + RulerPanel.getSlotWidth();
    }

    private final boolean isOverAutoScrollRight(int x) {
        Rectangle bounds = this.getLocalBounds();
        return x > bounds.x + bounds.width - RulerPanel.getSlotWidth();
    }

    private final void preflightData(IChartDataProvider chart, long first, long last, TIntSet selection) {
        List<ISeriesDataProvider> seriesList = chart.getSeries();
        int count = seriesList.size();
        int firstForRequest = (int)(first >= 0L ? first : 0L);
        int lastForRequest = (int)last;
        boolean isOpen = this.mChartHandlePanel.isOpen();
        boolean heatmapMode = chart.isHeatMapLineEnabled();
        int seriesIndex = count;
        while (--seriesIndex >= 0) {
            ISeriesDataProvider series = seriesList.get(seriesIndex);
            if (isOpen && !heatmapMode) {
                @NonNull ProcessingElementReference channelDescriptor = (ProcessingElementReference)NullChecking.neverNull((Object)this.channelDescriptor);
                series.getData(channelDescriptor, firstForRequest, lastForRequest, selection);
                continue;
            }
            series.getData(firstForRequest, lastForRequest, selection);
        }
    }

    private final boolean shouldDrawSeriesValuesOnLeft(long x, long leftSlotAtDensestLevel, long rightSlotAtDensestLevel, boolean isRange) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            FontInfo fontInfo = FontInfo.get(FONT_TOOLTIP);
            int width = 0;
            boolean average = isRange && chart.isAverageSelection();
            int count = chart.getSeries().size();
            double[] values = new double[count];
            ScaledFormat chosenFormat = this.determineFormat(leftSlotAtDensestLevel, rightSlotAtDensestLevel, values);
            int i = 0;
            while (i < count) {
                int stringWidth;
                ISeriesDataProvider series = chart.getSeries().get(i);
                Object text = chosenFormat.format(values[i], series.getConfig().getUnits());
                if (average && series.isAverageSelectionPossible()) {
                    text = (String)text + AVERAGE;
                }
                if (width < (stringWidth = fontInfo.getWidth((String)text))) {
                    width = stringWidth;
                }
                ++i;
            }
            Rectangle bounds = this.getLocalBounds();
            if ((x += 8L) + (long)(width += 20) >= (long)(bounds.x + bounds.width)) {
                return true;
            }
        }
        return false;
    }

    private final boolean shouldHideData() {
        IChartDataProvider chart = this.getChart();
        for (ISeriesDataProvider seriesDataProvider : chart.getSeries()) {
            if (!seriesDataProvider.isDataHiddenDueToEfficientFtrace()) continue;
            return true;
        }
        return false;
    }

    private final void updateLimit(GC gc, double plateau) {
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            Rectangle bounds = this.getLocalBounds();
            bounds.x += 4;
            bounds.y += 4;
            String limit = ScaledFormat.format(plateau, chart.isPercentage(), 0, chart.getUnits());
            TextDrawing.drawString(gc, limit, bounds.x + 4, bounds.y + 2);
        }
    }

    final boolean showFullVisualAnnotation(Point where) {
        for (FilmStrip filmstrip : this.getFilmStrips()) {
            if (!filmstrip.getBounds().contains(where)) continue;
            BaseTimelineContent content = this.getBaseTimelineContent();
            content.setDetailAreaMode("images");
            ((ImageWrapper)content.getBottomPanel()).setImageFile(filmstrip.getFile());
            return true;
        }
        return false;
    }

    private static class SlotData {
        VisualAnnotation mTopAnnotation;
        int mTotalAnnotations;

        SlotData(VisualAnnotation annotation, int total) {
            this.mTopAnnotation = annotation;
            this.mTotalAnnotations = total;
        }
    }

    private class VisualAnnotationTracker
    extends TimelineDragTracker {
        protected VisualAnnotationTracker() {
            super(ChartPanel.this);
        }

        @Override
        public void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            ChartPanel.this.showFullVisualAnnotation(where);
            ChartPanel.this.setupAutoScroll(where.x);
        }

        @Override
        public void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            ChartPanel.this.showFullVisualAnnotation(where);
        }
    }
}

