/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.CaptureControlView;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.charts.ChartConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.ChartPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.charts.SeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.SharedLimitCalculator;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.live.CoreClusterDescription;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.utility.ui.StreamlineUIUtils;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.utils.ListUtils;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ChartHandlePanel
extends Block
implements IBlockLayout {
    public static final int CORE_BOX_H_MARGIN = 2;
    public static final int CORE_BOX_SIZE = 14;
    public static final int CORE_BOX_V_MARGIN = 4;
    public static final int DOT_SIZE = 8;
    public static final int H_MARGIN = 4;
    public static final int V_MARGIN = 2;
    private static final int BEFORE_SERIES_TITLE_GAP = 4;
    private static final int GRIP_SIZE = 8;
    private static final int SERIES_TITLE_GAP = 2;
    private final int SERIES_TITLE_HEIGHT;
    private final @NonNull IChartDataProvider mChartProvider;
    private final @NonNull ChartsPanel mChartsPanel;
    private boolean mAutoScrollPending;
    private ChartConfigurationPanel mConfigurationPanel;
    private int mHeight;
    private int mSeriesDragDestinationIndex = -1;
    private boolean mTitleWasTruncated;
    private DragTracker mTracker;
    private @NonNull Set<@NonNull String> mHighlightedSources = Collections.emptySet();
    private final @NonNull SharedLimitCalculator limitCalculator;

    void updateHeatmapZoomingFactor() {
        int heatmapZoomFactor = this.calculateHeatmapZoomFactor();
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int i = this.getChildCount();
            while (--i >= 0) {
                Block child = this.getChild(i);
                if (!(child instanceof ChartPanel)) continue;
                ChartPanel child2 = (ChartPanel)child;
                child2.setHeatmapZoomingFactor(heatmapZoomFactor);
            }
        }
    }

    private int calculateHeatmapZoomFactor() {
        int heightRequiredForSpacing;
        int totalHeight = this.getFixedHeight();
        int chartHeight = this.getFixedHeightWithoutConfiguration();
        int configHeight = totalHeight - chartHeight;
        int seriesCount = this.getChart().getSeries().size();
        int channelCount = this.getChart().getCoreInformationProvider().getChannelCount();
        if (seriesCount < 1 || channelCount < 1) {
            return 1;
        }
        boolean BORDER_WIDTH = true;
        int heightRequiredForLinesBetweenSeries = 1 * (seriesCount - 1);
        int heightAvailableForSeriesContents = Math.max(chartHeight - heightRequiredForLinesBetweenSeries, 0);
        int effectiveHeight = Math.max(heightAvailableForSeriesContents / seriesCount - 1, 0);
        int heightPerBlock = Math.min(Math.max((effectiveHeight - (heightRequiredForSpacing = 2 * (channelCount - 1))) / channelCount, ChartPanel.HEATMAPLINE_MIN_BLOCK_HEIGHT), 50);
        int minimumHeightRequired = (heightPerBlock * channelCount + heightRequiredForSpacing) * seriesCount + heightRequiredForLinesBetweenSeries + configHeight;
        if (totalHeight < minimumHeightRequired || heightPerBlock == 50 && totalHeight > minimumHeightRequired) {
            this.setFixedHeight(minimumHeightRequired);
        }
        return heightPerBlock;
    }

    private static final void fillGradientBox(GC gc, int x, int y, int size, Color color) {
        gc.setBackground(color);
        gc.setForeground(Colors.darken(color, 25));
        gc.fillGradientRectangle(x, y, size, size, true);
    }

    private static @NonNull String makeNumericalLabel(@NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider, @NonNull ProcessingElementReference peReference) {
        if (peReference.deviceType.isSystemWide()) {
            if (coreInformationProvider.hasMultipleVms()) {
                return Long.toString(peReference.vmUID);
            }
            return "";
        }
        @Nullable ProcessingElementTopology topology = coreInformationProvider.getTopology(peReference);
        if (topology != null) {
            return Integer.toString(topology.osID);
        }
        return Long.toString(peReference.deviceNumber);
    }

    public ChartHandlePanel(@NonNull ChartsPanel parent, @NonNull IChartDataProvider chartProvider) {
        this.SERIES_TITLE_HEIGHT = FontInfo.get(StreamlineUIConstants.SERIES_TITLE_FONT).getHeight();
        this.mChartsPanel = parent;
        this.limitCalculator = new SharedLimitCalculator(this.getCaptureDataProvider());
        this.mChartProvider = chartProvider;
        IChartDataProvider chart = this.getChart();
        this.mHeight = Math.max(chart.getHeight(), this.getMinimumHeight());
        this.setLayout(this);
        if (this.isOpen() && !this.hasDisclosure()) {
            chart.setOpen(false);
        }
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
        @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
        if (chart.isHeatMapLineEnabled()) {
            int zoomFactor = this.calculateHeatmapZoomFactor();
            int i = 0;
            while (i < chart.getSeries().size()) {
                this.add(new ChartPanel(this, this.limitCalculator, null, "", i, chart.getSeries().get(i), zoomFactor), i);
                ++i;
            }
        } else if (this.isOpen() && channels.length > 0 && deviceType != null) {
            int i = 0;
            while (i < channels.length) {
                this.add(new ChartPanel(this, this.limitCalculator, channels[i], ChartHandlePanel.makeNumericalLabel(coreInformationProvider, channels[i]), coreInformationProvider.getCoreColourIndex(channels[i])), i);
                ++i;
            }
        } else {
            int colour = ChartHandlePanel.selectClosedCoreColour(coreInformationProvider, channels);
            this.add(new ChartPanel(this, this.limitCalculator, null, "", colour));
        }
    }

    private static int selectClosedCoreColour(@NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider, @NonNull ProcessingElementReference @NonNull [] channels) {
        boolean systemWide;
        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
        boolean bl = systemWide = deviceType == null || deviceType.isSystemWide();
        int colour = channels.length > 1 && deviceType != null ? -2 : (systemWide || channels.length == 0 ? -1 : coreInformationProvider.getCoreColourIndex(channels[0]));
        return colour;
    }

    public void addSeries(@NonNull ISeriesDataProvider series, @Nullable SeriesConfigurationPanel seriesConfig) {
        int index = this.getChart().getSeries().indexOf(series);
        if (index == -1) {
            return;
        }
        ChartConfigurationPanel configPanel = this.mConfigurationPanel;
        if (configPanel != null) {
            if (seriesConfig != null) {
                seriesConfig.replaceSeries(configPanel, series);
                this.createSeriesConfigurationPanel(index, configPanel, seriesConfig);
            } else if (series.getConfig().isExpandedSeries()) {
                WildcardSeriesConfigurationPanel wildCardSeriesPanel = configPanel.findWildCardSeriesPanel(series);
                if (wildCardSeriesPanel != null) {
                    configPanel.createAndAddExpandedSeries(series, wildCardSeriesPanel);
                }
            } else {
                this.createSeriesConfigurationPanel(index, configPanel, configPanel.createSeriesPanel(series));
            }
        } else {
            this.seriesCountChanged(0);
        }
    }

    private void createSeriesConfigurationPanel(int index, ChartConfigurationPanel configPanel, SeriesConfigurationPanel toSeriesConfig) {
        int toSeriesConfigIndex = configPanel.getSeriesStartIndex() + index;
        configPanel.add(toSeriesConfig, toSeriesConfigIndex);
        this.seriesCountChanged(toSeriesConfig.getPreferredSize((int)this.getWidth(), (int)-1).y);
    }

    public final void adjustForSeriesExpressionChange() {
        this.adjustConfigurationControls();
        this.repaint();
    }

    public final void fillInChartConfig(@NonNull ChartAndSeriesConfig config) {
        config.load(this.getChart());
    }

    public final ICaptureDataProvider getCaptureDataProvider() {
        return this.mChartsPanel.getCaptureDataProvider();
    }

    public @NonNull IChartDataProvider getChart() {
        return this.mChartProvider;
    }

    public final @NonNull ChartsPanel getChartsPanel() {
        return this.mChartsPanel;
    }

    public final @Nullable ChartConfigurationPanel getConfigurationPanel() {
        return this.mConfigurationPanel;
    }

    public final DividerPanel getDividerPanel() {
        return this.mChartsPanel.getBaseTimelineContent().getDividerPanel();
    }

    public final int getHandleAreaWidth() {
        return this.mChartsPanel.getHandleAreaWidth();
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return new Point(widthHint == -1 ? 200 : widthHint, this.getFixedHeight());
    }

    public final long getPosition() {
        return this.getDividerPanel().getPosition();
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        return new Point(widthHint == -1 ? this.getHandleAreaWidth() + this.getCaptureDataProvider().getLastBinCount() * RulerPanel.getSlotWidth() : widthHint, this.getFixedHeight());
    }

    public final int getPreferredWidth() {
        int width = FontInfo.get(StreamlineUIConstants.TITLE_FONT).getWidth(this.getTitle());
        IChartDataProvider chart = this.getChart();
        FontInfo fontInfo = FontInfo.get(StreamlineUIConstants.SERIES_TITLE_FONT);
        for (ISeriesDataProvider series : chart.getSeries()) {
            String title = series.getName();
            int seriesWidth = 16 + fontInfo.getWidth(title);
            if (width >= seriesWidth) continue;
            width = seriesWidth;
        }
        if (this.isEditable()) {
            width += 2 + StreamlinePlugin.getImage((String)StreamlineImages.GEAR).getBounds().width + 2;
        }
        return 4 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width + 4 + width + 4 + 2 + 2 + 14 + 2;
    }

    public final @NonNull String getTitle() {
        return this.getChart().getTitle();
    }

    public final String getTitleFormat() {
        return this.getChart().getTitleFormat();
    }

    public final boolean isEditable() {
        return this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION;
    }

    public final boolean isOpen() {
        return this.getChart().isOpen();
    }

    @Override
    public final void layout(Block target) {
        int count = this.getChildCount();
        Point configSize = this.getConfigurationPanelSize();
        if (configSize.y != 0) {
            --count;
        }
        if (count > 0) {
            Rectangle bounds = this.getLocalBounds();
            int spaceForCharts = bounds.height - configSize.y;
            int height = spaceForCharts / count;
            int extra = spaceForCharts - height * count;
            int handleAreaWidth = this.getHandleAreaWidth();
            int left = bounds.x + handleAreaWidth;
            int width = bounds.width - handleAreaWidth;
            int y = bounds.y;
            int i = 0;
            while (i < count) {
                int actualHeight = height;
                if (extra > 0) {
                    ++actualHeight;
                    --extra;
                }
                this.getChild(i).setBounds(left, y, width, actualHeight);
                y += actualHeight;
                ++i;
            }
            if (configSize.y != 0) {
                this.mConfigurationPanel.setBounds(left, y, width, configSize.y);
            }
        }
    }

    public final void moveSeries(@NonNull ISeriesDataProvider series, @NonNull ChartHandlePanel to, int toIndex) {
        IChartDataProvider fromChart = this.getChart();
        IChartDataProvider toChart = to.getChart();
        int fromIndex = fromChart.getSeries().indexOf(series);
        if (to == this) {
            if (fromIndex == toIndex) {
                return;
            }
            if (this.mConfigurationPanel != null) {
                int seriesIndexStart = this.mConfigurationPanel.getSeriesStartIndex();
                this.mConfigurationPanel.move(seriesIndexStart + fromIndex, seriesIndexStart + toIndex);
                this.mConfigurationPanel.layout();
            }
            ListUtils.moveBefore(toChart.getSeries(), (int)fromIndex, (int)toIndex);
            this.getCaptureDataProvider().notifyChartsChanged();
            this.repaint();
        } else if (toChart.getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION && fromIndex > -1) {
            fromChart.getSeries().remove(fromIndex);
            this.getCaptureDataProvider().notifyChartsChanged();
            SeriesConfigurationPanel seriesConfig = this.removeSeries(series);
            SeriesConfig config = series.getConfig().clone();
            ISeriesDataProvider newSeries = toChart.createSeries(toIndex, config);
            to.addSeries(newSeries, seriesConfig);
        }
    }

    public final void removeChart() {
        MessageDialogWithToggle dialog;
        int code;
        boolean remove;
        boolean bl = remove = !StreamlinePreferences.showRemoveChartConfirmDialog();
        if (!remove && (code = (dialog = new MessageDialogWithToggle(this.getShell(), ChartMessages.REMOVE_CHART_TITLE, null, ChartMessages.REMOVE_CHART_QUESTION, 5, new String[]{IDialogConstants.CANCEL_LABEL, ChartMessages.REMOVE_CHART_TITLE}, 1, ChartMessages.ALWAYS_REMOVE_WITHOUT_ASKING, false)).open()) == 256) {
            if (dialog.getToggleState()) {
                StreamlinePreferences.setShowRemoveChartConfirmDialog(false);
            }
            remove = true;
        }
        if (remove) {
            this.removeFromParent();
            this.getCaptureDataProvider().removeChart(this.getChart());
        }
    }

    public @Nullable SeriesConfigurationPanel removeSeries(@NonNull ISeriesDataProvider series) {
        if (this.mConfigurationPanel != null) {
            List<@NonNull Block> removed = this.mConfigurationPanel.removeMatching(b -> {
                if (b instanceof SeriesConfigurationPanel) {
                    ISeriesDataProvider series2 = ((SeriesConfigurationPanel)b).getSeries();
                    return series2 != null && series2.equals(series);
                }
                return false;
            });
            removed.forEach(b -> this.seriesCountChanged(-b.getHeight()));
            return removed.stream().findAny().orElse(null);
        }
        this.seriesCountChanged(0);
        return null;
    }

    public final void clearSharedLimit() {
        this.limitCalculator.clear();
    }

    public final void seriesCountChanged(int delta) {
        this.limitCalculator.clear();
        int chartHeight = this.getFixedHeightWithoutConfiguration();
        int configHeight = this.getFixedHeight() - chartHeight + delta;
        if (configHeight < 0) {
            configHeight = 0;
        }
        this.setFixedHeight(chartHeight + configHeight);
        this.adjustConfigurationControls();
        this.repack();
    }

    public final void setFixedHeight(int height) {
        int min = this.getMinimumHeight();
        if (height < min) {
            height = min;
        }
        if (this.mHeight != height) {
            this.mHeight = height;
            this.repack();
            this.getChart().setHeight(this.getFixedHeightWithoutConfiguration());
        }
    }

    public void setSeriesDragDestinationIndex(int seriesDragDestinationIndex) {
        this.mSeriesDragDestinationIndex = seriesDragDestinationIndex;
    }

    public final void setTitleFormat(String title) {
        this.getChart().setTitleFormat(title);
        this.repaint();
    }

    public final void toggleConfigurationPanel() {
        @Nullable ChartConfigurationPanel currentConfigurationPanel = this.mConfigurationPanel;
        if (currentConfigurationPanel == null) {
            this.mConfigurationPanel = new ChartConfigurationPanel(this);
            this.add(this.mConfigurationPanel);
            this.mHeight += this.getConfigurationPanelSize().y;
        } else {
            this.mHeight -= this.getConfigurationPanelSize().y;
            this.remove(currentConfigurationPanel);
            this.mConfigurationPanel = null;
        }
        this.repack();
        if (this.mConfigurationPanel != null) {
            BaseTimelineContent content;
            int height = this.getHeight();
            if (height > (content = this.getChartsPanel().getBaseTimelineContent()).getChartsScroller().getHeight()) {
                content.setDividerPosition(height);
            }
            this.scrollIntoView();
        }
    }

    public final void openHeatMapLinesChart() {
        IChartDataProvider chart = this.getChart();
        int chartSeriesCount = chart.getSeries().size();
        this.limitCalculator.clear();
        chart.setHeatMapLineEnabled(true);
        int i = this.getChildCount();
        while (--i >= 0) {
            if (!(this.getChild(i) instanceof ChartPanel)) continue;
            this.remove(i);
        }
        int zoomFactor = this.calculateHeatmapZoomFactor();
        int i2 = 0;
        while (i2 < chartSeriesCount) {
            this.add(new ChartPanel(this, this.limitCalculator, null, "", i2, chart.getSeries().get(i2), zoomFactor), i2);
            ++i2;
        }
        this.getRoot().layout();
        this.repack();
    }

    public final void toggleDisclosureState() {
        IChartDataProvider chart = this.getChart();
        if (chart.isHeatMapLineEnabled()) {
            return;
        }
        this.limitCalculator.clear();
        chart.setOpen(!this.isOpen());
        int originalCount = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            if (!(this.getChild(i) instanceof ChartPanel)) continue;
            ++originalCount;
            this.remove(i);
        }
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
        @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
        if (this.isOpen() && channels.length > 0 && deviceType != null) {
            int chartHeight = this.getFixedHeightWithoutConfiguration();
            int configHeight = this.getFixedHeight() - chartHeight;
            int i2 = 0;
            while (i2 < channels.length) {
                this.add(new ChartPanel(this, this.limitCalculator, channels[i2], ChartHandlePanel.makeNumericalLabel(coreInformationProvider, channels[i2]), coreInformationProvider.getCoreColourIndex(channels[i2])), i2);
                ++i2;
            }
            this.setFixedHeight(chartHeight * channels.length + configHeight);
        } else {
            int colour = ChartHandlePanel.selectClosedCoreColour(coreInformationProvider, channels);
            this.add(new ChartPanel(this, this.limitCalculator, null, "", colour), 0);
            if (originalCount > 1) {
                int chartHeight = this.getFixedHeightWithoutConfiguration();
                int configHeight = this.getFixedHeight() - chartHeight;
                this.setFixedHeight(chartHeight / originalCount + configHeight);
            }
        }
        this.repack();
        this.scrollIntoView();
    }

    protected final Point getConfigurationPanelSize() {
        return this.mConfigurationPanel != null ? this.mConfigurationPanel.getPreferredSize(this.getBounds().width - this.getHandleAreaWidth(), -1) : new Point(0, 0);
    }

    protected final int getFixedHeight() {
        return this.mHeight;
    }

    protected final boolean isOverGearHitArea(Point where) {
        return this.isEditable() && this.getConfigHitArea().contains(where);
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            if (count == 2) {
                if (this.isOverHorizontalResizeGrip(where)) {
                    this.getChartsPanel().getBaseTimelineContent().autoresizeHandlePanels();
                } else if (this.isOverVerticalResizeGrip(where)) {
                    this.setFixedHeight(this.getMinimumHeight());
                    if (this.getChart().isHeatMapLineEnabled()) {
                        this.updateHeatmapZoomingFactor();
                    }
                }
            } else {
                this.adjustCursorAndToolTip(where);
                if (this.isOverDisclosure(where)) {
                    this.mTracker = new DisclosureTracker();
                } else if (this.isOverGearHitArea(where)) {
                    this.mTracker = new GearTracker();
                } else if (this.isOverVerticalResizeGrip(where)) {
                    this.mTracker = new VerticalResizeTracker(where.y);
                } else if (this.isOverHorizontalResizeGrip(where)) {
                    this.mTracker = new HorizontalResizeTracker(where.x);
                } else if (!this.isOverCoreBox(where)) {
                    int i = this.getOverSeriesTitle(where);
                    if (i != -1) {
                        if (!this.getChart().getWildcardSeries().isEmpty()) {
                            return;
                        }
                        this.mTracker = new SeriesMoveTracker(i);
                    } else {
                        this.mTracker = new MoveTracker(where);
                    }
                }
            }
        } else if (button == 3 && count == 1) {
            Menu menu = new Menu((Control)this.getOwner());
            MenuItem item = new MenuItem(menu, 8);
            item.setText(ChartMessages.MOVE_CHART_TO_TOP);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    ChartsPanel chartsPanel = ChartHandlePanel.this.getChartsPanel();
                    chartsPanel.move(ChartHandlePanel.this, chartsPanel.getChild(0));
                    chartsPanel.layout();
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(ChartMessages.MOVE_CHART_TO_BOTTOM);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    ChartsPanel chartsPanel = ChartHandlePanel.this.getChartsPanel();
                    chartsPanel.move(ChartHandlePanel.this, null);
                    chartsPanel.layout();
                }
            });
            if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
                ContextMenu.createSeparator(menu);
                item = new MenuItem(menu, 8);
                item.setText(ChartMessages.REMOVE_CHART_TITLE);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public final void widgetSelected(SelectionEvent event) {
                        ChartHandlePanel.this.removeChart();
                    }
                });
            }
            this.showContextMenu(menu, where);
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.setToolTip(null);
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected void mouseExit() {
        CaptureControlView.getCounterDropTarget().ifPresent(countersOutline -> countersOutline.setHighlightedSources(Collections.emptySet()));
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.getChartsPanel().getBaseTimelineContent().setBookmarkPopOver(null);
        this.adjustCursorAndToolTip(where);
        CaptureControlView.getCounterDropTarget().ifPresent(countersOutline -> {
            int i = this.getOverSeriesTitle(where);
            @NonNull Set<@NonNull String> sources = i != -1 ? this.getChart().getSeries().get(i).getSources() : this.getChart().getSeries().stream().flatMap(s -> s.getSources().stream()).collect(Collectors.toSet());
            countersOutline.setHighlightedSources(sources);
        });
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursorAndToolTip(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        this.drawBackground(gc);
        this.drawVerticalResizeGrip(gc);
        this.drawDisclosure(gc);
        this.drawTitle(gc);
        this.drawSeriesTitles(gc);
        this.drawCoreBoxes(gc);
        this.drawConfigButton(gc);
        if (this.mTracker instanceof MoveTracker) {
            ((MoveTracker)this.mTracker).redraw();
        }
    }

    private final void adjustConfigurationControls() {
        IChartDataProvider chart;
        if (this.isOpen() && !this.hasDisclosure()) {
            this.toggleDisclosureState();
        }
        if ((chart = this.getChart()).getRenderingType() == GraphRenderingType.HEATMAP) {
            if (ChartUtility.canBeRespresentedAsAHeatMapChart(chart)) {
                this.openHeatMapLinesChart();
            } else {
                this.openDefaultChart();
            }
        }
        Block[] blockArray = this.mChartsPanel.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            ChartConfigurationPanel configPanel = ((ChartHandlePanel)block).mConfigurationPanel;
            if (configPanel != null) {
                configPanel.adjustForSeriesExpressionChange();
                configPanel.enableOrDisableHeatMapButton(ChartUtility.canBeRespresentedAsAHeatMapChart(chart));
            }
            ++n2;
        }
    }

    private final void adjustCursorAndToolTip(Point where) {
        Display display;
        String tooltip = null;
        int cursorID = 0;
        Cursor cursor = null;
        if (where.x < this.getLocalBounds().x + this.getHandleAreaWidth()) {
            if (this.isOverDisclosure(where)) {
                cursorID = 21;
                tooltip = this.isOpen() ? ChartMessages.DISCLOSURE_CLOSED_TOOLTIP : ChartMessages.DISCLOSURE_OPEN_TOOLTIP;
            } else if (this.isOverGearHitArea(where)) {
                cursorID = 21;
                tooltip = ChartMessages.CHART_CONFIGURATION_TOOLTIP;
            } else if (this.isOverVerticalResizeGrip(where)) {
                cursorID = 7;
            } else if (this.isOverHorizontalResizeGrip(where)) {
                cursorID = 9;
            } else if (this.isOverCoreBox(where)) {
                if (!this.getChart().isHeatMapLineEnabled()) {
                    tooltip = this.getToolTipForCoreBox(this.getOverCoreBox(where));
                } else {
                    @Nullable ChartPanel chartPanel = this.getChartPanel(where);
                    if (chartPanel != null) {
                        tooltip = chartPanel.getSeriesDataprovider().getName();
                    }
                }
            } else {
                int i = this.getOverSeriesFilter(where);
                if (i != -1) {
                    tooltip = ChartMessages.SERIES_IS_FILTERED;
                } else {
                    i = this.getOverSeriesTitle(where);
                    if (i != -1) {
                        ISeriesDataProvider series = this.getChart().getSeries().get(i);
                        String warning = series.getWarning();
                        tooltip = warning != null ? String.format(ChartMessages.SERIES_WARNING, warning) : series.getDescription();
                    } else if (this.mTitleWasTruncated && this.isOverTitle(where)) {
                        tooltip = this.getTitle();
                    }
                }
                cursor = StreamlinePlugin.getOpenHandCursor();
            }
        }
        if (cursor == null && (display = this.getDisplay()) != null) {
            cursor = display.getSystemCursor(cursorID);
        }
        this.setCursor(cursor);
        this.setToolTip(tooltip);
    }

    private final void autoScroll(int amount) {
        BlockScrollBar scrollbar;
        int y;
        this.mAutoScrollPending = false;
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null && this.getScrollAmount(scroller, y = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).y) != 0 && (scrollbar = scroller.getVerticalBar()) != null) {
            scrollbar.setValue(scrollbar.getValue() + (long)amount);
            if (this.mTracker != null) {
                this.mTracker.mouseDrag(new Point(0, y), 0);
            }
        }
    }

    private final void drawBackground(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        Color color = this.getAdjustedBackgroundColor();
        gc.setBackground(color);
        gc.fillRectangle(bounds.x, bounds.y, this.getHandleAreaWidth(), bounds.height);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int bottom = bounds.y + bounds.height - 1;
        gc.setForeground(Colors.getWidgetNormalShadow());
        Block[] children = this.mChartsPanel.getChildren();
        if (children.length > 0 && children[children.length - 1] != this) {
            gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        }
        int x = bounds.x + this.getHandleAreaWidth() - 1;
        gc.drawLine(x, bounds.y, x, bottom);
        Rectangle grip = this.getHorizontalResizeGripHitArea();
        x = grip.x;
        gc.setForeground(Colors.darken(color, 20));
        gc.drawLine(x, bounds.y, x, bottom);
        gc.setAntialias(savedAA);
    }

    private final void drawConfigButton(GC gc) {
        if (this.isEditable()) {
            Rectangle bounds = this.getConfigHitArea();
            Image configImage = StreamlinePlugin.getImage(StreamlineImages.GEAR);
            gc.drawImage(configImage, bounds.x, bounds.y);
        }
    }

    private final void drawCoreBoxes(GC gc) {
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            int i = this.getChildCount();
            while (--i >= 0) {
                Block child = this.getChild(i);
                if (!(child instanceof ChartPanel)) continue;
                Rectangle bounds = this.getCoreBox(i);
                ++bounds.x;
                bounds.width -= 2;
                bounds.height -= 2;
                gc.setForeground(Colors.darken(this.getAdjustedBackgroundColor(), 20));
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                gc.setForeground(Colors.darken(Colors.getWhite(), 5));
                gc.drawRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
                ChartPanel chartPanel = (ChartPanel)child;
                Color color = chartPanel.getCoreColor();
                int interiorBoxSize = bounds.width - 4;
                int x = bounds.x + 2;
                int y = bounds.y + 2;
                if (color == null) {
                    int half = interiorBoxSize / 2;
                    ChartHandlePanel.fillGradientBox(gc, x, y, half, Colors.getCoreColor(0));
                    ChartHandlePanel.fillGradientBox(gc, x + half, y, half, Colors.getCoreColor(1));
                    ChartHandlePanel.fillGradientBox(gc, x, y + half, half, Colors.getCoreColor(2));
                    ChartHandlePanel.fillGradientBox(gc, x + half, y + half, half, Colors.getCoreColor(3));
                    continue;
                }
                ChartHandlePanel.fillGradientBox(gc, x, y, interiorBoxSize, color);
                @Nullable ProcessingElementReference channelDescriptor = chartPanel.getChannelDescriptor();
                if (channelDescriptor == null) continue;
                gc.setForeground(Colors.getBlack());
                gc.setFont(Fonts.getSmall());
                TextDrawing.drawString(gc, chartPanel.getChannelLabel(), bounds.x, bounds.y + bounds.height, bounds.width + 4, 0x1000000);
            }
            gc.setAntialias(savedAA);
        }
    }

    private final void drawDisclosure(GC gc) {
        if (this.hasDisclosure() && !this.getChart().isHeatMapLineEnabled()) {
            Rectangle bounds = this.getDisclosureHitArea();
            gc.drawImage(StreamlinePlugin.getImage(this.isOpen() ? StreamlineImages.DISCLOSURE_DOWN : StreamlineImages.DISCLOSURE_UP), bounds.x + 4, bounds.y + 2);
        }
    }

    private final void drawSeriesTitles(GC gc) {
        int initialY;
        IChartDataProvider chart = this.getChart();
        Rectangle bounds = this.getLocalBounds();
        int x = bounds.x + 12 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width;
        int width = this.getHandleAreaWidth() - (16 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width + 14 + 4);
        int y = initialY = bounds.y + 4 + StreamlineUIConstants.TITLE_HEIGHT;
        gc.setFont(StreamlineUIConstants.SERIES_TITLE_FONT);
        gc.setForeground(Colors.getWidgetForeground());
        boolean isFiltered = this.getChartsPanel().isFilteringActive();
        int i = 0;
        while (i < chart.getSeries().size()) {
            ISeriesDataProvider series = chart.getSeries().get(i);
            if (!Collections.disjoint(series.getSources(), this.mHighlightedSources)) {
                gc.setBackground(Colors.lighten(Colors.getYellow(), 75));
                gc.fillRectangle(new Rectangle(x, y, width, this.SERIES_TITLE_HEIGHT));
            }
            SeriesConfig config = series.getConfig();
            if (chart.isHeatMapLineEnabled()) {
                StreamlineTheme theme = StreamlinePreferences.getTheme();
                RGB heatMapColor = theme.getHeatMapColor(i);
                if (theme == StreamlineTheme.DARK) {
                    Color c1 = Colors.lighten(heatMapColor, 45);
                    gc.setBackground(c1);
                } else if (theme == StreamlineTheme.LIGHT) {
                    Color c1 = Colors.adjust(heatMapColor, 0.0f, 0.0f, 100.0f);
                    gc.setBackground(c1);
                }
            } else {
                gc.setBackground(Colors.create(config.getColor()));
            }
            int dotTop = y + (this.SERIES_TITLE_HEIGHT - 8) / 2;
            gc.fillOval(x, dotTop, 8, 8);
            int savedAA = gc.getAntialias();
            gc.setAntialias(1);
            gc.setForeground(Colors.getMarker());
            gc.drawOval(x, dotTop, 8, 8);
            gc.setAntialias(savedAA);
            if (isFiltered && series.isFilterable()) {
                Image image = StreamlinePlugin.getImage("Filtered.png");
                Rectangle imgBounds = image.getBounds();
                gc.drawImage(image, x - (imgBounds.width + 1), y + (this.SERIES_TITLE_HEIGHT - imgBounds.height) / 2);
            }
            int xx = x + 8 + 4;
            int ww = width - 12;
            if (series.getWarning() != null) {
                Image image = switch (series.getWarningSource()) {
                    case ISeriesDataProvider.WarningSource.DUMMY_COUNTER -> StreamlinePlugin.getImage("WarningLow.png");
                    case ISeriesDataProvider.WarningSource.INVALID_COUNTER -> StreamlinePlugin.getImage("WarningHigh.png");
                    default -> StreamlinePlugin.getImage("Warning.png");
                };
                Rectangle imgBounds = image.getBounds();
                int newImgWidth = imgBounds.width;
                int newImgHeight = imgBounds.height;
                if (newImgHeight > this.SERIES_TITLE_HEIGHT) {
                    newImgWidth = newImgWidth * this.SERIES_TITLE_HEIGHT / newImgHeight;
                    newImgHeight = this.SERIES_TITLE_HEIGHT;
                }
                gc.drawImage(image, 0, 0, imgBounds.width, imgBounds.height, xx, y, newImgWidth, newImgHeight);
                int space = newImgWidth + 4;
                xx += space;
                ww -= space;
            }
            gc.setForeground(Colors.getWidgetForeground());
            TextDrawing.drawString(gc, series.getName(), xx, y, ww, 16384);
            y += this.SERIES_TITLE_HEIGHT + 2;
            ++i;
        }
        if (this.mSeriesDragDestinationIndex != -1) {
            int lineY = initialY + this.mSeriesDragDestinationIndex * (this.SERIES_TITLE_HEIGHT + 2) - 1;
            gc.drawLine(x, lineY, x + width, lineY);
        }
    }

    private final void drawTitle(GC gc) {
        String trimmedTitle;
        String title;
        Rectangle bounds = this.getLocalBounds();
        gc.setFont(StreamlineUIConstants.TITLE_FONT);
        gc.setForeground(Colors.getWidgetForeground());
        int disclosureArea = 8 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width;
        Rectangle configHitArea = this.getConfigHitArea();
        int width = configHitArea.x - (bounds.x + disclosureArea + 4);
        if (!this.isEditable()) {
            width += configHitArea.width;
        }
        this.mTitleWasTruncated = !(title = this.getTitle()).equals(trimmedTitle = TextDrawing.truncateString(gc, title, width, 131072));
        TextDrawing.drawString(gc, trimmedTitle, bounds.x + disclosureArea, bounds.y + 2, 16384);
    }

    private final void drawVerticalResizeGrip(GC gc) {
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            gc.setAlpha(64);
            Rectangle bounds = this.getVerticalResizeGripHitArea();
            int y = bounds.y + 2;
            int left = bounds.x;
            int right = left + bounds.width - 1;
            gc.setForeground(Colors.getBlack());
            gc.drawLine(left, y, right, y);
            gc.drawLine(left, y += 2, right, y);
            gc.setAlpha(96);
            gc.setForeground(Colors.getWhite());
            gc.drawLine(left, --y, right, y);
            gc.drawLine(left, y += 2, right, y);
            gc.setAlpha(255);
            gc.setAntialias(savedAA);
        }
    }

    private final Color getAdjustedBackgroundColor() {
        boolean isFiltered;
        Color color = Colors.getWidgetBackground();
        if (this.mTracker instanceof MoveTracker) {
            color = Colors.darken(color, 10);
        }
        if (isFiltered = this.getChartsPanel().isFilteringActive()) {
            isFiltered = false;
            for (ISeriesDataProvider series : this.getChart().getSeries()) {
                if (!series.isFilterable()) continue;
                isFiltered = true;
                color = Colors.blend(color, Colors.getBlue(), 5);
                break;
            }
        }
        return color;
    }

    private final String getCluster(@NonNull ProcessingElementReference peReference) {
        String clusterName = this.getChart().getCoreInformationProvider().getChannelName(peReference);
        if (clusterName == null) {
            clusterName = ChartMessages.UNKNOWN;
        }
        return clusterName;
    }

    private final Rectangle getConfigHitArea() {
        Rectangle bounds = this.getLocalBounds();
        Rectangle imgBounds = StreamlinePlugin.getImage(StreamlineImages.GEAR).getBounds();
        int left = bounds.x + this.getHandleAreaWidth() - (imgBounds.width + 14 + 6);
        return new Rectangle(left, bounds.y + 4, imgBounds.width, imgBounds.height);
    }

    private final Rectangle getCoreBox(int index) {
        int left = this.getLocalBounds().x + this.getHandleAreaWidth() - 16;
        return new Rectangle(left, this.getChild((int)index).getBounds().y + 4, 14, 14);
    }

    private final Rectangle getDisclosureHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.y += (StreamlineUIConstants.TITLE_HEIGHT - StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.height) / 2;
        bounds.width = StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width + 8;
        bounds.height = StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.height + 4;
        return bounds;
    }

    private final int getFixedHeightWithoutConfiguration() {
        int height = this.mHeight;
        if (this.mConfigurationPanel != null) {
            height -= this.mConfigurationPanel.getBounds().height;
        }
        return height;
    }

    private final Rectangle getHorizontalResizeGripHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.width = 18;
        bounds.x += this.getHandleAreaWidth() - bounds.width;
        return bounds;
    }

    private final int getMinimumHeight() {
        int height;
        IChartDataProvider chart = this.getChart();
        if (chart.getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
            height = StreamlineUIUtils.getAnnotationBlankImageHeight() + 8;
        } else {
            int count = Math.max(chart.getSeries().size(), 2);
            height = 8 + StreamlineUIConstants.TITLE_HEIGHT + 4 + (this.SERIES_TITLE_HEIGHT + 2) * count;
            if (this.isOpen() && !this.isHeatMapEnabled()) {
                height *= Math.max(chart.getCoreInformationProvider().getChannelCount(), 1);
            }
        }
        return height + this.getConfigurationPanelSize().y;
    }

    private final @Nullable ProcessingElementReference getOverCoreBox(Point where) {
        @Nullable ChartPanel chartPanel = this.getChartPanel(where);
        if (chartPanel != null) {
            return chartPanel.getChannelDescriptor();
        }
        return null;
    }

    private final @Nullable ChartPanel getChartPanel(Point where) {
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int i = this.getChildCount();
            while (--i >= 0) {
                Block child = this.getChild(i);
                if (!(child instanceof ChartPanel) || !this.getCoreBox(i).contains(where)) continue;
                return (ChartPanel)child;
            }
        }
        return null;
    }

    private final int getOverSeriesFilter(Point where) {
        if (this.getChartsPanel().getBaseTimelineContent().getSelectedProcessAndThreadIds() != null) {
            List<ISeriesDataProvider> series = this.getChart().getSeries();
            int i = series.size();
            while (--i >= 0) {
                if (!series.get(i).isFilterable() || !this.getSeriesFilterHitArea(i).contains(where)) continue;
                return i;
            }
        }
        return -1;
    }

    private final int getOverSeriesTitle(Point where) {
        int i = this.getChart().getSeries().size();
        while (--i >= 0) {
            if (!this.getSeriesTitleHitArea(i).contains(where)) continue;
            return i;
        }
        return -1;
    }

    private final int getScrollAmount(ScrollingBlock scroller, int y) {
        int amount = 0;
        if (scroller != null) {
            int top = scroller.toRootY(0);
            int bottom = top + scroller.getHeight() - 1;
            int pos = this.toRootY(y);
            if (pos < top + 5) {
                amount = -20;
            } else if (pos > bottom - 5) {
                amount = 20;
            }
        }
        return amount;
    }

    private final Rectangle getSeriesFilterHitArea(int index) {
        Rectangle bounds = this.getLocalBounds();
        int width = StreamlinePlugin.getImage((String)"Filtered.png").getBounds().width;
        bounds.x += 4 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width - (width + 1);
        bounds.y += 4 + StreamlineUIConstants.TITLE_HEIGHT;
        bounds.width = width + 8;
        bounds.height = this.SERIES_TITLE_HEIGHT;
        bounds.y += (this.SERIES_TITLE_HEIGHT + 2) * index;
        return bounds;
    }

    private final int getSeriesTitleDropIndex(int yThis) {
        int seriesDelta = this.SERIES_TITLE_HEIGHT + 2;
        int ySeriesTitles = yThis - (StreamlineUIConstants.TITLE_HEIGHT + 4);
        int index = (ySeriesTitles + seriesDelta / 2) / seriesDelta;
        return Math.min(this.getChart().getSeries().size(), Math.max(0, index));
    }

    private final Rectangle getSeriesTitleHitArea(int index) {
        int width;
        IChartDataProvider chart = this.getChart();
        ISeriesDataProvider series = chart.getSeries().get(index);
        Rectangle bounds = this.getLocalBounds();
        bounds.x += 8 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width;
        bounds.y += 4 + StreamlineUIConstants.TITLE_HEIGHT;
        FontInfo fontInfo = FontInfo.get(StreamlineUIConstants.SERIES_TITLE_FONT);
        bounds.width = 24;
        bounds.height = this.SERIES_TITLE_HEIGHT;
        int maxTextWidth = this.getHandleAreaWidth() - (16 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width + 8 + 14 + 4);
        if (series.getWarning() != null) {
            Image image = StreamlinePlugin.getImage("Warning.png");
            Rectangle imgBounds = image.getBounds();
            int newImgWidth = imgBounds.width;
            int newImgHeight = imgBounds.height;
            if (newImgHeight > this.SERIES_TITLE_HEIGHT) {
                newImgWidth = newImgWidth * this.SERIES_TITLE_HEIGHT / newImgHeight;
            }
            int space = newImgWidth + 4;
            bounds.width += space;
            maxTextWidth -= space;
        }
        if ((width = fontInfo.getWidth(series.getName())) > maxTextWidth) {
            width = maxTextWidth;
        }
        bounds.width += width;
        bounds.y += (this.SERIES_TITLE_HEIGHT + 2) * index;
        return bounds;
    }

    private final String getToolTipForCoreBox(@Nullable ProcessingElementReference peReference) {
        boolean systemWide;
        IChartDataProvider chart = this.getChart();
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
        boolean bl = systemWide = deviceType == null || deviceType.isSystemWide();
        if (peReference == null || !this.isOpen()) {
            if (this.hasDisclosure()) {
                if (deviceType == null || systemWide) {
                    if (coreInformationProvider.hasMultipleVms()) {
                        return CoreClusterDescription.getMultiVMTooltip();
                    }
                    return CoreClusterDescription.getSystemWideTooltip();
                }
                if (deviceType.isCPU()) {
                    return CoreClusterDescription.getMultiCoreTooltip();
                }
                return ClusterNameUtils.getPrettyNameForNonCpu((String)deviceType.getName());
            }
            @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
            if (channels.length > 0 && (!systemWide || coreInformationProvider.hasMultipleVms())) {
                if (deviceType != null && !deviceType.isCPU() && !deviceType.isSystemWide()) {
                    return ClusterNameUtils.getPrettyNameForNonCpu((String)deviceType.getName());
                }
                if (channels.length == 1 && !systemWide) {
                    return CoreClusterDescription.generateTooltip(coreInformationProvider.getVmName(channels[0]), this.getCluster(channels[0]), channels[0], coreInformationProvider.getChannelName(channels[0]), coreInformationProvider.getTopology(channels[0]), coreInformationProvider.getRelativeCoreID(channels[0]));
                }
            }
            return CoreClusterDescription.getSystemWideTooltip();
        }
        if (systemWide) {
            return CoreClusterDescription.generateVmTooltip(coreInformationProvider.getVmName(peReference), peReference);
        }
        return CoreClusterDescription.generateTooltip(coreInformationProvider.getVmName(peReference), this.getCluster(peReference), peReference, coreInformationProvider.getChannelName(peReference), coreInformationProvider.getTopology(peReference), coreInformationProvider.getRelativeCoreID(peReference));
    }

    private final Rectangle getVerticalResizeGripHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.width = this.getHandleAreaWidth() / 3;
        bounds.x += bounds.width;
        bounds.y += bounds.height - 8;
        bounds.height = 8;
        return bounds;
    }

    private final boolean hasDisclosure() {
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = this.getChart().getCoreInformationProvider();
        return coreInformationProvider.getDeviceType() != null && coreInformationProvider.getChannelCount() > 1;
    }

    private final boolean isOverCoreBox(Point where) {
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            int i = this.getChildCount();
            while (--i >= 0) {
                Block child = this.getChild(i);
                if (!(child instanceof ChartPanel) || !this.getCoreBox(i).contains(where)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isOverHorizontalResizeGrip(Point where) {
        return this.getHorizontalResizeGripHitArea().contains(where) && !this.isOverCoreBox(where);
    }

    private final boolean isOverTitle(Point where) {
        Rectangle bounds = this.getLocalBounds();
        bounds.x += 8 + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width;
        Rectangle configHitArea = this.getConfigHitArea();
        bounds.width = configHitArea.x - (bounds.x + 4);
        if (!this.isEditable()) {
            bounds.width += configHitArea.width;
        }
        return bounds.contains(where);
    }

    private final boolean isOverVerticalResizeGrip(Point where) {
        if (this.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
            return this.getVerticalResizeGripHitArea().contains(where);
        }
        return false;
    }

    private final void repack() {
        this.getChartsPanel().pack();
        NullChecking.consumeIfNonNull((Object)this.getRoot(), Block::layout);
    }

    final boolean isOverDisclosure(Point where) {
        if (this.hasDisclosure()) {
            return this.getDisclosureHitArea().contains(where);
        }
        return false;
    }

    final void setupAutoScroll(int y) {
        int amount;
        ScrollingBlock scroller;
        if (!this.mAutoScrollPending && (scroller = this.getContainingScrollingBlock()) != null && (amount = this.getScrollAmount(scroller, y)) != 0) {
            this.mAutoScrollPending = true;
            int scroll = amount;
            Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public boolean isHeatMapEnabled() {
        return this.getChart().isHeatMapLineEnabled();
    }

    public void openDefaultChart() {
        this.limitCalculator.clear();
        IChartDataProvider chart = this.getChart();
        chart.setHeatMapLineEnabled(false);
        int i = this.getChildCount();
        while (--i >= 0) {
            if (!(this.getChild(i) instanceof ChartPanel)) continue;
            this.remove(i);
        }
        @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
        @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
        if (this.isOpen() && channels.length > 0) {
            int i2 = 0;
            while (i2 < channels.length) {
                this.add(new ChartPanel(this, this.limitCalculator, channels[i2], ChartHandlePanel.makeNumericalLabel(coreInformationProvider, channels[i2]), coreInformationProvider.getCoreColourIndex(channels[i2])), i2);
                ++i2;
            }
        } else {
            int colour = ChartHandlePanel.selectClosedCoreColour(coreInformationProvider, channels);
            ChartPanel block = new ChartPanel(this, this.limitCalculator, null, "", colour);
            this.add(block, 0);
        }
        this.setFixedHeight(this.mHeight);
        this.getRoot().layout();
        this.repack();
    }

    public void setHighlightedSources(@NonNull Set<@NonNull String> sources) {
        this.mHighlightedSources = sources;
        this.repaint();
    }

    private class DisclosureTracker
    extends TimelineDragTracker {
        DisclosureTracker() {
            super(ChartHandlePanel.this);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            if (ChartHandlePanel.this.isOverDisclosure(where)) {
                ChartHandlePanel.this.toggleDisclosureState();
            }
            super.mouseUp(where, button, stateMask, count);
        }
    }

    private class GearTracker
    extends TimelineDragTracker {
        GearTracker() {
            super(ChartHandlePanel.this);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            if (ChartHandlePanel.this.isOverGearHitArea(where)) {
                ChartHandlePanel.this.toggleConfigurationPanel();
            }
            super.mouseUp(where, button, stateMask, count);
        }
    }

    private class HorizontalResizeTracker
    extends TimelineDragTracker {
        private int mStartWidth;
        private int mStartX;

        HorizontalResizeTracker(int x) {
            super(ChartHandlePanel.this);
            this.mStartX = x;
            this.mStartWidth = ChartHandlePanel.this.getHandleAreaWidth();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            ChartHandlePanel.this.getChartsPanel().setHandleAreaWidth(this.mStartWidth + where.x - this.mStartX);
        }
    }

    private class MoveTracker
    extends TimelineDragTracker
    implements PaintListener {
        private int mPosition;
        private Shell mShell;
        private Point mStartPosition;
        private int mStartY;

        MoveTracker(Point where) {
            super(ChartHandlePanel.this);
            this.mStartY = ChartHandlePanel.this.toDisplay((Point)where).y;
            this.mStartPosition = ChartHandlePanel.this.toDisplay(0, 0);
            this.mPosition = this.mStartPosition.y;
            ChartHandlePanel.this.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
            ChartHandlePanel.this.repaint();
            this.mShell = new Shell(ChartHandlePanel.this.getShell(), 537133064);
            this.mShell.setAlpha(192);
            this.mShell.addPaintListener((PaintListener)this);
            Rectangle bounds = ChartHandlePanel.this.getLocalBounds();
            this.mShell.setBounds(this.mStartPosition.x, this.mStartPosition.y, bounds.width, bounds.height);
            this.mShell.setCursor(StreamlinePlugin.getClosedHandCursor());
            this.mShell.setVisible(true);
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            ChartHandlePanel.this.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
            ChartHandlePanel.this.setupAutoScroll(where.y);
            Point whereDisplay = ChartHandlePanel.this.toDisplay(where);
            CaptureControlView.getCounterDropTarget().ifPresent(outline -> outline.setDropHighlight(outline.getBounds().contains(outline.toControl(whereDisplay))));
            this.mPosition = this.mStartPosition.y + whereDisplay.y - this.mStartY;
            this.mShell.setLocation(this.mStartPosition.x, this.mPosition);
            ChartsPanel chartsPanel = ChartHandlePanel.this.getChartsPanel();
            Point whereCharts = chartsPanel.fromDisplay(whereDisplay);
            Block[] blockArray = chartsPanel.getChildren();
            int n = blockArray.length;
            int n2 = 0;
            while (n2 < n) {
                Block child = blockArray[n2];
                Rectangle bounds = child.getBounds();
                if (whereCharts.y < bounds.y + bounds.height / 2) {
                    if (chartsPanel.move(ChartHandlePanel.this, child)) {
                        chartsPanel.layout();
                    }
                    return;
                }
                ++n2;
            }
            if (chartsPanel.move(ChartHandlePanel.this, null)) {
                chartsPanel.layout();
            }
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            ChartHandlePanel.this.repaint();
            ChartHandlePanel.this.getOwner().applyCursor(null);
            this.mShell.dispose();
            CaptureControlView.getCounterDropTarget().ifPresent(outline -> {
                outline.setDropHighlight(false);
                if (outline.getBounds().contains(outline.toControl(ChartHandlePanel.this.toDisplay(where)))) {
                    ChartHandlePanel.this.removeChart();
                }
            });
        }

        public final void paintControl(PaintEvent event) {
            GC gc = new GC(event.gc);
            ChartHandlePanel.this.paintAsRoot(gc);
        }

        final void redraw() {
            SafeUpdate.redraw((Control)this.mShell);
        }
    }

    private class SeriesMoveTracker
    extends DragTracker {
        private final @NonNull Cursor cursor;
        private final @NonNull Image cursorImage;
        private int destinationIndex;
        private @Nullable ChartHandlePanel destinationPanel;
        private final @NonNull ISeriesDataProvider series;
        private final @NonNull Image textImage;

        SeriesMoveTracker(int series) {
            super(null);
            this.series = ChartHandlePanel.this.getChart().getSeries().get(series);
            Display display = ChartHandlePanel.this.getDisplay();
            final ImageData handImageData = StreamlinePlugin.getImage("ClosedHand.gif").getImageData();
            final int hotSpotX = handImageData.width / 2;
            final int hotsoptY = handImageData.height / 2;
            this.textImage = TextDrawing.createTextImage((String)NullChecking.neverNull((Object)this.series.getName()), display);
            final ImageData textImageData = this.textImage.getImageData();
            CompositeImageDescriptor cursorImageDescriptor = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(textImageData, hotSpotX, hotsoptY);
                    this.drawImage(handImageData, 0, 0);
                }

                protected Point getSize() {
                    return new Point(textImageData.width + hotSpotX, textImageData.height + hotsoptY);
                }
            };
            this.cursorImage = (Image)NullChecking.neverNull((Object)cursorImageDescriptor.createImage());
            this.cursor = new Cursor((Device)display, this.cursorImage.getImageData(), hotSpotX, hotsoptY);
            ChartHandlePanel.this.getOwner().applyCursor(this.cursor);
            ChartHandlePanel.this.repaint();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            ChartHandlePanel.this.getOwner().applyCursor(this.cursor);
            ChartHandlePanel.this.setupAutoScroll(where.y);
            Point whereDisplay = ChartHandlePanel.this.toDisplay(where);
            CaptureControlView.getCounterDropTarget().ifPresent(outline -> outline.setDropHighlight(outline.getBounds().contains(outline.toControl(whereDisplay))));
            this.clearDestination();
            ChartsPanel chartsPanel = ChartHandlePanel.this.getChartsPanel();
            Point whereCharts = chartsPanel.fromDisplay(new Point(whereDisplay.x, whereDisplay.y));
            Block[] blockArray = chartsPanel.getChildren();
            int n = blockArray.length;
            int n2 = 0;
            while (n2 < n) {
                Block child = blockArray[n2];
                if (child instanceof ChartHandlePanel && child.getBounds().contains(whereCharts)) {
                    ChartHandlePanel destinationPanel = (ChartHandlePanel)child;
                    if (!destinationPanel.getChart().getWildcardSeries().isEmpty()) {
                        return;
                    }
                    Point whereDestinationPanel = destinationPanel.fromDisplay(whereDisplay);
                    this.destinationIndex = destinationPanel.getSeriesTitleDropIndex(whereDestinationPanel.y);
                    destinationPanel.setSeriesDragDestinationIndex(this.destinationIndex);
                    destinationPanel.repaint();
                    this.destinationPanel = destinationPanel;
                    return;
                }
                ++n2;
            }
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            ChartHandlePanel destinationPanel = this.destinationPanel;
            if (destinationPanel != null) {
                ChartHandlePanel.this.moveSeries(this.series, destinationPanel, this.destinationIndex);
            }
            this.clearDestination();
            ChartHandlePanel.this.repaint();
            ChartHandlePanel.this.getOwner().applyCursor(null);
            this.cursor.dispose();
            this.cursorImage.dispose();
            this.textImage.dispose();
            CaptureControlView.getCounterDropTarget().ifPresent(outline -> {
                outline.setDropHighlight(false);
                if (outline.getBounds().contains(outline.toControl(ChartHandlePanel.this.toDisplay(where))) && ChartHandlePanel.this.getCaptureDataProvider().isLive()) {
                    ChartHandlePanel.this.getChart().remove(this.series);
                }
            });
        }

        private void clearDestination() {
            ChartHandlePanel destinationPanel = this.destinationPanel;
            if (destinationPanel != null) {
                destinationPanel.setSeriesDragDestinationIndex(-1);
                destinationPanel.repaint();
            }
            this.destinationPanel = null;
        }
    }

    private class VerticalResizeTracker
    extends TimelineDragTracker {
        private int mStartHeight;
        private int mStartY;

        VerticalResizeTracker(int y) {
            super(ChartHandlePanel.this);
            this.mStartY = y;
            this.mStartHeight = ChartHandlePanel.this.getFixedHeight();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            int y = where.y;
            int amount = y - this.mStartY;
            boolean needScroll = false;
            ScrollingBlock scroller = ChartHandlePanel.this.getContainingScrollingBlock();
            if (scroller != null) {
                int top = scroller.toRootY(0);
                int bottom = top + scroller.getHeight() - 1;
                int pos = ChartHandlePanel.this.toRootY(y);
                if (pos < top || pos > bottom) {
                    needScroll = true;
                    if (pos < top - 20) {
                        int delta = top - 20 - pos;
                        y += delta;
                        amount += delta;
                    } else if (pos > bottom + 20) {
                        int delta = pos - (bottom + 20);
                        y -= delta;
                        amount -= delta;
                    }
                }
            }
            ChartHandlePanel.this.setFixedHeight(this.mStartHeight + amount);
            if (ChartHandlePanel.this.getChart().isHeatMapLineEnabled()) {
                ChartHandlePanel.this.updateHeatmapZoomingFactor();
            }
            if (needScroll) {
                ChartHandlePanel.this.scrollIntoView(0, y, 1, 1);
            }
            ChartHandlePanel.this.setupAutoScroll(y);
        }
    }
}

