/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureBuild;
import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureTransfer;
import com.arm.streamline.jni.apcdbgen.proto.BufferTransfer;
import com.arm.streamline.jni.apcdbgen.proto.Dispatch;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ImageTransfer;
import com.arm.streamline.jni.apcdbgen.proto.Renderpass;
import com.arm.streamline.jni.apcdbgen.proto.TraceRays;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class WorkloadLabelVisitor
implements ILabelVisitor {
    private final @NonNull List<@NonNull String> labels = new ArrayList<String>();
    private static final @NonNull String MULTIPLY = "\u00d7";

    private static String formatByteSize(long bytes) {
        String[] units = new String[]{"bytes", "KiB", "MiB", "GiB", "TiB", "PiB"};
        if (bytes < 0L) {
            return " (Unknown)";
        }
        if (bytes < 1024L) {
            return " (" + bytes + " bytes)";
        }
        double size = bytes;
        int unitIndex = 0;
        while (size >= 1024.0 && unitIndex < units.length - 1) {
            size /= 1024.0;
            ++unitIndex;
        }
        return " (" + String.format("%.2f %s", size, units[unitIndex]) + ")";
    }

    public @NonNull List<@NonNull String> getLabels() {
        return this.labels;
    }

    public void visit(@NonNull Renderpass renderPass) {
        long draws;
        String resolutionLabel = renderPass.getWidth() + MULTIPLY + renderPass.getHeight();
        String drawLabel = " (" + draws + ((draws = renderPass.getDrawCallCount()) > 1L ? " draws)" : " draw)");
        String mergedLabel = resolutionLabel + drawLabel;
        this.labels.add(mergedLabel);
        String attachments = renderPass.getAttachments();
        String attachmentsLoaded = renderPass.getAttachmentsLoaded();
        String attachmentsStored = renderPass.getAttachmentsStored();
        StringBuilder builder = new StringBuilder();
        if (!attachmentsLoaded.isEmpty()) {
            builder.append("load(" + attachmentsLoaded + ")");
        }
        if (!attachments.isEmpty()) {
            builder.append(" > [" + attachments + "]");
        }
        if (!attachmentsStored.isEmpty()) {
            builder.append(" > store(" + attachmentsStored + ")");
        }
        this.labels.add(builder.toString());
    }

    public void visit(@NonNull Dispatch dispatch) {
        if (dispatch.getX() < 0L || dispatch.getY() < 0L || dispatch.getZ() < 0L) {
            this.labels.add("Unknown groups");
        } else {
            this.labels.add(dispatch.getX() + MULTIPLY + dispatch.getY() + MULTIPLY + dispatch.getZ() + " groups");
        }
    }

    public void visit(@NonNull TraceRays traceRays) {
        if (traceRays.getX() < 0L || traceRays.getY() < 0L || traceRays.getZ() < 0L) {
            this.labels.add("Unknown items");
        } else {
            this.labels.add(traceRays.getX() + MULTIPLY + traceRays.getY() + MULTIPLY + traceRays.getZ() + " items");
        }
    }

    public void visit(@NonNull ImageTransfer imageTransfer) {
        if (imageTransfer.getPixelCount() < 0L) {
            this.labels.add((String)NullChecking.neverNull((Object)(imageTransfer.getTransferType().displayName() + " (Unknown)")));
        } else {
            this.labels.add((String)NullChecking.neverNull((Object)String.format("%s (%,d pixels)", imageTransfer.getTransferType().displayName(), imageTransfer.getPixelCount())));
        }
    }

    public void visit(@NonNull BufferTransfer bufferTransfer) {
        this.labels.add(bufferTransfer.getTransferType().displayName() + WorkloadLabelVisitor.formatByteSize(bufferTransfer.getByteCount()));
    }

    public void visit(AccelerationStructureBuild build) {
        if (build.getPrimitiveCount() < 0L) {
            this.labels.add((String)NullChecking.neverNull((Object)(build.getBuildType().displayName() + " (Unknown)")));
        } else {
            this.labels.add((String)NullChecking.neverNull((Object)String.format("%s (%,d primitives)", build.getBuildType().displayName(), build.getPrimitiveCount())));
        }
    }

    public void visit(AccelerationStructureTransfer accStructTransfer) {
        this.labels.add(accStructTransfer.getBuildType().displayName() + WorkloadLabelVisitor.formatByteSize(accStructTransfer.getByteCount()));
    }
}

