/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.cam.RenderedJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.model.cam.CAMJobListMerger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;

final class CachedRender {
    private static final int JOB_SPACING_PX = 1;
    public final boolean collapsed;
    public final long firstVisibleSlot;
    public final @NonNull CAMJobListMerger jobList;
    public final long lastVisibleSlot;
    public final @NonNull ZoomLevel zoomLevel;
    private @Nullable List<@NonNull RenderedJob> renderedJobs = null;
    private int slotWidth = 0;

    public CachedRender(@NonNull CAMJobListMerger jobList, @NonNull ZoomLevel zoomLevel, long firstVisibleSlot, long lastVisibleSlot, boolean collapsed) {
        this.jobList = jobList;
        this.zoomLevel = zoomLevel;
        this.firstVisibleSlot = firstVisibleSlot;
        this.lastVisibleSlot = lastVisibleSlot;
        this.collapsed = collapsed;
    }

    public @NonNull List<@NonNull RenderedJob> getRenderedJobs(int slotWidth) {
        if (slotWidth <= 0) {
            return Collections.emptyList();
        }
        List<RenderedJob> cachedJobs = this.renderedJobs;
        if (this.slotWidth == slotWidth && cachedJobs != null) {
            return cachedJobs;
        }
        List<RenderedJob> newJobs = this.mapJobsToDisplay(slotWidth);
        this.slotWidth = slotWidth;
        this.renderedJobs = newJobs;
        return newJobs;
    }

    private @NonNull List<@NonNull RenderedJob> mapJobsToDisplay(int slotWidth) {
        long visibleSlotCount = this.lastVisibleSlot - this.firstVisibleSlot + 1L;
        if (visibleSlotCount < 1L) {
            return Collections.emptyList();
        }
        long rangeStartNS = this.zoomLevel.convertBinToNanoseconds(this.firstVisibleSlot);
        long rangeDurationNS = this.zoomLevel.convertBinToNanoseconds(visibleSlotCount);
        long visibleSlotPixels = (long)slotWidth * visibleSlotCount;
        RenderingDecider predicate = new RenderingDecider(rangeStartNS, rangeDurationNS, visibleSlotPixels);
        this.jobList.forEach(predicate);
        return predicate.pixelToJob;
    }

    public @NonNull Point getRenderedPosition(long starttime, long stoptime, int slotWidth) {
        long visibleSlotCount = this.lastVisibleSlot - this.firstVisibleSlot + 1L;
        long visibleSlotPixels = (long)slotWidth * visibleSlotCount;
        long rangeStartNS = this.zoomLevel.convertBinToNanoseconds(this.firstVisibleSlot);
        long rangeDurationNS = this.zoomLevel.convertBinToNanoseconds(visibleSlotCount);
        long startOffsetNS = starttime - rangeStartNS;
        long stopOffsetNS = stoptime - rangeStartNS;
        int startPix = (int)(startOffsetNS * visibleSlotPixels / rangeDurationNS);
        int stopPix = (int)(stopOffsetNS * visibleSlotPixels / rangeDurationNS);
        return new Point(startPix, stopPix);
    }

    static class RenderingDecider
    implements Predicate<ICAMJob> {
        private final long rangeStartNS;
        private final long rangeDurationNS;
        private final long visibleSlotPixels;
        private final @NonNull ArrayList<@NonNull RenderedJob> pixelToJob = new ArrayList();
        private int currentLeftPix = 0;
        private int lastMarginStartPix = 0;

        public RenderingDecider(long rangeStartNS, long rangeDurationNS, long visibleSlotPixels) {
            this.rangeStartNS = rangeStartNS;
            this.rangeDurationNS = rangeDurationNS;
            this.visibleSlotPixels = visibleSlotPixels;
        }

        @Override
        public boolean test(@NonNull ICAMJob j) {
            int clippedStopPix;
            long startOffsetNS = j.getStartTime() - this.rangeStartNS;
            long stopOffsetNS = j.getStopTime() - this.rangeStartNS;
            if (stopOffsetNS < 0L) {
                return true;
            }
            if (startOffsetNS >= this.rangeDurationNS) {
                return false;
            }
            long clippedStartNS = Math.max(0L, startOffsetNS);
            long clippedEndNS = Math.min(this.rangeDurationNS, stopOffsetNS);
            int startPix = (int)(clippedStartNS * this.visibleSlotPixels / this.rangeDurationNS);
            int stopPix = Math.max(startPix + 1, (int)(clippedEndNS * this.visibleSlotPixels / this.rangeDurationNS));
            int clippedStartPix = Math.max(this.currentLeftPix, startPix);
            if (clippedStartPix >= (clippedStopPix = Math.max(this.currentLeftPix, stopPix))) {
                return this.handleHiddenJob(j, startPix, stopPix);
            }
            RenderedJob renderedItem = new RenderedJob(startPix, clippedStartPix, clippedStopPix, j, false);
            this.pixelToJob.add(renderedItem);
            this.currentLeftPix = stopPix + 1;
            this.lastMarginStartPix = stopPix;
            return true;
        }

        private boolean handleHiddenJob(@NonNull ICAMJob j, int startPix, int stopPix) {
            int marginStopPix;
            int marginStartPix = Math.max(this.lastMarginStartPix, startPix);
            if (marginStartPix < (marginStopPix = Math.max(this.lastMarginStartPix, stopPix))) {
                RenderedJob renderedItem = new RenderedJob(startPix, marginStartPix, marginStopPix, j, true);
                this.pixelToJob.add(renderedItem);
                this.lastMarginStartPix = marginStopPix;
            }
            int i = this.pixelToJob.size() - 1;
            while (i >= 0) {
                RenderedJob that = this.pixelToJob.get(i);
                if (that.renderStopPix <= startPix) break;
                assert (that.realStartPix <= startPix);
                List<ICAMJob> hiddenJobs = that.hiddenJobs;
                if (hiddenJobs == null) {
                    that.hiddenJobs = hiddenJobs = new ArrayList<ICAMJob>();
                }
                hiddenJobs.add(j);
                --i;
            }
            return true;
        }
    }
}

