/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineCommonMessages;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.utility.RunnableUIAction;

public class CenterOnCSMAction
extends RunnableUIAction
implements ICrossSectionMarkerListener {
    private BaseTimelineContent mContent;

    public CenterOnCSMAction(BaseTimelineContent content) {
        super(TimelineCommonMessages.CENTER_ON_CSM, StreamlinePlugin.getImageDescriptor(StreamlineImages.CENTER_ON_CSM));
        this.mContent = content;
        this.updateFromContent();
        this.setRunnable(() -> this.center());
    }

    public void center() {
        CrossSectionMarker csm;
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        if (cdp != null && !(csm = cdp.getCrossSectionMarker()).isParked()) {
            this.mContent.centerViewOn(csm.getLeft(), csm.getRight());
        }
    }

    @Override
    public void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.setEnabled(!csm.isParked());
    }

    public boolean isEnabled() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        return cdp != null ? !cdp.getCrossSectionMarker().isParked() : false;
    }

    public void updateFromContent() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        if (cdp != null) {
            CrossSectionMarker csm = cdp.getCrossSectionMarker();
            csm.addListener(this);
            this.setEnabled(!csm.isParked());
        } else {
            this.setEnabled(false);
        }
    }
}

