/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.log.LogEntryTab;
import com.arm.streamline.editortabs.report.BaseExportDialog;
import com.arm.streamline.editortabs.timeline.ExportHeatMapDataJob;
import com.arm.streamline.editortabs.timeline.ExportHeatMapDialog;
import com.arm.streamline.editortabs.timeline.ExportTimelineDialog;
import com.arm.streamline.editortabs.timeline.FilterToolbar;
import com.arm.streamline.editortabs.timeline.TimelineMessages;
import com.arm.streamline.editortabs.timeline.TimelineTab;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.CenterOnCSMAction;
import com.arm.streamline.editortabs.timeline.common.ResetCalipersAction;
import com.arm.streamline.editortabs.timeline.common.TimeReadout;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapScrollableWrapper;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapWrapper;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapsPanel;
import com.arm.streamline.editortabs.timeline.common.images.ImageWrapper;
import com.arm.streamline.editortabs.timeline.common.process.ProcessPanel;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.editortabs.timeline.common.samples.SamplesPanel;
import com.arm.streamline.editortabs.timeline.common.templates.NewChartAction;
import com.arm.streamline.editortabs.timeline.common.templates.TemplateAction;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.CAMConfig;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.utility.RunnableUIAction;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.DropDownMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;

public class TimelineContent
extends BaseTimelineContent
implements DropDownMenu.IPopupMenuItemSelectionListener,
IScaleListener {
    private final @NonNull Analysis mAnalysis;
    private RunnableUIAction mLogAction = new RunnableUIAction(TimelineContent.adjustTitleForHotKey(TimelineMessages.SELECT_IN_LOG, 'l'), StreamlinePlugin.getImageDescriptor("Log.gif"), () -> this.showLogAtCrossSectionIndex());
    private RunnableUIAction mZoomInAction = new RunnableUIAction(TimelineContent.adjustTitleForHotKey(TimelineMessages.ZOOM_IN, '+'), StreamlinePlugin.getImageDescriptor("ZoomIn.png"), () -> this.getRulerPanel().zoomIn());
    private RunnableUIAction mZoomOutAction = new RunnableUIAction(TimelineContent.adjustTitleForHotKey(TimelineMessages.ZOOM_OUT, '-'), StreamlinePlugin.getImageDescriptor("ZoomOut.png"), () -> this.getRulerPanel().zoomOut());
    private RunnableUIAction mCycleThemeAction = new RunnableUIAction(TimelineMessages.CYCLE_THEME, StreamlinePlugin.getImageDescriptor("Theme.png"), () -> StreamlinePreferences.cycleTheme());
    private RunnableUIAction mExportAction;
    private DropDownMenu mZoomMenu;
    private TimeReadout mDurationReadout;

    private static final String getInitialDetailAreaMode(TimelineTab parent) {
        String mode = parent.getAnalysis().getTimelineConfiguration().getDetailAreaMode();
        if (mode == null) {
            mode = "heat";
        }
        try {
            Integer.valueOf(mode);
            mode = "heat";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mode;
    }

    public TimelineContent(TimelineTab parent) {
        super(parent, TimelineContent.getInitialDetailAreaMode(parent));
        this.mAnalysis = parent.getAnalysis();
        TimelineConfig config = this.mAnalysis.getTimelineConfiguration();
        this.setTemplateName(config.getTemplate());
        this.mAnalysis.setFocusSource(config.getFocusSource());
        this.mAnalysis.getScales().setZoomLevel(config.getScale());
        this.mAnalysis.getCalipers().load(config);
        this.mAnalysis.getCrossSectionMarker().load(config);
        this.setHeatmapAveragePerCore(config.isHeatmapAveragePerCore());
        this.setShowBookmarks(config.showBookmarks());
        this.setHeatMapFilter(config.getHeatMapFilter());
        this.setAnnotationFilter(config.getAnnotationFilter());
        this.createStandardPanels(config.getHandleWidth());
        this.mAnalysis.getScales().addListener((IScaleListener)this);
        this.getDividerPanel().setPosition(config.getScrollPosition());
        this.setDividerPosition(config.getDividerPosition());
        this.getContentWrapper().getRoot().addKeyHandler(() -> this.showLogAtCrossSectionIndex(), 'L', 'l');
        this.mExportAction = new RunnableUIAction(TimelineMessages.EXPORT, StreamlinePlugin.getImageDescriptor("Export.gif"), () -> this.exportTimelineData());
        this.getContentWrapper().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if ((e.stateMask & 0x40000) == 0) {
                    return;
                }
                long currentHoveredSlot = TimelineContent.this.getCurrentHoverPosition();
                Scales scales = TimelineContent.this.mAnalysis.getScales();
                ZoomLevel currentZoomLevel = scales.getZoomLevel();
                ZoomLevel prevZoomLevel = scales.getNextScaleDown();
                ZoomLevel nextZoomLevel = scales.getNextScaleUp();
                if (e.count > 0) {
                    if (nextZoomLevel != null) {
                        int threshold = nextZoomLevel.getBps() * 6 / currentZoomLevel.getBps();
                        if (RulerPanel.getSlotWidth() + 1 >= threshold) {
                            TimelineContent.this.getRulerPanel().changeZoom(nextZoomLevel, 6, currentHoveredSlot);
                        } else {
                            TimelineContent.this.getRulerPanel().changeZoom(currentZoomLevel, RulerPanel.getSlotWidth() + 1, currentHoveredSlot);
                        }
                    } else {
                        TimelineContent.this.getRulerPanel().changeZoom(currentZoomLevel, RulerPanel.getSlotWidth() + 1, currentHoveredSlot);
                    }
                } else if (e.count < 0) {
                    if (prevZoomLevel != null) {
                        int newWidth = currentZoomLevel.getBps() * 6 / prevZoomLevel.getBps();
                        if (RulerPanel.getSlotWidth() <= 6) {
                            TimelineContent.this.getRulerPanel().changeZoom(prevZoomLevel, newWidth - 1, currentHoveredSlot);
                        } else {
                            TimelineContent.this.getRulerPanel().changeZoom(currentZoomLevel, RulerPanel.getSlotWidth() - 1, currentHoveredSlot);
                        }
                    } else {
                        TimelineContent.this.getRulerPanel().changeZoom(currentZoomLevel, RulerPanel.getSlotWidth() - 1, currentHoveredSlot);
                    }
                }
                TimelineContent.this.getContentWrapper().redraw();
            }
        });
    }

    @Override
    public TimelineConfig createConfiguration() {
        TimelineConfig config = super.createConfiguration();
        HeatMapWrapper heatMap = (HeatMapWrapper)this.lookupDetailArea("heat");
        if (heatMap != null) {
            TIntHashSet openIds = config.getOpenHeatMapRowIds();
            openIds.clear();
            HeatMapsPanel heatMapsPanel = heatMap.getHeatMapsPanel();
            int i = heatMapsPanel.getChildCount();
            while (--i >= 0) {
                this.addToOpenSet((HeatMapHandlePanel)heatMapsPanel.getChild(i), openIds);
            }
            TIntHashSet selectedIds = config.getSelectedHeatMapRowIds();
            selectedIds.clear();
            selectedIds.addAll((TIntCollection)heatMapsPanel.getSelection());
        }
        return config;
    }

    public final void exportTimelineData() {
        Calipers calipers = this.mAnalysis.getCalipers();
        ExportTimelineDialog.show(this.mAnalysis, calipers.getLeft(), calipers.getRight(), this.getSelectedProcessAndThreadIds());
    }

    @Override
    public void exportHeatMapData() {
        String filename = MessageFormat.format("HeatMap_for_{0}.csv", this.mAnalysis);
        @NonNull String fullPath = (String)NullChecking.neverNull((Object)FilePath.getPathForPlatform((String)FilePath.getFullPath((String)BaseExportDialog.getDefaultPath(), (String)filename)));
        ExportHeatMapDialog dlg = new ExportHeatMapDialog(fullPath);
        int result = dlg.open();
        if (result != 1) {
            fullPath = (String)NullChecking.neverNull((Object)dlg.getPath());
            @NonNull ReportProcessor.Format format = (ReportProcessor.Format)((Object)NullChecking.neverNull((Object)((Object)BaseExportDialog.getSelectedFormat())));
            Calipers calipers = this.mAnalysis.getCalipers();
            int from = (int)calipers.getLeft();
            int to = (int)calipers.getRight() - 1;
            Analysis dataProvider = this.mAnalysis;
            @NonNull ITimelineMapProvider mapProvider = dataProvider.getMapProvider();
            @Nullable TIntSet selection = this.getSelectedProcessAndThreadIds();
            @NonNull ZoomLevel resolution = this.mAnalysis.getScales().getZoomLevel();
            @NonNull TimeUnit timeUnit = this.mAnalysis.getTimeUnit();
            ExportHeatMapDataJob job = new ExportHeatMapDataJob(format, from, to, mapProvider.getRootTimelineRows(), selection, fullPath, resolution, timeUnit, this.isHeatmapAveragePerCore());
            job.schedule();
        }
    }

    public final void fillToolbar(CustomToolbar toolbar) {
        Scales scales = this.mAnalysis.getScales();
        TimeUnit timeUnit = this.mAnalysis.getTimeUnit();
        this.mZoomInAction.setEnabled(!scales.isAtMaxZoom());
        this.mZoomOutAction.setEnabled(!scales.isAtMinZoom());
        toolbar.addAction(this.getBookmarkToggleAction());
        toolbar.addAction(new CenterOnCSMAction(this));
        toolbar.addAction(new ResetCalipersAction(this));
        toolbar.addAction(this.mLogAction).setLayoutData(new CustomToolbar.LayoutData().setGap(10));
        toolbar.addAction(this.mZoomInAction);
        toolbar.addAction(this.mZoomOutAction);
        this.mZoomMenu = new DropDownMenu(toolbar);
        this.mZoomMenu.setLayoutData(new CustomToolbar.LayoutData().setFlexibleGap());
        ZoomLevel[] zoomLevelArray = scales.getAvailableZoomLevels();
        int n = zoomLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZoomLevel zoomLevel = zoomLevelArray[n2];
            this.mZoomMenu.addMenuItem(timeUnit.formatZoomLevel(zoomLevel), zoomLevel);
            ++n2;
        }
        this.mZoomMenu.selectItemWithData(scales.getZoomLevel());
        this.mZoomMenu.addPopupMenuItemSelectionListener(this);
        ZoomLevel densestZoomLevel = scales.getDensestZoomLevel();
        TimeReadout positionReadout = this.getPositionReadout();
        positionReadout.updateDesiredMinimumWidthForScale(this.mAnalysis.getBinCountForDensestScale(), densestZoomLevel, timeUnit);
        positionReadout.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(positionReadout.computeSize((int)-1, (int)-1).x).setGap(4));
        this.mDurationReadout = new TimeReadout(toolbar, true);
        this.mDurationReadout.update(this.mAnalysis.getBinCountForDensestScale(), densestZoomLevel, timeUnit);
        this.mDurationReadout.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mDurationReadout.computeSize((int)-1, (int)-1).x).setFlexibleGap());
        toolbar.addAction(new TemplateAction(this, this.mAnalysis.getTemplates(), this.mAnalysis.getSpeKeys()));
        toolbar.addAction(new NewChartAction(this));
        toolbar.addAction(this.mCycleThemeAction);
        toolbar.addAction(this.mExportAction);
    }

    @Override
    public final @NonNull ICaptureDataProvider getCaptureDataProvider() {
        return this.mAnalysis;
    }

    @Override
    public final CustomToolbar getTopToolbar() {
        return ((TimelineTab)this.getParent()).getToolbar();
    }

    @Override
    public final void popupMenuItemSelected(DropDownMenu popupMenu, int itemIndex, Object data) {
        this.getRulerPanel().changeZoom((ZoomLevel)NullChecking.neverNull((Object)data), 6, -1L);
    }

    public final void scaleChanged(Scales scales) {
        this.mZoomInAction.setEnabled(!scales.isAtMaxZoom());
        this.mZoomOutAction.setEnabled(!scales.isAtMinZoom());
        this.mZoomMenu.selectItemWithData(scales.getZoomLevel());
    }

    @Override
    public final void setDetailAreaMode(String detailAreaMode) {
        super.setDetailAreaMode(detailAreaMode);
        ((FilterToolbar)this.getBottomToolbar()).adjustToContent();
    }

    public final void showLogAtCrossSectionIndex() {
        CrossSectionMarker csm = this.mAnalysis.getCrossSectionMarker();
        @NonNull ZoomLevel densestZoomLevel = csm.getDensestZoomLevel();
        long left = csm.getRangeLeftAtDensestScale();
        long right = csm.getRangeRightAtDensestScale() - 1L;
        left = Position.scale((long)left, (ZoomLevel)densestZoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
        right = Position.scale((long)right, (ZoomLevel)densestZoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
        @NonNull AnalysisEditor editor = ((TimelineTab)this.getParent()).requireEditor();
        editor.setActivePage(EditorTabID.LOG);
        ((LogEntryTab)editor.getSelectedPage()).selectEntryRange(left, right);
    }

    @Override
    public final void widgetDisposed(DisposeEvent event) {
        this.saveConfiguration(this.mAnalysis.getReportDirectory(), false);
        this.mAnalysis.saveBookmarks();
        super.widgetDisposed(event);
    }

    @Override
    protected final BlockToolbar createBottomToolbar() {
        return new FilterToolbar(this);
    }

    @Override
    protected final Block createDetailArea(String key) {
        @NonNull TimelineConfig config = this.mAnalysis.getTimelineConfiguration();
        switch (key) {
            case "heat": {
                TIntHashSet openIds = config.getOpenHeatMapRowIds();
                for (ITimelineRowProvider row : this.getCaptureDataProvider().getMapProvider().getRootTimelineRows()) {
                    this.setOpenRows(row, openIds);
                }
                return new HeatMapWrapper(this, config.getSelectedHeatMapRowIds());
            }
            case "core": 
            case "cluster": 
            case "heat_inverted": {
                HeatMapWrapper wrapper = (HeatMapWrapper)this.lookupOrCreateDetailAreaMode("heat");
                wrapper.getHeatMapsPanel().setMode(key);
                return wrapper;
            }
            case "processes": {
                return new ProcessPanel(this, this.getCaptureDataProvider().getProcessDataProvider().getThreadMode());
            }
            case "samples": {
                return new SamplesPanel(this);
            }
            case "images": {
                return new ImageWrapper();
            }
        }
        if (key.startsWith("cam_")) {
            int index = Integer.parseInt(key.substring("cam_".length()));
            ICAMDataProvider camDataProvider = this.getCaptureDataProvider().getCAMDataProviders().get(index);
            @NonNull CAMConfig camConfig = config.findCamConfig(key);
            return new CustomActivityMapScrollableWrapper(this, camDataProvider, camConfig);
        }
        return null;
    }

    @Override
    protected final DividerPanel createDividerPanel() {
        DividerPanel dividerPanel = super.createDividerPanel();
        dividerPanel.setCaptureEnded();
        return dividerPanel;
    }

    private final void addToOpenSet(HeatMapHandlePanel panel, TIntHashSet ids) {
        if (panel.isOpen()) {
            ids.add(panel.getRowUID());
            int i = panel.getChildCount();
            while (--i >= 0) {
                Block block = panel.getChild(i);
                if (!(block instanceof HeatMapHandlePanel)) continue;
                this.addToOpenSet((HeatMapHandlePanel)block, ids);
            }
        }
    }

    private final void setOpenRows(ITimelineRowProvider row, TIntHashSet openIds) {
        switch (row.getRowType()) {
            case VMUID: {
                row.setOpenness(true);
                break;
            }
            case PROCESS: 
            case THREAD: 
            case GROUP: 
            case ANNOTATION: {
                row.setOpenness(openIds.contains(row.getUID()));
                break;
            }
            case CPU: {
                row.setOpenness(false);
                break;
            }
            default: {
                throw new AssertionError((Object)row.getRowType());
            }
        }
        for (ITimelineRowProvider child : row.getChildren()) {
            this.setOpenRows(child, openIds);
        }
    }

    @Override
    public boolean isLiveStopping() {
        return false;
    }
}

