/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.report.ReportMessages;
import com.arm.streamline.widget.Divider;
import com.arm.streamline.widget.TextField;
import com.arm.utils.text.SWTLabelFilter;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class BaseExportDialog
extends TitleAreaDialog
implements SelectionListener {
    private static String defaultPath = null;
    private static ReportProcessor.Format selectedFormat = ReportProcessor.Format.COMMAS;
    private String mMessage;
    private String mHelpKey;
    private String mPath;
    protected Composite mContent;
    private Button mSpacesRadio;
    private Button mTabsRadio;
    private Button mCommasRadio;
    private TextField mPathField;
    private Button mBrowseButton;

    public static ReportProcessor.Format getSelectedFormat() {
        return selectedFormat;
    }

    public static String getDefaultPath() {
        if (defaultPath == null) {
            File home = new File(System.getProperty("user.home"));
            File desktop = new File(home, "Desktop");
            if (desktop.isDirectory() && desktop.canWrite()) {
                home = desktop;
            }
            defaultPath = home.getAbsolutePath();
        }
        return defaultPath;
    }

    public static void setSelectedFormat(ReportProcessor.Format format) {
        selectedFormat = format;
    }

    public static void setDefaultPath(String path) {
        defaultPath = FilePath.getParent((String)path);
    }

    protected static Label createLabel(Composite parent, String title, String tooltip) {
        Label label = new Label(parent, 131072);
        label.setText(title);
        label.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        return label;
    }

    public BaseExportDialog(String path, String message, String helpKey) {
        super(WorkspaceUtils.getShell());
        this.mPath = path;
        this.mMessage = message;
        this.mHelpKey = helpKey;
    }

    public final String getPath() {
        return this.mPath;
    }

    public final void setPath(String path) {
        this.mPath = path.trim();
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.mBrowseButton) {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.csv", "*.txt", "*.*"});
            dialog.setOverwrite(false);
            dialog.setFilterPath(FilePath.getParent((String)this.getPath()));
            dialog.setFileName(FilePath.getLeafName((String)this.getPath()));
            dialog.setFilterNames(new String[]{ReportMessages.TEXT_FILES, ReportMessages.ALL_FILES});
            String fileName = dialog.open();
            if (fileName != null) {
                this.mPathField.setText(fileName);
            }
        } else {
            BaseExportDialog.setSelectedFormat((ReportProcessor.Format)((Object)event.widget.getData()));
            this.mSpacesRadio.setSelection(this.mSpacesRadio == event.widget);
            this.mTabsRadio.setSelection(this.mTabsRadio == event.widget);
            this.mCommasRadio.setSelection(this.mCommasRadio == event.widget);
        }
    }

    protected abstract void addAdditionalOptions();

    protected void addDivider() {
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)new Divider(this.mContent, false));
    }

    protected void adjustAcceptance() {
        this.setPath(this.mPathField.getText());
        String path = this.getPath();
        if (path.isEmpty()) {
            this.setErrorMessage(ReportMessages.MAY_NOT_BE_EMPTY);
            this.getButton(0).setEnabled(false);
        } else if (path.endsWith(File.separator) || new File(path).isDirectory()) {
            this.setErrorMessage(ReportMessages.NO_DIRECTORIES);
            this.getButton(0).setEnabled(false);
        } else {
            BaseExportDialog.setDefaultPath(FilePath.getParent((String)path));
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ReportMessages.DIALOG_TITLE);
    }

    protected final Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(ReportMessages.EXPORT_BUTTON);
        this.adjustAcceptance();
        return control;
    }

    protected final Control createDialogArea(Composite parent) {
        this.setTitle(ReportMessages.DIALOG_TITLE);
        this.setMessage(this.mMessage);
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        GridLayoutFactory.swtDefaults().numColumns(3).extendedMargins(5, 5, 0, 0).applyTo(this.mContent);
        this.addTableFormattingOptions();
        this.addAdditionalOptions();
        this.addDivider();
        this.addOutputPathOptions();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, this.mHelpKey);
        return this.mContent;
    }

    protected void okPressed() {
        File file = new File(this.mPath);
        if (file.exists() && !MessageDialog.openConfirm(null, (String)ReportMessages.EXISTS_TITLE, (String)MessageFormat.format(ReportMessages.EXISTS_FORMAT, this.mPath))) {
            return;
        }
        super.okPressed();
    }

    private void addOutputPathOptions() {
        this.mPathField = this.createPathField(this.mContent, ReportMessages.FILE, ReportMessages.FILE_TOOLTIP, this.getPath());
    }

    private void addTableFormattingOptions() {
        this.mSpacesRadio = this.createFormatRadioButton(this.mContent, ReportMessages.SPACES, ReportMessages.SPACES_TOOLTIP, ReportProcessor.Format.SPACES);
        this.mTabsRadio = this.createFormatRadioButton(this.mContent, ReportMessages.TABS, ReportMessages.TABS_TOOLTIP, ReportProcessor.Format.TABS);
        this.mCommasRadio = this.createFormatRadioButton(this.mContent, ReportMessages.COMMAS, ReportMessages.COMMAS_TOOLTIP, ReportProcessor.Format.COMMAS);
        this.updateInitialFormatSelection();
    }

    private void updateInitialFormatSelection() {
        ReportProcessor.Format fmt = BaseExportDialog.getSelectedFormat();
        this.mTabsRadio.setSelection(fmt == ReportProcessor.Format.TABS);
        this.mSpacesRadio.setSelection(fmt == ReportProcessor.Format.SPACES);
        this.mCommasRadio.setSelection(fmt == ReportProcessor.Format.COMMAS);
    }

    private Button createFormatRadioButton(Composite parent, String title, String tooltip, ReportProcessor.Format format) {
        Button button = new Button(parent, 16);
        button.setData((Object)format);
        button.setSelection(format == selectedFormat);
        button.setText(title);
        button.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        button.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)button);
        return button;
    }

    private TextField createPathField(Composite parent, String label, String tooltip, String defaultPath) {
        BaseExportDialog.createLabel(parent, label, tooltip);
        TextField field = new TextField(parent);
        field.setText(defaultPath);
        field.setToolTipText(tooltip);
        field.setDesiredMinimumTextWidth(50);
        field.addFieldModifiedListener(textField -> this.adjustAcceptance());
        GridDataFactory.fillDefaults().hint(100, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)field);
        this.mBrowseButton = new Button(parent, 8);
        this.mBrowseButton.setText(ReportMessages.BROWSE);
        this.mBrowseButton.setToolTipText(SWTLabelFilter.filterForToolTip((String)ReportMessages.BROWSE_TOOLTIP));
        this.mBrowseButton.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.mBrowseButton);
        return field;
    }
}

