/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.log;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.log.LogEntryRow;
import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.model.annotation.AnnotationThread;
import com.arm.streamline.utility.io.ImageUtils;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class LogOutline
extends AnalysisOutline<LogEntry> {
    private static final int BORDER_WIDTH = 5;
    private String mImagePreviewPath;
    private Image mImagePreview;
    private Rectangle mLastImageVirtualBoundsDrawn;
    private boolean mFullImagePreview;
    private boolean mDrawActionOverlay;

    public LogOutline(@NonNull Composite parent, @NonNull OutlineModel<EnumColumn<LogEntry>> model) {
        super(parent, model, AnalysisOutline.ISelectionMatcher.forNone(), false);
    }

    public void clearMarkers() {
        for (Row row : this.getModel().getRows()) {
            ((LogEntryRow)row).setMarked(false);
        }
        this.redraw();
    }

    @Override
    public void notifyOfSelectionChange() {
        this.redrawImagePreview();
        super.notifyOfSelectionChange();
        Rectangle bounds = this.getImagePreviewBounds();
        if (bounds != null) {
            this.redrawVirtual(this.getInclusiveBounds(bounds));
        }
    }

    public void selectEntryRange(long startMicros, long endMicros) {
        OutlineModel model = this.getModel();
        int count = model.getRowCount();
        HashMap<AnnotationThread, TIntArrayList> threadMap = new HashMap<AnnotationThread, TIntArrayList>();
        int i = 0;
        while (i < count) {
            Row row = model.getRowAtIndex(i);
            LogEntryRow logEntryRow = (LogEntryRow)row;
            LogEntry logEntry = (LogEntry)logEntryRow.getModelObject();
            AnnotationThread at = new AnnotationThread(logEntry.getUniqueProcess(), logEntry.getChannel(), logEntry.isVisualAnnotation());
            TIntArrayList range = (TIntArrayList)threadMap.get(at);
            if (range == null) {
                range = new TIntArrayList();
                threadMap.put(at, range);
            }
            range.add(i);
            logEntryRow.setMarked(false);
            ++i;
        }
        TIntArrayList indexes = new TIntArrayList();
        for (Map.Entry entry : threadMap.entrySet()) {
            TIntArrayList range = (TIntArrayList)entry.getValue();
            int[] array = range.toArray();
            int arrayCount = array.length;
            count = 0;
            int i2 = 0;
            while (i2 < arrayCount) {
                int index = array[i2];
                Row row = model.getRowAtIndex(index);
                LogEntryRow logEntryRow = (LogEntryRow)row;
                LogEntry logEntry = (LogEntry)logEntryRow.getModelObject();
                long from = logEntry.getTimelineMarker();
                long to = logEntry.getEndTimelineMarker();
                if (from <= endMicros && to >= startMicros) {
                    ++count;
                    indexes.add(index);
                    logEntryRow.setMarked(true);
                }
                ++i2;
            }
        }
        if (indexes.isEmpty()) {
            model.deselect();
        } else {
            model.select(indexes.toArray(), false);
            this.selectionDidChange(model);
        }
        this.redraw();
    }

    @Override
    protected void checkOverCustomArea(Point virtualWhere, int stateMask) {
        boolean over = this.isOverImagePreview(virtualWhere);
        if (over != this.mDrawActionOverlay) {
            this.mDrawActionOverlay = over;
            this.redrawImagePreview();
        }
    }

    @Override
    protected String computeTooltip(Point virtualWhere) {
        return this.isOverImagePreview(virtualWhere) ? null : super.computeTooltip(virtualWhere);
    }

    @Override
    protected Outline.MouseState determineMouseState(int x, int y, int stateMask) {
        if (this.mLastImageVirtualBoundsDrawn != null && this.mLastImageVirtualBoundsDrawn.contains(this.toVirtual(new Point(x, y)))) {
            return Outline.MouseState.CUSTOM;
        }
        return super.determineMouseState(x, y, stateMask);
    }

    @Override
    protected void handleCustomMouseUp(Point virtualWhere, int stateMask) {
        this.redrawImagePreview();
        this.mFullImagePreview = !this.mFullImagePreview;
        this.mImagePreviewPath = null;
        this.mLastImageVirtualBoundsDrawn = this.getImagePreviewBounds();
        this.checkOverCustomArea(virtualWhere, stateMask);
        this.redrawImagePreview();
    }

    @Override
    protected void paintCanvas(GC gc) {
        super.paintCanvas(gc);
        this.drawImagePreview(gc);
    }

    private void drawImagePreview(GC gc) {
        this.mLastImageVirtualBoundsDrawn = this.getImagePreviewBounds();
        if (this.mLastImageVirtualBoundsDrawn != null) {
            Rectangle bounds = new Rectangle(this.mLastImageVirtualBoundsDrawn.x, this.mLastImageVirtualBoundsDrawn.y, this.mLastImageVirtualBoundsDrawn.width, this.mLastImageVirtualBoundsDrawn.height);
            gc.setForeground(Colors.getBlack());
            --bounds.width;
            --bounds.height;
            int i = 0;
            while (i < 5) {
                gc.setAlpha(25 * (i + 1));
                gc.drawRectangle(bounds);
                ++bounds.x;
                ++bounds.y;
                bounds.width -= 2;
                bounds.height -= 2;
                ++i;
            }
            gc.setAlpha(255);
            gc.drawImage(this.mImagePreview, this.mLastImageVirtualBoundsDrawn.x + 5, this.mLastImageVirtualBoundsDrawn.y + 5);
            this.mDrawActionOverlay = this.mLastImageVirtualBoundsDrawn.contains(this.toVirtual(this.toControl(this.getDisplay().getCursorLocation())));
            if (this.mDrawActionOverlay) {
                Image image = StreamlinePlugin.getImage(this.mFullImagePreview ? "CollapseImage.png" : "ExpandImage.png");
                gc.drawImage(image, this.mLastImageVirtualBoundsDrawn.x + this.mLastImageVirtualBoundsDrawn.width - (image.getBounds().width + 10), this.mLastImageVirtualBoundsDrawn.y + 10);
            }
        }
    }

    private Rectangle getImagePreviewBounds() {
        LogEntry logEntry;
        OutlineModel model = this.getModel();
        if (model.getSelectionCount() == 1 && (logEntry = (LogEntry)((LogEntryRow)model.getSelectionAsList().get(0)).getModelObject()).isVisualAnnotation()) {
            String path;
            String string = path = this.mFullImagePreview ? logEntry.getImagePath() : logEntry.getThumbnailPath();
            if (!path.equals(this.mImagePreviewPath)) {
                this.mImagePreviewPath = path;
                if (this.mImagePreview != null && this.mImagePreview != StreamlinePlugin.getImage("ImageError.png")) {
                    this.mImagePreview.dispose();
                }
                this.mImagePreview = ImageUtils.load((Device)this.getDisplay(), this.mImagePreviewPath);
                if (this.mImagePreview == null) {
                    this.mImagePreview = StreamlinePlugin.getImage("ImageError.png");
                }
            }
            Rectangle clientArea = this.toVirtual(this.getClientArea());
            Rectangle imageBounds = this.mImagePreview.getBounds();
            return new Rectangle(clientArea.x + clientArea.width - (imageBounds.width + 10 + 10), clientArea.y + 20, imageBounds.width + 10, imageBounds.height + 10);
        }
        return null;
    }

    private Rectangle getInclusiveBounds(Rectangle previewBounds) {
        int height;
        previewBounds = new Rectangle(previewBounds.x, previewBounds.y, previewBounds.width, previewBounds.height);
        Image image = StreamlinePlugin.getImage(this.mFullImagePreview ? "CollapseImage.png" : "ExpandImage.png");
        Rectangle actionOverlayBounds = image.getBounds();
        int width = actionOverlayBounds.width + 10;
        if (previewBounds.width < width) {
            previewBounds.x += previewBounds.width - width;
            previewBounds.width = width;
        }
        if (previewBounds.height < (height = actionOverlayBounds.height + 10)) {
            previewBounds.height = height;
        }
        return previewBounds;
    }

    private boolean isOverImagePreview(Point virtualWhere) {
        return this.mLastImageVirtualBoundsDrawn != null && this.mLastImageVirtualBoundsDrawn.contains(virtualWhere.x, virtualWhere.y);
    }

    private void redrawImagePreview() {
        if (this.mLastImageVirtualBoundsDrawn != null) {
            this.redrawVirtual(this.getInclusiveBounds(this.mLastImageVirtualBoundsDrawn));
        }
    }
}

