/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import org.eclipse.jface.action.Action;

public class ExpandCollapseAllAction
extends Action
implements IOutlineModelListener<EnumColumn<CallPathRowValue>> {
    private Outline<EnumColumn<CallPathRowValue>> mOutline;
    private boolean mExpand;
    private boolean mInProgress;

    public ExpandCollapseAllAction(Outline<EnumColumn<CallPathRowValue>> outline, boolean expand) {
        super(expand ? CallPathMessages.EXPAND_ALL : CallPathMessages.COLLAPSE_ALL, StreamlinePlugin.getImageDescriptor(expand ? "ExpandAll.gif" : "CollapseAll.gif"));
        this.mOutline = outline;
        this.mExpand = expand;
        this.updateState();
        this.mOutline.getModel().addListener(this);
    }

    @Override
    public void rowsAdded(OutlineModel<EnumColumn<CallPathRowValue>> model, Row<EnumColumn<CallPathRowValue>>[] rows) {
        this.updateState();
    }

    @Override
    public void rowsWereRemoved(OutlineModel<EnumColumn<CallPathRowValue>> model, Row<EnumColumn<CallPathRowValue>>[] rows) {
        this.updateState();
    }

    @Override
    public void rowsWillBeRemoved(OutlineModel<EnumColumn<CallPathRowValue>> model, Row<EnumColumn<CallPathRowValue>>[] rows) {
    }

    public final void run() {
        this.mInProgress = true;
        if (this.mExpand) {
            this.mOutline.openAllRows();
        } else {
            this.mOutline.closeAllRows();
        }
        this.mInProgress = false;
        this.updateState();
    }

    @Override
    public void selectionDidChange(OutlineModel<EnumColumn<CallPathRowValue>> model) {
        this.updateState();
    }

    @Override
    public void selectionWillChange(OutlineModel<EnumColumn<CallPathRowValue>> model) {
    }

    @Override
    public void sortCleared(OutlineModel<EnumColumn<CallPathRowValue>> model) {
    }

    @Override
    public void sorted(OutlineModel<EnumColumn<CallPathRowValue>> model, boolean restoring) {
    }

    private void updateState() {
        if (!this.mInProgress) {
            this.setEnabled(this.mOutline.getModel().getRowCount() > 0);
        }
    }
}

