/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.IUpdateOnDisplayTab;
import com.arm.streamline.editortabs.InstructionCounterOutlineUpdater;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.StreamlineContextMenu;
import com.arm.streamline.editortabs.callpath.CallPathColumn;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.callpath.CallPathFunctionContributor;
import com.arm.streamline.editortabs.callpath.CallPathFunctionRow;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathOutline;
import com.arm.streamline.editortabs.callpath.CallPathOutlineContributor;
import com.arm.streamline.editortabs.callpath.CallPathRow;
import com.arm.streamline.editortabs.callpath.ExpandCollapseAllAction;
import com.arm.streamline.editortabs.callpath.ICallPathColumn;
import com.arm.streamline.editortabs.callpath.ICallPathFunctionColumn;
import com.arm.streamline.editortabs.callpath.ToggleCallpathTotalsAction;
import com.arm.streamline.editortabs.callpath.ToggleFilterCallStacksAction;
import com.arm.streamline.editortabs.callpath.ToggleFilterKernelAddressesAction;
import com.arm.streamline.editortabs.callpath.ToggleInvertCallStacksAction;
import com.arm.streamline.editortabs.callpath.ToggleUseInlinesAction;
import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.ExportTableAction;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ICallPathFunctions;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.CallPathFunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.Splitter;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.actions.ActionFactory;

public class CallPathTab
extends EditorTab
implements FilterField.IFilterMatcher,
ICommandTarget,
ISelectionChangedListener,
IUpdateOnDisplayTab {
    private AnalysisOutline<CallPathFunctionRowValue> mCallPathFunctionOutline;
    private CallPathOutline mCallPathOutline;
    private FilterField mFilterField;
    private Composite mFunctionArea;
    private ToolbarReadout mSamplesField;
    private @Nullable TIntSet previouslySelectedPidsAndTids;
    private ToolbarReadout mTotalsField;
    private InstructionCounterCallPathOutlineUpdater updateListener;
    private @Nullable ToggleFilterCallStacksAction filterCallStacksAction;
    private @Nullable ToggleFilterKernelAddressesAction filterKernelAddressesAction;
    private @Nullable ToggleUseInlinesAction useInlinesAction;
    private @Nullable ToggleInvertCallStacksAction invertCallStacksAction;
    private @Nullable ToggleCallpathTotalsAction useTotalsAction;

    private static void createPlaceholder(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        ControlHacks.setBackground((Control)wrapper, Colors.getListBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        Label label = new Label(wrapper, 0x1000040);
        label.setText(CallPathMessages.SELECT);
        ControlHacks.setBackground((Control)label, Colors.getListBackground());
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)new Label(parent, 258));
    }

    public CallPathTab(@NonNull AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
        super(editor, baseTimelineContent);
        this.init();
    }

    @Override
    public void dispose() {
        if (this.updateListener != null) {
            this.getInstructionCounterViewModel().propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)this.updateListener);
        }
        super.dispose();
    }

    @Override
    public void findMatches(FilterField field) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        String config = this.mCallPathOutline.getConfig();
        OutlineModel<EnumColumn<CallPathRowValue>> model = this.mCallPathOutline.getModel();
        HashSet<CallPathRowValue> selected = new HashSet<CallPathRowValue>();
        for (Row row : model.getSelectionAsList()) {
            selected.add((CallPathRowValue)((CallPathRow)row).getModelObject());
        }
        @NonNull ArrayList<@NonNull E> selection = new ArrayList();
        this.mCallPathOutline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        model.removeAllRows();
        Pattern pattern = field.getPattern();
        boolean emptyPattern = pattern.pattern().isEmpty();
        if (instructionCounterSource != null) {
            CallPathTab.populateModel(instructionCounterSource, this.previouslySelectedPidsAndTids, model, pattern);
        }
        this.mCallPathOutline.applyConfig(config, true, true);
        this.mCallPathOutline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        this.mCallPathOutline.adjustScrollBarsForContent();
        if (emptyPattern && !selected.isEmpty()) {
            @NonNull ArrayList<@NonNull Row<EnumColumn<CallPathRowValue>>> rows = new ArrayList<Row<EnumColumn<CallPathRowValue>>>();
            for (Row<EnumColumn<CallPathRowValue>> row : model.getTopLevelRows()) {
                this.collectMatches(rows, selected, row);
            }
            model.select(rows, false);
        } else if (!selection.isEmpty()) {
            model.select(selection, false);
        }
        this.mCallPathOutline.notifyOfSelectionChange();
    }

    public CallPathOutline getCallPathOutline() {
        return this.mCallPathOutline;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.mCallPathOutline;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mFilterField.handleCommand(command)) {
            if (this.mCallPathFunctionOutline != null && this.mCallPathFunctionOutline.isFocusControl()) {
                this.mCallPathFunctionOutline.obeyCommand(commandAction);
            } else if (this.mCallPathOutline.isFocusControl()) {
                this.mCallPathOutline.obeyCommand(commandAction);
            }
        }
    }

    @Override
    public void onTabDisplayed() {
        this.reloadOutline(false);
    }

    private void reloadOutline(boolean force) {
        boolean newIsEmpty;
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntSet newlySelectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        TIntSet previouslySelectedPidsAndTids = this.previouslySelectedPidsAndTids;
        boolean previousIsEmpty = previouslySelectedPidsAndTids == null || previouslySelectedPidsAndTids.isEmpty();
        boolean bl = newIsEmpty = newlySelectedPidsAndTids == null || newlySelectedPidsAndTids.isEmpty();
        if (newIsEmpty) {
            if (force || !previousIsEmpty) {
                this.previouslySelectedPidsAndTids = null;
                this.updateListener.recomputeFromModelChange(instructionCounterSource);
            }
        } else if (force || previousIsEmpty || !NullChecking.equalsNullable((Object)previouslySelectedPidsAndTids, (Object)newlySelectedPidsAndTids)) {
            TIntHashSet copyOfNew = new TIntHashSet((TIntCollection)newlySelectedPidsAndTids);
            this.previouslySelectedPidsAndTids = copyOfNew;
            this.updateListener.recomputeFromModelChange(instructionCounterSource);
        }
    }

    @Override
    public void recomputeFromModel() {
        final CallPathOutline callPathOutline = this.mCallPathOutline;
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!callPathOutline.isDisposed()) {
                    CallPathTab.this.reloadOutline(true);
                }
            }
        });
    }

    public void select(CallPathRowValue ... paths) {
        OutlineModel<EnumColumn<CallPathRowValue>> model = this.mCallPathOutline.getModel();
        ArrayList<@NonNull Row<EnumColumn<CallPathRowValue>>> rows = new ArrayList<Row<EnumColumn<CallPathRowValue>>>();
        HashSet<CallPathRowValue> set = new HashSet<CallPathRowValue>();
        CallPathRowValue[] callPathRowValueArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            CallPathRowValue callPathRowValue = callPathRowValueArray[n2];
            set.add(callPathRowValue);
            ++n2;
        }
        for (Row<EnumColumn<CallPathRowValue>> row : model.getTopLevelRows()) {
            this.collectMatches(rows, set, row);
        }
        model.select(rows, false);
        this.mCallPathOutline.scrollSelectionIntoView(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        @NonNull List<Row<C>> rows = this.mCallPathOutline.getModel().getSelectionAsList();
        int count = rows.size();
        boolean needLayout = this.mTotalsField != null ? this.mTotalsField.setText(NumberUtils.prettyFormat((int)count)) : true;
        @NonNull String text = instructionCounterSource != null && !rows.isEmpty() ? CallPathTab.calculateCallPathTabSelectionText(instructionCounterSource, rows.stream().map(row -> (CallPathRow)row).map(ReportRow::getModelObject)) : CallPathMessages.NA;
        if (needLayout |= this.mSamplesField != null ? this.mSamplesField.setText(text) : true) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    private static @NonNull String calculateCallPathTabSelectionText(@NonNull IInstructionCounterSource source, @NonNull Stream<@NonNull CallPathRowValue> selectionStream) {
        ISampleCounterColumnAccessorFactory.PercentAndLong value = source.calculateCallPathTabSelectionValue(selectionStream);
        if (value == null) {
            return CallPathMessages.NA;
        }
        return MessageFormat.format(CallPathMessages.SAMPLES_FORMAT, NumberUtils.format((long)value.value()), NumberUtils.formatPercentage((double)value.percent(), (boolean)false));
    }

    public boolean setFocus() {
        return this.mCallPathOutline.setFocus();
    }

    @Override
    public void sourceFilePathChanged() {
        this.mCallPathOutline.redraw();
        if (this.mCallPathFunctionOutline != null) {
            this.mCallPathFunctionOutline.redraw();
        }
    }

    @Override
    protected Composite createContent() {
        Composite content = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        Splitter splitter = new Splitter(content, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)splitter);
        this.createCallPathOutline((Composite)splitter);
        this.createFunctionArea((Composite)splitter);
        splitter.setWeights(new int[]{70, 30});
        return content;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        @NonNull CallPathOutline mCallPathOutline = (CallPathOutline)NullChecking.neverNull((Object)this.mCallPathOutline);
        toolbar.addAction(new ExpandCollapseAllAction(mCallPathOutline, true));
        toolbar.addAction(new ExpandCollapseAllAction(mCallPathOutline, false));
        if (analysis.canFilterStacksDynamically()) {
            this.filterCallStacksAction = new ToggleFilterCallStacksAction(analysis);
            toolbar.addAction(this.filterCallStacksAction);
            this.filterKernelAddressesAction = new ToggleFilterKernelAddressesAction(analysis);
            toolbar.addAction(this.filterKernelAddressesAction);
            this.invertCallStacksAction = new ToggleInvertCallStacksAction(analysis);
            this.useInlinesAction = new ToggleUseInlinesAction(analysis);
            toolbar.addAction(this.useInlinesAction);
            this.useTotalsAction = new ToggleCallpathTotalsAction(preferTotals -> this.updateListener.recomputeFromPreferTotalsChange(preferTotals));
            toolbar.addAction(this.useTotalsAction);
        }
        toolbar.addAction(new OpenSourceFileAction(analysis::computeFullPath, mCallPathOutline, analysis::showPathSubstitutionDialog)).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        this.mFilterField = new FilterField(toolbar, this, CallPathMessages.FILTER, CallPathMessages.FILTER_TOOLTIP);
        this.mFilterField.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setGap(5));
        this.mTotalsField = new ToolbarReadout(toolbar, NumberUtils.prettyFormat((int)0), 131072, CallPathMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(5));
        this.mSamplesField = new ToolbarReadout(toolbar, CallPathMessages.NA, 131072, CallPathMessages.SAMPLES_TOOLTIP);
        this.mSamplesField.setDesiredMinimumTextWidth(FontInfo.get(this.mSamplesField.getFont()).getWidth("0000000000000000"));
        this.mSamplesField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mSamplesField.computeSize((int)-1, (int)-1).x).setGap(5));
        toolbar.addAction(new ExportTableAction(analysis, mCallPathOutline, "call_paths_for_{0}.csv"));
        this.updateListener.refresh();
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.call_path";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        String id = ActionFactory.SELECT_ALL.getId();
        map.put(id, (IAction)new CommandAction(id, this));
        id = ActionFactory.COPY.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    protected final void loadCallPathOutline(@Nullable IInstructionCounterSource instructionCounterSource, @Nullable TIntSet selectedPidsAndTids) {
        Pattern pattern;
        String config = this.mCallPathOutline.getConfig();
        this.mCallPathOutline.setAllowLazyAdjust(false);
        OutlineModel<EnumColumn<CallPathRowValue>> outlineModel = this.mCallPathOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        Pattern pattern2 = pattern = this.mFilterField != null && !this.mFilterField.getText().trim().isEmpty() ? this.mFilterField.getPattern() : null;
        if (instructionCounterSource != null) {
            CallPathTab.populateModel(instructionCounterSource, selectedPidsAndTids, outlineModel, pattern);
        }
        this.mCallPathOutline.applyConfig(config, true, true);
        this.mCallPathOutline.setAllowLazyAdjust(true);
        this.mCallPathOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        this.mCallPathOutline.getDefaultConfig();
        this.mCallPathOutline.adjustScrollBarsForContent();
        this.mCallPathOutline.openAllRows();
    }

    private static void populateModel(@NonNull IInstructionCounterSource instructionCounterSource, @Nullable TIntSet selectedPidsAndTids, @NonNull OutlineModel<EnumColumn<CallPathRowValue>> outlineModel, @Nullable Pattern pattern) {
        boolean showProcesses = instructionCounterSource.getModel().shouldShowProcesses();
        CallPathRow.FilterMode filterMode = showProcesses ? CallPathRow.FilterMode.MATCH_PROCESS_OR_THREAD : CallPathRow.FilterMode.DISCARD_PROCESSES_ONLY_FILTER_THREADS;
        Predicate<@NonNull CallPathRowValue> keepProcessOrThread = node -> selectedPidsAndTids == null || selectedPidsAndTids.isEmpty() || selectedPidsAndTids.contains(Math.toIntExact(node.getCallPathNode().itemUID));
        Predicate<@NonNull CallPathRowValue> nodeFilter = node -> pattern == null || node.matches(pattern);
        for (CallPathRowValue callPathRowValue : instructionCounterSource.getCallPathRoots()) {
            List<CallPathRow> rows = CallPathRow.buildRecursive(callPathRowValue, filterMode, keepProcessOrThread, nodeFilter);
            for (CallPathRow row : rows) {
                outlineModel.addRow(row, true);
            }
        }
        if (outlineModel.getRecursiveRowCount() > 10000) {
            for (EnumColumn enumColumn : outlineModel.getColumns()) {
                @NonNull ICallPathColumn one = (ICallPathColumn)enumColumn.getColumnEnum();
                if (one.isHiddenFromUi()) continue;
                enumColumn.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, enumColumn.getMaxWidth()));
            }
        }
    }

    private void collectMatches(List<Row<EnumColumn<CallPathRowValue>>> rows, Set<CallPathRowValue> set, Row<EnumColumn<CallPathRowValue>> row) {
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                this.collectMatches(rows, set, child);
            }
        }
        if (set.contains(((CallPathRow)row).getModelObject())) {
            rows.add(row);
            row.disclose();
        }
    }

    private Composite createCallPathOutline(Composite parent) {
        CallPathOutline mCallPathOutline;
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        Composite wrapper = new Composite(parent, 0);
        ControlHacks.setBackground((Control)wrapper, Colors.getWidgetBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        Header header = new Header(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        OutlineModel<EnumColumn<CallPathRowValue>> model = new OutlineModel<EnumColumn<CallPathRowValue>>();
        this.mCallPathOutline = mCallPathOutline = new CallPathOutline(wrapper, model, true);
        mCallPathOutline.setAnalysis(analysis);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mCallPathOutline);
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntSet selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        this.previouslySelectedPidsAndTids = selectedPidsAndTids != null ? new TIntHashSet((TIntCollection)selectedPidsAndTids) : null;
        mCallPathOutline.addOutlineListener(new CallPathOutlineListener());
        mCallPathOutline.addSelectionChangedListener(this);
        mCallPathOutline.setHeader(header);
        ContextMenu cm = StreamlineContextMenu.createStdContextMenu(this.getEditor(), (Control)mCallPathOutline, EditorTabID.CALL_PATH);
        cm.add(new CallPathOutlineContributor(symbol -> {
            @Nullable @NonNull IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
            if (instructionCounterSource != null) {
                return instructionCounterSource.mapCallPathsForSymbol(symbol);
            }
            assert (false);
            return Collections.emptySet();
        }));
        this.updateListener = new InstructionCounterCallPathOutlineUpdater(mCallPathOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue(), false);
        instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)this.updateListener);
        return wrapper;
    }

    private Composite createFunctionArea(Composite parent) {
        this.mFunctionArea = new Composite(parent, 0);
        ControlHacks.setBackground((Control)this.mFunctionArea, Colors.getWidgetBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.mFunctionArea);
        CallPathTab.createPlaceholder(this.mFunctionArea);
        return this.mFunctionArea;
    }

    private @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.requireEditor().requireInstructionCountersViewModel();
    }

    protected static final void loadCallPathFunctionOutline(@NonNull AnalysisOutline<CallPathFunctionRowValue> mCallPathFunctionOutline, @Nullable IInstructionCounterSource instructionCounterSource, @Nullable ICallPathFunctions dataView) {
        if (mCallPathFunctionOutline.isDisposed()) {
            return;
        }
        @NonNull String config = mCallPathFunctionOutline.getConfig();
        mCallPathFunctionOutline.setAllowLazyAdjust(false);
        @NonNull OutlineModel<EnumColumn<CallPathFunctionRowValue>> outlineModel = mCallPathFunctionOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        if (dataView != null && instructionCounterSource != null) {
            for (ReferencedSymbol symbol : dataView.getReferencedSymbols()) {
                Set allCallPaths = instructionCounterSource.mapCallPathsForSymbol(symbol);
                CallPathFunctionRowValue cpf = new CallPathFunctionRowValue(instructionCounterSource, symbol, allCallPaths.stream().filter(p -> p.isDescendantOf(dataView.getRootCallPathNode())).collect(Collectors.toUnmodifiableSet()));
                outlineModel.addRow(new CallPathFunctionRow(cpf), false);
            }
            if (outlineModel.getRecursiveRowCount() > 10000) {
                for (EnumColumn column : outlineModel.getColumns()) {
                    @NonNull ICallPathFunctionColumn one = (ICallPathFunctionColumn)column.getColumnEnum();
                    column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, column.getMaxWidth()));
                }
            }
        }
        mCallPathFunctionOutline.applyConfig(config, true, true);
        mCallPathFunctionOutline.setAllowLazyAdjust(true);
        mCallPathFunctionOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        mCallPathFunctionOutline.getDefaultConfig();
        mCallPathFunctionOutline.adjustScrollBarsForContent();
    }

    protected static final @NonNull List<@NonNull CallPathFunctionContributor.ICallPathFunctionContributorSortProperties> createCallPathFunctionsMenuContributionSorters(@NonNull InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater) {
        ICallPathFunctions currentDataSet = callPathFunctionUpdater.currentDataSet;
        if (currentDataSet == null) {
            return Collections.emptyList();
        }
        final LongFunction supplier = currentDataSet.getTopCallpathsMetricSupplier();
        if (supplier == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new CallPathFunctionContributor.ICallPathFunctionContributorSortProperties(){

            @Override
            public @NonNull String getName() {
                return CallPathMessages.TOP_LINKS;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getMetric(@NonNull CallPathNode callPath) {
                return (ISampleCounterColumnAccessorFactory.PercentAndLong)supplier.apply(callPath.uid);
            }
        });
    }

    private void updateFilterActions(boolean filterEnabled, boolean inlineEnabled, boolean invertEnabled, boolean enableTotals) {
        ToggleFilterCallStacksAction filterCallStacksAction = this.filterCallStacksAction;
        ToggleFilterKernelAddressesAction filterKernelAddressesAction = this.filterKernelAddressesAction;
        ToggleUseInlinesAction useInlinesAction = this.useInlinesAction;
        ToggleInvertCallStacksAction invertCallStacksAction = this.invertCallStacksAction;
        ToggleCallpathTotalsAction useTotalsAction = this.useTotalsAction;
        if (filterCallStacksAction != null) {
            filterCallStacksAction.setEnabled(filterEnabled);
        }
        if (filterKernelAddressesAction != null) {
            filterKernelAddressesAction.setEnabled(filterEnabled);
        }
        if (useInlinesAction != null) {
            useInlinesAction.setEnabled(inlineEnabled);
        }
        if (invertCallStacksAction != null) {
            invertCallStacksAction.setEnabled(invertEnabled);
        }
        if (useTotalsAction != null) {
            useTotalsAction.setEnabled(enableTotals);
        }
    }

    private final class CallPathFunctionOutlineListener
    implements IOutlineListener<EnumColumn<CallPathFunctionRowValue>> {
        @Override
        public void deleteSelectionRequested(Outline<EnumColumn<CallPathFunctionRowValue>> outline) {
        }

        @Override
        public void editorChanged(Outline<EnumColumn<CallPathFunctionRowValue>> outline) {
        }

        @Override
        public void openSelectionRequested(Outline<EnumColumn<CallPathFunctionRowValue>> outline) {
            ArrayList paths = new ArrayList();
            OutlineModel<EnumColumn<CallPathFunctionRowValue>> model = outline.getModel();
            StdSelection selection = model.getSelection();
            int index = selection.firstSelectedIndex();
            while (index >= 0) {
                CallPathFunctionRowValue cpf = (CallPathFunctionRowValue)((CallPathFunctionRow)model.getRowAtIndex(index)).getModelObject();
                paths.addAll(cpf.getCallPaths());
                index = selection.nextSelectedIndex(index + 1);
            }
            if (!paths.isEmpty()) {
                CallPathTab.this.requireEditor().select(EditorTabID.CALL_PATH, (ISelection)new StructuredSelection(paths.toArray()));
            }
        }

        @Override
        public void selectionChanged(Outline<EnumColumn<CallPathFunctionRowValue>> outline) {
        }
    }

    private final class CallPathOutlineListener
    implements IOutlineListener<EnumColumn<CallPathRowValue>> {
        private @Nullable InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater;

        @Override
        public void deleteSelectionRequested(Outline<EnumColumn<CallPathRowValue>> outline) {
        }

        @Override
        public void editorChanged(Outline<EnumColumn<CallPathRowValue>> outline) {
        }

        @Override
        public void openSelectionRequested(Outline<EnumColumn<CallPathRowValue>> outline) {
            ArrayList<CallPathRowValue> paths = new ArrayList<CallPathRowValue>();
            OutlineModel<EnumColumn<CallPathRowValue>> model = outline.getModel();
            StdSelection selection = model.getSelection();
            int index = selection.firstSelectedIndex();
            while (index >= 0) {
                CallPathRowValue path = (CallPathRowValue)((CallPathRow)model.getRowAtIndex(index)).getModelObject();
                if (!path.isStructureOnlyNode()) {
                    paths.add(path);
                }
                index = selection.nextSelectedIndex(index + 1);
            }
            if (!paths.isEmpty()) {
                CallPathTab.this.requireEditor().select(EditorTabID.CODE, (ISelection)new StructuredSelection(paths.toArray()));
            }
        }

        @Override
        public void selectionChanged(Outline<EnumColumn<CallPathRowValue>> outline) {
            @NonNull Analysis analysis = CallPathTab.this.getAnalysis();
            @NonNull InstructionCountersViewModel instructionCounterViewModel = CallPathTab.this.getInstructionCounterViewModel();
            @NonNull OutlineModel<EnumColumn<CallPathRowValue>> model = outline.getModel();
            @Nullable AnalysisOutline<CallPathFunctionRowValue> callPathFunctionOutline = CallPathTab.this.mCallPathFunctionOutline;
            if (model.getSelectionCount() == 1) {
                CallPathRowValue selection = (CallPathRowValue)((CallPathRow)NullChecking.neverNull((Object)((CallPathRow)model.getFirstSelectedRow()))).getModelObject();
                if (callPathFunctionOutline == null) {
                    InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater;
                    WidgetUtils.disposeAllChildren(CallPathTab.this.mFunctionArea);
                    Header header = new Header(CallPathTab.this.mFunctionArea);
                    GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
                    OutlineModel subModel = new OutlineModel();
                    subModel.setUserRef(model.getUserRef());
                    AnalysisOutline<CallPathFunctionRowValue> mCallPathFunctionOutline = new AnalysisOutline<CallPathFunctionRowValue>((Composite)NullChecking.neverNull((Object)CallPathTab.this.mFunctionArea), subModel, AnalysisOutline.ISelectionMatcher.forCallPathFunctions(), false);
                    CallPathTab.this.mCallPathFunctionOutline = mCallPathFunctionOutline;
                    mCallPathFunctionOutline.setAnalysis(analysis);
                    GridDataFactory.fillDefaults().grab(true, true).applyTo(mCallPathFunctionOutline);
                    mCallPathFunctionOutline.addOutlineListener(new CallPathFunctionOutlineListener());
                    mCallPathFunctionOutline.setHeader(header);
                    ContextMenu cm = StreamlineContextMenu.createStdContextMenu(CallPathTab.this.getEditor(), mCallPathFunctionOutline, new EditorTabID[0]);
                    this.callPathFunctionUpdater = callPathFunctionUpdater = new InstructionCounterCallPathFunctionOutlineUpdater(mCallPathFunctionOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue(), selection);
                    instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)callPathFunctionUpdater);
                    cm.add(new CallPathFunctionContributor(() -> CallPathTab.createCallPathFunctionsMenuContributionSorters(callPathFunctionUpdater)));
                    CallPathTab.this.layout(true, true);
                } else {
                    InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater = (InstructionCounterCallPathFunctionOutlineUpdater)NullChecking.neverNull((Object)this.callPathFunctionUpdater);
                    callPathFunctionUpdater.setSelection(selection);
                }
            } else if (callPathFunctionOutline != null) {
                @Nullable InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater = this.callPathFunctionUpdater;
                if (callPathFunctionUpdater != null) {
                    instructionCounterViewModel.propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)callPathFunctionUpdater);
                    this.callPathFunctionUpdater = null;
                }
                CallPathTab.this.mCallPathFunctionOutline = null;
                WidgetUtils.disposeAllChildren(CallPathTab.this.mFunctionArea);
                CallPathTab.createPlaceholder(CallPathTab.this.mFunctionArea);
                CallPathTab.this.layout(true, true);
            }
        }
    }

    public final class InstructionCounterCallPathFunctionOutlineUpdater
    implements IValueChangeListener<IInstructionCounterSource> {
        private final @NonNull AnalysisOutline<CallPathFunctionRowValue> outline;
        private final @NonNull Map<@NonNull IInstructionCounterSource, @NonNull String> currentColumnConfiguration = new HashMap<IInstructionCounterSource, String>();
        private final @NonNull Map<@NonNull IInstructionCounterSource, @NonNull ICallPathFunctions> currentDataViews = new HashMap<IInstructionCounterSource, ICallPathFunctions>();
        private @NonNull CallPathRowValue currentCallPath;
        private @Nullable IInstructionCounterSource currentSource;
        private @Nullable ICallPathFunctions currentDataSet;

        public InstructionCounterCallPathFunctionOutlineUpdater(@Nullable AnalysisOutline<CallPathFunctionRowValue> outline, @NonNull IInstructionCounterSource instructionCounterSource, CallPathRowValue currentCallPath) {
            this.outline = outline;
            this.currentCallPath = currentCallPath;
            this.currentSource = instructionCounterSource;
            this.updateInstructionCounterSource(null, instructionCounterSource);
        }

        public void setSelection(@NonNull CallPathRowValue currentCallPath) {
            if (currentCallPath != this.currentCallPath) {
                this.currentCallPath = currentCallPath;
                this.currentDataViews.clear();
                this.updateInstructionCounterSource(this.currentSource, this.currentSource);
            }
        }

        public final void handleValueChange(ValueChangeEvent<? extends @Nullable IInstructionCounterSource> event) {
            this.updateInstructionCounterSource((IInstructionCounterSource)event.diff.getOldValue(), (IInstructionCounterSource)event.diff.getNewValue());
        }

        private void updateInstructionCounterSource(@Nullable IInstructionCounterSource previousCounterSource, @Nullable IInstructionCounterSource instructionCounterSource) {
            String config;
            if (previousCounterSource != null) {
                this.currentColumnConfiguration.put(previousCounterSource, this.outline.getConfig());
            }
            ICallPathFunctions dataView = instructionCounterSource != null ? this.currentDataViews.computeIfAbsent(instructionCounterSource, new Function<IInstructionCounterSource, ICallPathFunctions>(){

                @Override
                public @NonNull ICallPathFunctions apply(@NonNull IInstructionCounterSource k) {
                    return k.getActiveReportData().computeCallPathFunctions(InstructionCounterCallPathFunctionOutlineUpdater.this.currentCallPath.getCallPathNode());
                }
            }) : null;
            this.currentDataSet = dataView;
            this.outline.getModel().removeAllColumns();
            ColumnUtils.createColumns(this.outline.getModel(), CallPathFunctionColumn.aggregateColumns(dataView), null);
            CallPathTab.loadCallPathFunctionOutline(this.outline, instructionCounterSource, dataView);
            if (instructionCounterSource != null && (config = this.currentColumnConfiguration.get(instructionCounterSource)) != null) {
                this.outline.applyConfig(config, false, false);
            }
        }
    }

    public final class InstructionCounterCallPathOutlineUpdater
    extends InstructionCounterOutlineUpdater<CallPathRowValue, ICallPathColumn> {
        public InstructionCounterCallPathOutlineUpdater(@Nullable AnalysisOutline<CallPathRowValue> outline, IInstructionCounterSource instructionCounterSource, boolean preferTotal) {
            super(outline, instructionCounterSource, preferTotal);
        }

        @Override
        protected @NonNull Iterable<@NonNull ICallPathColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource, boolean preferTotals) {
            return CallPathColumn.aggregateColumns(instructionCounterSource, preferTotals);
        }

        @Override
        protected void populateOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
            CallPathTab.this.loadCallPathOutline(instructionCounterSource, CallPathTab.this.previouslySelectedPidsAndTids);
        }

        @Override
        protected void updateOtherUiElements(@Nullable IInstructionCounterSource instructionCounterSource) {
            CallPathTab.this.updateFilterActions(instructionCounterSource != null && instructionCounterSource.canFilterStacksDynamically(), instructionCounterSource != null, instructionCounterSource != null, instructionCounterSource != null && instructionCounterSource.canShowCallPathTotalsColumns());
        }
    }
}

