/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathTab;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.model.iterable.CallPathSelectionIterator;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.utils.NullChecking;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.MenuItem;

public final class CallPathOutlineContributor
implements IContextMenuContributor {
    private @Nullable Set<@NonNull CallPathRowValue> mExpansion;
    private final @NonNull Function<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathRowValue>> symbolToReferencingNodes;

    public CallPathOutlineContributor(@NonNull Function<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathRowValue>> symbolToReferencingNodes) {
        this.symbolToReferencingNodes = symbolToReferencingNodes;
    }

    @Override
    public void cleanup(ContextMenu cm) {
        this.mExpansion = null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (CallPathMessages.EXPAND_TO_MATCHING.equals(commandID)) {
            Set mExpansion = (Set)NullChecking.neverNull(this.mExpansion);
            CallPathTab tab = (CallPathTab)WidgetUtils.getAncestorOfType(cm.getHandlerControl(), CallPathTab.class);
            tab.select((CallPathRowValue[])mExpansion.toArray(CallPathRowValue[]::new));
        } else if (CallPathMessages.COLLAPSE_UNSELECTED.equals(commandID)) {
            ((Outline)cm.getHandlerControl()).closeUnselectedRows();
        } else if (CallPathMessages.EXPAND_UNSELECTED.equals(commandID)) {
            ((Outline)cm.getHandlerControl()).openUnselectedRows();
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        if (cm.getHandlerControl() instanceof Outline) {
            this.mExpansion = new HashSet<CallPathRowValue>();
            HashSet<CallPathRowValue> mExpansion = this.mExpansion;
            HashSet<CallPathNode> selectionNodes = new HashSet<CallPathNode>();
            HashSet expansionNodes = new HashSet();
            for (CallPathNode link : new CallPathSelectionIterator(cm.getSelection())) {
                ReferencedSymbol function;
                if (link != null) {
                    selectionNodes.add(link);
                }
                ReferencedSymbol referencedSymbol = function = link != null ? link.symbol : null;
                if (link == null || function == null) continue;
                Set<CallPathRowValue> pathRows = this.symbolToReferencingNodes.apply(function);
                mExpansion.addAll(pathRows);
                pathRows.forEach(r -> {
                    boolean bl = expansionNodes.add(r.getCallPathNode());
                });
            }
            cm.createConditionalSeparator();
            if (!selectionNodes.containsAll(expansionNodes)) {
                cm.createMenuItem(this, CallPathMessages.EXPAND_TO_MATCHING, CallPathMessages.EXPAND_TO_MATCHING, true);
            }
            if (((Outline)cm.getHandlerControl()).areUnselectedRowsClosable()) {
                cm.createMenuItem(this, CallPathMessages.COLLAPSE_UNSELECTED, CallPathMessages.COLLAPSE_UNSELECTED, true);
            }
            if (((Outline)cm.getHandlerControl()).areUnselectedRowsOpenable()) {
                cm.createMenuItem(this, CallPathMessages.EXPAND_UNSELECTED, CallPathMessages.EXPAND_UNSELECTED, true);
            }
        }
    }
}

