/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.EditorTabsMessages;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IReAnalysisProgressListener;
import com.arm.utils.NullChecking;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ProcessingDialog
extends TitleAreaDialog
implements IReAnalysisProgressListener,
Runnable {
    private final @NonNull IProcessingDialogCallbacks callbacks;
    private boolean isClosed;
    private Composite mContent;
    private ProgressIndicator mProgress;
    private Label mSubTitleLabel;
    private Label mTitleLabel;

    public static @NonNull Supplier<@NonNull Runnable> asClosableSupplier(@NonNull Analysis analysis) {
        return () -> {
            ProcessingDialog dialog = new ProcessingDialog(analysis);
            dialog.setBlockOnOpen(false);
            dialog.create();
            dialog.open();
            return () -> dialog.reAnalysisFinished();
        };
    }

    public ProcessingDialog(final @NonNull Analysis analysis) {
        this(new IProcessingDialogCallbacks(){

            @Override
            public void close(@NonNull IReAnalysisProgressListener listener, boolean cancelled) {
                analysis.removeReAnalysisListener(listener);
                if (cancelled) {
                    analysis.cancelReAnalysis();
                }
            }

            @Override
            public void setProgressListener(@NonNull IReAnalysisProgressListener listener) {
                analysis.addReAnalysisListener(listener);
            }
        });
    }

    public ProcessingDialog(final @NonNull AnalysisEditor editor, final @NonNull EditorTabID tab) {
        this(new IProcessingDialogCallbacks(){
            private final @NonNull Analysis analysis;
            {
                this.analysis = (Analysis)NullChecking.neverNull((Object)analysisEditor.getAnalysis());
            }

            @Override
            public void close(@NonNull IReAnalysisProgressListener listener, boolean cancelled) {
                this.analysis.removeReAnalysisListener(listener);
                if (cancelled) {
                    this.analysis.cancelReAnalysis();
                } else {
                    editor.setActivePage(tab);
                }
            }

            @Override
            public void setProgressListener(@NonNull IReAnalysisProgressListener listener) {
                this.analysis.addReAnalysisListener(listener);
            }
        });
    }

    public ProcessingDialog(@NonNull IProcessingDialogCallbacks callbacks) {
        super(WorkspaceUtils.getShell());
        this.callbacks = callbacks;
    }

    public boolean close() {
        this.isClosed = true;
        boolean result = super.close();
        this.callbacks.close(this, this.getReturnCode() == 1);
        return result;
    }

    @Override
    public void progress(@NonNull String title, @Nullable String subTitle, int percent) {
        Task.callOnUIThread(() -> {
            if (!this.isClosed && !this.mProgress.isDisposed()) {
                this.mTitleLabel.setText(title);
                this.mSubTitleLabel.setText(subTitle != null ? subTitle : "");
                this.mProgress.setWork(100, percent);
            }
        });
    }

    @Override
    public void reAnalysisFinished() {
        Task.callOnUIThread((Runnable)this);
    }

    @Override
    public void run() {
        if (!this.isClosed) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EditorTabsMessages.PLEASE_WAIT);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(EditorTabsMessages.ANALYZING);
        this.setMessage(EditorTabsMessages.SELECTED_DATA_BEING_REANALYZED);
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        this.mTitleLabel = new Label(this.mContent, 0);
        this.mTitleLabel.setText("Loading");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mTitleLabel);
        this.mProgress = new ProgressIndicator(this.mContent, 65792);
        this.mProgress.beginTask(100);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mProgress);
        this.mSubTitleLabel = new Label(this.mContent, 0);
        this.mSubTitleLabel.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mSubTitleLabel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, "com.arm.streamline.processing");
        this.callbacks.setProgressListener(this);
        return this.mContent;
    }

    public static interface IProcessingDialogCallbacks {
        public void close(@NonNull IReAnalysisProgressListener var1, boolean var2);

        public void setProgressListener(@NonNull IReAnalysisProgressListener var1);
    }
}

