/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.SourcePanel;
import com.arm.streamline.jni.apcdbgen.proto.IBasicSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.model.SourceFileUiUtils;
import com.arm.streamline.model.iterable.BasicSourceReferenceSelectionIterator;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenSourceFileAction
extends Action
implements ISelectionChangedListener {
    private ISelectionProvider mProvider;
    private ContextMenu mContextMenu;
    private final @NonNull Runnable showPathSubstitutionDialogRunner;
    private final @NonNull Function<@NonNull SourceFile, @NonNull String> sourcePathMapper;

    public OpenSourceFileAction(@NonNull Function<@NonNull SourceFile, @NonNull String> sourcePathMapper, ContextMenu cm, @NonNull Runnable showPathSubstitutionDialogRunner) {
        super(PluginMessages.EDIT_SOURCE, StreamlinePlugin.getImageDescriptor("EditSource.png"));
        this.sourcePathMapper = sourcePathMapper;
        this.showPathSubstitutionDialogRunner = showPathSubstitutionDialogRunner;
        this.mContextMenu = cm;
        this.selectionChanged(null);
    }

    public OpenSourceFileAction(@NonNull Function<@NonNull SourceFile, @NonNull String> sourcePathMapper, ISelectionProvider provider, @NonNull Runnable showPathSubstitutionDialogRunner) {
        super(PluginMessages.EDIT_SOURCE, StreamlinePlugin.getImageDescriptor("EditSource.png"));
        this.sourcePathMapper = sourcePathMapper;
        this.showPathSubstitutionDialogRunner = showPathSubstitutionDialogRunner;
        this.mProvider = provider;
        this.selectionChanged(null);
        this.mProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        try {
            HashMap<@NonNull SourceFile, @NonNull IBasicSourceReference> map = new HashMap<SourceFile, IBasicSourceReference>();
            for (IBasicSourceReference ref : new BasicSourceReferenceSelectionIterator(this.getSelection())) {
                ISourceLineReference lineRef;
                int refLine;
                SourceFile file = ref.getSourceFile();
                IBasicSourceReference mapRef = (IBasicSourceReference)map.get(file);
                if (mapRef == null) {
                    map.put(file, ref);
                    continue;
                }
                ISourceLineReference mapLineRef = mapRef instanceof ISourceLineReference ? (ISourceLineReference)mapRef : null;
                int mapLine = mapLineRef != null ? mapLineRef.getStartLine() : 0;
                int diff = mapLine - (refLine = (lineRef = ref instanceof ISourceLineReference ? (ISourceLineReference)ref : null) != null ? lineRef.getStartLine() : 0);
                if (diff <= 0) continue;
                map.put(file, ref);
            }
            SourceFile file = null;
            boolean notFound = false;
            for (Map.Entry entry : map.entrySet()) {
                file = (SourceFile)entry.getKey();
                IEditorInput input = SourceFileUiUtils.createEditorInput(this.sourcePathMapper, file);
                if (input == null) {
                    notFound = true;
                    continue;
                }
                IEditorPart editor = SourceFileUiUtils.openWithDefaultEditor(input);
                if (!(editor instanceof ITextEditor)) continue;
                IBasicSourceReference reference = (IBasicSourceReference)entry.getValue();
                SourceFileUiUtils.select((ITextEditor)editor, reference);
            }
            if (notFound && MessageDialog.openQuestion(null, (String)PluginMessages.WARNING, (String)PluginMessages.NOT_FOUND) && file != null) {
                this.showPathSubstitutionDialogRunner.run();
            }
        }
        catch (Exception exception) {
            Error.show(exception);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Iterator iterator = new BasicSourceReferenceSelectionIterator(this.getSelection()).iterator();
        if (iterator.hasNext()) {
            IBasicSourceReference file = (IBasicSourceReference)iterator.next();
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private ISelection getSelection() {
        ISelection selection;
        ISelection iSelection = selection = this.mProvider != null ? this.mProvider.getSelection() : this.mContextMenu.getSelection();
        if (selection.isEmpty()) {
            SourceFile file;
            Object provider = this.mProvider;
            if (provider == null) {
                provider = this.mContextMenu.getHandlerControl();
            }
            if (provider instanceof CodeTab) {
                provider = ((CodeTab)provider).getSourcePanel();
            }
            if (provider instanceof SourcePanel && (file = ((SourcePanel)provider).getActiveSourceFile()) != null) {
                selection = new StructuredSelection((Object)file);
            }
        }
        return selection;
    }
}

