/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterOutlineUpdater<T extends IExtractable, C extends IColumnEnum<T, Void>>
implements IValueChangeListener<IInstructionCounterSource> {
    protected final @NonNull AnalysisOutline<T> outline;
    private final @NonNull Map<@NonNull IInstructionCounterSource, @NonNull String> currentColumnConfiguration = new HashMap<IInstructionCounterSource, String>();
    private @Nullable IInstructionCounterSource currentInstructionCounterSource;
    private boolean currentPreferTotal;

    public InstructionCounterOutlineUpdater(@NonNull AnalysisOutline<T> outline, @Nullable IInstructionCounterSource instructionCounterSource, boolean preferTotal) {
        this.outline = outline;
        this.updateInstructionCounterSource(null, instructionCounterSource, preferTotal);
        this.updateOtherUiElements(instructionCounterSource);
    }

    public final void handleValueChange(ValueChangeEvent<? extends @Nullable IInstructionCounterSource> event) {
        this.updateInstructionCounterSource((IInstructionCounterSource)event.diff.getOldValue(), (IInstructionCounterSource)event.diff.getNewValue(), this.currentPreferTotal);
        this.updateOtherUiElements((IInstructionCounterSource)event.diff.getNewValue());
    }

    public final void recomputeFromModelChange(@Nullable IInstructionCounterSource instructionCounterSource) {
        this.updateInstructionCounterSource(instructionCounterSource, instructionCounterSource, this.currentPreferTotal);
        this.updateOtherUiElements(instructionCounterSource);
    }

    public void recomputeFromPreferTotalsChange(boolean preferTotal) {
        this.updateInstructionCounterSource(this.currentInstructionCounterSource, this.currentInstructionCounterSource, preferTotal);
        this.updateOtherUiElements(this.currentInstructionCounterSource);
    }

    public void refresh() {
        this.updateInstructionCounterSource(this.currentInstructionCounterSource, this.currentInstructionCounterSource, this.currentPreferTotal);
        this.updateOtherUiElements(this.currentInstructionCounterSource);
    }

    protected void updateOtherUiElements(@Nullable IInstructionCounterSource instructionCounterSource) {
    }

    protected abstract @NonNull Iterable<@NonNull C> aggregateColumns(@Nullable IInstructionCounterSource var1, boolean var2);

    protected abstract void populateOutline(@Nullable IInstructionCounterSource var1);

    private synchronized void updateInstructionCounterSource(@Nullable IInstructionCounterSource previousCounterSource, @Nullable IInstructionCounterSource instructionCounterSource, boolean preferTotals) {
        String config;
        if (previousCounterSource != null) {
            assert (this.currentColumnConfiguration != null);
            this.currentColumnConfiguration.put(previousCounterSource, this.outline.getConfig());
        }
        this.outline.getModel().removeAllColumns();
        ColumnUtils.createColumns(this.outline.getModel(), this.aggregateColumns(instructionCounterSource, preferTotals), null);
        this.populateOutline(instructionCounterSource);
        if (instructionCounterSource != null && (config = this.currentColumnConfiguration.get(instructionCounterSource)) != null) {
            this.outline.applyConfig(config, false, false);
        }
        this.currentInstructionCounterSource = instructionCounterSource;
        this.currentPreferTotal = preferTotals;
    }
}

