/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.trace_dump_import;

import com.arm.coresight.ds5_trace_dump.ITMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.STMTraceSourceStreamWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public enum TraceDumpImportClassification {
    BARMAN_ITM,
    BARMAN_ITM_AGENTLESS_DWT,
    BARMAN_STM;

    private static final @NonNull TraceSourceClassifierVisitor CLASSIFIER;

    static {
        CLASSIFIER = new TraceSourceClassifierVisitor();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Map<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> classify(@NonNull ITraceDumpDirectory traceDumpDirectory) {
        @NonNull HashMap<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> result = new HashMap<TraceDumpImportClassification, Collection<ITraceSourceStreamWrapper>>();
        @NonNull @NonNull List traceSources = traceDumpDirectory.getAllTraceSourceStreamWrappers();
        for (ITraceSourceStreamWrapper traceSource : traceSources) {
            traceSource.accept((ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor)CLASSIFIER, result);
        }
        return result;
    }

    private static final class TraceSourceClassifierVisitor
    implements ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Map<TraceDumpImportClassification, Collection<ITraceSourceStreamWrapper>>, Void, RuntimeException> {
        private static void addClassification(@NonNull Map<TraceDumpImportClassification, Collection<@NonNull ITraceSourceStreamWrapper>> map, @NonNull TraceDumpImportClassification classification, @NonNull ITraceSourceStreamWrapper stream) {
            Collection<@NonNull ITraceSourceStreamWrapper> collection = map.get((Object)classification);
            if (collection == null) {
                collection = new ArrayList<ITraceSourceStreamWrapper>();
                map.put(classification, collection);
            }
            collection.add(stream);
        }

        public Void visit(@NonNull ITMTraceSourceStreamWrapper stream, @NonNull Map<TraceDumpImportClassification, Collection<@NonNull ITraceSourceStreamWrapper>> map) throws RuntimeException {
            TraceSourceClassifierVisitor.addClassification(map, BARMAN_ITM, (ITraceSourceStreamWrapper)stream);
            TraceSourceClassifierVisitor.addClassification(map, BARMAN_ITM_AGENTLESS_DWT, (ITraceSourceStreamWrapper)stream);
            return null;
        }

        public Void visit(@NonNull STMTraceSourceStreamWrapper stream, @NonNull Map<TraceDumpImportClassification, Collection<@NonNull ITraceSourceStreamWrapper>> map) throws RuntimeException {
            @NonNull String streamName = stream.getTraceStream().getStreamName();
            if (!streamName.toLowerCase().startsWith("systemprofile")) {
                TraceSourceClassifierVisitor.addClassification(map, BARMAN_STM, (ITraceSourceStreamWrapper)stream);
            }
            return null;
        }
    }
}

