/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.model;

import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Shell;

public abstract class FileOrDirectoryListPanelModel {
    protected final @NonNull ILastFilterPathStore lastFilterStorePath = new SimpleLastFilterPathStore();
    protected final @NonNull IObservableList<@NonNull File> propAllDirectories = new WritableList(new ArrayList(), File.class);
    protected final @NonNull IObservableSet<@NonNull File> propCheckedDirectories = new WritableSet(new HashSet(), File.class);
    protected final @NonNull IObservableValue<@Nullable File> propertyCurrentSelection = new WritableValue(null, File.class);

    public void commandAddPath(@NonNull File file) {
        this.commandAddPath(file, true);
    }

    public void commandAddPath(@NonNull File file, boolean use) {
        if (!this.propAllDirectories.contains((Object)(file = FileUtils.canonicalise((File)file)))) {
            this.propAllDirectories.add((Object)file);
        }
        if (use) {
            this.propCheckedDirectories.add((Object)file);
        } else {
            this.propCheckedDirectories.remove((Object)file);
        }
    }

    public void commandCheckAll() {
        this.propCheckedDirectories.addAll(this.propAllDirectories);
    }

    public void commandRemoveSelected() {
        @Nullable File currentSelection = (File)this.propertyCurrentSelection.getValue();
        if (currentSelection != null) {
            this.propCheckedDirectories.remove((Object)currentSelection);
            this.propAllDirectories.remove((Object)currentSelection);
        }
    }

    public abstract @Nullable File commandShowAddDialog(Shell var1);

    public void commandUncheckAll() {
        this.propCheckedDirectories.clear();
    }

    public abstract @NonNull String getPathLabel(@NonNull File var1);

    public @NonNull List<@NonNull PathWithEnabledFlag> getPathsWithEnabledFlag() {
        return this.propAllDirectories.stream().map(f -> new PathWithEnabledFlag((File)f, this.propCheckedDirectories.contains(f) && this.isValidPath((File)f))).collect(Collectors.toList());
    }

    public @NonNull IObservableList<@NonNull File> getPropertyAllPaths() {
        return this.propAllDirectories;
    }

    public abstract @NonNull IObservableValue<@NonNull Boolean> getPropertyCanRemoveSelection();

    public @NonNull IObservableSet<@NonNull File> getPropertyCheckedPaths() {
        return this.propCheckedDirectories;
    }

    public @NonNull IObservableValue<@Nullable File> getPropertyCurrentSelection() {
        return this.propertyCurrentSelection;
    }

    public abstract boolean isValidPath(@NonNull File var1);
}

