/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionBrowserMessages;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.text.BasicNumberUtils;

public class BrowseResultRow
extends Row<SimpleColumn> {
    private BrowseResult mBrowseResult;

    public BrowseResultRow(BrowseResult browseResult) {
        this.mBrowseResult = browseResult;
    }

    public BrowseResult getBrowseResult() {
        return this.mBrowseResult;
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        switch (column.getID()) {
            case 0: {
                String deviceId = this.mBrowseResult.getDeviceId();
                return deviceId == null ? this.mBrowseResult.getDisplayName() : deviceId;
            }
            case 1: {
                return this.mBrowseResult.getAvailable() ? this.mBrowseResult.getDetails() : ConnectionBrowserMessages.NO_NETWORK;
            }
            case 2: {
                if (!this.mBrowseResult.getAvailable()) {
                    return ConnectionBrowserMessages.NO_NETWORK_HELP;
                }
                GatorProtocolVersion version = new GatorProtocolVersion(BasicNumberUtils.getNonLocalizedInteger((String)this.mBrowseResult.getVersion(), (int)0));
                if (version.isValidEncoding()) {
                    return String.format("gator %s", version.getVersionString());
                }
                return "";
            }
        }
        return "";
    }

    public void setBrowseResult(BrowseResult result) {
        this.mBrowseResult = result;
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }
}

