/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.utils.text.BasicStringUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class AndroidProbeResult {
    public final boolean hasMali;
    public final @Nullable String model;
    public final @Nullable Integer configVersion;
    private final boolean isEmpty;

    public static AndroidProbeResult fromCommandOutput(@NonNull List<@NonNull String> outputLines, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AdbDevice.AdbDeviceState state) {
        boolean hasMali = false;
        String manufacturer = null;
        String model = null;
        Integer configVersion = null;
        for (String line : outputLines) {
            String[] elements = line.split("\\s*:\\s*");
            if (elements.length != 2) continue;
            switch (elements[0]) {
                case "has_mali": {
                    hasMali = "true".equals(elements[1]);
                    break;
                }
                case "manufacturer": {
                    manufacturer = elements[1];
                    break;
                }
                case "model": {
                    model = elements[1];
                    break;
                }
                case "config_version": {
                    configVersion = AndroidProbeResult.parseConfigurationVersion(elements[1]);
                    break;
                }
            }
        }
        model = AndroidProbeResult.parseDeviceModel(state, manufacturer, model);
        return new AndroidProbeResult(model, configVersion, hasMali);
    }

    private AndroidProbeResult(@Nullable String model, @Nullable Integer configVersion, boolean hasMali, boolean isEmpty) {
        this.model = model;
        this.configVersion = configVersion;
        this.hasMali = hasMali;
        this.isEmpty = isEmpty;
    }

    private AndroidProbeResult(@Nullable String model, @Nullable Integer configVersion, boolean hasMali) {
        this(model, configVersion, hasMali, false);
    }

    static AndroidProbeResult makeEmptyProbeResult() {
        return new AndroidProbeResult(null, null, false, true);
    }

    private static @Nullable String parseDeviceModel(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AdbDevice.AdbDeviceState state, @Nullable String manufacturer, @Nullable String model) {
        switch (state) {
            case AVAILABLE: {
                if (manufacturer != null && model != null) {
                    return String.format("%s %s", BasicStringUtils.titleCase((String)manufacturer), model);
                }
                if (manufacturer != null) {
                    return BasicStringUtils.titleCase((String)manufacturer);
                }
                return model;
            }
            case NOT_SUPPORTED: 
            case UNAUTHORIZED: {
                return null;
            }
        }
        throw new AssertionError((Object)"Invalid AdbDeviceState");
    }

    private static @Nullable Integer parseConfigurationVersion(@Nullable String versionString) {
        if (versionString == null) {
            return null;
        }
        String streamlineVersionAttr = "streamline_version=";
        try {
            return Integer.valueOf(versionString.substring(versionString.lastIndexOf(streamlineVersionAttr) + streamlineVersionAttr.length() + 1).replaceAll("\"", "").trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    boolean isEmpty() {
        return this.isEmpty;
    }
}

