/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.databrowser.GatorConnectionConstants;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.adb.utils.AdbRedirects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;

public final class AdbPortForwarder {
    private static final int TCP_PORT_NO = 8080;
    private static final @NonNull String UDS_SOCKET_NAME = "streamline-data";
    private final @NonNull TObjectIntMap<String> mForwardedPortsTcp = new TObjectIntHashMap(10, 0.5f, 0);
    private final @NonNull TObjectIntMap<String> mForwardedPortsUds = new TObjectIntHashMap(10, 0.5f, 0);
    private int mNextPort = 8084;
    private final @NonNull IAdbProcessRunner commandRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    private static boolean available(int port) {
        var1_1 = GatorConnectionConstants.SETUP_LOCK;
        synchronized (var1_1) {
            try {
                var2_2 = null;
                var3_5 = null;
                try {
                    socket = new Socket(InetAddress.getLoopbackAddress(), port);
                    try {
                        out = socket.getOutputStream();
                        try {
                            in = new LittleEndianDataInputStream(socket.getInputStream());
                            try {
                                out.write("STREAMLINE\n".getBytes());
                                response = GatorSendCommandUtility.readLine(in);
                                message = new byte[5];
                                if (response != null) {
                                    message[0] = 5;
                                    out.write(message);
                                }
                                message[0] = 4;
                                out.write(message);
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            ** if (out == null) goto lbl-1000
                        }
                        catch (Throwable var3_6) {
                            if (var2_2 == null) {
                                var2_2 = var3_6;
                            } else if (var2_2 != var3_6) {
                                var2_2.addSuppressed(var3_6);
                            }
                            if (out != null) {
                                out.close();
                            }
                            throw var2_2;
                        }
lbl-1000:
                        // 1 sources

                        {
                            out.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (socket == null) goto lbl-1000
                    }
                    catch (Throwable var3_7) {
                        if (var2_2 == null) {
                            var2_2 = var3_7;
                        } else if (var2_2 != var3_7) {
                            var2_2.addSuppressed(var3_7);
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        throw var2_2;
                    }
lbl-1000:
                    // 1 sources

                    {
                        socket.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var3_8) {
                    if (var2_2 == null) {
                        var2_2 = var3_8;
                    } else if (var2_2 != var3_8) {
                        var2_2.addSuppressed(var3_8);
                    }
                    throw var2_2;
                }
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    public AdbPortForwarder(@NonNull IAdbProcessRunner commandRunner) throws IOException {
        this.commandRunner = commandRunner;
        for (AdbRedirects.AdbRedirect redirects : AdbRedirects.enumerateForwards((IAdbProcessRunner)commandRunner)) {
            if (redirects.getLocalType() != AdbRedirects.AdbRedirectType.TCP) continue;
            if (redirects.getRemoteType() == AdbRedirects.AdbRedirectType.TCP && redirects.getRemoteValue().asInt() == 8080) {
                this.mForwardedPortsTcp.put((Object)redirects.getSerialNumber(), redirects.getLocalValue().asInt());
                continue;
            }
            if (redirects.getRemoteType() != AdbRedirects.AdbRedirectType.LOCALABSTRACT || !UDS_SOCKET_NAME.contentEquals(redirects.getRemoteValue().asString())) continue;
            this.mForwardedPortsUds.put((Object)redirects.getSerialNumber(), redirects.getLocalValue().asInt());
        }
    }

    public @NonNull AdbPortPair getAdbDevicePorts(@NonNull String device) throws IOException {
        int tcpPort = this.getAdbDevicePortTcp(device);
        int udsPort = this.getAdbDevicePortUds(device);
        return new AdbPortPair(tcpPort, udsPort);
    }

    private int getAdbDevicePortTcp(@NonNull String device) throws IOException {
        int port = this.mForwardedPortsTcp.get((Object)device);
        if (port == this.mForwardedPortsTcp.getNoEntryValue()) {
            port = this.getNextPort();
            try {
                AdbRedirects.forward((IAdbProcessRunner)this.commandRunner, (String)device, (int)port, (int)8080);
            }
            catch (AdbCommandIOException e) {
                StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)"Failed to setup 8080 port forward", (Throwable)e);
                return 0;
            }
            this.mForwardedPortsTcp.put((Object)device, port);
        }
        return port;
    }

    private int getAdbDevicePortUds(@NonNull String device) throws IOException {
        int port = this.mForwardedPortsUds.get((Object)device);
        if (port == this.mForwardedPortsUds.getNoEntryValue()) {
            port = this.getNextPort();
            try {
                AdbRedirects.forward((IAdbProcessRunner)this.commandRunner, (String)device, (int)port, (String)UDS_SOCKET_NAME);
            }
            catch (AdbCommandIOException e) {
                StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)"Failed to setup UDS port forward", (Throwable)e);
                return 0;
            }
            this.mForwardedPortsUds.put((Object)device, port);
        }
        return port;
    }

    private int getNextPort() {
        while (!AdbPortForwarder.available(this.mNextPort)) {
            ++this.mNextPort;
        }
        return this.mNextPort++;
    }

    public static final class AdbPortPair {
        public final int tcp;
        public final int uds;

        public AdbPortPair(int tcp, int uds) {
            this.uds = uds;
            this.tcp = tcp;
        }
    }
}

