/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class ExportCaptureJob
extends Job {
    private static final int NUM_WORK_ITEMS_PER_DIR = 1;
    private static final int BLOCK_SIZE = 65536;
    private static final long MAX_BLOCKS = 32767L;
    private final @NonNull File mDst;
    private final @NonNull Set<String> mFilter;
    private final @NonNull String mPrefix;
    private final int mPrefixLength;
    private final @NonNull File mSrc;

    private static int getNumWorkItems(@NonNull File file) {
        if (file.isFile()) {
            long length = file.length();
            long numBlocks = (length + 65536L - 1L) / 65536L;
            return (int)Math.min(numBlocks, 32767L);
        }
        return 1;
    }

    public ExportCaptureJob(@NonNull File src, @NonNull File dst) {
        super(MessageFormat.format(DocumentsMessages.EXPORTING, src.getName()));
        this.setUser(true);
        this.setSystem(false);
        this.mSrc = src;
        this.mPrefixLength = FilePath.getFullPath((File)this.mSrc).length();
        this.mPrefix = (String)NullChecking.neverNull((Object)FilePath.enforceExtension((String)dst.getName().replaceAll("\\.apc\\.zip$", ".zip"), (String)"apc", (boolean)true));
        this.mDst = dst;
        this.mFilter = new HashSet<String>();
        String filterPrefix = this.mPrefix + FilePath.PATH_SEPARATOR;
        this.mFilter.add(filterPrefix + ".DS_Store");
        this.mFilter.add(filterPrefix + ".svn" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + ".git" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "db" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "gatorbase" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "report" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "report.del" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "report-new" + FilePath.PATH_SEPARATOR);
        this.mFilter.add(filterPrefix + "report-new.del" + FilePath.PATH_SEPARATOR);
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean abort = false;
        monitor.beginTask(MessageFormat.format(DocumentsMessages.EXPORTING, this.mSrc.getName()), this.countFiles(this.mSrc));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.mDst));){
                this.zip(this.mSrc, out, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            abort = true;
            Error.show(exception);
        }
        if (abort || monitor.isCanceled()) {
            this.mDst.delete();
        }
        return Status.OK_STATUS;
    }

    private int countFiles(@NonNull File currentFile) {
        File[] children;
        boolean isFile = currentFile.isFile();
        String zipPath = this.makeZipPath(currentFile);
        if (this.isExcluded(zipPath)) {
            return 0;
        }
        int result = ExportCaptureJob.getNumWorkItems(currentFile);
        if (!isFile && (children = currentFile.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result += this.countFiles((File)NullChecking.neverNull((Object)child));
                ++n2;
            }
        }
        return result;
    }

    private boolean isExcluded(@NonNull String zipPath) {
        return this.mFilter.contains(zipPath);
    }

    private @NonNull String makeZipPath(@NonNull File currentFile) {
        boolean isFile = currentFile.isFile();
        String fullSourcePath = FilePath.getFullPath((File)currentFile);
        return this.mPrefix + fullSourcePath.substring(this.mPrefixLength) + (isFile ? "" : FilePath.PATH_SEPARATOR);
    }

    private void zip(File current, ZipOutputStream out, IProgressMonitor monitor) throws IOException {
        if (!monitor.isCanceled()) {
            boolean isFile = current.isFile();
            String zipPath = this.makeZipPath(current);
            if (!this.isExcluded(zipPath)) {
                monitor.setTaskName(MessageFormat.format(DocumentsMessages.EXPORTING, zipPath));
                ZipEntry entry = new ZipEntry(zipPath);
                entry.setTime(current.lastModified());
                out.putNextEntry(entry);
                if (isFile) {
                    int totalWorkItems = ExportCaptureJob.getNumWorkItems(current);
                    long writtenLength = 0L;
                    int currentWorkItems = 0;
                    Throwable throwable = null;
                    Object var12_16 = null;
                    try (FileInputStream in = new FileInputStream(current);){
                        int amount;
                        byte[] buffer = new byte[65536];
                        while (!monitor.isCanceled() && (amount = in.read(buffer)) > 0) {
                            out.write(buffer, 0, amount);
                            int newWorkItems = (int)Math.min((writtenLength += (long)amount) / 65536L, (long)totalWorkItems);
                            if (newWorkItems <= currentWorkItems) continue;
                            monitor.worked(newWorkItems - currentWorkItems);
                            currentWorkItems = newWorkItems;
                        }
                        if (currentWorkItems < totalWorkItems) {
                            monitor.worked(totalWorkItems - currentWorkItems);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    out.closeEntry();
                } else {
                    File[] children = current.listFiles();
                    if (children != null) {
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            if (!monitor.isCanceled()) {
                                this.zip(child, out, monitor);
                            }
                            ++n2;
                        }
                    }
                    monitor.worked(1);
                }
            }
        }
    }
}

