/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ElfImageStatus {
    private String imageName;
    private boolean enabled;

    ElfImageStatus(String imageName, boolean enabled) {
        this.imageName = imageName;
        this.enabled = enabled;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.imageName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElfImageStatus other = (ElfImageStatus)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        return Objects.equals(this.imageName, other.imageName);
    }

    public static @NonNull List<@NonNull ElfImageStatus> getElfImagesFromSettings(@NonNull IAnalysisInputSettings settings) {
        @NonNull List<@NonNull ElfImageStatus> previousElfImages = settings.getImages().stream().map(image -> new ElfImageStatus(image.getImageName(), image.loadSymbols())).collect(Collectors.toList());
        return previousElfImages;
    }

    public static boolean elfImagesInDbDifferFromImagesDirectory(@NonNull ICapture capture) {
        @NonNull File dbImagePath = ElfImageStatus.getDbImagePath(capture);
        @NonNull List<@NonNull String> dbImages = ElfImageStatus.getElfImagesFromDirectory(dbImagePath);
        @NonNull File imagePath = ElfImageStatus.getImagePath(capture);
        @NonNull List<@NonNull String> images = ElfImageStatus.getElfImagesFromDirectory(imagePath);
        Collections.sort(images);
        Collections.sort(dbImages);
        return !dbImages.equals(images);
    }

    private static @NonNull List<@NonNull String> getElfImagesFromDirectory(@NonNull File folder) {
        @NonNull File @Nullable [] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return Collections.emptyList();
        }
        @NonNull ArrayList<@NonNull String> dbImages = new ArrayList<String>();
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                dbImages.add(f.getName());
            }
            ++n2;
        }
        return dbImages;
    }

    private static @NonNull File getImagePath(@NonNull ICapture capture) {
        return new File(capture.getApcDirectory(), "images");
    }

    private static @NonNull File getDbImagePath(@NonNull ICapture capture) {
        return new File(new File(capture.getApcDirectory(), "db"), "images");
    }
}

