/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.CountersUiShared;
import com.arm.streamline.counterconfig.EventsEditorComposite;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.counterconfig.outline.SpeTargetDescriptionRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.databrowser.CountersPanelButtons;
import com.arm.streamline.editortabs.timeline.common.ContentWrapper;
import com.arm.streamline.live.LiveContent;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CountersPanel
extends Composite {
    private final @NonNull CountersUiShared sharedControls;
    private final @NonNull Configurations configurations;
    private final @NonNull CountersPanelButtons counterPanelButton;

    public CountersPanel(@NonNull Composite parent, @NonNull CounterConfiguration config, @NonNull LiveContent liveContent) {
        super(parent, 0x20000000);
        EventsEditorComposite ebsEntry;
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 5).applyTo((Composite)this);
        this.configurations = config.getConfigurations();
        @NonNull EventsEditorComposite ebsToggleHandler = ebsEntry = new EventsEditorComposite(this, config);
        this.sharedControls = new CountersUiShared(this, config, ebsToggleHandler, false);
        this.sharedControls.label.dispose();
        this.sharedControls.toolbar.moveAbove(null);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.sharedControls.toolbar);
        this.sharedControls.availableOutline.moveBelow((Control)this.sharedControls.toolbar);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sharedControls.availableOutline);
        this.counterPanelButton = new CountersPanelButtons(this, config, this.sharedControls.availableOutline);
        this.counterPanelButton.toolBar.moveBelow((Control)this.sharedControls.availableOutline);
        GridDataFactory.fillDefaults().span(1, 2).grab(false, true).applyTo((Control)this.counterPanelButton.toolBar);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.sharedControls.description);
        ebsEntry.createComposite();
        ebsEntry.getControl().moveAbove((Control)this.sharedControls.description);
        this.setupDropTarget((Control)liveContent);
        this.setupSourceHighlight(liveContent);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void setupSourceHighlight(@NonNull LiveContent liveContent) {
        Consumer<@Nullable IAvailableEvent> listener = events -> {
            @Nullable ContentWrapper contentWrapper = liveContent.getContentWrapper();
            if (contentWrapper != null) {
                Set<@NonNull Object> sources = new HashSet();
                if (events == null) {
                    sources = Collections.emptySet();
                } else if (events instanceof StockCounter) {
                    sources = ((StockCounter)events).getAllCombinations().map(StockCounter.Combination::getUniqueSourceName).collect(Collectors.toSet());
                }
                contentWrapper.getChartsPanel().setHighlightedSources(sources);
            }
        };
        this.sharedControls.availableOutline.addMouseCounterListener(listener);
        this.addDisposeListener(e -> listener.accept(null));
    }

    private void setupDropTarget(@NonNull Control dropTarget) {
        final DropTarget drop = new DropTarget(dropTarget, 1);
        this.addDisposeListener(e -> drop.dispose());
        drop.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        drop.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = this.isValidDrag(event) ? 1 : 0;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = this.isValidDrag(event) ? 1 : 0;
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                ArrayList<@NonNull StockCounter> counters = new ArrayList<StockCounter>();
                ArrayList<@NonNull SpeTargetDescription> spes = new ArrayList<SpeTargetDescription>();
                Row<SimpleColumn>[] rowArray = this.getDropTargetTransfer().getTransferObjects();
                int n = rowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Row<SimpleColumn> row = rowArray[n2];
                    if (row instanceof StockCounterRow) {
                        counters.add(((StockCounterRow)row).getCounter());
                    } else if (row instanceof SpeTargetDescriptionRow) {
                        spes.add(((SpeTargetDescriptionRow)row).getTargetDescription());
                    }
                    ++n2;
                }
                CountersPanel.this.configurations.addEvents(spes, counters);
            }

            public void dropAccept(DropTargetEvent event) {
            }

            private LocalObjectTransfer<Row<SimpleColumn>> getDropTargetTransfer() {
                return (LocalObjectTransfer)drop.getTransfer()[0];
            }

            private boolean isValidDrag(DropTargetEvent event) {
                if ((event.operations & 1) == 1) {
                    return this.getDropTargetTransfer().isSupportedType(event.currentDataType);
                }
                return false;
            }
        });
    }

    public @NonNull CountersOutline getCounterDropTarget() {
        return this.sharedControls.availableOutline;
    }

    public void dispose() {
        this.counterPanelButton.dispose();
        super.dispose();
    }
}

