/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.counterconfig.CountersDialog;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.live.LiveContent;
import com.arm.streamline.live.LiveMessages;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.ImageButton;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;

public class CaptureControlToolbar
extends CustomToolbar {
    private final @NonNull ImageButton discard;
    private final @NonNull ImageButton refresh;
    private final @NonNull ImageButton refreshAndSave;
    private final @NonNull ImageButton stop;
    private @Nullable LiveContent liveContent;
    private @Nullable CounterConfiguration config;
    private boolean isDiscardEnabled;
    private final @NonNull IDeviceConnectionModel deviceConnectionModel;

    public CaptureControlToolbar(Composite parent, @NonNull IDeviceConnectionModel deviceConnectionModel) {
        super(parent);
        this.deviceConnectionModel = deviceConnectionModel;
        this.refreshAndSave = new ImageButton((Composite)this, StreamlinePlugin.getImage("Save.gif"));
        this.refreshAndSave.setToolTipText(CountersMessages.SAVE_AND_REFRESH_LIVE_CONFIGURATION);
        this.refreshAndSave.addClickListener(button -> {
            try {
                this.updateCaptureButtonStatus(false);
                if (this.config != null) {
                    this.config.save(false);
                    this.updateConfigurations(null, null);
                }
            }
            catch (IOException exception) {
                CountersDialog.handleError(exception);
            }
        });
        this.refreshAndSave.setEnabled(this.liveContent != null);
        this.refresh = new ImageButton((Composite)this, StreamlinePlugin.getImage("RefreshArrows.gif"));
        this.refresh.setToolTipText(CountersMessages.REFRESH_LIVE_CONFIGURATION);
        this.refresh.addClickListener(button -> {
            try {
                this.updateCaptureButtonStatus(false);
                if (this.config != null) {
                    this.config.save(true);
                    this.updateConfigurations(null, null);
                }
            }
            catch (IOException exception) {
                CountersDialog.handleError(exception);
            }
        });
        this.refresh.setEnabled(this.liveContent != null);
        this.stop = new ImageButton((Composite)this, StreamlinePlugin.getImage("StopAndAnalyze.png"));
        this.stop.setToolTipText(LiveMessages.STOP_CAPTURE_TOOLTIP);
        this.stop.addClickListener(button -> {
            boolean confirmStop;
            if (this.liveContent != null && (confirmStop = this.liveContent.stop(false))) {
                this.updateConfigurations(null, null);
            }
        });
        this.stop.setEnabled(this.liveContent != null);
        this.discard = new ImageButton((Composite)this, StreamlinePlugin.getImage("StopAndDiscard.png"));
        this.discard.setToolTipText(LiveMessages.STOP_CAPTURE_TOOLTIP_DISCARD);
        this.discard.addClickListener(button -> {
            this.updateCaptureButtonStatus(false);
            if (this.liveContent != null) {
                this.liveContent.stop(true);
                this.updateConfigurations(null, null);
            }
        });
        this.discard.setEnabled(this.liveContent != null);
        this.redraw();
    }

    public void setTargetIsActive(boolean targetIsActive, @Nullable CounterConfiguration config, @Nullable LiveContent liveContent) {
        this.updateConfigurations(config, liveContent);
        this.redraw();
    }

    private void updateConfigurations(@Nullable CounterConfiguration config, @Nullable LiveContent liveContent) {
        this.config = config;
        this.liveContent = liveContent;
        this.updateCaptureButtonStatus(liveContent != null);
    }

    private void updateCaptureButtonStatus(boolean state) {
        this.refresh.setEnabled(!this.isDiscardEnabled && state);
        this.refreshAndSave.setEnabled(!this.isDiscardEnabled && state);
        this.stop.setEnabled(!this.isDiscardEnabled && state);
        this.discard.setEnabled(state);
    }
}

