/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.GatorBinaryId;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.databrowser.AndroidABIDetector;
import com.arm.streamline.databrowser.AndroidDeviceException;
import com.arm.streamline.databrowser.IConfigurer;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.adb.AdbSelfCleaningSession;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AndroidDeviceGatordManager {
    private final @NonNull IAdbCommandRunner commandRunner;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode;

    public AndroidDeviceGatordManager(@NonNull IAdbCommandRunner commandRunner, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode) {
        this.commandRunner = commandRunner;
        this.wrapMode = wrapMode;
    }

    private static @NonNull File getGatord(@NonNull AndroidABIDetector.AndroidDeviceABI deviceABI) throws IOException, AndroidDeviceException {
        switch (deviceABI) {
            case ARM64: {
                return StreamlinePlugin.getGatord(GatorBinaryId.ANDROID_ARM64);
            }
            case ARM32: {
                return StreamlinePlugin.getGatord(GatorBinaryId.ANDROID_ARM32);
            }
            case X86_64: {
                try {
                    return StreamlinePlugin.getGatord(GatorBinaryId.ANDROID_X86_64);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new AndroidDeviceException("Device must support either arm64-v8a or armeabi-v7a or x86_64 abi.");
    }

    public @NonNull IInstallUninstall getGatordInstallUninstall(final @NonNull IConfigurer configurer, final @NonNull AndroidABIDetector.AndroidDeviceABI deviceABI, String ... gatordArgs) {
        boolean logDebug;
        final AdbSelfCleaningSession session = new AdbSelfCleaningSession(this.commandRunner, this.wrapMode, StreamlinePlugin::warning);
        String envDebug = System.getenv("DEVTEST_LOG_DEBUG");
        boolean bl = logDebug = AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN && envDebug != null && envDebug.toLowerCase().matches("^(true)|([1-9][0-9]*)$");
        if (logDebug) {
            String[] newArgs = new String[gatordArgs.length + 1];
            newArgs[0] = "-d";
            System.arraycopy(gatordArgs, 0, newArgs, 1, gatordArgs.length);
            gatordArgs = newArgs;
        }
        final String[] argsToUse = gatordArgs;
        return new IInstallUninstall(){

            @Override
            public @NonNull IRunnableWithProgress getInstaller() {
                return monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                    try {
                        subMonitor.subTask("Detecting device gatord executable");
                        File gatord = AndroidDeviceGatordManager.getGatord(deviceABI);
                        subMonitor.split(1);
                        subMonitor.subTask("Transferring gatord to device");
                        AdbSelfCleaningSession.RemoteExecutable remoteGatord = session.pushExecutable(gatord, "gatord");
                        subMonitor.split(1);
                        subMonitor.subTask("Starting gatord");
                        IInteractiveCommand gatordCommand = remoteGatord.runExe(argsToUse);
                        subMonitor.split(1);
                        try {
                            gatordCommand.waitForLineMatching(false, Pattern.compile("Gator ready"), true);
                        }
                        catch (EOFException e) {
                            throw new AndroidDeviceException("Error starting gatord", gatordCommand);
                        }
                        subMonitor.subTask("Gatord ready");
                        subMonitor.split(1);
                        configurer.configureTarget(subMonitor);
                        subMonitor.split(1);
                    }
                    catch (AndroidDeviceException | AdbSelfCleaningSession.CommandFailedException | IOException e) {
                        throw new InvocationTargetException(e);
                    }
                };
            }

            @Override
            public @NonNull IRunnableWithProgress getUninstaller() {
                return monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(session.getNumberOfCleanUpActions() + 1));
                    subMonitor.subTask("Removing gatord from device");
                    try {
                        AndroidDeviceGatordManager.this.commandRunner.runCommandAndGetOutput(AndroidDeviceGatordManager.this.wrapMode, "killall", new String[]{"gatord"});
                        subMonitor.worked(1);
                    }
                    catch (IOException e) {
                        StreamlinePlugin.warning("Failed to stop gatord", e);
                    }
                    session.cleanUp(() -> {
                        SubMonitor split = subMonitor.split(1);
                        split.worked(1);
                    });
                };
            }
        };
    }

    public static interface IInstallUninstall {
        public @NonNull IRunnableWithProgress getInstaller();

        public @NonNull IRunnableWithProgress getUninstaller();
    }
}

